/* Balsa E-Mail Client
 * Copyright (C) 1997 Jay Painter
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include <string.h>
#include <gtk/gtk.h>
#include "message_interface.h"
#include "mail_structs.h"
#include "main_window.h"

extern MainWindow *mainW;

void
display_message (Message *message)
{
  int nchars;
  char *c;
  
  if (!message)
    return;

  /*
   * first clear the text box
   */
  nchars = gtk_text_get_length(GTK_TEXT(mainW->message_area));
  gtk_text_set_point(GTK_TEXT(mainW->message_area), 0);

  /* spelling mistake! */
  gtk_text_foreward_delete(GTK_TEXT(mainW->message_area), nchars);


  /*
   * display the current message
   */
  c = mail_fetchtext (message->mailbox->stream, message->mesgno);
  gtk_text_insert (GTK_TEXT (mainW->message_area), NULL,  NULL, 
		   NULL, c, strlen(c));
  gtk_text_thaw (GTK_TEXT (mainW->message_area));
}
