set print repeats 100
set height 0
br main
run
n
#
#  create basic objects
#
set $foo = gimp_flat_buffer_new (tag_new (PRECISION_U8, FORMAT_RGB, ALPHA_YES), 256, 256)
set $portion = (GimpPortion*) g_malloc (sizeof (GimpPortion))
set $memstatus = (GimpMemStatus*) g_malloc (sizeof (GimpMemStatus))
set $pixelarray = (GimpPixelArray*) g_malloc (sizeof (GimpPixelArray))
#
#  test the creation and basic query methods
#
print "--------------------------------"
print gimp_buffer_width ($foo)
print gimp_buffer_height ($foo)
print tag_precision (gimp_buffer_tag ($foo))
print tag_format (gimp_buffer_tag ($foo))
print tag_alpha (gimp_buffer_tag ($foo))
#
# test focus ranges
#
print "--------------------------------"
print gimp_buffer_focus ($foo, $portion, 0, -1)
print *$portion
print gimp_buffer_focus ($foo, $portion, 0, 0)
print *$portion
print gimp_buffer_focus ($foo, $portion, 0, 255)
print *$portion
print gimp_buffer_focus ($foo, $portion, 0, 256)
print *$portion
print gimp_buffer_focus ($foo, $portion, -1, 0)
print *$portion
print gimp_buffer_focus ($foo, $portion, 0, 0)
print *$portion
print gimp_buffer_focus ($foo, $portion, 255, 0)
print *$portion
print gimp_buffer_focus ($foo, $portion, 256, 0)
print *$portion
print gimp_buffer_focus ($foo, $portion, 130, 241)
print *$portion
#
#  allocation
#
print "--------------------------------"
print gimp_buffer_alloc ($foo, $portion, ALLOC_ALLOC)
print gimp_buffer_alloc ($foo, $portion, ALLOC_ALLOC)
print gimp_buffer_alloc ($foo, $portion, ALLOC_UNALLOC)
print gimp_buffer_alloc ($foo, $portion, ALLOC_UNALLOC)
#
# use and autoalloc
# 
print "--------------------------------"
print gimp_buffer_query ($foo, $portion, $memstatus)
print *$memstatus
print gimp_buffer_alloc ($foo, $portion, ALLOC_ALLOC)
print gimp_buffer_query ($foo, $portion, $memstatus)
print *$memstatus
print gimp_buffer_alloc ($foo, $portion, ALLOC_UNALLOC)
print gimp_buffer_query ($foo, $portion, $memstatus)
print *$memstatus
print gimp_buffer_use ($foo, $portion, USE_READ)
print gimp_buffer_query ($foo, $portion, $memstatus)
print *$memstatus
print gimp_buffer_use ($foo, $portion, USE_RELEASE)
print gimp_buffer_query ($foo, $portion, $memstatus)
print *$memstatus
print gimp_buffer_use ($foo, $portion, USE_READ)
print gimp_buffer_use ($foo, $portion, USE_READ)
print gimp_buffer_query ($foo, $portion, $memstatus)
print *$memstatus
print gimp_buffer_alloc ($foo, $portion, ALLOC_UNALLOC)
print gimp_buffer_use ($foo, $portion, USE_RELEASE)
print gimp_buffer_use ($foo, $portion, USE_RELEASE)
print gimp_buffer_query ($foo, $portion, $memstatus)
print *$memstatus
print gimp_buffer_alloc ($foo, $portion, ALLOC_UNALLOC)
print gimp_buffer_query ($foo, $portion, $memstatus)
print *$memstatus
#
# data pointer 
#
print "--------------------------------"
print gimp_buffer_data ($foo, $portion, $pixelarray)
print *$pixelarray
print gimp_buffer_use ($foo, $portion, USE_READ)
print gimp_buffer_data ($foo, $portion, $pixelarray)
print *$pixelarray
print gimp_buffer_use ($foo, $portion, USE_RELEASE)
print gimp_buffer_data ($foo, $portion, $pixelarray)
print *$pixelarray
print gimp_buffer_alloc ($foo, $portion, ALLOC_UNALLOC)
print gimp_buffer_data ($foo, $portion, $pixelarray)
print *$pixelarray
print gimp_buffer_focus ($foo, $portion, 130, 241)
print gimp_buffer_alloc ($foo, $portion, ALLOC_ALLOC)
print gimp_buffer_data ($foo, $portion, $pixelarray)
print *$pixelarray
print gimp_buffer_use ($foo, $portion, USE_READ)
print gimp_buffer_data ($foo, $portion, $pixelarray)
print *$pixelarray
print gimp_buffer_focus ($foo, $portion, 131, 241)
print gimp_buffer_data ($foo, $portion, $pixelarray)
print *$pixelarray
print gimp_buffer_focus ($foo, $portion, 130, 240)
print gimp_buffer_data ($foo, $portion, $pixelarray)
print *$pixelarray
print gimp_buffer_focus ($foo, $portion, 130, 241)
print gimp_buffer_use ($foo, $portion, USE_RELEASE)
print gimp_buffer_data ($foo, $portion, $pixelarray)
print *$pixelarray
print gimp_buffer_alloc ($foo, $portion, ALLOC_UNALLOC)
print gimp_buffer_data ($foo, $portion, $pixelarray)
print *$pixelarray
#
#  test dirty flag
#
print "--------------------------------"
print gimp_buffer_use ($foo, $portion, USE_READ)
print gimp_buffer_query ($foo, $portion, $memstatus)
print *$memstatus
print gimp_buffer_use ($foo, $portion, USE_WRITE)
print gimp_buffer_query ($foo, $portion, $memstatus)
print *$memstatus
print gimp_buffer_use ($foo, $portion, USE_READ)
print gimp_buffer_query ($foo, $portion, $memstatus)
print *$memstatus
print gimp_buffer_use ($foo, $portion, USE_RELEASE)
print gimp_buffer_use ($foo, $portion, USE_RELEASE)
print gimp_buffer_query ($foo, $portion, $memstatus)
print *$memstatus
print gimp_buffer_use ($foo, $portion, USE_RELEASE)
print gimp_buffer_query ($foo, $portion, $memstatus)
print *$memstatus
print gimp_buffer_alloc ($foo, $portion, ALLOC_UNALLOC)
print gimp_buffer_query ($foo, $portion, $memstatus)
print *$memstatus

