/* test_conf_parser_ov2.c test */

/* test all kinds of options and the conf file parser */
/* differently from test_conf_parser_ov.c, first scan the conf file and
   then the command line */

#include <stdlib.h>
#include <stdio.h>

#include "test_conf_parser_cmd.h"

static struct my_args_info args_info;

int
main (int argc, char **argv)
{
  struct test_conf_parser_cmd_parser_params *params;
  
  /* initialize the parameters structure */
  params = test_conf_parser_cmd_parser_params_init();
  
  /* 
     initialize args_info
     NOTICE: the other fields of the structure are already initialized to 0. 
  */
  params->initialize = 1;

  /* call the config file parser */
  if (test_conf_parser_cmd_parser_config_file
      ("./test_conf2.conf", &args_info, params) != 0)
    exit(1);

  /* 
     override config file options,
     do not initialize args_info, check for required options.
  */
  params->initialize = 0;
  params->override = 1;
  params->check_required = 1;

  /* call the command line parser */
  if (test_conf_parser_cmd_parser_ext (argc, argv, &args_info, params) != 0)
    exit(1) ;

  printf ("value of required: %s\n", args_info.required_arg);
  printf ("value of string: %s\n", args_info.string_arg);
  printf ("value of no-short_given: %d\n", args_info.no_short_given);
  printf ("value of int: %d\n", args_info.int_arg);
  printf ("value of float: %f\n", args_info.float_arg);

  /* release memory */
  test_conf_parser_cmd_parser_free (&args_info);
  free (params);

  return 0;
}
