/* -*- mode:c -*-
 *
 * Copyright 2020 The Chromium OS Authors. All rights reserved.
 * Use of this source code is governed by a BSD-style license that can be
 * found in the LICENSE file.
 */

/* Declare symbolic names for all the GPIOs that we care about.
 * Note: Those with interrupt handlers must be declared first. */

GPIO_INT(USB_C0_TCPC_INT_ODL,	PIN(3, 4), GPIO_INT_FALLING,			tcpc_alert_event)
GPIO_INT(USB_C1_TCPC_INT_ODL,	PIN(F, 1), GPIO_INT_FALLING,			tcpc_alert_event)
GPIO_INT(USB_C0_PPC_FAULT_ODL,	PIN(6, 3), GPIO_INT_FALLING,			ppc_interrupt)
GPIO_INT(USB_C1_PPC_INT_ODL,	PIN(D, 4), GPIO_INT_BOTH | GPIO_PULL_UP,	ppc_interrupt)
GPIO_INT(USB_C0_BC12_INT_ODL,	PIN(9, 3), GPIO_INT_FALLING | GPIO_PULL_UP,	bc12_interrupt)
GPIO_INT(USB_C1_BC12_INT_ODL, 	PIN(A, 4), GPIO_INT_FALLING | GPIO_PULL_UP,	bc12_interrupt)
GPIO_INT(SLP_S3_L,		PIN(7, 4), GPIO_INT_BOTH,			power_signal_interrupt)
GPIO_INT(SLP_S5_L,		PIN(E, 0), GPIO_INT_BOTH,			power_signal_interrupt)
GPIO_INT(S0_PWROK_OD,		PIN(5, 6), GPIO_INT_BOTH,			power_signal_interrupt)
GPIO_INT(EC_PWROK_OD,		PIN(3, 7), GPIO_INT_BOTH,			power_signal_interrupt)
GPIO_INT(EC_PWR_BTN_ODL,	PIN(0, 1), GPIO_INT_BOTH,			power_button_interrupt)
GPIO_INT(LID_OPEN,		PIN(D, 2), GPIO_INT_BOTH | GPIO_HIB_WAKE_HIGH,	lid_interrupt)
GPIO_INT(TABLET_MODE_L,		PIN(4, 4), GPIO_INT_BOTH,			gmr_tablet_switch_isr)
GPIO_INT(ACOK_OD,		PIN(0, 0), GPIO_INT_BOTH | GPIO_HIB_WAKE_HIGH,	extpower_interrupt)
GPIO_INT(EC_WP_L,		PIN(5, 0), GPIO_INT_BOTH,			switch_interrupt)
GPIO_INT(VOLDN_BTN_ODL,		PIN(A, 6), GPIO_INT_BOTH | GPIO_PULL_UP,	button_interrupt)
GPIO_INT(VOLUP_BTN_ODL,		PIN(9, 5), GPIO_INT_BOTH | GPIO_PULL_UP,	button_interrupt)
GPIO_INT(6AXIS_INT_L,		PIN(A, 0), GPIO_INT_FALLING | GPIO_PULL_UP,	lsm6dsm_interrupt)

/* GPIO_INT_BOTH is required for PSL wake from hibernate, but we don't need an interrupt handler. */
GPIO(EC_RST_ODL,		PIN(0, 2), GPIO_INT_BOTH | GPIO_HIB_WAKE_HIGH)

GPIO(3AXIS_INT_L,		PIN(9, 6), GPIO_INPUT | GPIO_PULL_DOWN)		/* 3 Axis Accel */
GPIO(CCD_MODE_ODL,		PIN(C, 6), GPIO_INPUT)				/* Case Closed Debug Mode */
GPIO(PROCHOT_ODL,		PIN(D, 5), GPIO_ODR_HIGH)			/* PROCHOT to SOC */
GPIO(EC_BATT_PRES_ODL,		PIN(4, 1), GPIO_INPUT)				/* Battery Present */
GPIO(EC_AP_INT_ODL,		PIN(A, 3), GPIO_ODR_HIGH)			/* Sensor MKBP event to SOC */
GPIO(EN_PWR_A,			PIN(B, 7), GPIO_OUT_LOW)			/* Enable Power */
GPIO(EC_EDP_BL_DISABLE,		PIN(A, 2), GPIO_OUT_HIGH)			/* Enable Backlight */
GPIO(EC_ENTERING_RW,		PIN(E, 5), GPIO_OUT_LOW)			/* EC Entering RW */
GPIO(EC_FCH_PWR_BTN_L,		PIN(6, 7), GPIO_OUT_HIGH)			/* Power Button to SOC */
GPIO(EC_FCH_RSMRST_L,		PIN(A, 1), GPIO_OUT_LOW)			/* RSMRST# to SOC */
GPIO(EC_FCH_PWROK,		PIN(7, 0), GPIO_OUT_LOW)			/* Power OK to SOC */
GPIO(EC_FCH_WAKE_L,		PIN(0, 3), GPIO_OUT_HIGH)			/* Wake SOC */
GPIO(EC_FCH_SCI_ODL,		PIN(7, 6), GPIO_ODR_HIGH)			/* SCI to SOC */
GPIO(EC_SYS_RST_L,		PIN(C, 7), GPIO_ODR_HIGH)			/* Cold Reset to SOC */
GPIO(USB_C0_TCPC_RST_L,		PIN(E, 1), GPIO_OUT_HIGH)			/* C0 TCPC Reset */
GPIO(USB_C1_TCPC_RST_L,		PIN(F, 0), GPIO_OUT_HIGH)			/* C1 TCPC Reset */
GPIO(USB3_C0_DP2_HPD,		PIN(F, 5), GPIO_OUT_LOW)			/* C0 DP Hotplug Detect */
GPIO(DP1_HPD,			PIN(F, 4), GPIO_OUT_LOW)			/* C1 DP Hotplug Detect */
GPIO(EC_H1_PACKET_MODE,		PIN(8, 6), GPIO_OUT_LOW)			/* H1 Packet Mode */

UNIMPLEMENTED(PCH_SMI_L)

GPIO(LED_FULL_L,		PIN(6, 0), GPIO_OUT_HIGH)
GPIO(LED_CHRG_L,		PIN(C, 0), GPIO_OUT_HIGH)
GPIO(PWR_LED_WHITE_L,		PIN(C, 3), GPIO_OUT_HIGH)

/*
 * Gumboz has 1 DB options.
 * IOEX_C1_NCT3807 is the DB (USB-C1).
 */

IOEX_INT(USB_C0_SBU_FAULT_ODL,	EXPIN(IOEX_C0_NCT3807, 1, 2), GPIO_INT_FALLING, sbu_fault_interrupt)
IOEX_INT(USB_C1_SBU_FAULT_DB_ODL, EXPIN(IOEX_C1_NCT3807, 1, 2), GPIO_INT_FALLING, sbu_fault_interrupt)

IOEX(USB_C0_FAULT_ODL,		EXPIN(IOEX_C0_NCT3807, 0, 3), GPIO_ODR_HIGH)	/* C0 Fault to SOC */
IOEX(USB_C0_TCPC_FASTSW_CTL_EN,	EXPIN(IOEX_C0_NCT3807, 0, 4), GPIO_OUT_LOW)	/* C0 FastSwitch Control */
IOEX(USB_C1_FAULT_ODL,		EXPIN(IOEX_C0_NCT3807, 1, 0), GPIO_ODR_HIGH)	/* C1 Fault to SOC */
IOEX(USB_C0_PPC_ILIM_3A_EN,	EXPIN(IOEX_C0_NCT3807, 1, 1), GPIO_OUT_LOW)	/* C0 3A Current Limit Enable */
IOEX(KB_BL_EN,			EXPIN(IOEX_C0_NCT3807, 1, 3), GPIO_OUT_LOW)	/* KB Backlight Enable */
IOEX(EN_USB_A0_5V,		EXPIN(IOEX_C0_NCT3807, 1, 5), GPIO_OUT_LOW)	/* A0 5V Source Enable */
IOEX(USB_A0_CHARGE_EN_L,	EXPIN(IOEX_C0_NCT3807, 1, 6), GPIO_OUT_HIGH)	/* A0 5V High Current Enable */
IOEX(USB_C0_SBU_FLIP,		EXPIN(IOEX_C0_NCT3807, 1, 7), GPIO_OUT_LOW)	/* C0 SBU Flip */

IOEX(USB_A1_RETIMER_EN,	EXPIN(IOEX_C1_NCT3807, 0, 0), GPIO_OUT_LOW)	/* A1 Retimer Enable */
IOEX(USB_C1_HPD_IN_DB,		EXPIN(IOEX_C1_NCT3807, 0, 2), GPIO_OUT_LOW)	/* C1 HPD */
IOEX(USB_C1_TCPC_FASTSW_CTL_EN,	EXPIN(IOEX_C1_NCT3807, 0, 4), GPIO_OUT_LOW)	/* C1 FastSwitch Control */
IOEX(USB_C1_PPC_EN_L,		EXPIN(IOEX_C1_NCT3807, 1, 3), GPIO_OUT_LOW)	/* C1 PPC Enable */
IOEX(USB_C1_DATA_EN,		EXPIN(IOEX_C1_NCT3807, 1, 5), GPIO_OUT_HIGH)	/* C1 Retimer Enable */
IOEX(EN_USB_A1_5V_DB,	EXPIN(IOEX_C1_NCT3807, 1, 6), GPIO_OUT_LOW)	/* A1 5V Source Enable */
IOEX(USB_A1_CHARGE_EN_DB_L,EXPIN(IOEX_C1_NCT3807, 1, 7), GPIO_OUT_HIGH)	/* A1 5V High Current Enable */
IOEX(C1_CHARGER_LED_WHITE_DB,EXPIN(IOEX_C1_NCT3807, 1, 0), GPIO_OUT_HIGH)	/* C1 Charge LED White */
IOEX(C1_CHARGER_LED_AMBER_DB,EXPIN(IOEX_C1_NCT3807, 1, 4), GPIO_OUT_HIGH)	/* C1 Charge LED Amber */


/*
 * The NPCX LPC driver configures and controls SCI, so PCH_SCI_ODL [PIN(7, 6)]
 * is not defined here as GPIO.
 */

/* I2C pins - these will be reconfigured for alternate function below */
GPIO(EC_I2C_USB_A0_C0_SCL,	PIN(B, 5), GPIO_INPUT)
GPIO(EC_I2C_USB_A0_C0_SDA,	PIN(B, 4), GPIO_INPUT)
GPIO(EC_I2C_USB_A1_C1_SCL,	PIN(9, 0), GPIO_INPUT)
GPIO(EC_I2C_USB_A1_C1_SDA,	PIN(8, 7), GPIO_INPUT)
GPIO(EC_I2C_POWER_SCL,		PIN(9, 2), GPIO_INPUT)
GPIO(EC_I2C_POWER_SDA,		PIN(9, 1), GPIO_INPUT)
GPIO(EC_I2C_USBC_AP_MUX_SCL,	PIN(D, 1), GPIO_INPUT)
GPIO(EC_I2C_USBC_AP_MUX_SDA,	PIN(D, 0), GPIO_INPUT)
GPIO(FCH_SIC,			PIN(F, 3), GPIO_INPUT)
GPIO(FCH_SID,			PIN(F, 2), GPIO_INPUT)
GPIO(EC_I2C_SENSOR_CBI_SCL,	PIN(3, 3), GPIO_INPUT)
GPIO(EC_I2C_SENSOR_CBI_SDA,	PIN(3, 6), GPIO_INPUT)
GPIO(I2C_AUDIO_USB_HUB_SCL,	PIN(E, 4), GPIO_INPUT | GPIO_SEL_1P8V)
GPIO(I2C_AUDIO_USB_HUB_SDA,	PIN(E, 3), GPIO_INPUT | GPIO_SEL_1P8V)
GPIO(EC_I2C_BATT_SCL,		PIN(B, 3), GPIO_INPUT)
GPIO(EC_I2C_BATT_SDA,		PIN(B, 2), GPIO_INPUT)

ALTERNATE(PIN_MASK(6, BIT(4) | BIT(5)), 0, MODULE_UART, 0) /* Cr50 requires no pullups. */

ALTERNATE(PIN_MASK(B, BIT(4) | BIT(5)), 0, MODULE_I2C, 0)			/* I2C0 */
ALTERNATE(PIN_MASK(9, BIT(0) | BIT(1) | BIT(2)), 0, MODULE_I2C, 0)		/* I2C1 SCL / I2C2 */
ALTERNATE(PIN_MASK(8, BIT(7)), 0, MODULE_I2C, 0)				/* I2C1 SDA */
ALTERNATE(PIN_MASK(D, BIT(0) | BIT(1)), 0, MODULE_I2C, 0)			/* I2C3 */
ALTERNATE(PIN_MASK(F, BIT(2) | BIT(3)), 0, MODULE_I2C, 0)			/* I2C4 */
ALTERNATE(PIN_MASK(3, BIT(3) | BIT(6)), 0, MODULE_I2C, 0)			/* I2C5 */
ALTERNATE(PIN_MASK(E, BIT(3) | BIT(4)), 0, MODULE_I2C, 0)			/* I2C6 */
ALTERNATE(PIN_MASK(B, BIT(2) | BIT(3)), 0, MODULE_I2C, 0)			/* I2C7 */

ALTERNATE(PIN_MASK(4, BIT(2) | BIT(3)), 0, MODULE_ADC, 0)			/* ADC2, ADC3 Temp Sensors */

ALTERNATE(PIN_MASK(8, BIT(0)), 0, MODULE_PWM, 0)				/* PWM3 KB Backlight */

ALTERNATE(PIN_MASK(3, 0x03), 0, MODULE_KEYBOARD_SCAN, GPIO_INPUT)		/* KSI_00-01 */
ALTERNATE(PIN_MASK(2, 0xFC), 0, MODULE_KEYBOARD_SCAN, GPIO_INPUT)		/* KSI_02-07 */
ALTERNATE(PIN_MASK(2, 0x03), 0, MODULE_KEYBOARD_SCAN, GPIO_ODR_HIGH)		/* KSO_00-01 */
GPIO(EC_KSO_02_INV, PIN(1, 7), GPIO_OUT_LOW)					/* KSO_02 inverted */
ALTERNATE(PIN_MASK(1, 0x7F), 0, MODULE_KEYBOARD_SCAN, GPIO_ODR_HIGH)		/* KSO_03-09 */
ALTERNATE(PIN_MASK(0, 0xE0), 0, MODULE_KEYBOARD_SCAN, GPIO_ODR_HIGH)		/* KSO_10-12 */

/* Power Switch Logic (PSL) inputs */
ALTERNATE(PIN_MASK(0, BIT(0) | BIT(1) | BIT(2)), 0, MODULE_PMU, 0)		/* AC_PRESENT, POWER_BUTTON_L, EC_RST_ODL */
ALTERNATE(PIN_MASK(D, BIT(2)), 0, MODULE_PMU, 0)				/* LID_OPEN */

ALTERNATE(PIN_MASK(A, 0xA0), 1,  MODULE_WOV, 0) 				/* I2S_SYNC/I2S_SCLK  GPIOA5/A7 */
ALTERNATE(PIN_MASK(B, 0x01), 1,  MODULE_WOV, 0) 				/* I2S_SDAT           GPIOB0    */
ALTERNATE(PIN_MASK(9, 0x90), 1,  MODULE_WOV, 0) 				/* DMIC_CLK/DMIC_IN   GPIO94/97 */
