/* -*- Mode: c++ -*- */
/*
 * Copyright 2001 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
/*
 *  Copyright 1999 Massachusetts Institute of Technology
 * 
 *  Permission to use, copy, modify, distribute, and sell this software and its
 *  documentation for any purpose is hereby granted without fee, provided that
 *  the above copyright notice appear in all copies and that both that
 *  copyright notice and this permission notice appear in supporting
 *  documentation, and that the name of M.I.T. not be used in advertising or
 *  publicity pertaining to distribution of the software without specific,
 *  written prior permission.  M.I.T. makes no representations about the
 *  suitability of this software for any purpose.  It is provided "as is"
 *  without express or implied warranty.
 * 
 */

/*
    This program will  1. read the data generated from the GuPPI
                       2. slice the symbol according to the symbol rate.
                       3. do manchester decoding
                       4. decode the type of the message 
 */
//--------------------------------------------------------------------------

#include <VrGuppiSource.h>
#include <VrFileSink.h>
#include <VrSigSource.h>
#include <VrConnect.h>
//#include "VrGUI.h"
#include <VrManchester.h>
#include <VrFileSource.h>
#include <VrSlicing.h>
#include <VrControlAmpsDecode.h>

//--------------------------------------------------------------------------

int main(int argc, char **argv)
{
  int inputRate,  sample_per_bit, sliceRate, manchesterRate;
  int decodeRate;
  int count=0;
  int slicingDecimation=5; // 5:1  <---> input:output
  int manchesterDecimation= 2; // 2:1
  int controlAmpsDecodeDecimation= 1; // 1:1
  
  //VrGUI *guimain = new VrGUI(argc, argv);
  inputRate = 100000;                        
  sliceRate = inputRate / slicingDecimation;
  manchesterRate = sliceRate / manchesterDecimation;
  decodeRate = manchesterRate / controlAmpsDecodeDecimation;
  sample_per_bit = 5;

  //define objects.
  VrFileSource<char>* source = new VrFileSource<char>("tmp_backup.dat"); 
  VrSlicing<char>* slice = new VrSlicing<char>(slicingDecimation, sample_per_bit); 
  VrFileSink<char>* sink = new VrFileSink<char>("tmp.dat"); 
  VrManchester<char>* manchester = new VrManchester<char>(manchesterDecimation);
  VrControlAmpsDecode<char>* ampsDecode = new VrControlAmpsDecode<char>(controlAmpsDecodeDecimation);
    
  /* connect the modules together. It works like this
     : CONNECT(output, input, transfer rate, ??). 
  */
  CONNECT(sink, ampsDecode, decodeRate, 8);
  CONNECT(ampsDecode  , manchester , manchesterRate , 8);
  CONNECT(manchester , slice, sliceRate , 8);
  CONNECT(slice, source, inputRate , 8);


  sink->start(); 
  //guimain->start(); 

    //start the process
    while (count < 70) {
      //guimain->processEvents(10 /*ms*/);
      sink->process();  
      count += 1;
    }  

    sink->stop();
  
} //end of main();

//--------------------------------------------------------------------------




