/*
 * Decompiled with CFR 0.152.
 */
package gnu.bytecode;

import gnu.bytecode.Filter;
import gnu.bytecode.Method;
import gnu.bytecode.ObjectType;
import gnu.bytecode.Type;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayType
extends ObjectType
implements Externalizable {
    public Type elements;

    public ArrayType(Type type) {
        this(type, type.getName() + "[]");
    }

    ArrayType(Type type, String string) {
        this.this_name = string;
        this.setSignature("[" + type.getSignature());
        this.elements = type;
    }

    @Override
    public Type getImplementationType() {
        Type type = this.elements.getImplementationType();
        return this.elements == type ? this : ArrayType.make(type);
    }

    static ArrayType make(String string) {
        Type type = Type.getType(string.substring(0, string.length() - 2));
        ArrayType arrayType = type.array_type;
        if (arrayType == null) {
            type.array_type = arrayType = new ArrayType(type, string);
        }
        return arrayType;
    }

    public static ArrayType make(Type type) {
        ArrayType arrayType = type.array_type;
        if (arrayType == null) {
            type.array_type = arrayType = new ArrayType(type, type.getName() + "[]");
        }
        return arrayType;
    }

    public Type getComponentType() {
        return this.elements;
    }

    @Override
    public String getInternalName() {
        return this.getSignature();
    }

    @Override
    public Class getReflectClass() {
        block3: {
            try {
                if (this.reflectClass == null) {
                    String string = this.getInternalName().replace('/', '.');
                    Class clazz = this.elements.getReflectClass();
                    this.reflectClass = Class.forName(string, false, clazz.getClassLoader());
                }
                this.flags |= 0x10;
            }
            catch (ClassNotFoundException classNotFoundException) {
                if ((this.flags & 0x10) == 0) break block3;
                RuntimeException runtimeException = new RuntimeException("no such array class: " + this.getName());
                runtimeException.initCause(classNotFoundException);
                throw runtimeException;
            }
        }
        return this.reflectClass;
    }

    @Override
    public int getMethods(Filter filter, int n, List<Method> list) {
        if (n > 0) {
            int n2 = Type.objectType.getMethods(filter, 0, list);
            if (n > 1 && filter.select(Type.clone_method)) {
                if (list != null) {
                    Method method = Type.clone_method;
                    list.add(method);
                }
                ++n2;
            }
            return n2;
        }
        return 0;
    }

    @Override
    public int compare(Type type) {
        if (type == nullType) {
            return 1;
        }
        if (type instanceof ArrayType) {
            return this.elements.compare(((ArrayType)type).elements);
        }
        if (type.getName().equals("java.lang.Object") || type == toStringType) {
            return -1;
        }
        return -3;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.elements);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.elements = (Type)objectInput.readObject();
    }

    public Object readResolve() throws ObjectStreamException {
        ArrayType arrayType = this.elements.array_type;
        if (arrayType != null) {
            return arrayType;
        }
        this.elements.array_type = this;
        return this;
    }
}

