/*
 * Decompiled with CFR 0.152.
 */
package gnu.bytecode;

import gnu.bytecode.Attribute;
import gnu.bytecode.ClassTypeWriter;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Label;
import gnu.bytecode.Method;
import gnu.bytecode.ObjectType;
import gnu.bytecode.PrimType;
import gnu.bytecode.Type;
import gnu.bytecode.UninitializedType;
import java.io.DataOutputStream;
import java.io.IOException;

public class StackMapTableAttr
extends Attribute {
    public static boolean compressStackMapTable = true;
    byte[] data;
    int dataLength;
    int numEntries;
    int prevPosition = -1;
    int[] encodedLocals;
    int[] encodedStack;
    int countLocals;
    int countStack;

    public StackMapTableAttr() {
        super("StackMapTable");
    }

    public StackMapTableAttr(int n, byte[] byArray, CodeAttr codeAttr) {
        super("StackMapTable");
        this.addToFrontOf(codeAttr);
        this.numEntries = n;
        this.data = byArray;
        this.dataLength = byArray.length;
    }

    public Method getMethod() {
        return ((CodeAttr)this.container).getMethod();
    }

    public int getLength() {
        return 2 + this.dataLength;
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.numEntries);
        dataOutputStream.write(this.data, 0, this.dataLength);
    }

    private int u1(int n) {
        return this.data[n] & 0xFF;
    }

    private int u2(int n) {
        return ((this.data[n] & 0xFF) << 8) + (this.data[n + 1] & 0xFF);
    }

    private void put1(int n) {
        if (this.data == null) {
            this.data = new byte[20];
        } else if (this.dataLength >= this.data.length) {
            byte[] byArray = new byte[2 * this.data.length];
            System.arraycopy(this.data, 0, byArray, 0, this.dataLength);
            this.data = byArray;
        }
        this.data[this.dataLength++] = (byte)n;
    }

    private void put2(int n) {
        this.put1((byte)(n >> 8));
        this.put1((byte)n);
    }

    private void put2(int n, int n2) {
        this.data[n] = (byte)(n2 >> 8);
        this.data[n + 1] = (byte)n2;
    }

    void emitVerificationType(int n) {
        int n2 = n & 0xFF;
        this.put1(n2);
        if (n2 >= 7) {
            this.put2(n >> 8);
        }
    }

    int encodeVerificationType(Type type, CodeAttr codeAttr) {
        if (type == null) {
            return 0;
        }
        if (type instanceof UninitializedType) {
            UninitializedType uninitializedType = (UninitializedType)type;
            Label label = uninitializedType.label;
            if (label == null) {
                return 6;
            }
            return label.position << 8 | 8;
        }
        if ((type = type.getImplementationType()) instanceof PrimType) {
            switch (type.signature.charAt(0)) {
                case 'B': 
                case 'C': 
                case 'I': 
                case 'S': 
                case 'Z': {
                    return 1;
                }
                case 'J': {
                    return 4;
                }
                case 'F': {
                    return 2;
                }
                case 'D': {
                    return 3;
                }
            }
            return 0;
        }
        if (type == Type.nullType) {
            return 5;
        }
        return codeAttr.getConstants().addClass((ObjectType)((ObjectType)type)).index << 8 | 7;
    }

    public void emitStackMapEntry(Label label, CodeAttr codeAttr) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = this.dataLength;
        int n6 = label.position - this.prevPosition - 1;
        boolean bl = false;
        int n7 = label.localTypes.length;
        if (n7 > this.encodedLocals.length) {
            int[] nArray = new int[n7 + this.encodedLocals.length];
            System.arraycopy(this.encodedLocals, 0, nArray, 0, this.countLocals);
            this.encodedLocals = nArray;
        }
        if ((n4 = label.stackTypes.length) > this.encodedStack.length) {
            int[] nArray = new int[n4 + this.encodedStack.length];
            System.arraycopy(this.encodedStack, 0, nArray, 0, this.countStack);
            this.encodedStack = nArray;
        }
        int n8 = 0;
        int n9 = 0;
        for (n3 = 0; n3 < n7; ++n3) {
            n2 = this.encodedLocals[n9];
            n = this.encodeVerificationType(label.localTypes[n3], codeAttr);
            if (n2 == n && n8 == n9) {
                n8 = n9 + 1;
            }
            this.encodedLocals[n9++] = n;
            if (n != 3 && n != 4) continue;
            ++n3;
        }
        n3 = 0;
        for (n2 = 0; n2 < n4; ++n2) {
            n = this.encodedStack[n3];
            Type type = label.stackTypes[n2];
            if (type == Type.voidType) {
                type = label.stackTypes[++n2];
            }
            int n10 = this.encodeVerificationType(type, codeAttr);
            this.encodedStack[n3++] = n10;
        }
        n2 = n9 - this.countLocals;
        if (compressStackMapTable && n2 == 0 && n9 == n8 && n3 <= 1) {
            if (n3 == 0) {
                if (n6 <= 63) {
                    this.put1(n6);
                } else {
                    this.put1(251);
                    this.put2(n6);
                }
            } else {
                if (n6 <= 63) {
                    this.put1(64 + n6);
                } else {
                    this.put1(247);
                    this.put2(n6);
                }
                this.emitVerificationType(this.encodedStack[0]);
            }
        } else if (compressStackMapTable && n3 == 0 && n9 < this.countLocals && n8 == n9 && n2 >= -3) {
            this.put1(251 + n2);
            this.put2(n6);
        } else if (compressStackMapTable && n3 == 0 && this.countLocals == n8 && n2 <= 3) {
            this.put1(251 + n2);
            this.put2(n6);
            for (n = 0; n < n2; ++n) {
                this.emitVerificationType(this.encodedLocals[n8 + n]);
            }
        } else {
            this.put1(255);
            this.put2(n6);
            this.put2(n9);
            for (n = 0; n < n9; ++n) {
                this.emitVerificationType(this.encodedLocals[n]);
            }
            this.put2(n3);
            for (n = 0; n < n3; ++n) {
                this.emitVerificationType(this.encodedStack[n]);
            }
        }
        this.countLocals = n9;
        this.countStack = n3;
        this.prevPosition = label.position;
        ++this.numEntries;
    }

    void printVerificationType(int n, ClassTypeWriter classTypeWriter) {
        int n2 = n & 0xFF;
        switch (n2) {
            case 0: {
                classTypeWriter.print("top/unavailable");
                break;
            }
            case 1: {
                classTypeWriter.print("integer");
                break;
            }
            case 2: {
                classTypeWriter.print("float");
                break;
            }
            case 3: {
                classTypeWriter.print("double");
                break;
            }
            case 4: {
                classTypeWriter.print("long");
                break;
            }
            case 5: {
                classTypeWriter.print("null");
                break;
            }
            case 6: {
                classTypeWriter.print("uninitialized this");
                break;
            }
            case 7: {
                int n3 = n >> 8;
                classTypeWriter.printOptionalIndex(n3);
                classTypeWriter.printConstantTersely(n3, 7);
                break;
            }
            case 8: {
                int n4 = n >> 8;
                classTypeWriter.print("uninitialized object created at ");
                classTypeWriter.print(n4);
                break;
            }
            default: {
                classTypeWriter.print("<bad verification type tag " + n2 + '>');
            }
        }
    }

    int extractVerificationType(int n, int n2) {
        if (n2 == 7 || n2 == 8) {
            int n3 = this.u2(n + 1);
            n2 |= n3 << 8;
        }
        return n2;
    }

    static int[] reallocBuffer(int[] nArray, int n) {
        if (nArray == null) {
            nArray = new int[n + 10];
        } else if (n > nArray.length) {
            int[] nArray2 = new int[n + 10];
            System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
            nArray = nArray2;
        }
        return nArray;
    }

    int extractVerificationTypes(int n, int n2, int n3, int[] nArray) {
        int n4 = n;
        while (--n2 >= 0) {
            int n5;
            if (n4 >= this.dataLength) {
                n5 = -1;
            } else {
                byte by = this.data[n4];
                n5 = this.extractVerificationType(n4, by);
                n4 += by == 7 || by == 8 ? 3 : 1;
            }
            nArray[n3++] = n5;
        }
        return n4;
    }

    void printVerificationTypes(int[] nArray, int n, int n2, ClassTypeWriter classTypeWriter) {
        int n3 = 0;
        for (int i = 0; i < n + n2; ++i) {
            int n4 = nArray[i];
            int n5 = n4 & 0xFF;
            if (i >= n) {
                classTypeWriter.print("  ");
                if (n3 < 100) {
                    if (n3 < 10) {
                        classTypeWriter.print(' ');
                    }
                    classTypeWriter.print(' ');
                }
                classTypeWriter.print(n3);
                classTypeWriter.print(": ");
                this.printVerificationType(n4, classTypeWriter);
                classTypeWriter.println();
            }
            ++n3;
            if (n5 != 3 && n5 != 4) continue;
            ++n3;
        }
    }

    public void print(ClassTypeWriter classTypeWriter) {
        classTypeWriter.print("Attribute \"");
        classTypeWriter.print(this.getName());
        classTypeWriter.print("\", length:");
        classTypeWriter.print(this.getLength());
        classTypeWriter.print(", number of entries: ");
        classTypeWriter.println(this.numEntries);
        int n = 0;
        int n2 = -1;
        Method method = this.getMethod();
        int[] nArray = null;
        int n3 = (method.getStaticFlag() ? 0 : 1) + method.arg_types.length;
        int n4 = 0;
        for (int i = 0; i < this.numEntries; ++i) {
            if (n >= this.dataLength) {
                i = -1;
                break;
            }
            int n5 = this.u1(n++);
            ++n2;
            int n6 = -1;
            if (n5 <= 127) {
                n2 += n5 & 0x3F;
            } else {
                if (n + 1 >= this.dataLength) {
                    n = -1;
                    break;
                }
                n6 = this.u2(n);
                n2 += n6;
                n += 2;
            }
            classTypeWriter.print("  offset: ");
            classTypeWriter.print(n2);
            if (n5 <= 63) {
                classTypeWriter.println(" - same_frame");
                n4 = 0;
            } else if (n5 <= 127 || n5 == 247) {
                classTypeWriter.println(n5 <= 127 ? " - same_locals_1_stack_item_frame" : " - same_locals_1_stack_item_frame_extended");
                nArray = StackMapTableAttr.reallocBuffer(nArray, 1);
                n = this.extractVerificationTypes(n, 1, 0, nArray);
                this.printVerificationTypes(nArray, 0, 1, classTypeWriter);
                n4 = 1;
            } else {
                int n7;
                if (n5 <= 246) {
                    classTypeWriter.print(" - tag reserved for future use - ");
                    classTypeWriter.println(n5);
                    break;
                }
                if (n5 <= 250) {
                    n7 = 251 - n5;
                    classTypeWriter.print(" - chop_frame - undefine ");
                    classTypeWriter.print(n7);
                    classTypeWriter.println(" locals");
                    n3 -= n7;
                    n4 = 0;
                } else if (n5 == 251) {
                    classTypeWriter.println(" - same_frame_extended");
                    n4 = 0;
                } else if (n5 <= 254) {
                    n7 = n5 - 251;
                    classTypeWriter.print(" - append_frame - define ");
                    classTypeWriter.print(n7);
                    classTypeWriter.println(" more locals");
                    nArray = StackMapTableAttr.reallocBuffer(nArray, n3 + n7);
                    n = this.extractVerificationTypes(n, n7, n3, nArray);
                    this.printVerificationTypes(nArray, n3, n7, classTypeWriter);
                    n3 += n7;
                    n4 = 0;
                } else {
                    if (n + 1 >= this.dataLength) {
                        n = -1;
                        break;
                    }
                    n7 = this.u2(n);
                    n += 2;
                    classTypeWriter.print(" - full_frame.  Locals count: ");
                    classTypeWriter.println(n7);
                    nArray = StackMapTableAttr.reallocBuffer(nArray, n7);
                    n = this.extractVerificationTypes(n, n7, 0, nArray);
                    this.printVerificationTypes(nArray, 0, n7, classTypeWriter);
                    n3 = n7;
                    if (n + 1 >= this.dataLength) {
                        n = -1;
                        break;
                    }
                    int n8 = this.u2(n);
                    n += 2;
                    classTypeWriter.print("    (end of locals)");
                    int n9 = Integer.toString(n2).length();
                    while (--n9 >= 0) {
                        classTypeWriter.print(' ');
                    }
                    classTypeWriter.print("       Stack count: ");
                    classTypeWriter.println(n8);
                    nArray = StackMapTableAttr.reallocBuffer(nArray, n8);
                    n = this.extractVerificationTypes(n, n8, 0, nArray);
                    this.printVerificationTypes(nArray, 0, n8, classTypeWriter);
                    n4 = n8;
                }
            }
            if (n >= 0) continue;
            classTypeWriter.println("<ERROR - missing data>");
            return;
        }
    }
}

