/*
 * Decompiled with CFR 0.152.
 */
package gnu.bytecode;

import gnu.bytecode.ArrayType;
import gnu.bytecode.ClassToTypeMap;
import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Method;
import gnu.bytecode.ObjectType;
import gnu.bytecode.PrimType;
import java.io.PrintWriter;
import java.util.HashMap;

public abstract class Type
implements java.lang.reflect.Type {
    String signature;
    String this_name;
    int size;
    ArrayType array_type;
    static ClassToTypeMap mapClassToType;
    static HashMap<String, Type> mapNameToType;
    public static final PrimType byteType;
    public static final PrimType shortType;
    public static final PrimType intType;
    public static final PrimType longType;
    public static final PrimType floatType;
    public static final PrimType doubleType;
    public static final PrimType booleanType;
    public static final PrimType charType;
    public static final PrimType voidType;
    public static final PrimType byte_type;
    public static final PrimType short_type;
    public static final PrimType int_type;
    public static final PrimType long_type;
    public static final PrimType float_type;
    public static final PrimType double_type;
    public static final PrimType boolean_type;
    public static final PrimType char_type;
    public static final PrimType void_type;
    public static final PrimType neverReturnsType;
    public static final ObjectType nullType;
    public static final ObjectType errorType;
    public static ClassType javalangStringType;
    public static final ClassType toStringType;
    public static final ClassType javalangObjectType;
    public static final ClassType objectType;
    public static final ClassType javalangBooleanType;
    public static final ClassType javalangThrowableType;
    public static final Type[] typeArray0;
    public static final Method toString_method;
    public static final ClassType javalangNumberType;
    public static final Method clone_method;
    public static final Method intValue_method;
    public static final Method longValue_method;
    public static final Method floatValue_method;
    public static final Method doubleValue_method;
    public static final Method booleanValue_method;
    public static final ClassType javalangClassType;
    public static final ClassType pointer_type;
    public static final ClassType string_type;
    public static final ClassType tostring_type;
    public static final ClassType java_lang_Class_type;
    public static final ClassType boolean_ctype;
    public static final ClassType throwable_type;
    public static final ClassType number_type;
    protected Class reflectClass;

    protected Type() {
    }

    public Type getImplementationType() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Type lookupType(String string) {
        HashMap<String, Type> hashMap;
        HashMap<String, Type> hashMap2 = hashMap = mapNameToType;
        synchronized (hashMap2) {
            return hashMap.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Type getType(String string) {
        HashMap<String, Type> hashMap;
        HashMap<String, Type> hashMap2 = hashMap = mapNameToType;
        synchronized (hashMap2) {
            Type type = hashMap.get(string);
            if (type == null) {
                if (string.endsWith("[]")) {
                    type = ArrayType.make(string);
                } else {
                    ClassType classType = new ClassType(string);
                    classType.flags |= 0x10;
                    type = classType;
                }
                hashMap.put(string, type);
            }
            return type;
        }
    }

    public static synchronized void registerTypeForClass(Class clazz, Type type) {
        ClassToTypeMap classToTypeMap = mapClassToType;
        if (classToTypeMap == null) {
            mapClassToType = classToTypeMap = new ClassToTypeMap(100);
        }
        type.reflectClass = clazz;
        classToTypeMap.put(clazz, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized Type make(Class clazz) {
        Type type;
        Object object2;
        if (mapClassToType != null && (object2 = (Type)mapClassToType.get(clazz)) != null) {
            return object2;
        }
        if (clazz.isArray()) {
            type = ArrayType.make(Type.make(clazz.getComponentType()));
        } else {
            HashMap<String, Type> hashMap;
            if (clazz.isPrimitive()) {
                throw new Error("internal error - primitive type not found");
            }
            object2 = clazz.getName();
            HashMap<String, Type> hashMap2 = hashMap = mapNameToType;
            synchronized (hashMap2) {
                type = hashMap.get(object2);
                if (type == null || type.reflectClass != clazz && type.reflectClass != null) {
                    ClassType classType = new ClassType((String)object2);
                    classType.flags |= 0x10;
                    type = classType;
                    mapNameToType.put((String)object2, type);
                }
            }
        }
        Type.registerTypeForClass(clazz, type);
        return type;
    }

    public final String getSignature() {
        return this.signature;
    }

    protected void setSignature(String string) {
        this.signature = string;
    }

    Type(String string, String string2) {
        this.this_name = string;
        this.signature = string2;
    }

    public Type(Type type) {
        this.this_name = type.this_name;
        this.signature = type.signature;
        this.size = type.size;
        this.reflectClass = type.reflectClass;
    }

    public Type promote() {
        return this.size < 4 ? intType : this;
    }

    public final int getSize() {
        return this.size;
    }

    public int getSizeInWords() {
        return this.size > 4 ? 2 : 1;
    }

    public final boolean isVoid() {
        return this.size == 0;
    }

    public static PrimType signatureToPrimitive(char c) {
        switch (c) {
            case 'B': {
                return byteType;
            }
            case 'C': {
                return charType;
            }
            case 'D': {
                return doubleType;
            }
            case 'F': {
                return floatType;
            }
            case 'S': {
                return shortType;
            }
            case 'I': {
                return intType;
            }
            case 'J': {
                return longType;
            }
            case 'Z': {
                return booleanType;
            }
            case 'V': {
                return voidType;
            }
        }
        return null;
    }

    public static Type signatureToType(String string, int n, int n2) {
        Type type;
        if (n2 == 0) {
            return null;
        }
        char c = string.charAt(n);
        if (n2 == 1 && (type = Type.signatureToPrimitive(c)) != null) {
            return type;
        }
        if (c == '[') {
            type = Type.signatureToType(string, n + 1, n2 - 1);
            return type == null ? null : ArrayType.make(type);
        }
        if (c == 'L' && n2 > 2 && string.indexOf(59, n) == n2 - 1 + n) {
            return ClassType.make(string.substring(n + 1, n2 - 1 + n).replace('/', '.'));
        }
        return null;
    }

    public static Type signatureToType(String string) {
        return Type.signatureToType(string, 0, string.length());
    }

    public static void printSignature(String string, int n, int n2, PrintWriter printWriter) {
        if (n2 == 0) {
            return;
        }
        char c = string.charAt(n);
        if (n2 == 1) {
            PrimType primType = Type.signatureToPrimitive(c);
            if (primType != null) {
                printWriter.print(primType.getName());
            }
            return;
        }
        if (c == '[') {
            Type.printSignature(string, n + 1, n2 - 1, printWriter);
            printWriter.print("[]");
            return;
        }
        if (c == 'L' && n2 > 2 && string.indexOf(59, n) == n2 - 1 + n) {
            printWriter.print(string.substring(n + 1, n2 - 1 + n).replace('/', '.'));
        }
    }

    public static int signatureLength(String string, int n) {
        int n2;
        int n3 = string.length();
        if (n3 <= n) {
            return -1;
        }
        char c = string.charAt(n);
        int n4 = 0;
        while (c == '[') {
            ++n4;
            c = string.charAt(++n);
        }
        if (Type.signatureToPrimitive(c) != null) {
            return n4 + 1;
        }
        if (c == 'L' && (n2 = string.indexOf(59, n)) > 0) {
            return n4 + n2 + 1 - n;
        }
        return -1;
    }

    public static int signatureLength(String string) {
        return Type.signatureLength(string, 0);
    }

    public static String signatureToName(String string) {
        PrimType primType;
        int n = string.length();
        if (n == 0) {
            return null;
        }
        char c = string.charAt(0);
        if (n == 1 && (primType = Type.signatureToPrimitive(c)) != null) {
            return primType.getName();
        }
        if (c == '[') {
            int n2 = 1;
            if (n2 < n && string.charAt(n2) == '[') {
                ++n2;
            }
            if ((string = Type.signatureToName(string.substring(n2))) == null) {
                return null;
            }
            StringBuffer stringBuffer = new StringBuffer(50);
            stringBuffer.append(string);
            while (--n2 >= 0) {
                stringBuffer.append("[]");
            }
            return stringBuffer.toString();
        }
        if (c == 'L' && n > 2 && string.indexOf(59) == n - 1) {
            return string.substring(1, n - 1).replace('/', '.');
        }
        return null;
    }

    public final String getName() {
        return this.this_name;
    }

    protected void setName(String string) {
        this.this_name = string;
    }

    public static boolean isValidJavaTypeName(String string) {
        int n;
        int n2;
        boolean bl = false;
        for (n2 = string.length(); n2 > 2 && string.charAt(n2 - 1) == ']' && string.charAt(n2 - 2) == '['; n2 -= 2) {
        }
        for (n = 0; n < n2; ++n) {
            char c = string.charAt(n);
            if (c == '.') {
                if (bl) {
                    bl = false;
                    continue;
                }
                return false;
            }
            if (bl ? Character.isJavaIdentifierPart(c) : Character.isJavaIdentifierStart(c)) {
                bl = true;
                continue;
            }
            return false;
        }
        return n == n2;
    }

    public boolean isInstance(Object object2) {
        return this.getReflectClass().isInstance(object2);
    }

    public final boolean isSubtype(Type type) {
        int n = this.compare(type);
        return n == -1 || n == 0;
    }

    public static Type lowestCommonSuperType(Type type, Type type2) {
        if (type == neverReturnsType) {
            return type2;
        }
        if (type2 == neverReturnsType) {
            return type;
        }
        if (type == null || type2 == null) {
            return null;
        }
        if (type instanceof PrimType && type2 instanceof PrimType) {
            if (type == type2) {
                return type;
            }
            return (type = ((PrimType)type).promotedType()) == (type2 = ((PrimType)type2).promotedType()) ? type : null;
        }
        if (type.isSubtype(type2)) {
            return type2;
        }
        if (type2.isSubtype(type)) {
            return type;
        }
        if (!(type instanceof ClassType) || !(type2 instanceof ClassType)) {
            return objectType;
        }
        ClassType classType = (ClassType)type;
        ClassType classType2 = (ClassType)type2;
        if (classType.isInterface() || classType2.isInterface()) {
            return objectType;
        }
        return Type.lowestCommonSuperType(classType.getSuperclass(), classType2.getSuperclass());
    }

    public abstract int compare(Type var1);

    protected static int swappedCompareResult(int n) {
        return n == 1 ? -1 : (n == -1 ? 1 : n);
    }

    public static boolean isMoreSpecific(Type[] typeArray, Type[] typeArray2) {
        if (typeArray.length != typeArray2.length) {
            return false;
        }
        int n = typeArray.length;
        while (--n >= 0) {
            if (typeArray[n].isSubtype(typeArray2[n])) continue;
            return false;
        }
        return true;
    }

    public void emitIsInstance(CodeAttr codeAttr) {
        codeAttr.emitInstanceof(this);
    }

    public abstract Object coerceFromObject(Object var1);

    public Object coerceToObject(Object object2) {
        return object2;
    }

    public void emitCoerceToObject(CodeAttr codeAttr) {
    }

    public void emitCoerceFromObject(CodeAttr codeAttr) {
        throw new Error("unimplemented emitCoerceFromObject for " + this);
    }

    public Class getReflectClass() {
        return this.reflectClass;
    }

    public void setReflectClass(Class clazz) {
        this.reflectClass = clazz;
    }

    public String toString() {
        return "Type " + this.getName();
    }

    public int hashCode() {
        String string = this.toString();
        return string == null ? 0 : string.hashCode();
    }

    static {
        byteType = new PrimType("byte", "B", 1, Byte.TYPE);
        shortType = new PrimType("short", "S", 2, Short.TYPE);
        intType = new PrimType("int", "I", 4, Integer.TYPE);
        longType = new PrimType("long", "J", 8, Long.TYPE);
        floatType = new PrimType("float", "F", 4, Float.TYPE);
        doubleType = new PrimType("double", "D", 8, Double.TYPE);
        booleanType = new PrimType("boolean", "Z", 1, Boolean.TYPE);
        charType = new PrimType("char", "C", 2, Character.TYPE);
        voidType = new PrimType("void", "V", 0, Void.TYPE);
        byte_type = byteType;
        short_type = shortType;
        int_type = intType;
        long_type = longType;
        float_type = floatType;
        double_type = doubleType;
        boolean_type = booleanType;
        char_type = charType;
        void_type = voidType;
        mapNameToType = new HashMap();
        mapNameToType.put("byte", byteType);
        mapNameToType.put("short", shortType);
        mapNameToType.put("int", intType);
        mapNameToType.put("long", longType);
        mapNameToType.put("float", floatType);
        mapNameToType.put("double", doubleType);
        mapNameToType.put("boolean", booleanType);
        mapNameToType.put("char", charType);
        mapNameToType.put("void", voidType);
        neverReturnsType = new PrimType(voidType);
        Type.neverReturnsType.this_name = "(never-returns)";
        nullType = new ObjectType("(type of null)");
        errorType = new ClassType("(error type)");
        javalangStringType = ClassType.make("java.lang.String");
        toStringType = new ClassType("java.lang.String");
        objectType = javalangObjectType = ClassType.make("java.lang.Object");
        javalangBooleanType = ClassType.make("java.lang.Boolean");
        javalangThrowableType = ClassType.make("java.lang.Throwable");
        typeArray0 = new Type[0];
        toString_method = objectType.getDeclaredMethod("toString", 0);
        javalangNumberType = ClassType.make("java.lang.Number");
        clone_method = Method.makeCloneMethod(objectType);
        intValue_method = javalangNumberType.addMethod("intValue", typeArray0, intType, 1);
        longValue_method = javalangNumberType.addMethod("longValue", typeArray0, longType, 1);
        floatValue_method = javalangNumberType.addMethod("floatValue", typeArray0, floatType, 1);
        doubleValue_method = javalangNumberType.addMethod("doubleValue", typeArray0, doubleType, 1);
        booleanValue_method = javalangBooleanType.addMethod("booleanValue", typeArray0, booleanType, 1);
        javalangClassType = ClassType.make("java.lang.Class");
        pointer_type = javalangObjectType;
        string_type = javalangStringType;
        tostring_type = toStringType;
        java_lang_Class_type = javalangClassType;
        boolean_ctype = javalangBooleanType;
        throwable_type = javalangThrowableType;
        number_type = javalangNumberType;
    }
}

