/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.expr.Compilation;
import gnu.expr.Expression;
import gnu.expr.Target;
import gnu.mapping.OutPort;
import gnu.text.SourceMessages;

public class ErrorExp
extends Expression {
    String message;

    public ErrorExp(String string) {
        this.message = string;
    }

    public ErrorExp(String string, SourceMessages sourceMessages) {
        sourceMessages.error('e', string);
        this.message = string;
    }

    public ErrorExp(String string, Compilation compilation) {
        compilation.getMessages().error('e', string);
        this.message = string;
    }

    protected boolean mustCompile() {
        return false;
    }

    public void print(OutPort outPort) {
        outPort.startLogicalBlock("(Error", false, ")");
        outPort.writeSpaceLinear();
        outPort.print(this.message);
        outPort.endLogicalBlock(")");
    }

    public void compile(Compilation compilation, Target target) {
        throw new Error(compilation.getFileName() + ":" + compilation.getLineNumber() + ": internal error: compiling error expression: " + this.message);
    }
}

