/*
 * Decompiled with CFR 0.152.
 */
package gnu.mapping;

import gnu.lists.Consumer;
import gnu.lists.Sequence;
import gnu.lists.TreeList;
import gnu.mapping.Procedure;
import gnu.text.Printable;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.util.Enumeration;

public class Values
extends TreeList
implements Printable,
Externalizable {
    public static final Object[] noArgs = new Object[0];
    public static final Values empty = new Values(noArgs);

    public Values() {
    }

    public Values(Object[] objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            this.writeObject(objectArray[i]);
        }
    }

    public Object[] getValues() {
        return this.isEmpty() ? noArgs : this.toArray();
    }

    public static Object values(Object ... objectArray) {
        return Values.make(objectArray);
    }

    public static Values make() {
        return new Values();
    }

    public static Object make(Object[] objectArray) {
        if (objectArray.length == 1) {
            return objectArray[0];
        }
        if (objectArray.length == 0) {
            return empty;
        }
        return new Values(objectArray);
    }

    public static Object make(Sequence sequence) {
        int n = sequence.size();
        if (n == 0) {
            return empty;
        }
        if (n == 1) {
            return sequence.get(0);
        }
        Values values = new Values();
        Enumeration enumeration = sequence.elements();
        while (enumeration.hasMoreElements()) {
            values.writeObject(enumeration.nextElement());
        }
        return values;
    }

    public static Object make(TreeList treeList) {
        return Values.make(treeList, 0, treeList.data.length);
    }

    public static Object make(TreeList treeList, int n, int n2) {
        int n3;
        if (n == n2 || (n3 = treeList.nextDataIndex(n)) <= 0) {
            return empty;
        }
        if (n3 == n2 || treeList.nextDataIndex(n3) < 0) {
            return treeList.getPosNext(n << 1);
        }
        Values values = new Values();
        treeList.consumeIRange(n, n2, values);
        return values;
    }

    public final Object canonicalize() {
        if (this.gapEnd == this.data.length) {
            if (this.gapStart == 0) {
                return empty;
            }
            if (this.nextDataIndex(0) == this.gapStart) {
                return this.getPosNext(0);
            }
        }
        return this;
    }

    public Object call_with(Procedure procedure) throws Throwable {
        return procedure.applyN(this.toArray());
    }

    public void print(Consumer consumer) {
        int n;
        if (this == empty) {
            consumer.write("#!void");
            return;
        }
        Object[] objectArray = this.toArray();
        int n2 = objectArray.length;
        boolean bl = true;
        if (bl) {
            consumer.write("#<values");
        }
        int n3 = 0;
        while ((n = this.nextDataIndex(n3)) >= 0) {
            Object object2;
            consumer.write(32);
            if (n3 >= this.gapEnd) {
                n3 -= this.gapEnd - this.gapStart;
            }
            if ((object2 = this.getPosNext(n3 << 1)) instanceof Printable) {
                ((Printable)object2).print(consumer);
            } else {
                consumer.writeObject(object2);
            }
            n3 = n;
        }
        if (bl) {
            consumer.write(62);
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        Object[] objectArray = this.toArray();
        int n = objectArray.length;
        objectOutput.writeInt(n);
        for (int i = 0; i < n; ++i) {
            objectOutput.writeObject(objectArray[i]);
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        for (int i = 0; i < n; ++i) {
            this.writeObject(objectInput.readObject());
        }
    }

    public Object readResolve() throws ObjectStreamException {
        return this.isEmpty() ? empty : this;
    }

    public static int nextIndex(Object object2, int n) {
        if (object2 instanceof Values) {
            return ((Values)object2).nextDataIndex(n);
        }
        return n == 0 ? 1 : -1;
    }

    public static Object nextValue(Object object2, int n) {
        if (object2 instanceof Values) {
            Values values = (Values)object2;
            if (n >= values.gapEnd) {
                n -= values.gapEnd - values.gapStart;
            }
            return ((Values)object2).getPosNext(n << 1);
        }
        return object2;
    }

    public static void writeValues(Object object2, Consumer consumer) {
        if (object2 instanceof Values) {
            ((Values)object2).consume(consumer);
        } else {
            consumer.writeObject(object2);
        }
    }

    public static int countValues(Object object2) {
        return object2 instanceof Values ? ((Values)object2).size() : 1;
    }
}

