DOC_SECTION (MISCELLANEOUS-TAGS)
DOC_SECTION (ARRAYS)
DEFUN (pf_array-delete-index,  index arrayvar,
" Delete the element of <var arrayvar> indicated by <var index>.
 The remainder of the array after <var index> is shifted back by one,
 so that the array ends up with one less element than it had before.
")
DOC_SECTION (MISCELLANEOUS-TAGS)
DEFUN (pf_comma-separated,  array,
" Produce a human readable string of the elements in the array
 variable <var array> separated by commas where appropriate, and
 the word \"and\" after the penultimate item.

")
DOC_SECTION (ARITHMETIC-OPERATORS)
DEFUN (pf_comma-separated-digits,  num,
" Produce NUM in standard human readable format, inserting commas
 where appropriate.

 Example:
 <complete-example>
 <comma-separated-digits 98342367.09>
 </complete-example>
")
DOC_SECTION (VARIABLES)
DEFUN (pf_content-length, ,
" Return the length of the contents of <var var>.
 If <var var> is an array or string, returns the number of
 elements in the array.
 If <var var> is a binary variable, returns the amount of data
 stored within.
 If <var var> is a function, returns the empty string.
")
DOC_SECTION (PACKAGES)
DEFUN (pf_copy-package,  src dest,
" Copy the contents of the package <var src> to the package <var dest>.
")
DOC_SECTION (PAGECOUNT-APPENDIX)
DEFUN (pf_count-this-page,  &optional key,
" Add the current hit on this page to the pagecounter database, and
 return the current number of hits.  The pagecounter database is
 only accessed if this is the first time that this function is
 called on this page.

 If <var key> is not supplied, it defaults to the web-relative
 path to the current document.

 <example>
   <count-this-page> --> 2349
 </example>
")
DOC_SECTION (HTML-HELPERS)
DEFUN (pf_date::canonicalize,  date-string,
" Return the canonical version of DATE-STRING, in the format
 \"MM/DD/YY HH:MM:SS\".

 Example:
 <complete-example>
 <date::canonicalize <date>>
 </complete-example>
 Start by removing the day-of-week.
")
DOC_SECTION (FILE-OPERATORS)
DEFUN (pf_dir::basename,  pathname,
" Return the \"basename\" of <var pathname>.  This simply returns the last
 component of <var pathname>.

 Example:
 <complete-example>
 <dir::basename /foo/bar/baz>
 </complete-example>
")
DOC_SECTION (FILE-OPERATORS)
DEFUN (pf_dir::canonicalize-pathname,  path,
" Make <var path> be absolute in the file system.

 If <var path> starts with a \"/\", then do nothing, otherwise, prefix
 it with <varref mhtml::include-prefix> and
 <varref mhtml::relative-prefix>.

 Given an empty <var path>, return the full path to the directory that
 this page resides in.

 Example:
 <complete-example>
 <dir::canonicalize-pathname foo.mhtml>
 </complete-example>
")
DOC_SECTION (FILE-OPERATORS)
DEFUN (pf_dir::filename-extension,  filename,
" Return the filename extension of <var filename>, without the leading
 period.  Returns the empty string if <var filename> doesn't have an
 extension.

 <example>
 <dir::filename-extension /images/foo.gif>       --> gif
 <dir::filename-extension /downloads/foo.tar.gz> --> gz
 <dir::filename-extension /data/file>            -->
 </example>
")
DOC_SECTION (FILE-OPERATORS)
DEFUN (pf_dir::names-in-dir,  dir type matching,
" Return an array of the fully qualified pathnames in <var dir> which
 are of type <var type> (either \"<code>FILE</code>\" or
 \"<code>DIRECTORY</code>\") and which satisfy the regular
 expression <var matching>.

 <var dir> defaults to the directory of the currently executing page.
 <var type> defaults to \"<code>FILE</code>\".
 <var matching> defaults to all possible filenames.
")
DOC_SECTION (FILE-OPERATORS)
DEFUN (pf_directory-p,  var,
" Treat the argument <var var> as the name of a variable which contains
 an alist produced by <funref file-operators get-file-properties> or
 <funref file-operators directory-contents>, and return \"true\" if
 the referenced file object is a directory, as opposed to a file.
")
DOC_SECTION (FILE-OPERATORS)
DEFUN (pf_directory?,  pathname,
" Return \"true\" if <var pathname> is a directory, or \"\" if not.
")
DOC_SECTION (LANGUAGE-OPERATORS)
DEFUN (pf_dump-all-packages, ,
" Call <funref language-operators dump-package> on every defined package.
")
DOC_SECTION (LANGUAGE-OPERATORS)
DEFUN (pf_dump-package,  pack &optional recurse?,
" Dump the contents of <var pack> in a format suitable for including in
 <code>HTML</code> output.  If second argument <var RECURSE?> is
 non-empty, then recursively dump the contents of any alists
 found as values in <var pack>.
")
DOC_SECTION (NETWORK-APPENDIX)
DEFUN (pf_e-mail::sendmail,  from to[] cc[] bcc[] headers[] message,
" Send the mail message MESSAGE using a network stream from FROM to TO.

 The host used to connect to for SMTP defaults to the value of
 the variable E-MAIL::MAILHOST, or \"localhost\" if that variable is
 not defined.

 TO, CC, BCC and HEADERS are arrays containing elements of the indicated
 type.

 <example>
 <e-mail::sendmail webmaster@mysite.com bfox@ua.com \"\" \"\"
    \"Subject: Testing e-mail::sendmail
     Reply-to: nobody@nobody.com\"
    \"This is the body of the message.\">
 </example>

 If the variable <var e-mail::debug-sendmail-session> is non-empty,
 it says to populate the array e-mail::sendmail-session with the
 conversation that takes place between <Meta-HTML> and the SMTP
 server at <var e-mail::mailhost>.
")
DOC_SECTION (FILE-OPERATORS)
DEFUN (pf_file-newer?,  file1 file2,
" Return \"true\" if <var file1> has been written more recently than
 <var file2>.

 Both <var file1> and <var file2> are fully qualified pathnames.
")
DOC_SECTION (MISCELLANEOUS-TAGS)
DEFMACRO (pf_form-to-database,  database &key dbname key redirect-to action-name,
" Used almost exactly like <code>FORM</code>, this stores the
 values entered into the form into the specified database.  Takes
 keyword arguments of <var dbname>, <var key>, <var redirect-to>,
 and <var action-name>.

 <ul>
 <li> <var dbname>
 The name of the database to store the results in.  If it
 isn't supplied, \"anonymous.db\" is used.  The name of the
 database file is always relative to the current directory.

 <li> <var key>
 The name of the input field which contains the unique key
 for this record.  For example, this might be \"name\" for a
 rolodex application which asked for that information field.

 <li> <var redirect-to>
 The URL of the page to go to after the data is stored.
 If this is not specified, the user remains on the page
 containing this form.

 <li> <var action-name>
 The text to place in the button which submits the form.
 Defaults to \"Submit Form\".
</ul>
")
DOC_SECTION (NETWORK-APPENDIX)
DEFUN (pf_http::get-document,  host port path &key strip-headers,
" Get an HTTP document specified by <var host>, <var port> and <var path>.

 If a redirection is necessary in order to get the final
 document, the variable <code>http::redirected-url</code> is set
 to the fully qualified URI of the document.

 If the document could not be retrieved, the variable
 <code>http::error-status</code> contains the word \"NO-DATA\", and
 the variable <code>http::explanation</code> contains an human
 readable string explaining the problem.

 If <var strip-headers> is given, the HTTP protocol headers are
 stripped from the document before it is returned.

")
DOC_SECTION (NETWORK-APPENDIX)
DEFUN (pf_http::host-part,  url,
" Return the hostname and port portion of the fully qualified <var url>.
 <complete-example>
 <http::host-part http://www.metahtml.com/page.mhtml>
 </complete-example>
")
DOC_SECTION (NETWORK-APPENDIX)
DEFUN (pf_http::include,  url,
" Include the contents of the Web document referenced by <var url>
 in the page.
")
DOC_SECTION (NETWORK-APPENDIX)
DEFUN (pf_http::path-part,  url,
" Return the path portion of the fully qualified <var url>.
 This is the part of <var url> that is meaningful to the host.
 <complete-example>
 <http::path-part http://www.metahtml.com:8080/page.mhtml?foo=bar>
 </complete-example>
")
DOC_SECTION (NETWORK-APPENDIX)
DEFUN (pf_http::port-part,  url,
" Return the port portion of the fully qualified <var url>.
 If the <var url> doesn't have a port specifier, the value \"80\" is
 returned.
 <complete-example>
 <http::port-part http://www.metahtml.com:8080/page.mhtml>
 </complete-example>
")
DOC_SECTION (HTML-HELPERS)
DEFUN (pf_locale::select-common-country,  postname sitename,
" Produce a selection widget suitable for placing in a form which
 allows the user to select a country from a pull-down menu.
 <var postname> is the name of the variable which should be posted
 when the form is submitted.
 <var sitename> is the name of another variable which can contain the
 currently selected country.

 This differs from <funref html-helpers locale::select-country>
 only in the number of countries that are displayed.
")
DOC_SECTION (HTML-HELPERS)
DEFUN (pf_locale::select-country,  postname sitename,
" Produce a selection widget suitable for placing in a form which
 allows the user to select a country from a pull-down menu.
 <var postname> is the name of the variable which should be posted
 when the form is submitted.
 <var sitename> is the name of another variable which can contain the
 currently selected country -- this variable must be fully
 qualified with its package name (i.e., DEFAULT::FOO, or SITE::COUNTRY).
")
DOC_SECTION (HTML-HELPERS)
DEFUN (pf_locale::select-from-country,  postname sitename country-array,
" Produce a selection widget suitable for placing in a form which
 allows the user to select a country from a pull-down menu.
 <var postname> is the name of the variable which should be posted
 when the form is submitted.
 <var sitename> is the name of another variable which can contain the
 currently selected country -- this variable must be fully
 qualified with its package name (i.e., DEFAULT::FOO, or SITE::COUNTRY).
")
DOC_SECTION (HTML-HELPERS)
DEFUN (pf_locale::select-state,  postname sitename,
" Produce a selection widget suitable for placing in a form which
 allows the user to select a US state name from a pull-down menu.
 <var postname> is the name of the variable which should be posted
 when the form is submitted.
 <var sitename> is the name of another variable which can contain the
 currently selected state.
")
DOC_SECTION (MISCELLANEOUS-TAGS)
DEFUN (pf_mailable-address,  addr,
" Return \"true\" if ADDR appears to be a correctly formatted E-mail address.
")
DOC_SECTION (PACKAGES)
DEFUN (pf_make-alist,  &rest args,
" Return an alist from the name=value pairs passed.
 <complete-example>
 <make-alist foo=bar baz=this>
 </complete-example>
")
DOC_SECTION (FILE-OPERATORS)
DEFUN (pf_make-directories,  path &optional mode-string,
" Create all of the directories in <var path> (a fully qualified path to
 a directory) if they are not already present.
")
DOC_SECTION (MISCELLANEOUS-TAGS)
DEFUN (pf_make-identifier,  limit,
" Create an identifier that is <var limit> characters in length.
 The identifier characters are taken from the array MI::ALPHABET.
 MI::ALPHABET defaults to uppercase letters and numbers excluding
 \"I\", \"O\", zero, and one.
")
DOC_SECTION (PACKAGES)
DEFUN (pf_make-innocuous,  &rest packages[],
" Causes each variable in the specified <var packages> to have
 non-interpretable text.
 This is done by substituting HTML constructs for angle braces,
 among other things.

")
DOC_SECTION (HTML-HELPERS)
DEFMACRO (pf_menu,  title &key nobr,
" Create an HTML menu with title, text and links.
 
 Calling sequence:
 <example>
 <menu \"This Is The Title\">
   This is link text: target.mhtml
   External Site:  http://www.external.com/welcome.mhtml
 </menu>
 </example>
")
DOC_SECTION (HTML-HELPERS)
DEFUN (pf_message, ,
" Add BODY to the contents of the session variable \"message\".
 Also see <funref html-helpers show-message>.
")
DOC_SECTION (HTML-HELPERS)
DEFUN (pf_meta-html, ,
" Produces the canonical form of the words \"Meta-HTML\".
")
DOC_SECTION (MISCELLANEOUS-TAGS)
DEFUN (pf_mhtml::engine-per-page-function, ,
" Code that sets up the URL rewriter.  This has to be a per-page function
 because we haven't computed the URL of the document at the time
 this engine.conf file is read, so variables such as mhtml::http-prefix
 aren't set yet, and will be changed at the time the page location is
 computed.
")
DOC_SECTION (MISCELLANEOUS-TAGS)
DEFUN (pf_number-to-english,  value,
" Take the numeric value of VALUE and produce an English representation
 of it.  For example: 232 --: Two Hundred and Thirty-Two.
")
DOC_SECTION (MISCELLANEOUS-TAGS)
DEFUN (pf_number-to-englith,  value,
" Take the numeric value of VALUE and produce an English representation
 of it as a counting value.  For example:
 232 --> Two Hundred and Thirty-Second.
")
DOC_SECTION (PAGECOUNT-APPENDIX)
DEFUN (pf_pagecount::available-fonts, ,
" Return an array of the names of the fonts available on this system
 for displaying digit counters.
")
DOC_SECTION (PAGECOUNT-APPENDIX)
DEFUN (pf_pagecount::english-counter, ,
" Produce an English text representation of the number of times
 this page has been accessed.  Implicitly calls the function
 <funref pagecount-appendix count-this-page>.
 
 <example>
 <pagecount::english-counter> --> One Thousand Two Hundred and Fifty
 </example>
")
DOC_SECTION (PAGECOUNT-APPENDIX)
DEFUN (pf_pagecount::englith-counter, ,
" Produce an English text representation of the number of times
 this page has been accessed.  Implicitly calls the function
 <funref pagecount-appendix count-this-page>.
 
 <example>
 <pagecount::english-counter> --> One Thousandth Two Hundred and Fiftieth
 </example>
")
DOC_SECTION (PAGECOUNT-APPENDIX)
DEFUN (pf_pagecount::gif-counter,  fontname,
" Produce a sequence of GIFS representing the number of times this
 page has been accessed.  Implicitly calls count-this-page.
 The gifs are rendered using the font specified in FONTNAME.
")
DOC_SECTION (HTML-HELPERS)
DEFUN (pf_parse-date-string,  string,
" Populates the DATE package with the result of parsing DATE::DATE-STRING.
 If STRING is passed, that string is used instead of DATE::DATE-STRING,
 and should be the date in human readable format, just as
 <funref language-operators date> returns.
")
DOC_SECTION (FILE-OPERATORS)
DEFUN (pf_path::find-executable,  basename,
" Return the fully qualified path to the program which would be
 executed by CGI-EXEC for BASENAME.

 Example:
 <example>
 <path::find-executable ls> --> /bin/ls
 </example>
")
DOC_SECTION (ARITMETIC-OPERATORS)
DEFUN (pf_percent,  num total,
" Return the percentage of TOTAL that NUM is.
 <example>
 <percent 20 200> --> 10.00
 </example>
")
DOC_SECTION (HTML-HELPERS)
DEFUN (pf_select-option, ,
" Use instead of the <example code><option></example> HTML tag within
 the select HTML tag.

 It assumes that the text you wish to display on the page is in
 fact the value you wish to return from the form when this option
 is selected.  Particularly suited to situations where it is 
 helpful to know what the currently 'SELECTED' option might be.
 Example:
 <example>
 <select name=airport>
   <select-option airport Atlanta>
   <select-option airport Boston>
   <select-option airport Chicago>
   <select-option airport \"Los Angeles\">
   <select-option airport \"New York\">
   <select-option airport Miami>
   <select-option airport \"San Francisco\">
 </select>
</example>
")
DOC_SECTION (HTML-HELPERS)
DEFUN (pf_select-option-value, ,
" Use instead of the <example code><option></example> HTML tag
 within the `SELECT' HTML tag, when the text you wish to display
 is actually different from that you wish to post back to the
 server.  Also suited to helping the user see what the currently
 'SELECTED' option might be.
 
 Example:
 <example>
 <select name=airport>
   <select-option-value airport ALT Atlanta>
   <select-option-value airport BTN Boston>
   <select-option-value airport CHI Chicago>
   <select-option-value airport LAS \"Los Angeles\">
   <select-option-value airport NY  \"New York\">
   <select-option-value airport MI  Miami>
   <select-option-value airport SFO \"San Francisco\">
 </select>
 </example>
 San Francisco is displayed on the page but SFO is actually
 what is returned as the selected options value.

")
DOC_SECTION (PACKAGES)
DEFUN (pf_session-destroy-package,  package,
" Delete all of the variables referenced by <var package> in the
 current session.  Also see <funref packages session-export>.
")
DOC_SECTION (SESSION-OPERATORS)
DEFUN (pf_session::initialize,  &optional timeout timeout-page,
" Create or resume a session for the currently connected browser.
 <var timeout> is the length of time this session should stick around
 in the session database expressed in minutes; it defaults to 200.

 If the variable <code>SESSION::INHIBIT-SESSION</code> is
 non-empty, then no session processing is done.

")
DOC_SECTION (SESSION-OPERATORS)
DEFUN (pf_session::reset-cookie, ,
" Place this at the end of a page which is supposed to timeout the
 user's session.  It sends the browser a Set-Cookie header which
 makes the cookie go away.
")
DOC_SECTION (HTML-HELPERS)
DEFUN (pf_show-message, ,
" Display the contents of the session variable \"message\",
 and then remove that variable from the session.
 Also see <funref html-helpers message>.
")
DOC_SECTION (HTML-HELPERS)
DEFUN (pf_source-link,  text,
" You write `Click <source-link here> for source.'
")
DOC_SECTION (HTML-HELPERS)
DEFUN (pf_source-of,  web-path highlight-keywords-p,
" Display the contents of <var web-path> in <code>HTML</code>.
 Use sparingly.
 If <var highlight-keywords-p> is non-empty, then make each
 <Meta-HTML> function in the displayed text be a link which will
 display the contents of the the manual page for that keyword.
")
DOC_SECTION (GENERIC-SQL-INTERFACE)
DEFUN (pf_sql::admin-prog, ,
" Returns the complete path of the executable program which is used to
 perform administration functions on the undrlying SQL database.
 For example, <code>/usr/local/Hughes/bin/msqladmin</code>, or
 <code>/usr/local/bin/mysqladmin</code>.
")
DOC_SECTION (GENERIC-SQL-INTERFACE)
DEFUN (pf_sql::affected-rows,  cursor,
" Return the number of rows affected by the last SQL query execution,
 associated with the database referenced indirectly by <var cursor>.
 This may be completely unrelated to the query which created the
 cursor object, depending on the underlying database which is in
 use.
")
DOC_SECTION (GENERIC-SQL-INTERFACE)
DEFUN (pf_sql::cursor-get-column,  cursor column-number,
" Called with a cursor which is the result from a call to
 <funref generic-sql-interface sql::database-exec-query>,
 this function returns the data from the current result set,
 in the column numbered <var column-number> (starting at column 0). 
")
DOC_SECTION (GENERIC-SQL-INTERFACE)
DEFUN (pf_sql::database-column-info,  dbvar table fieldname,
" Returns an association list of properties on the specified
 <var column> in the table <var table>.

 Example:
 <pre>
 ((NAME . realname)
  (LENGTH . 30)
  (TYPE . GSQL_CHAR)
  (IS_UNIQUE . \"\")
  (IS_NULLABLE . true)
  (QUALIFIER . \"\")
  (OWNER . \"\")
  (TYPENAME . \"\")
  (PRECISION . 0)
  (SCALE . 0)
  (RADIX . 0)
  (TABLE . accounts))
 </pre>

 This is actually implemented by fetching information on <i>all</i>
 columns and selecting the specified one.  This means that you should
 use the command
 <funref generic-sql-interface sql::database-columns-info> if you
 are looking for information on several columns, as opposed to
 the specific column mentioned by <var column>.
")
DOC_SECTION (GENERIC-SQL-INTERFACE)
DEFUN (pf_sql::database-columns,  dbvar tablename &key result=varname,
" Returns a newline separated list of the columns present in <var
 tablename> in the open SQL database referenced by <var dbvar>.

 The keyword <var result=varname> argument specifies the name of
 a variable to put the result array into; if not present, the
 array is returned to the caller.
")
DOC_SECTION (GENERIC-SQL-INTERFACE)
DEFUN (pf_sql::database-columns-info,  dbvar table &key result=varname,
" Analogous to <funref generic-sql-interface sql::database-column-info>,
 this function returns an <i>array</i> of association lists where
 each entry in the array is the information about a single column.
")
DOC_SECTION (GENERIC-SQL-INTERFACE)
DEFUN (pf_sql::database-delete-record,  dbvar key &key table=tablename keyname=fieldname,
" Deletes the specified record in the database referenced by
 <var dbvar>. The record to delete is specified by <var key> and
 <var keyname>. An SQL <code>DELETE</code> query is issued which
 will delete all records in the table named <var table> whose column
 named <var fieldname> matches the value of <var key>.

 You must supply values for <var table> and <var keyname>.

")
DOC_SECTION (GENERIC-SQL-INTERFACE)
DEFUN (pf_sql::database-exec-query,  dbvar query-string &key cursor=varname,
" Executes the SQL query in <var query-string> by sending it to
 the open database connection referenced by <var dbvar>.

 <var query-string> can be any <Meta-HTML> expression which
 evaluates to a valid SQL query or command string.

 Returns a cursor object, which can be passed to
 <funref generic-sql-interface sql::database-next-record>,
 <funref generic-sql-interface sql::number-of-rows>, or
 <funref generic-sql-interface sql::set-row-position>.

 If the keyword argument <var cursor=varname> is given, the
 returned cursor value is stored in <var varname>.

")
DOC_SECTION (GENERIC-SQL-INTERFACE)
DEFUN (pf_sql::database-exec-sql,  dbvar query-string,
" Executes the SQL query in <var query-string>, on the open
 database connection specified by <var dbvar>.

 Returns TRUE if no errors are encountered.

 This function differs from
 <funref generic-sql-interface sql::database-exec-query> in that
 it does not return any cursor; i.e., there is no way to get
 results back from the execution of your SQL command. Thus, it is
 most useful for sending commands which expect no return values,
 such as a SQL DELETE statement:

 <example>
 <sql::database-exec-sql 
    db \"DELETE FROM maillists where list = '<get-var listname>'\">
 </example>
")
DOC_SECTION (GENERIC-SQL-INTERFACE)
DEFUN (pf_sql::database-load-record,  dbvar key &key table=tablename keyname=fieldname package=packagename,
" Load variable values from the database referenced by <var dbvar>
 and <var key> into the package specified by <var packagename>
 (defaulting to the current package if not supplied).

 <var tablename> and <var fieldname> must be supplied -- they
 specify the table and primary key field to be operated on.

")
DOC_SECTION (GENERIC-SQL-INTERFACE)
DEFUN (pf_sql::database-next-record,  cursor &key colnames=namelist prefixtablenames=true package=packagename,
" Fill the variables in <var packagename> (defaulting to the
 current package if not supplied) with the values of the next
 record which last satisfied the search referenced by <var cursorvar>.

 Each subsequent call gets a subsequent record from the list of
 results, until all of the results are exhausted.

 Returns <code>true</code> if there are any records left in the
 search results, or the empty string if not.

 If <var colnames> is supplied, then the column values of this
 result are bound sequentially to the comma-separated list of
 names in <var namelist> instead of the field names in the result
 set.

 <example>
 <sql::database-next-record db cursor package=tmp
             colnames=\"a.name, a.partnum, b.name\">
 <get-var tmp::b.name>
 <get-var tmp::a.name>
 </example>

 If <var colnames> is non-null, or the database connection option
 <code>SQL-PREFIX-TABLENAMES</code> is non-null, then for each
 column in the result set, use the column's table name, if it
 exists, as a prefix to the column name as the variable name.

")
DOC_SECTION (GENERIC-SQL-INTERFACE)
DEFUN (pf_sql::database-query,  dbvar query &key colnames=namelist prefixtablenames=true format=fexpr keys=varname keyname=fieldname,
" Select and optionally format records in the database referenced
 by <var dbvar> according to the criterion in <var fexpr>.

 <var query> is an SQL query, which is expected to return a list of rows.

 For each result row, <var expr> is then evaluated, with the
 column values of each row bound to their corresponding column
 name. If the result of that evaluation is not an empty string,
 then that record is selected for further processing by either
 <var format>, <var keys>, or to return in plain text the list of
 keys. If <var format=fexpr> is present, <var fexpr> is an
 expression to evaluate in the context of the database fields,
 (as with <var expr>).

 The value of \"true\" for <var expr> is specially optimized to
 for those queries where no additional processing is necessary.

 The example below shows an SQL query which is formatted as rows
 of an HTML table. In this case, the <var expr> is simply the
 constant <code>true</code>, and all of the selection of records
 is done via the SQL query itself. (Note that <var expr> could be
 used to impose additional conditions to decide whether to invoke
 <var fexpr> on a row.

 <example>
 <table border=1>
   <tr> <th>Name</th> <th>Age</th> </tr>
   <sql::with-open-database db dsn=\"DATABASE=ROLO;HOST=localhost\">
     <sql::database-query db true
         \"SELECT * FROM people
          WHERE name like 'Washington' ORDER BY lastname\"
         format=<group <tr>
                       <td> <get-var lastname>, <get-var firstname> </td>
                       <td> <get-var age> </td>
                       </tr>>>
   </sql::with-open-database>
 </table>
 </example>

 If <var keys=varname> is given, then <var varname> is the name
 of a variable to receive the array of keys which satisfied
 the query.  If you specify an argument for <var keys>, you must
 also specify which column to collect the values from, using the
 <var keyname=fieldname> keyword argument.

 If the optional argument <var colnames=namelist> is supplied,
 then for each row, column values are bound sequentially to these
 comma separated names instead of the column names in the result set.

 <example>
 <sql::database-query db true <get-var query>
    colnames=\"foo.name, bar.name\"
    format=<group FOO.NAME IS <get-var foo.name> 
                  BAR.NAME IS <get-var bar.name>>>
 </example>

 If <var prefixtablenames> is non-null, or the database
 connection option <code>SQL-PREFIX-TABLENAMES</code> is
 non-null, then for each column in the result set, use that
 column's table name as a prefix to the column name as the
 variable name.
")
DOC_SECTION (GENERIC-SQL-INTERFACE)
DEFUN (pf_sql::database-query-info,  cursor &key result=varname,
" Returns an array of association lists giving information about
 each column in the result set specified by <var cursor>.
 
 If the keyword argument <var result=varname> is given, the
 resultant array is placed into that variable -- otherwise it is
 simply returned.
")
DOC_SECTION (GENERIC-SQL-INTERFACE)
DEFUN (pf_sql::database-save-package,  dbvar key package &key table=tablename keyname=fieldname,
" Save the variables in <var package> associated with the value
 <var key> in column <var keyname> in the table <var tablename>
 of the database referenced by <var dbvar>.

 This only saves variables which have names matching existing
 table column names. Package prefixes are stripped from the
 variables, and the symbol name is used as the column name to
 store the data. Symbol names and column names are treated in a
 case-insensitive manner.

 The implementation is to first attempt to do a SQL
 <code>INSERT</code> into the table, and if that fails to try a
 <code>UPDATE</code> query, with <var keyname> = <var key>.

 Example: Say we want to save some information about employee
 Kate Mulgrew, in a table of employees, which has a primary key
 field named \"id\", and we want to save this record with id=103:

 <example>
 <set-var record::name=\"Kate Mulgrew\" record::age=45
          record::salary=34000 record::dept=travel>
.blank
 <set-var saved? =
    <sql::database-save-package db 103 record table=employees keyname=id>>
 </example>

 If a variable in the package you are saving corresponds to a
 column with a numeric field type, and the value of the variable
 is the empty string, the system will attempt to store a NULL
 value into this field of the record. If the table does not
 support NULL values on that column, the operation will fail.
")
DOC_SECTION (GENERIC-SQL-INTERFACE)
DEFUN (pf_sql::database-save-record,  dbvar key table keyname &optional var... &key table=tablename keyname=fieldname,
" Write a record to the open SQL database connection referenced by
 <var dbvar>, using <var key> as the value of the primary key, on
 the table <var table>.  <var KEYNAME> is the SQL column name of
 the column that you are specifying as the primary key.

 For each <var var>, treat the name of <var var> as a column
 name, and set that column's value to the value stored within
 <var var>.

 An <code>UPDATE</code> is initially attempted to store the data.
 If the <code>UPDATE</code> fails, then an <code>INSERT</code> is
 attempted.

 NOTE: If the key field for table you are using is not configured
 as the primary key, then it is possible to create duplicate entries
 in the database.

 If you pass in a variable <var var> which does not match a column
 name in <var table>, that variable is silently ignored.

 If you try to save character data into a numeric field, the
 <code>INSERT</code> or <code>UPDATE</code> will fail.

 As always, the most recent query executed is available by
 calling the function <funref generic-sql-interface sql::recent-query>,
 and error messages may be retrieved by calling the function
 <funref generic-sql-interface sql::sql-error-message>.
")
DOC_SECTION (GENERIC-SQL-INTERFACE)
DEFUN (pf_sql::database-set-options,  dbvar &key option-name=value,
" Sets various database-specific options.

 Possible values for <var option-name> are:
 <ul>
 <li> <b>SQL-ESCAPE-CHARACTER-CODE</b>:
 The character which is used to escape single quotes in strings.
 <li> <b>SQL-TRUNCATE-COLUMNS</b>:
 When set to a non-empty string, queries composed by
 <funref generic-sql-interface database-save-record> and
 <funref generic-sql-interface database-save-package> will have
 character string field data automatically truncated to the maximum
 column width of the field being stored into, before the query is
 ever sent to the SQL server.
 </ul>
")
DOC_SECTION (GENERIC-SQL-INTERFACE)
DEFUN (pf_sql::database-table-info,  dbvar &optional tablename &key result=varname tabletype=regexp tablequalifier=regexp tableowner=regexp,
" Returns an array of association lists, one per table in the
 open SQL database referenced by <var dbvar>.

 Each alist contains database-specific information about the
 table, including at least the <i>name</i> of the table.
 <example>
 ((name . \"table_name\"))
 </example>

 The keyword arguments starting with
 <code>\"table...\"</code> are ANSI SQL regular expression
 patterns.  They are used if supplied, ignored if not.

 The keyword <var result=varname> argument specifies the name of
 a variable to put the result array into; if not present, the
 array is returned to the caller.
")
DOC_SECTION (GENERIC-SQL-INTERFACE)
DEFUN (pf_sql::database-tables,  dbvar &key result=varname,
" Return the names of the tables in the database referenced by
 <var dbvar> as a newline separated list. If <var varname> is
 supplied, it is the name of the variable to receive the table
 names.
")
DOC_SECTION (GENERIC-SQL-INTERFACE)
DEFUN (pf_sql::database-tables-info,  dbvar &optional tablename &key result=varname tabletype=regexp tablequalifier=regexp tableowner=regexp,
" Returns an array of association lists, one per table in the
 open SQL database referenced by <var dbvar>.

 Each alist contains database-specific information about the
 table, including at least the <i>name</i> of the table.
 <example>
 ((name . \"table_name\"))
 </example>

 The keyword arguments starting with
 <code>\"table...\"</code> are ANSI SQL regular expression
 patterns.  They are used if supplied, ignored if not.

 The keyword <var result=varname> argument specifies the name of
 a variable to put the result array into; if not present, the
 array is returned to the caller.
")
DOC_SECTION (GENERIC-SQL-INTERFACE)
DEFUN (pf_sql::get-database-type, ,
" Return the type of the underlying SQL database which will be accessed
 by the various SQL::... functions.  The possibilities are one of
 
 <ul>
 <li> <b>msql</b>: The Minerva mSQL database from Hughes,
 <li> <b>mysql</b>: The mySQL database, or
 <li> <b>odbc</b>: A generic ODBC database, such as Oracle or Sybase.
 </ul>
")
DOC_SECTION (GENERIC-SQL-INTERFACE)
DEFUN (pf_sql::host-databases,  &optional host,
" Return an array of the database names present on <var host>
 (defaults to <code>localhost</code>.

 This command is only meaningful to the <code>mSQL</code> and
 <code>mySQL</code> database engines -- calling it on
 <code>odbc</code> databases always returns an empty array.
")
DOC_SECTION (GENERIC-SQL-INTERFACE)
DEFUN (pf_sql::query-get-column, ,
" Undocumented.
")
DOC_SECTION (GENERIC-SQL-INTERFACE)
DEFUN (pf_sql::recent-query, ,
" Returns the last SQL query statement that was sent to the underlying
 SQL database.  Can be useful in debugging.
")
DOC_SECTION (GENERIC-SQL-INTERFACE)
DEFUN (pf_sql::set-database-type,  type,
" Create a command set called SQL::... which contains all of the functions
 normally used for accessing ODBC, mySQL, or mSQL databases.  This allows
 you to write a complete application using the mySQL database,
 <funref generic-sql-interface sql::with-open-database> and
 friends, and then to painlessly \"port\" it to ODBC, simply by calling this
 function with an argument of <code>odbc</code>.
 
 The possible values for <var type> are
 
 <ul>
 <li> <b>msql</b>: The Minerva mSQL database from Hughes,
 <li> <b>mysql</b>: The mySQL database, or
 <li> <b>odbc</b>: A generic ODBC database, such as Oracle or Sybase.
 </ul>
")
DOC_SECTION (GENERIC-SQL-INTERFACE)
DEFUN (pf_sql::sql-error-message, ,
" Return the current error message from recent SQL statements.
")
DOC_SECTION (GENERIC-SQL-INTERFACE)
DEFUN (pf_sql::sql-transact, ,
" Currently unimplemented.
")
DOC_SECTION (GENERIC-SQL-INTERFACE)
DEFMACRO (pf_sql::with-open-database,  dbvar &key dsn=dsn-string nolock=true,
" Opens the database specified by DSN (database service name)
 string, and stores a referent to it in <var dbvar>.  If the
 connection fails, the value of <var dbvar> is the empty string.

 <var DSN> should contain a minimum of
 \"HOST=hostname;DATABASE=dbname\" in order to connect successfully
 to an mSQL database.  Although the older <var HOST=host> <var
 DATABASE=dbname> keyword arguments are still supported, they
 have been deprecated, and the <var DSN=dsn-string> form is
 preferred.

 If <var nolock=true> is supplied, then no lock file on the server is
 created.  This is useful when you don't want to block other processes
 from accessing the database for the duration of the
 <code>sql::with-open-database</code> form.
")
DOC_SECTION (HTML-HELPERS)
DEFUN (pf_thisdir, ,
" The fully qualified pathname to the directory containing the currently
 executing document.
")
DOC_SECTION (HTML-HELPERS)
DEFUN (pf_thisdoc, ,
" The complete URL to this document, without the query string or
 path information.
")
DOC_SECTION (HTML-HELPERS)
DEFUN (pf_thisfile, ,
" The fully qualified pathname to the document which is currently
 executing.
")
DOC_SECTION (HTML-HELPERS)
DEFUN (pf_thispage, ,
" The local web-based URL to this document, without the query string
 or path information.
")
DOC_SECTION (FILE-OPERATORS)
DEFUN (pf_webpath-exists,  document-path,
" Returns \"true\" if the specified <var document-path> exists with
 \"/\" being equal to the document root directory.
")
DOC_SECTION (LANGUAGE-OPERATORS)
DEFMACRO (pf_with-safe-environment, ,
" Execute <var body> in an environment where commands that could
 affect the file system are disabled.  In addition, commands
 which can define or undefine functions are disabled.

 This command is especially useful when filtering input from an
 external source, such as a third party Web page.
")
