//
// Part of the ht://Dig package   <http://www.htdig.org/>
// Copyright (c) 1999, 2000 The ht://Dig Group
// For copyright details, see the file COPYING in your distribution
// or the GNU General Public License version 2 or later
// <http://www.gnu.org/copyleft/gpl.html>
//
// $Id: WordMatch.h,v 1.1 2000/10/24 14:23:29 loic Exp $
//

#ifndef _WordMatch_h
#define _WordMatch_h

#include <WordKey.h>
#include <WordContext.h>

//
// Return value of the Search method, tells us which document
// matched and why.
//
class WordMatch {
public:
  WordMatch(WordContext* context) : match(context) { }

  //-
  // Return a textual representation of the object.
  //
  String Get() const;

  //-
  // The document that matched
  //
  WordKey match;
  //-
  // An ascii description of why it matched.
  //
  String info;
};

#endif /* _WordMatch_h */
