%{ /* -*- c -*- */ /* <--- EMACS knows now about what mode to use ... */
  /* Time-stamp: "98/05/27 23:06:20 bauer" */

  /* Filter for Windows NT 4.0 postscript printer driver. Enables
   * the use of psnup from Angus Duggan's psutils package
   * ( http://www.dcs.ed.ac.uk/home/ajcd/psutils/ )
   * Copyright: GNU General Public License (GPL)
   * Authors: 
   *         Holger Bauer 1998 bauer@itsm.uni-stuttgart.de
   *         Michael Rath 1998  rath@itsm.uni-stuttgart.de
   * Version: 0.1b
   * Release Date: 1998/05/27
   *
   * Compilation:
   *
   * flex fixnt.l
   * cc -O -o fixnt lex.yy.c
   *
   * Usage: 
   * csh-prompt> fixnt < BAD_NT_Postscript_FILE.ps | psnup -4 | gs -
   * or:
   * csh-prompt> fixnt < BAD_NT_Postscript_FILE.ps | psnup -4 >GOOD.ps
   *
   * Windows NT 3.5 users may be happy with:
   * csh-prompt> sed -e 's/NTPSOct94/NTPSOct95/g' BAD_NT_Postscript_FILE.ps | \
   *             | fixnt | psnup -4 >GOOD.ps
   *
   * TODO-List:
   * - check for NTPSOct94 (in the meantime use the sed command above)
   *
   *
   * BUG-Reports: to Authors (above) (please, no 20MB postscript files !!!!!!)
   * Patches (welcome) to code maintainer:   bauer@itsm.uni-stuttgart.de
   *
   */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#  include <stdio.h>
#  if HAVE_SYS_TYPES_H
#   include <sys/types.h>
#  endif
#  if HAVE_UNISTD_H
#   include <unistd.h>
#  endif
#else /* !HAVE_CONFIG_H */
#  include <stdio.h>
#  include <unistd.h>
#  include <sys/types.h>
#endif /* !HAVE_CONFIG_H */

static int first_time = 1;
FILE *font;
FILE *adobe;
FILE *body;
static char xx;
int ifpagesv   = 0;
int ifcorel    = 0;
int ifendsetup = 0;
pid_t pid;
char  fontfname[255];
char adobefname[255];
char  bodyfname[255];

%}

%Start DUMMY NORMAL BODY ADOBE FONT

%%

%{
  if(first_time){
    BEGIN DUMMY;
    first_time = 0;
  }
%}

<DUMMY>%!.*\n { /* regular Postscript starts here ... */
      ECHO;
      BEGIN NORMAL;
}

<DUMMY>^.*\n { /* nothing to do */
}

<NORMAL>%%Title:.*CorelDRAW.*\n { /* Corel Draw modus recognized */
  ifcorel = 1;
  ECHO;
}

<NORMAL>%%EndSetup.*\nNTPSOct95[ ]+begin.*\n { /* suppress EndSetup */
  fprintf(yyout,"NTPSOct95 begin\n");
  ifendsetup = 1;
}

<NORMAL>%%Page:.*\n { /* read up to first page and just output everyting */
  if (getenv("TMPDIR") == NULL)
    sprintf(bodyfname, "/tmp/fixnt_Body_%d", (int) getpid());
  else
    sprintf(bodyfname, "%s/fixnt_Body_%d", getenv("TMPDIR"), (int) getpid());
  body = fopen(bodyfname,"w+");
  fprintf(body,"%s",yytext);
  BEGIN BODY;
}

<NORMAL>.*\n {    /* o.k. */
                 fprintf(yyout,"%s",yytext);
}

<BODY>[/]Adobe_WinNT_Driver_Gfx[ ]175[ ]dict[ ]dup[ ]begin.*\n { /* Adobe Stuff */
  if (getenv("TMPDIR") == NULL)
    sprintf(adobefname, "/tmp/fixnt_Adobe_%d", (int) getpid());
  else
    sprintf(adobefname, "%s/fixnt_Adobe_%d", getenv("TMPDIR"), (int) getpid());
  adobe = fopen(adobefname,"w+");
  fprintf(adobe,"%s",yytext);
  BEGIN ADOBE;
}

<ADOBE>end[ ]reinitialize.*\n { /* End of Adobe definition stuff */
  fprintf(adobe,"%s",yytext);
  BEGIN BODY;
}

<ADOBE>.*\n { /* print just everything ... */
  fprintf(adobe,"%s",yytext);
}


<BODY>^[ ]@gs[ ]spg[ ]@gr.*\n { ;
  /* remove showpage definition of CorelDraw defintions */
  if( ifcorel == 1 ){
    fprintf(body," @gs @gr\n"); /* Corel draw defines spg as showpage */
  } else {
    fprintf(body,"%s",yytext);  /* Somebody else defined spg, leave it in */
  }
}

<BODY>(NTPSOct95[ ]){0,1}[/]FontSV[ ]save[ ](put|def).*\n { ;
  /* font definitions from here on  */
  if (getenv("TMPDIR") == NULL)
    sprintf(fontfname, "/tmp/fixnt_Font_%d", (int) getpid());
  else
    sprintf(fontfname, "%s/fixnt_Font_%d", getenv("TMPDIR"), (int) getpid());
  font = fopen(fontfname,"w+");
  fprintf(font,"%s",yytext);
  BEGIN FONT;
}

<FONT,BODY>%%BeginFont:.*\n { /* Font definitions go to FILE* font */
  fprintf(font,"%s",yytext);
  BEGIN FONT;
}

<FONT>%%EndFont.*\n { /* End of Font Definition */
  fprintf(font,"%s",yytext);
  BEGIN BODY;
}

<FONT,BODY>%%BeginResource:[ ]font.*\n { ;
/* NT 3.5 Postscript Files have different FontDefinitions */
 fprintf(font,"%s",yytext);
 BEGIN FONT;
}

<FONT>%%EndResource.*\n { ;
/* NT 3.5 Postscript Files have different FontDefinitions */
 fprintf(font,"%s",yytext);
 BEGIN BODY;
}

<FONT>.*\n { /* goes all to FILE *font ... */
  fprintf(font,"%s",yytext);
}

<BODY>(NTPSOct95[ ]){0,1}[/]PageSV[ ]save[ ](put|def).*\n { ;
  ifpagesv = 1; 
}

<BODY>Adobe_WinNT_Driver_Gfx[ ]dup[ ][/]terminate[ ]get[ ]exec.*\nFontSV[ ]restore.*\nPageSV[ ]restore.*\n%%Trailer.*\n {
  fprintf(body,"%%%%Trailer\nAdobe_WinNT_Driver_Gfx dup /terminate get exec\nPageSV restore\nFontSV restore\n");
}

<BODY>FontSV[ ]restore.*\nPageSV[ ]restore.*\n    { ;
  /* switch FontSV/PageSV */
  fprintf(body,"PageSV restore\nFontSV restore\n");
}

<BODY>PageSV[ ]restore.*\n%%Trailer.*\n    { ;
/* put PageSV after Trailer */
  fprintf(body,"%%%%Trailer\nPageSV restore\n");
}

<BODY>FontSV[ ]restore.*\nPageSV[ ]restore.*\n%%Trailer.*\n    { ;
/* put PageSV/FontSV after Trailer */
  fprintf(body,"%%%%Trailer\nPageSV restore\nFontSV restore\n");
}

<BODY>%%EOF.*\n { /* put everything in right order ... */
  fprintf(body,"%s",yytext);
  if( adobe != NULL ){
    rewind(adobe);
    while( (xx = getc( adobe )) != EOF ){
      putc(xx,yyout);
    }
    fclose(adobe);
    remove(adobefname);
  }
  if( font != NULL){
    rewind(font);
    while( (xx = getc( font )) != EOF ){
      putc(xx,yyout);
    }
    fclose(font);
    remove(fontfname);
  }
  if( ifendsetup == 1){
    fprintf(yyout,"%%%%EndSetup:\n");
  }
  if( body != NULL){
    rewind(body);
    if(ifpagesv == 1)
      fprintf(yyout,"NTPSOct95 /PageSV save put\n");
    while( (xx = getc( body )) != EOF ){
      putc(xx,yyout);
    }
    fclose(body);
    remove(bodyfname);
  }
  return 0;
}

<BODY>.*\n { /* put pages in FILE *body */
  fprintf(body,"%s",yytext);
}

%%
int
yywrap ()
{
  return 1;
}

int
main (argc, argv)
  int argc;
  char *argv[];
{
  while (yylex() != 0)
    ;
  
  return 0;
}
