/* mcparameters.h -- This file is part of Archimedes release 0.0.7.
   Archimedes is a simulator for Submicron 2D Silicon/GaAs
   Devices. It implements the Monte Carlo method
   for the simulation of the semiclassical Boltzmann equation for both
   electrons and holes. It also includes the quantum effects by means 
   of effective potential method.

   Copyright (C) 2004, 2005, 2006, 2007 Jean Michel Sellier <sellier@dmi.unict.it>
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
   USA.  */


// ######################################################
// Created on 05 sep.2004, Siracusa, J.M.Sellier
// Last modif. : 27 Dec.2006, Siracusa, J.M.Sellier
// ######################################################

// Definition of the variables needed for taking into
// account scatterings from acoustic and optical,non-polar
// phonons (which are the most relevant scatterings in Silicon)

void
MCparameters(void)
{
 real wo,no,dos,aco,oge[7],oga[7];
 real ogeg,ogag;
 real dos1,dos2,am1,am2,eg,cl,deq,dij;
 real hwe,hwij,wij,we,ne,nij;
 real poe,poa,ope,opa,eqe,eqa,qmin,qmax;
 real initialenergy,sei,finalenergy,sef;
 real eps,epf,ep,bimp,cimp,qd;
 real ak,qq,wk;
 int ie,i;
 int z2=4;

 ISEED = 38467.;  //  initial value for random number generator

// These definitions are valid for every material
 BKTQ=KB*TL/Q; // in eV
 QH=Q/HBAR;

// Material = GaAs
// ###############
 if(Material==GAAS){
// Effective mass for the GAMMA and L-Valley, respectively
  am1=mstarGAAS*M;
  am2=mstar2GAAS*M;
// Energy minima of bands
  EC[1]=E_MIN_GAMMA;
  EC[2]=E_MIN_L;
// Energy gap
  eg=EG_GAAS;
  eps=EPS_GAAS*EPS0;
  epf=EPF_GAAS*EPS0;
  ep=1./(1./epf-1./eps);

// Parameters for Phonon Scattering
  cl=GAASRHO*pow(GAASUL,2.);
  deq=dij=GAASDTK*Q;
  hwe=hwij=GAASHWO;
// Non-parabolicity of GAMMA and L bands
  AF[1]=alphaGAAS;
  AF[2]=alpha2GAAS;

  SMH[1]=sqrt(2.*am1*Q)/HBAR;
  SMH[2]=sqrt(2.*am2*Q)/HBAR;
  HHM[1]=HBAR*HBAR/(2.*am1*Q);
  HHM[2]=HBAR*HBAR/(2.*am2*Q);
  HM[1]=HBAR/am1;
  HM[2]=HBAR/am2;

  wo=GAASHWO*Q/HBAR;
  wij=hwij*Q/HBAR;
  we=hwe*Q/HBAR;

  no=1./(exp(GAASHWO/BKTQ)-1.);
  nij=1./(exp(hwij/BKTQ)-1.);
  ne=1./(exp(hwe/BKTQ)-1.);

  dos1=pow(sqrt(2.*am1*Q)/HBAR,3.)/pow(2.*PI,2.);
  dos2=pow(sqrt(2.*am2*Q)/HBAR,3.)/pow(2.*PI,2.);

  poe=Q/8./PI/ep*Q*wo*(no+1.);
  poa=poe*no/(1.+no);
  aco=2.*PI*GAASDA/Q*GAASDA*BKTQ/HBAR*Q/cl;
  ope=PI*dij/wij*dij/GAASRHO/Q*(nij+1.);
  opa=ope*nij/(1.+nij);
  eqe=PI*deq/we*deq/GAASRHO/Q*(ne+1.);
  eqa=eqe*ne/(1.+ne);

// Parameters for impurity scatterings
  cimp=CIMP; // <--- impurity concentration
  qd=sqrt(Q*cimp/BKTQ/eps);
  QD2=qd*qd;
  bimp=2.*PI*cimp*Q*Q/HBAR*Q/eps/eps;

// Calculation of scattering rates
  for(ie=1;ie<=DIME;ie++){
    initialenergy=DE*((real)(ie));
    sei=sqrt(initialenergy);
// GAMMA-valley
// ============
// Polar optical phonon
// Emission - Parabolic
    finalenergy=initialenergy-GAASHWO;
    if(finalenergy>0.){
     sef=sqrt(finalenergy);
     qmax=sef+sei;
     qmin=sei-sef;
     SWK[1][1][ie]=poe*SMH[1]*sei/initialenergy/Q*log(qmax/qmin);
    }
    else SWK[1][1][ie]=0.;
// Absorption - Parabolic
    finalenergy=initialenergy+GAASHWO;
    sef=sqrt(finalenergy);
    qmax=sef+sei;
    qmin=sef-sei;
    SWK[1][2][ie]=SWK[1][1][ie]
                 +poa*SMH[1]*sei/initialenergy/Q*log(qmax/qmin);
// Emission
    finalenergy=initialenergy-hwij+EC[1]-EC[2];
    if(finalenergy>0.){
     sef=sqrt(finalenergy*(1.+AF[2]*finalenergy));
     SWK[1][3][ie]=SWK[1][2][ie]+z2*ope*sef*dos2*(1.+2.*AF[2]*finalenergy);
    }
    else SWK[1][3][ie]=SWK[1][2][ie];
// Absorption
    finalenergy=initialenergy+hwij+EC[1]-EC[2];
    if(finalenergy>0.){
     sef=sqrt(finalenergy*(1.+AF[2]*finalenergy));
     SWK[1][4][ie]=SWK[1][3][ie]+z2*opa*sef*dos2*(1.+2.*AF[2]*finalenergy);
    }
    else SWK[1][4][ie]=SWK[1][3][ie];
// Acoustic Phonon
    finalenergy=initialenergy;
    sef=sqrt(finalenergy*(1.+AF[1]*finalenergy));
    SWK[1][5][ie]=SWK[1][4][ie]+aco*sef*dos1*(1.+2.*AF[1]*finalenergy);
// Impurity scattering
    finalenergy=initialenergy;
    sef=sqrt(finalenergy*(1.+AF[1]*finalenergy));
    ak=SMH[1]*sef;
    qq=QD2*(4.*ak*ak+QD2);
    wk=bimp/qq*sef*dos1*(1.+2.*AF[1]*finalenergy);
    if(wk>1.e14) wk=1.e14;
    SWK[1][6][ie]=SWK[1][5][ie]+wk;

// L-valley
// ========
// Polar optical phonon
// Emission
    finalenergy=initialenergy-GAASHWO;
    if(finalenergy>0.){
      sef=sqrt(finalenergy);
      qmax=sef+sei;
      qmin=sei-sef;
      SWK[2][1][ie]=poe*SMH[2]*sei/initialenergy/Q*log(qmax/qmin);
    }
    else SWK[2][1][ie]=0.;
// Absorption
    finalenergy=initialenergy+GAASHWO;
    sef=sqrt(finalenergy);
    qmax=sef+sei;
    qmin=sef-sei;
    SWK[2][2][ie]=SWK[2][1][ie]
                 +poa*SMH[2]*sei/initialenergy/Q*log(qmax/qmin);
// Non-polar optical phonon
// Emission
    finalenergy=initialenergy-hwe;
    if(finalenergy>0.){
      sef=sqrt(finalenergy*(1.+AF[2]*finalenergy));
      SWK[2][3][ie]=SWK[2][2][ie]
                   +(z2-1.)*eqe*sef*dos2*(1.+2.*AF[2]*finalenergy);
    }
    else SWK[2][3][ie]=SWK[2][2][ie];
// Absorption
    finalenergy=initialenergy+hwe;
    sef=sqrt(finalenergy*(1.+AF[2]*finalenergy));
    SWK[2][4][ie]=SWK[2][3][ie]
                 +(z2-1.)*eqa*sef*dos2*(1.+2.*AF[2]*finalenergy);

// Emission
    finalenergy=initialenergy-hwij+EC[2]-EC[1];
    if(finalenergy>0.){
     sef=sqrt(finalenergy*(1.+AF[1]*finalenergy));
     SWK[2][5][ie]=SWK[2][4][ie]+ope*sef*dos1*(1.+2.*AF[1]*finalenergy);
    }
    else SWK[2][5][ie]=SWK[2][4][ie];
// Absorption
    finalenergy=initialenergy+hwij+EC[2]-EC[1];
    if(finalenergy>0.){
     sef=sqrt(finalenergy*(1.+AF[1]*finalenergy));
     SWK[2][6][ie]=SWK[2][5][ie]+opa*sef*dos1*(1.+2.*AF[1]*finalenergy);
    }
    else SWK[2][6][ie]=SWK[2][5][ie];
// Acoustic phonon
    finalenergy=initialenergy;
    sef=sqrt(finalenergy*(1.+AF[2]*finalenergy));
    SWK[2][7][ie]=SWK[2][6][ie]+aco*sef*dos2*(1.+2.*AF[2]*finalenergy);
// ==================
// --->  } <--- This is a bug! Removed by J.M.Sellier on 24 dec.2006 (SR)
// (Thanks to Kun-Yuan Xu who helped me in finding it!)
// ==================
// Impurity scattering
    finalenergy=initialenergy;
    sef=sqrt(finalenergy*(1.+AF[2]*finalenergy));
    ak=SMH[2]*sef;
    qq=QD2*(4.*ak*ak+QD2);
    wk=bimp/qq*sef*dos2*(1.+2.*AF[2]*finalenergy);
    if(wk>1.e14) wk=1.e14;
    SWK[2][8][ie]=SWK[2][7][ie]+wk;
  } // <--- this is the correct place for the symbol } (J.M.Sellier,24/12/2006)
// Evalutation of gamma
  GM=SWK[1][6][1];
  for(ie=1;ie<=DIME;ie++){
    if(SWK[1][6][ie]>GM) GM=SWK[1][6][ie];
    if(SWK[2][8][ie]>GM) GM=SWK[2][8][ie];
  }
  printf("GAMMA = %g \n", GM);
  for(i=1;i<=6;i++)
    for(ie=1;ie<=DIME;ie++)
      SWK[1][i][ie]/=GM;
  for(i=1;i<=8;i++)
    for(ie=1;ie<=DIME;ie++)
      SWK[2][i][ie]/=GM;
 }
// End of GaAs
// ###########

// Material = Si
// #############
 if(Material==SILICON){
  SMH[0]=sqrt(2.*mstar*M*Q)/HBAR;
  HHM[0]=HBAR*HBAR/(2.*mstar*M*Q);
  HM[0]=HBAR/(mstar*M);
// Density of states
  dos=pow((sqrt(2.*mstar*M)*sqrt(Q)/HBAR),3.)/(4.*PI*PI);
// constant for the acoustic phonon
  aco=2.*PI*(SiDA/Q)*SiDA*(BKTQ/HBAR)*(Q/(SiRHO*UL*UL));
// Constants for the 6 Silicon non-polar optical phonons
  for(i=1;i<=6;i++){
// i-th Optical Phonon
    wo=SiHWO[i-1]*Q/HBAR; // frequency of phonon
    no=1./(exp(SiHWO[i-1]/BKTQ) - 1.); // population of phonons
    oge[i]=ZF[i-1]*PI*(SiDTK[i-1]*Q/wo)*((SiDTK[i-1]*Q/SiRHO)/Q)*(no+1.);
    oga[i]=oge[i]*no/(1.+no);
  }
// Calculation of scattering rates
 for(ie=1; ie<=DIME; ++ie) SWK[0][0][ie]=0.;
 for(ie=1; ie<=DIME; ++ie){
   initialenergy=DE*((real) ie);
   sei=sqrt(initialenergy);
// non polar optical phonons
   for(i=1;i<=6;i++){
     finalenergy=initialenergy-SiHWO[i-1];
     SWK[0][i*2-1][ie]=SWK[0][i*2-2][ie];
     if(finalenergy>0.){
      sef=sqrt(finalenergy*(1.+alphaSILICON*finalenergy));
      SWK[0][i*2-1][ie]=SWK[0][i*2-2][ie]
                    +oge[i]*sef*dos*(1.+2.*alphaSILICON*finalenergy);
     }
     finalenergy=initialenergy+SiHWO[i-1];
     SWK[0][i*2][ie]=SWK[0][i*2-1][ie];
     if(finalenergy>0.){
      sef=sqrt(finalenergy*(1.+alphaSILICON*finalenergy));
      SWK[0][i*2][ie]=SWK[0][i*2-1][ie]
                  +oga[i]*sef*dos*(1.+2.*alphaSILICON*finalenergy);
     }
   }
// Acoustic phonon
   finalenergy=initialenergy;
   sef=sqrt(finalenergy*(1.+alphaSILICON*finalenergy));
   SWK[0][13][ie]=SWK[0][12][ie]
                 +aco*sef*dos*(1.+2.*alphaSILICON*finalenergy);
  }

// Evaluation of gamma
  GM=SWK[0][13][1];
  for(ie=1;ie<=DIME;++ie)
    if(SWK[0][13][ie]>GM) GM=SWK[0][13][ie];
  printf("GAMMA = %g \n", GM);
  for(ie=1;ie<=DIME;ie++)
    for(i=1;i<=13;i++)
      SWK[0][i][ie]/=GM;
 }
// End of Silicon

// Material = Ge
// #############
 if(Material==GERMANIUM){
  SMH[0]=sqrt(2.*mstar*M*Q)/HBAR;
  HHM[0]=HBAR*HBAR/(2.*mstar*M*Q);
  HM[0]=HBAR/(mstar*M);
// Density of states
  dos=pow((sqrt(2.*mstar*M)*sqrt(Q)/HBAR),3.)/(4.*PI*PI);
// constant for the acoustic phonon
  aco=2.*PI*(GeDA/Q)*GeDA*(BKTQ/HBAR)*(Q/(GeRHO*GeUL*GeUL));
// Constants for the 6 Silicon non-polar optical phonons
// Optical Phonon
    wo=GeHWO*Q/HBAR; // frequency of phonon
    no=1./(exp(GeHWO/BKTQ) - 1.); // population of phonons
    ogeg=PI*(GeDTK*Q/wo)*((GeDTK*Q/GeRHO)/Q)*(no+1.);
    ogag=ogeg*no/(1.+no);
// Calculation of scattering rates
 for(ie=1; ie<=DIME; ++ie) SWK[0][0][ie]=0.;
 for(ie=1; ie<=DIME; ++ie){
   initialenergy=DE*((real) ie);
   sei=sqrt(initialenergy);
// non polar optical phonons
     finalenergy=initialenergy-GeHWO;
     SWK[0][1][ie]=SWK[0][0][ie];
     if(finalenergy>0.){
      sef=sqrt(finalenergy*(1.+alphaGERMANIUM*finalenergy));
      SWK[0][1][ie]=SWK[0][1][ie]
                    +ogeg*sef*dos*(1.+2.*alphaGERMANIUM*finalenergy);
     }
     finalenergy=initialenergy+GeHWO;
     SWK[0][2][ie]=SWK[0][1][ie];
     if(finalenergy>0.){
      sef=sqrt(finalenergy*(1.+alphaGERMANIUM*finalenergy));
      SWK[0][2][ie]=SWK[0][1][ie]
                  +ogag*sef*dos*(1.+2.*alphaGERMANIUM*finalenergy);
     }
// Acoustic phonon
   finalenergy=initialenergy;
   sef=sqrt(finalenergy*(1.+alphaGERMANIUM*finalenergy));
   SWK[0][3][ie]=SWK[0][2][ie]
                 +aco*sef*dos*(1.+2.*alphaGERMANIUM*finalenergy);
  }

// Evaluation of gamma
  GM=SWK[0][3][1];
  for(ie=1;ie<=DIME;++ie)
    if(SWK[0][3][ie]>GM) GM=SWK[0][3][ie];
  printf("GAMMA = %g \n", GM);
  for(ie=1;ie<=DIME;ie++)
    for(i=1;i<=3;i++)
      SWK[0][i][ie]/=GM;
 }
// End of Germanium

}

// =======================================================
