// This file is part of The New Aspell
// Copyright (C) 2004 by Kevin Atkinson under the GNU LGPL
// license version 2.0 or 2.1.  You should have received a copy of the
// LGPL license along with this library if you did not you can find it
// at http://www.gnu.org/.
//
// Copyright 2002 Kevin B. Hendricks, Stratford, Ontario, Canada And
// Contributors.  All rights reserved.
//

#ifndef ASPELL_AFFIX__HPP
#define ASPELL_AFFIX__HPP

#include "posib_err.hpp"
#include "wordinfo.hpp"
#include "fstream.hpp"
#include "parm_string.hpp"
#include "simple_string.hpp"
#include "char_vector.hpp"
#include "objstack.hpp"

#define SETSIZE         256
#define MAXAFFIXES      256
#define MAXWORDLEN      255
#define XPRODUCT        (1 << 0)

#define MAXLNLEN        1024

#define TESTAFF( a , b) strchr(a, b)

namespace acommon {
  class Config;
  struct CheckInfo;
  struct Conv;
}

namespace aspeller {

//13-Sep-04   using namespace acommon;

  class Language;

  class SpellerImpl;
  using acommon::CheckInfo;
  struct GuessInfo;

  struct LookupInfo;
  struct AffEntry;
  struct PfxEntry;
  struct SfxEntry;

  struct WordAff
  {
    acommon::SimpleString word;
    const unsigned char * aff;
    WordAff * next;
  };

  enum CheckAffixRes {InvalidAffix, InapplicableAffix, ValidAffix};

  class AffixMgr
  {
    const Language * lang;

    PfxEntry *          pStart[SETSIZE];
    SfxEntry *          sStart[SETSIZE];
    PfxEntry *          pFlag[SETSIZE];
    SfxEntry *          sFlag[SETSIZE];

    int max_strip_f[SETSIZE];
    int max_strip_;

    const char *        encoding;
    //const char *        compound;
    //int                 cpdmin;

    acommon::ObjStack data_buf;

    const char * affix_file;

  public:
 
    AffixMgr(const Language * l);
    ~AffixMgr();

    unsigned int max_strip() const {return max_strip_;}

    acommon::PosibErr<void> setup(acommon::ParmString affpath, acommon::Conv &);

    bool affix_check(const LookupInfo &, acommon::ParmString, CheckInfo &, GuessInfo *) const;
    bool prefix_check(const LookupInfo &, acommon::ParmString, CheckInfo &, GuessInfo *) const;
    bool suffix_check(const LookupInfo &, acommon::ParmString, CheckInfo &, GuessInfo *,
                      int sfxopts, AffEntry* ppfx) const;

    ASPELL_API void munch(acommon::ParmString word, GuessInfo *) const;

    // None of the expand methods reset the objstack

    ASPELL_API WordAff * expand(acommon::ParmString word, acommon::ParmString aff, 
                     acommon::ObjStack &, int limit = INT_MAX) const;

    CheckAffixRes check_affix(acommon::ParmString word, char aff) const;

    WordAff * expand_prefix(acommon::ParmString word, acommon::ParmString aff, 
                            acommon::ObjStack & buf) const 
    {
      return expand(word,aff,buf,0);
    }
	 //13-Sep-04
	 //Made param names match function definition.
    WordAff * expand_suffix(acommon::ParmString word, const unsigned char * aff,
                            acommon::ObjStack &, int limit = INT_MAX,
                            unsigned char * new_aff = 0, WordAff * * * l = 0,
                            acommon::ParmString orig_word = 0) const;
    
  private:
    acommon::PosibErr<void> parse_file(const char * affpath, acommon::Conv &);

    acommon::PosibErr<void> build_pfxlist(PfxEntry* pfxptr);
    acommon::PosibErr<void> build_sfxlist(SfxEntry* sfxptr);
    acommon::PosibErr<void> process_pfx_order();
    acommon::PosibErr<void> process_sfx_order();
  };

  acommon::PosibErr<AffixMgr *> new_affix_mgr(acommon::ParmString name, 
                                     acommon::Conv &,
                                     const Language * lang);
}

#endif

