// Copyright (C) 2004 Etoile Diese
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// As a special exception to the GNU General Public License, permission is
// granted for additional uses of the text contained in its release
// of Bayonne as noted here.
//
// This exception is that permission is hereby granted to link Bayonne 
// with the Dialogic runtime libraries to produce a executable image
// without requiring Dialogic's sources to be supplied so long as each
// each source file so linked contains this exclusion.
//
// This exception does not however invalidate any other reasons why
// the resulting executable file might be covered by the GNU General
// public license or invalidate the licensing requirements of any
// other component or library.
//
// This exception applies only to the code released by OST under the
// name Bayonne.  If you copy code from other releases into a copy of
// Bayonne, as the General Public License permits, the exception does not
// apply to the code that you add in this way.  To avoid misleading
// anyone as to the status of such modified files, you must delete
// this exception notice from them.
//
// If you write modifications of your own to Bayonne, it is your choice
// whether to permit this exception to apply to your modifications.
// If you do not wish that, delete this exception notice, at which
// point the terms of your modification would be covered under the GPL
// as explicitly stated in "COPYING".


#include <cc++/slog.h>
#include "possibilite.h"

#ifdef	CCXX_NAMESPACES
using namespace ost;
#endif

void dumpIe(unsigned char  *ie, int len) {
	int i, v;

	slog(Slog::levelError) << "dumpIe : Begin " << endl;
	for (i = 0; i < len; i++) {
		v = *(ie + i);
		slog(Slog::levelError) << ": " << v  << endl ;
	}
	slog(Slog::levelError) << "dumpIe : End " << endl;
}

/* Fonction qui recoit un poiteur vers le buffer in, de longeur len
 * qui extrait une commande possibilite (si elle la trouve)
 * qui retourne la longueur et met la commande possibilite dans out s'il y en a une
 * qui retourne 0 si elle n'en trouve pas.
 * Si la structure du buffer in semble "incohrent", elle retourne 0
 * Remarque : out doit tre pralablement allou (64 octets max)
 */
int extraitPossibilite(void *in, void *out, int len)
{
	int lpos = -1;
	unsigned int nie, lie;
	int n;
	unsigned char *pt;
	int i = 0;
	int foundPos = 0;
	
	slog(Slog::levelDebug) << "extraitPossibilite : Possibilite parsing " << endl;

	pt = (unsigned char *)in;


	while (i < len) {

		if (*pt == IdPos ) {


			lpos = (unsigned int) *(pt + 2);	/* Longueur */
			if ((i + lpos + 3) > len) {
				slog(Slog::levelError) << "extraitPossibilite : Abnormal length" << endl;
				return (-1);
			} else {
				memcpy(out, pt, lpos + 3);
				return(lpos + 3);
			}
		} else {
			/* Probablement une ie ? */
			pt++;
			lie = (unsigned int) *pt;	/* Longueur */
			/* dumpIe(pt + 1, lie); */
			if (i + lie <= len) {
				pt = pt + lie + 1;
				i = i + lie + 1;
			}
		}
	}


	return(lpos);
}


/* Fonction qui extrait un Nas (appelant ou appel)
 *  partir d'un buffer de commande possibilit
 * de longueur 7
 */
int extraitNas(unsigned char *pt, int len, char *out)
{
	char nas[10 + 1];
	int temp, num;

	pt++;	/* Parit + Indicateur de la nature de l'adresse */
	pt++;	/* Indicateur de numro incomplet + Plan de numrotage + 4 bits  0 (0000) */

	pt++;	/* 1 */
	num = (unsigned int) *pt;
	temp = num/16;
	nas[1] = 0x30 + temp;
	temp = num - temp*16;
	nas[0] = 0x30 + temp;

	pt++;	/* 2 */
	num = (unsigned int) *pt;
	temp = num/16;
	nas[3] = 0x30 + temp;
	temp = num - temp*16;
	nas[2] = 0x30 + temp;

	pt++;	/* 3 */
	num = (unsigned int) *pt;
	temp = num/16;
	nas[5] = 0x30 + temp;
	temp = num - temp*16;
	nas[4] = 0x30 + temp;

	pt++;	/* 4 */
	num = (unsigned int) *pt;
	temp = num/16;
	nas[7] = 0x30 + temp;
	temp = num - temp*16;
	nas[6] = 0x30 + temp;

	pt++;	/* 5 */
	num = (unsigned int) *pt;
	temp = num/16;
	temp = num - temp*16;
	nas[8] = 0x30 + temp;
	nas[9] = 0;
	strcpy(out, nas);
	return(9);
}


/* Fonction qui extrait une zone de longueur len depuis un buffer
 * La zone est recopie dans out.
 * Cette fonction est utilise pour extraire les donnes de contexte
 * et les donnes en retour
 * d'une commande possibilite */
int extraitBuf(unsigned char *pt, char *out, int len)
{
	char buf[64 + 1];
	int i;

	for (i=0; i < len; i++) {
		pt++;
		buf[i] = *pt;
	}
	buf[len] = 0;
	memcpy(out, buf, len+1);
	return(0);
}


/* Fonction qui recoit un pointeur vers un buffer representant une commande possibilite
 * qui extrait le NAS appel et qui le stocke dans out
 * Si la structure de la commande possibilite nous semble "incohrent", elle retourne 0
 * Si tout va bien, la fonction retourne une valeur positive.
 * Remarque : Les buffers de sorties doivent tre pralablement allous
 *
 * */
int extraitInfosPossibilite(void *in, char *outNasAppele, char *outNasAppelant, char *ctx, char *retour, int len)
{
	unsigned char *pt;
	unsigned int l, num;
	unsigned int lnas, lcallingnas, lcontexteAscii, lcontexteDcb, ldonneesRetour, lmarquage;
	int temp;

	slog(Slog::levelDebug) << "extraitInfosPossibilite : Parsing a buffer of length = " << len << endl;

	// Mise  zro des donnes de sortie
	*outNasAppele=0;
	*outNasAppelant=0;
	*ctx=0;
	*retour=0;

	pt = (unsigned char *)in;

	if (*pt != IdPos) {
		return(0);
	}
	pt++;
		if (*pt == FromPcsToServer) {
			slog(Slog::levelDebug) << "extraitInfosPossibilite : From PCS to server" << endl;
		}
		else {
		if (*pt == FromServerToPcs) {
			slog(Slog::levelDebug) << "extraitInfosPossibilite : From server to PCS" << endl;
			}
			else {
				slog(Slog::levelError) << "extraitInfosPossibilite : unknown direction : " << *pt << endl;
			}
		}
	pt++;

	l = (unsigned int)  *pt;

	pt++;	/* discriminateur de protocole */
	pt++;	/* IndExt + IndSeg + IdVersion   devrait tre 0*/
	
	pt++;	/* Type de la commande : possibilit 0x83 */
	if (*pt != TYPE_POSSIBILITE) {
		slog(Slog::levelError) << "extraitInfosPossibilite : this is not a Possibilite (!= 0x83)" << endl;
		return(0);
	}

	pt++;	/* longueur de la commande */
	l = (unsigned int)  *pt;

	slog(Slog::levelDebug) << "extraitInfosPossibilite : Extraction from a command of length = " << l << endl;

	pt++;	/* Premier parametre : NAS appel*/
	if (*pt == NAS_APPELE) {
		slog(Slog::levelDebug) << "extraitInfosPossibilite : NAS_APPELE" << endl;
		pt++;	/* Longueur du NAS appel */
		lnas = (unsigned int) *pt;

		if (lnas == 7) {
			// Extraction du NasAppel
			extraitNas(pt, 7, outNasAppele);
			// On avance de 7
			pt += 7;

			if (l > 9) {	// La suite est facultative
				slog(Slog::levelDebug) << "extraitInfosPossibilite : other informations : l = " << l << endl;
				pt++;	/* parametre suivant : position 10 */
				slog(Slog::levelDebug) << "extraitInfosPossibilite : type : " << *pt << endl;
				if (*pt == NAS_APPELANT) {
					slog(Slog::levelDebug) << "extraitInfosPossibilite : NAS_APPELANT" << endl;
					pt++;
					lcallingnas = (unsigned int) *pt;
					if (lcallingnas != 7) {
						slog(Slog::levelError) << "extraitInfosPossibilite : Impossible de dcoder la commande possibilit (lcallingnas = " << lcallingnas << endl;
						// On arrete le decodage
						// ou on continue ?
						// Si on veut continuer, pt += lcallingnas;
					} else {
						// Decodage NAS_APPELANT
						extraitNas(pt, 7, outNasAppelant);
						pt +=8;
					}

				}

				if (*pt == MARQUAGE) {
					slog(Slog::levelDebug) << "extraitInfosPossibilite : MARQUAGE" << endl;
					pt++;	
					lmarquage = (unsigned int) *pt;
					if (lmarquage != 0)
						slog(Slog::levelError) << "extraitInfosPossibilite : Strange : marquage length is not zero " << endl;
					pt++;

				}

				if (*pt == CONTEXTE_ASCII) {
					slog(Slog::levelDebug) << "extraitInfosPossibilite : CONTEXTE_ASCII" << endl;
					pt++;
					lcontexteAscii = (unsigned int) *pt;
					pt++;
					if (*pt != 0x04)
						slog(Slog::levelError) << "extraitInfosPossibilite : Bizarre : le type de codage n est pas ASCII" << endl;

					extraitBuf(pt, ctx, lcontexteAscii - 1);
					slog(Slog::levelDebug) << "extraitInfosPossibilite : Contexte : " << ctx << endl;
					pt += lcontexteAscii;
				}

				if (*pt == CONTEXTE_DCB) {
					slog(Slog::levelDebug) << "extraitInfosPossibilite : CONTEXTE_DCB" << endl;
					pt++;
					lcontexteDcb = (unsigned int) *pt;
					// On extrait dans le mme buffer que celui du contexte ASCII
					// car c'est l'un ou l'autre
					extraitBuf(pt, ctx, lcontexteDcb);
					pt += lcontexteDcb + 1;
				}

				if (*pt == DONNEES_RETOUR ) {
					slog(Slog::levelDebug) << "extraitInfosPossibilite : DONNEES_RETOUR" << endl;
					pt++;
					ldonneesRetour = (unsigned int) *pt;
					extraitBuf(pt, retour, ldonneesRetour);
				}
			} else {
				slog(Slog::levelDebug) << "extraitInfosPossibilite : No more information" << endl;
			}
			return(9);

		} else {
			slog(Slog::levelError) << "extraitInfosPossibilite : Impossible to decode possibilit (lnas != 7)" << endl;
		}

	} else {
		slog(Slog::levelError) << "extraitInfosPossibilite : Impossible to decode possibilit (!= 0x83)" << endl;
	}

	return(0);
}


