// Copyright (C) 2005 Open Source Telecom Corp.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#include "bayonne.h"

#ifndef	WIN32
#include "private.h"
#endif

#ifdef	HAVE_LIBEXEC
#include "libexec.h"
#endif

#ifndef	VERSION
#define	VERSION "0.3.1"
#endif

#ifdef	WIN32
#define	SCRIPT_EXTENSIONS ".bat.cmd.php.py.pl"
#else
#define	SCRIPT_EXTENSIONS ".sh.py.pl.php"
#endif

namespace server {
using namespace ost;
using namespace std;

class InfoThread : public ScriptThread
{
private:
	BayonneAudio *audio;
	const char *path;
	const char *var_date, *var_time, *var_size, *var_info, *var_type;
	const char *var_coding, *var_rate, *var_bitrate, *var_count;
	struct stat ino;
	
	void run(void);
public:
	InfoThread(ScriptInterp *interp, BayonneAudio *a, const char *fn);
	~InfoThread();
};

class BuildThread : public ScriptThread, public Audio
{
private:
	char pathname[128];
	const char **paths;
	Encoded buffer;
	Linear lbuffer;
	Info from, to;
	AudioStream out;
	BayonneAudio *in;
	bool completed;

	void copyDirect(void);
	void copyConvert(void);

	void run(void);

public:
	BuildThread(ScriptInterp *interp, BayonneAudio *au, Audio::Info *inf, const char **list);
	~BuildThread();
};

class CopyThread : public ScriptThread
{
private:
	const char *src, *dest;
	FILE *in, *out;
	char buf[1024];

	void run(void);
public:
	CopyThread(ScriptInterp *interp, const char *from, const char *to);
	~CopyThread();
};

class PositionProperty : public ScriptProperty, public Audio
{
public:
	PositionProperty();

	void set(const char *data, char *temp, unsigned size);

	long getValue(const char *data);

	char token(void);

	unsigned prec(void);

	void clear(char *data, unsigned size);
};

class PersistProperty : public ScriptProperty, public Bayonne
{
private:
	static ScriptSymbols syms;
	static ThreadLock lock;
	static bool loaded;

#define	PERSIST_CACHE_SIZE 64

	typedef	struct
	{
		char cache[PERSIST_CACHE_SIZE];
		Symbol *sym;
	} persist_t;

public:
	PersistProperty();

	void set(const char *data, char *temp, unsigned size);

	static bool remap(const char *id, char *save, const char *val = "");

	static bool refresh(Symbol *sym, const char *ind, const char *val = "");

	static bool test(const char *key);

	static void save(void);

	static void load(void);

	static inline unsigned getSize(void)
		{return sizeof(persist_t) + sizeof(ScriptProperty *);};
};

class TimeslotProperty : public ScriptProperty, public Bayonne
{
public:
	TimeslotProperty();

	void set(const char *data, char *temp, unsigned size);

	long getValue(const char *data);

	long adjustValue(long value);

//	void adjust(char *data, size_t size, long offset);
};

class Binder : public ScriptBinder, public ScriptChecks
{
private:
        void attach(ScriptInterp *interp);
        void detach(ScriptInterp *interp);  

public:
	Binder();

	static Binder binder;
};

class Runtime : public ScriptRuntime, public Bayonne
{
protected:
        unsigned long getTrapMask(const char *trapname);

	static bool testFile(ScriptInterp *interp, const char *v);
	static bool testDir(ScriptInterp *interp, const char *v);
	static bool testTimeslot(ScriptInterp *interp, const char *v);
	static bool testSpan(ScriptInterp *interp, const char *v);
	static bool testDriver(ScriptInterp *interp, const char *v);
	static bool testVoice(ScriptInterp *interp, const char *v);
	static bool testLang(ScriptInterp *interp, const char *v);
	static bool testKey(ScriptInterp *interp, const char *v);

public:
	static void process(void);

	static bool startDriver(BayonneDriver *d, const char *name, const char *dial, const char *caller, const char *display);

	static bool startSelect(const char *name, const char *dial, const char *caller, const char *display);

	static bool command(char *line);

	const char *getExternal(const char *opt);

	void errlog(const char *level, const char *msg);

	bool isInput(Line *line);

	Runtime();
};

class Methods : public BayonneSession
{
public:
	bool scrEcho(void);
	bool scrPickup(void);
	bool scrHangup(void);
	bool scrWaitkey(void);
	bool scrSleep(void);
	bool scrSync(void);
	bool scrCleardigits(void);
	bool scrKeyinput(void);
	bool scrCollect(void);
	bool scrInput(void);
	bool scrRead(void);
	bool scrRoute(void);
	bool scrErase(void);
	bool scrMove(void);
	bool scrCopy(void);
	bool scrTimeslot(void);
	bool scrPosition(void);
	bool scrPathname(void);
	bool scrVoicelib(void);
	bool scrMenu(void);
	bool scrEndmenu(void);
	bool scrLibexec(void);
	bool scrPlay(void);
	bool scrReplay(void);
	bool scrRecord(void);
	bool scrAppend(void);
	bool scrPrompt(void);
	bool scrBuild(void);
	bool scrTone(void);
	bool scrTonegen(void);
	bool scrDTMF(void);
	bool scrMF(void);
	bool scrCancel(void);
	bool scrDetach(void);
	bool scrStart(void);
	bool scrTransfer(void);
	bool scrWait(void);
	bool scrJoin(void);
	bool scrSignal(void);
	bool scrFailsignal(void);
	bool scrDial(void);
	bool scrKey(void);
};

class Checks : public ScriptChecks, public Bayonne
{
public:
	const char *chkKey(Line *line, ScriptImage *img);
	const char *chkCDR(Line *line, ScriptImage *img);
	const char *chkTonegen(Line *line, ScriptImage *img);
	const char *chkRegister(Line *line, ScriptImage *img);
	const char *chkAssign(Line *line, ScriptImage *img);
	const char *chkSelect(Line *line, ScriptImage *img);
	const char *chkSleep(Line *line, ScriptImage *img);
	const char *chkCleardigits(Line *line, ScriptImage *img);
	const char *chkKeyinput(Line *line, ScriptImage *img);
	const char *chkInput(Line *line, ScriptImage *img);
	const char *chkCollect(Line *line, ScriptImage *img);
	const char *chkRoute(Line *line, ScriptImage *img);
	const char *chkErase(Line *line, ScriptImage *img);
	const char *chkInfo(Line *line, ScriptImage *img);
	const char *chkMove(Line *line, ScriptImage *img);
	const char *chkDir(Line *line, ScriptImage *img);
	const char *chkPathname(Line *line, ScriptImage *img);
	const char *chkReplay(Line *line, ScriptImage *img);
	const char *chkRecord(Line *line, ScriptImage *img);
	const char *chkAppend(Line *line, ScriptImage *img);
	const char *chkVoicelib(Line *line, ScriptImage *img);
	const char *chkLibexec(Line *line, ScriptImage *img);
	const char *chkLang(Line *line, ScriptImage *img);
	const char *chkLoad(Line *line, ScriptImage *img);
	const char *chkBuild(Line *line, ScriptImage *img);
	const char *chkTone(Line *line, ScriptImage *img);
	const char *chkDialer(Line *line, ScriptImage *img);
	const char *chkCancel(Line *line, ScriptImage *img);
	const char *chkStart(Line *line, ScriptImage *img);
	const char *chkTransfer(Line *line, ScriptImage *img);
	const char *chkWait(Line *line, ScriptImage *img);
	const char *chkJoin(Line *line, ScriptImage *img);
	const char *chkConnect(Line *line, ScriptImage *img);
	const char *chkChildSignal(Line *line, ScriptImage *img);
	const char *chkDial(Line *line, ScriptImage *img);
};

#ifdef	HAVE_LIBEXEC

class Sysexec : protected Thread, protected Bayonne
{
private:
	static bool exiting;
	static int iopair[2];
	static Sysexec *libexec;

	static void execute(unsigned slot, const char *cmd);
	static void readline(char *buf, unsigned max);

	void run(void);

	Sysexec();
	~Sysexec();

public:
	static bool create(BayonneSession *s);
	static void allocate(void);
	static void cleanup(void);
	static void startup(void);
};

#endif

extern Runtime runtime;
extern Keydata keypaths;
extern Keydata keyserver;
extern Keydata keyengine;
extern Keydata keyoptions;

extern TimeslotProperty typeTimeslot;
extern PositionProperty typePosition;

void purgedir(const char *dir);
void loadConfig(void);
void testConfig(char *argv0);
void dumpConfig(Keydata &keydef);
bool parseConfig(char **argv);

}

