// Copyright (C) 2005 Open Source Telecom Corp.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#include "engine.h"

namespace ost {
using namespace std;

BayonneRPC::BayonneRPC()
{
	rpc_keycount = rpc_argcount = 0;
}

const char *BayonneRPC::getArg(unsigned argc)
{
        unsigned pos = 0;
        unsigned count = 0;

        while(pos < rpc_keycount)
        {
                if(!rpc_keydata[pos].name)
                        if(count++ == argc)
                                return rpc_keydata[pos].value;
                ++pos;
        }
        return NULL;
}

const char *BayonneRPC::getKey(const char *id, const char *sub)
{
        unsigned pos = 0;

        while(pos < rpc_keycount)
        {
                if(!rpc_keydata[pos].name)
                        goto next;

                if(stricmp(rpc_keydata[pos].name, id))
                        goto next;

                if(sub && !rpc_keydata[pos].field)
                        goto next;

                if(!sub && rpc_keydata[pos].field)
                        goto next;

                if(!sub || !stricmp(sub, rpc_keydata[pos].field))
                        return rpc_keydata[pos].value;
next:
                ++pos;
        }
        return NULL;
}

void BayonneRPC::addKey(const char *key, const char *value, const char *field)
{
        if(rpc_keycount >= RPC_MAX_KEYS)
                return;

        rpc_keydata[rpc_keycount].value = value;
        rpc_keydata[rpc_keycount].name = key;
        rpc_keydata[rpc_keycount].field = field;
        ++rpc_keycount;
}

void BayonneRPC::addArg(const char *value)
{
        if(rpc_keycount >= RPC_MAX_KEYS)
                return;

        rpc_keydata[rpc_keycount].value = value;
        rpc_keydata[rpc_keycount].name = NULL;
        rpc_keydata[rpc_keycount].field = NULL;
        ++rpc_keycount;
	++rpc_argcount;
}
		
} // namespace
