;;; -*- Mode: LISP; Syntax: Common-Lisp; Package: LAPIDARY; Base: 10 -*-
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;         The Garnet User Interface Development Environment.      ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; This code was written as part of the Garnet project at          ;;;
;;; Carnegie Mellon University, and has been placed in the public   ;;;
;;; domain.  If you are using this code or any part of Garnet,      ;;;
;;; please contact garnet@cs.cmu.edu to be put on the mailing list. ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(in-package "LAPIDARY" :use '("LISP" "KR"))

;; line-to-line constraints 
(defvar *x1-to-x1* (formula `(+ (gvl :x1-over :x1) (gvl :x1-offset))))
(defvar *x1-to-x2* (formula `(+ (gvl :x1-over :x2) (gvl :x1-offset))))
(defvar *x2-to-x1* (formula `(+ (gvl :x2-over :x1) (gvl :x2-offset))))
(defvar *x2-to-x2* (formula `(+ (gvl :x2-over :x2) (gvl :x2-offset))))

(defvar *y1-to-y1* (formula `(+ (gvl :y1-over :y1) (gvl :y1-offset))))
(defvar *y1-to-y2* (formula `(+ (gvl :y1-over :y2) (gvl :y1-offset))))
(defvar *y2-to-y1* (formula `(+ (gvl :y2-over :y1) (gvl :y2-offset))))
(defvar *y2-to-y2* (formula `(+ (gvl :y2-over :y2) (gvl :y2-offset))))

;; line-to-box constraints 
(defvar *x1-to-box-left* (formula `(+ (gvl :x1-over :left) (gvl :x1-offset))))
(defvar *x1-to-box-center* (formula `(+ (lapidary::gv-center-x (gvl :x1-over))
				       (gvl :x1-offset))))
(defvar *x1-to-box-right* (formula `(+ (lapidary::gv-right (gvl :x1-over))
				     (gvl :x1-offset))))

(defvar *x2-to-box-left* (formula `(+ (gvl :x2-over :left) (gvl :x2-offset))))
(defvar *x2-to-box-center* (formula `(+ (lapidary::gv-center-x (gvl :x2-over))
				       (gvl :x2-offset))))
(defvar *x2-to-box-right* (formula `(+ (lapidary::gv-right (gvl :x2-over))
				     (gvl :x2-offset))))

(defvar *y1-to-box-top* (formula `(+ (gvl :y1-over :top) (gvl :y1-offset))))
(defvar *y1-to-box-center* (formula `(+ (lapidary::gv-center-y (gvl :y1-over))
				      (gvl :y1-offset))))
(defvar *y1-to-box-bottom* (formula `(+ (lapidary::gv-bottom (gvl :y1-over))
				      (gvl :y1-offset))))

(defvar *y2-to-box-top* (formula `(+ (gvl :y2-over :top) (gvl :y2-offset))))
(defvar *y2-to-box-center* (formula `(+ (lapidary::gv-center-y (gvl :y2-over))
				      (gvl :y2-offset))))
(defvar *y2-to-box-bottom* (formula `(+ (lapidary::gv-bottom (gvl :y2-over))
				      (gvl :y2-offset))))

;; line-to-circle constraints 
(defvar *x1-to-circle-left-corner* 
      (formula `(round (+ (gvl :x1-over :left)
			  (* (gvl :x1-over :radius) ,135deg)
			  (gvl :x1-offset)))))
(defvar *x1-to-circle-right-corner* 
      (formula `(round (+ (gvl :x1-over :left)
			  (* (gvl :x1-over :radius) ,45deg)
			  (gvl :x1-offset)))))

(defvar *x2-to-circle-left-corner* 
      (formula `(round (+ (gvl :x2-over :left)
			  (* (gvl :x2-over :radius) ,135deg)
			  (gvl :x2-offset)))))
(defvar *x2-to-circle-right-corner* 
      (formula `(round (+ (gvl :x2-over :left)
			  (* (gvl :x2-over :radius) ,45deg)
			  (gvl :x2-offset)))))

(defvar *y1-to-circle-top-corner* 
      (formula `(round (+ (gvl :y1-over :top)
			  (* (gvl :y1-over :radius) ,135deg)
			  (gvl :y1-offset)))))
(defvar *y1-to-circle-bottom-corner* 
      (formula `(round (+ (gvl :y1-over :top)
			  (* (gvl :y1-over :radius) ,45deg)
			  (gvl :y1-offset)))))

(defvar *y2-to-circle-top-corner* 
      (formula `(round (+ (gvl :y2-over :top)
			  (* (gvl :y2-over :radius) ,135deg)
			  (gvl :y2-offset)))))
(defvar *y2-to-circle-bottom-corner* 
      (formula `(round (+ (gvl :y2-over :top)
			  (* (gvl :y2-over :radius) ,45deg)
			  (gvl :y2-offset)))))

;; line-to-roundtangle constraints 
(defvar *x1-to-roundtangle-left-corner*
      (formula `(round (+ (gvl :x1-over :left) 
			  (* (gvl :x1-over :draw-radius) ,135deg)
			  (gvl :x1-offset)))))
(defvar *x1-to-roundtangle-right-corner*
      (formula `(round (+ (- (lapidary::gv-right (gvl :x1-over))
			     (* (gvl :x1-over :draw-radius) ,135deg))
			  (gvl :x1-offset)))))

(defvar *x2-to-roundtangle-left-corner*
      (formula `(round (+ (gvl :x2-over :left) 
			  (* (gvl :x2-over :draw-radius) ,135deg)
			  (gvl :x2-offset)))))
(defvar *x2-to-roundtangle-right-corner*
      (formula `(round (+ (- (lapidary::gv-right (gvl :x2-over))
			     (* (gvl :x2-over :draw-radius) ,135deg))
			  (gvl :x2-offset)))))

(defvar *y1-to-roundtangle-top-corner*
      (formula `(round (+ (gvl :y1-over :top) 
			  (* (gvl :y1-over :draw-radius) ,135deg)
			  (gvl :y1-offset)))))
(defvar *y1-to-roundtangle-bottom-corner*
      (formula `(round (+ (- (lapidary::gv-bottom (gvl :y1-over))
			     (* (gvl :y1-over :draw-radius) ,135deg))
			  (gvl :y1-offset)))))

(defvar *y2-to-roundtangle-top-corner*
      (formula `(round (+ (gvl :y2-over :top) 
			  (* (gvl :y2-over :draw-radius) ,135deg)
			  (gvl :y2-offset)))))
(defvar *y2-to-roundtangle-bottom-corner*
      (formula `(round (+ (- (lapidary::gv-bottom (gvl :y2-over))
			     (* (gvl :y2-over :draw-radius) ,135deg))
			  (gvl :y2-offset)))))

;; box-to-line constraints 
(defvar *box-left-to-x1* (formula `(+ (gvl :left-over :x1)
				    (gvl :left-offset))))
(defvar *box-center-to-x1* (formula `(+ (- (gvl :left-over :x1)
					 (floor (gvl :width) 2))
				      (gvl :left-offset))))
(defvar *box-right-to-x1* (formula `(+ (- (gvl :left-over :x1)
					(gvl :width))
				     (gvl :left-offset))))

(defvar *box-left-to-x2* (formula `(+ (gvl :left-over :x2)
				    (gvl :left-offset))))
(defvar *box-center-to-x2* (formula `(+ (- (gvl :left-over :x2)
					 (floor (gvl :width) 2))
				      (gvl :left-offset))))
(defvar *box-right-to-x2* (formula `(+ (- (gvl :left-over :x2)
					(gvl :width))
				     (gvl :left-offset))))

(defvar *box-top-to-y1* (formula `(+ (gvl :top-over :y1)
				     (gvl :top-offset))))
(defvar *box-center-to-y1* (formula `(+ (- (gvl :top-over :y1)
					 (floor (gvl :height) 2))
				      (gvl :top-offset))))
(defvar *box-bottom-to-y1* (formula `(+ (- (gvl :top-over :y1)
					(gvl :height))
				     (gvl :top-offset))))

(defvar *box-top-to-y2* (formula `(+ (gvl :top-over :y2)
				    (gvl :top-offset))))
(defvar *box-center-to-y2* (formula `(+ (- (gvl :top-over :y2)
					 (floor (gvl :height) 2))
				      (gvl :top-offset))))
(defvar *box-bottom-to-y2* (formula `(+ (- (gvl :top-over :y2)
					(gvl :height))
				     (gvl :top-offset))))

;; circle-to-line constraints
(defvar *circle-left-corner-to-x1*
      (formula `(round (+ (- (gvl :left-over :x1)
			     (* (gvl :radius) ,135deg))
			  (gvl :left-offset)))))
(defvar *circle-center-to-x1*
      (formula `(+ (- (gvl :left-over :x1)
		      (gvl :radius))
		   (gvl :left-offset))))
(defvar *circle-right-corner-to-x1*
      (formula `(round (+ (- (gvl :left-over :x1)
			     (* (gvl :radius) ,45deg))
			  (gvl :left-offset)))))


(defvar *circle-left-corner-to-x2*
      (formula `(round (+ (- (gvl :left-over :x2)
			     (* (gvl :radius) ,135deg))
			  (gvl :left-offset)))))
(defvar *circle-center-to-x2*
      (formula `(+ (- (gvl :left-over :x2)
		      (gvl :radius))
		   (gvl :left-offset))))
(defvar *circle-right-corner-to-x2*
      (formula `(round (+ (- (gvl :left-over :x2)
			     (* (gvl :radius) ,45deg))
			  (gvl :left-offset)))))

(defvar *circle-top-corner-to-y1*
      (formula `(round (+ (- (gvl :top-over :y1)
			     (* (gvl :radius) ,135deg))
			  (gvl :top-offset)))))
(defvar *circle-center-to-y1*
      (formula `(+ (- (gvl :top-over :y1)
		      (gvl :radius))
		   (gvl :top-offset))))
(defvar *circle-bottom-corner-to-y1*
      (formula `(round (+ (- (gvl :top-over :y1)
			     (* (gvl :radius) ,45deg))
			  (gvl :top-offset)))))


(defvar *circle-top-corner-to-y2*
      (formula `(round (+ (- (gvl :top-over :y2)
			     (* (gvl :radius) ,135deg))
			  (gvl :top-offset)))))
(defvar *circle-center-to-y2*
      (formula `(+ (- (gvl :top-over :y2)
		      (gvl :radius))
		   (gvl :top-offset))))
(defvar *circle-bottom-corner-to-y2*
      (formula `(round (+ (- (gvl :top-over :y2)
			     (* (gvl :radius) ,45deg))
			  (gvl :top-offset)))))

;; roundtangle-to-line constraints
(defvar *roundtangle-left-corner-to-x1*
      (formula `(round (+ (- (gvl :left-over :x1)
			     (* (gvl :draw-radius) ,135deg))
			  (gvl :left-offset)))))
(defvar *roundtangle-right-corner-to-x1*
      (formula `(round (+ (- (gvl :left-over :x1) 
			     (gvl :width))
			  (* (gvl :draw-radius) ,135deg)
			  (gvl :left-offset)))))

(defvar *roundtangle-left-corner-to-x2*
      (formula `(round (+ (- (gvl :left-over :x2)
			     (* (gvl :draw-radius) ,135deg))
			  (gvl :left-offset)))))
(defvar *roundtangle-right-corner-to-x2*
      (formula `(round (+ (- (gvl :left-over :x2) 
			     (gvl :width))
			  (* (gvl :draw-radius) ,135deg)
			  (gvl :left-offset)))))

(defvar *roundtangle-top-corner-to-y1*
      (formula `(round (+ (- (gvl :top-over :y1)
			     (* (gvl :draw-radius) ,135deg))
			  (gvl :top-offset)))))
(defvar *roundtangle-bottom-corner-to-y1*
      (formula `(round (+ (- (gvl :top-over :y1) 
			     (gvl :height))
			  (* (gvl :draw-radius) ,135deg)
			  (gvl :top-offset)))))

(defvar *roundtangle-top-corner-to-y2*
      (formula `(round (+ (- (gvl :top-over :y2)
			     (* (gvl :draw-radius) ,135deg))
			  (gvl :top-offset)))))
(defvar *roundtangle-bottom-corner-to-y2*
      (formula `(round (+ (- (gvl :top-over :y2) 
			     (gvl :height))
			  (* (gvl :draw-radius) ,135deg)
			  (gvl :top-offset)))))

;;; vectors of constraints that are passed to attach-constraint. The
;;; button chosen by the user in a constraint menu has an index
;;; associated with it that chooses a formula in the formula vector

(defvar *x1-to-line* 
  (make-array 2 :initial-contents (list *x1-to-x1* *x1-to-x2*)))
(defvar *x2-to-line* 
  (make-array 2 :initial-contents (list *x2-to-x1* *x2-to-x2*)))

(defvar *y1-to-line* 
  (make-array 2 :initial-contents (list *y1-to-y1* *y1-to-y2*)))
(defvar *y2-to-line* 
  (make-array 2 :initial-contents (list *y2-to-y1* *y2-to-y2*)))

(defvar *line-to-box*
  (make-array '(3 2) :initial-contents
	      (list (list (cons (list *x1-to-circle-left-corner*
				      *x1-to-box-left*
				      *x1-to-circle-left-corner*
				      *x1-to-box-center*
				      *x1-to-box-center*
				      *x1-to-box-center*
				      *x1-to-circle-right-corner*
				      *x1-to-box-right*
				      *x1-to-circle-right-corner*)
				(list *y1-to-circle-top-corner*
				      *y1-to-box-center*
				      *y1-to-circle-bottom-corner*
				      *y1-to-box-top*
				      *y1-to-box-center*
				      *y1-to-box-bottom*
				      *y1-to-circle-top-corner*
				      *y1-to-box-center*
				      *y1-to-circle-bottom-corner*))
			  (cons (list *x2-to-circle-left-corner*
				      *x2-to-box-left*
				      *x2-to-circle-left-corner*
				      *x2-to-box-center*
				      *x2-to-box-center*
				      *x2-to-box-center*
				      *x2-to-circle-right-corner*
				      *x2-to-box-right*
				      *x2-to-circle-right-corner*)
				(list *y2-to-circle-top-corner*
				      *y2-to-box-center*
				      *y2-to-circle-bottom-corner*
				      *y2-to-box-top*
				      *y2-to-box-center*
				      *y2-to-box-bottom*
				      *y2-to-circle-top-corner*
				      *y2-to-box-center*
				      *y2-to-circle-bottom-corner*)))
		    (list (cons (list *x1-to-roundtangle-left-corner*
				      *x1-to-box-left*
				      *x1-to-roundtangle-left-corner*
				      *x1-to-box-center*
				      *x1-to-box-center*
				      *x1-to-box-center*
				      *x1-to-roundtangle-right-corner*
				      *x1-to-box-right*
				      *x1-to-roundtangle-right-corner*)
				(list *y1-to-roundtangle-top-corner*
				      *y1-to-box-center*
				      *y1-to-roundtangle-bottom-corner*
				      *y1-to-box-top*
				      *y1-to-box-center*
				      *y1-to-box-bottom*
				      *y1-to-roundtangle-top-corner*
				      *y1-to-box-center*
				      *y1-to-roundtangle-bottom-corner*))
			  (cons (list *x2-to-roundtangle-left-corner*
				      *x2-to-box-left*
				      *x2-to-roundtangle-left-corner*
				      *x2-to-box-center*
				      *x2-to-box-center*
				      *x2-to-box-center*
				      *x2-to-roundtangle-right-corner*
				      *x2-to-box-right*
				      *x2-to-roundtangle-right-corner*)
				(list *y2-to-roundtangle-top-corner*
				      *y2-to-box-center*
				      *y2-to-roundtangle-bottom-corner*
				      *y2-to-box-top*
				      *y2-to-box-center*
				      *y2-to-box-bottom*
				      *y2-to-roundtangle-top-corner*
				      *y2-to-box-center*
				      *y2-to-roundtangle-bottom-corner*)))
		    (list (cons (list *x1-to-box-left*
				      *x1-to-box-left*
				      *x1-to-box-left*
				      *x1-to-box-center*
				      *x1-to-box-center*
				      *x1-to-box-center*
				      *x1-to-box-right*
				      *x1-to-box-right*
				      *x1-to-box-right*)
				(list *y1-to-box-top*
				      *y1-to-box-center*
				      *y1-to-box-bottom*
				      *y1-to-box-top*
				      *y1-to-box-center*
				      *y1-to-box-bottom*
				      *y1-to-box-top*
				      *y1-to-box-center*
				      *y1-to-box-bottom*))
			  (cons (list *x2-to-box-left*
				      *x2-to-box-left*
				      *x2-to-box-left*
				      *x2-to-box-center*
				      *x2-to-box-center*
				      *x2-to-box-center*
				      *x2-to-box-right*
				      *x2-to-box-right*
				      *x2-to-box-right*)
				(list *y2-to-box-top*
				      *y2-to-box-center*
				      *y2-to-box-bottom*
				      *y2-to-box-top*
				      *y2-to-box-center*
				      *y2-to-box-bottom*
				      *y2-to-box-top*
				      *y2-to-box-center*
				      *y2-to-box-bottom*))))))

(defvar *box-to-line*
  (make-array '(3 2) :initial-contents
	      (list (list (cons (list *circle-left-corner-to-x1*
				      *box-left-to-x1*
				      *circle-left-corner-to-x1*
				      *circle-center-to-x1*
				      *circle-center-to-x1*
				      *circle-center-to-x1*
				      *circle-right-corner-to-x1*
				      *box-right-to-x1*
				      *circle-right-corner-to-x1*)
				(list *circle-top-corner-to-y1*
				      *circle-center-to-y1*
				      *circle-bottom-corner-to-y1*
				      *box-top-to-y1*
				      *circle-center-to-y1*
				      *box-bottom-to-y1*
				      *circle-top-corner-to-y1*
				      *circle-center-to-y1*
				      *circle-bottom-corner-to-y1*))
			  (cons (list *circle-left-corner-to-x2*
				      *box-left-to-x2*
				      *circle-left-corner-to-x2*
				      *circle-center-to-x2*
				      *circle-center-to-x2*
				      *circle-center-to-x2*
				      *circle-right-corner-to-x2*
				      *box-right-to-x2*
				      *circle-right-corner-to-x2*)
				(list *circle-top-corner-to-y2*
				      *circle-center-to-y2*
				      *circle-bottom-corner-to-y2*
				      *box-top-to-y2*
				      *circle-center-to-y2*
				      *box-bottom-to-y2*
				      *circle-top-corner-to-y2*
				      *circle-center-to-y2*
				      *circle-bottom-corner-to-y2*)))
		    (list (cons (list *roundtangle-left-corner-to-x1*
				      *box-left-to-x1*
				      *roundtangle-left-corner-to-x1*
				      *box-center-to-x1*
				      *box-center-to-x1*
				      *box-center-to-x1*
				      *roundtangle-right-corner-to-x1*
				      *box-right-to-x1*
				      *roundtangle-right-corner-to-x1*)
				(list *roundtangle-top-corner-to-y1*
				      *box-center-to-y1*
				      *roundtangle-bottom-corner-to-y1*
				      *box-top-to-y1*
				      *box-center-to-y1*
				      *box-bottom-to-y1*
				      *roundtangle-top-corner-to-y1*
				      *box-center-to-y1*
				      *roundtangle-bottom-corner-to-y1*))
			  (cons (list *roundtangle-left-corner-to-x2*
				      *box-left-to-x2*
				      *roundtangle-left-corner-to-x2*
				      *box-center-to-x2*
				      *box-center-to-x2*
				      *box-center-to-x2*
				      *roundtangle-right-corner-to-x2*
				      *box-right-to-x2*
				      *roundtangle-right-corner-to-x2*)
				(list *roundtangle-top-corner-to-y2*
				      *box-center-to-y2*
				      *roundtangle-bottom-corner-to-y2*
				      *box-top-to-y2*
				      *box-center-to-y2*
				      *box-bottom-to-y2*
				      *roundtangle-top-corner-to-y2*
				      *box-center-to-y2*
				      *roundtangle-bottom-corner-to-y2*)))
		    (list (cons (list *box-left-to-x1*
				      *box-left-to-x1*
				      *box-left-to-x1*
				      *box-center-to-x1*
				      *box-center-to-x1*
				      *box-center-to-x1*
				      *box-right-to-x1*
				      *box-right-to-x1*
				      *box-right-to-x1*)
				(list *box-top-to-y1*
				      *box-center-to-y1*
				      *box-bottom-to-y1*
				      *box-top-to-y1*
				      *box-center-to-y1*
				      *box-bottom-to-y1*
				      *box-top-to-y1*
				      *box-center-to-y1*
				      *box-bottom-to-y1*))
			  (cons (list *box-left-to-x2*
				      *box-left-to-x2*
				      *box-left-to-x2*
				      *box-center-to-x2*
				      *box-center-to-x2*
				      *box-center-to-x2*
				      *box-right-to-x2*
				      *box-right-to-x2*
				      *box-right-to-x2*)
				(list *box-top-to-y2*
				      *box-center-to-y2*
				      *box-bottom-to-y2*
				      *box-top-to-y2*
				      *box-center-to-y2*
				      *box-bottom-to-y2*
				      *box-top-to-y2*
				      *box-center-to-y2*
				      *box-bottom-to-y2*))))))

