


CLISP(1)                                                 CLISP(1)


NNAAMMEE
       clisp - Common Lisp language interpreter and compiler

SSYYNNOOPPSSIISS
       cclliisspp  [  --hh  |  ----hheellpp ] [ ----vveerrssiioonn ] [ ----lliicceennssee ] [ --BB
       _l_i_s_p_l_i_b_d_i_r ] [ --KK _l_i_n_k_i_n_g_-_s_e_t ] [ --MM _m_e_m_f_i_l_e ] [  --mm  _m_e_m_-
       _s_i_z_e  ] [ --LL _l_a_n_g_u_a_g_e ] [ --NN _l_o_c_a_l_e_d_i_r ] [ --EE_d_o_m_a_i_n _e_n_c_o_d_-
       _i_n_g ] [ --qq | ----qquuiieett | ----ssiilleenntt ] [ --ww ] [ --II ] [ --aa  ]  [
       --pp  _p_a_c_k_a_g_e_n_a_m_e  ] [ --CC ] [ --nnoorrcc ] [ --ii _i_n_i_t_f_i_l_e ...  ] [
       --cc [ --ll ] _l_i_s_p_f_i_l_e [ --oo _o_u_t_p_u_t_f_i_l_e ] ...  ] [  --xx  _e_x_p_r_e_s_-
       _s_i_o_n ] [ _l_i_s_p_f_i_l_e [ _a_r_g_u_m_e_n_t ] ]

DDEESSCCRRIIPPTTIIOONN
       Invokes the common lisp interpreter and compiler.  Invoked
       without arguments, executes  a  read-eval-print  loop,  in
       which  expressions  are  in turn read from standard input,
       evaluated by the lisp interpreter, and their results  out-
       put  to  standard  output.  Invoked with --cc, the specified
       lisp files are compiled to a bytecode that can be executed
       more efficiently.

OOPPTTIIOONNSS
       --hh, ----hheellpp
              Displays a help message on how to use cclliisspp.

       ----vveerrssiioonn
              Displays  the cclliisspp version number, as given by the
              function call _(_l_i_s_p_-_i_m_p_l_e_m_e_n_t_a_t_i_o_n_-_v_e_r_s_i_o_n_).

       ----lliicceennssee
              Displays a summary of  the  licensing  information,
              the GNU GPL.

       --BB _l_i_s_p_l_i_b_d_i_r
              Specifies  the  installation directory. This is the
              directory containing the  linking  sets  and  other
              data files.  This option is normally not necessary,
              because  the  installation  directory  is   already
              built-in in the cclliisspp executable.

       --KK _l_i_n_k_i_n_g_-_s_e_t
              Specifies  the  linking  set  to  be run. This is a
              directory containing at least a main executable and
              an  initial memory image. Possible values are bbaassee,
              ffuullll.  The default is bbaassee.

       --MM _m_e_m_f_i_l_e
              Specifies the initial memory image.  This must be a
              memory  dump  produced by the _s_a_v_e_i_n_i_t_m_e_m function.
              It may have been compressed using GNU gzip.

       --mm _m_e_m_s_i_z_e
              Sets the amount of memory cclliisspp tries  to  grab  on
              startup.   The  amount  may  be  given  as  _n_n_n_n_n_n_n



                         15 January 2000                        1





CLISP(1)                                                 CLISP(1)


              (measured in bytes), _n_n_n_nKK or _n_n_n_nKKBB  (measured  in
              kilobytes)  or  _nMM  or _nMMBB (measured in megabytes).
              Default is  4  megabytes.   The  argument  is  con-
              strained  above  100  KB.  -- This version of cclliisspp
              allocates memory dynamically.   _m_e_m_s_i_z_e  is  essen-
              tially ignored.

       --LL _l_a_n_g_u_a_g_e
              Specifies  the  language  cclliisspp uses to communicate
              with the user. This may be eenngglliisshh, ddeeuuttsscchh,  ffrraann--
              ccaaiiss,  eessppaannooll.   Other  languages may be specified
              through the environment variable LLAANNGG, provided the
              corresponding message catalog is installed.

       --NN _l_o_c_a_l_e_d_i_r
              Specifies  the  base  directory  of  locale  files.
              cclliisspp  will  search   its   message   catalogs   in
              _l_o_c_a_l_e_d_i_r/_l_a_n_g_u_a_g_e/LC_MESSAGES/clisp.mo.

       --EE_d_o_m_a_i_n _e_n_c_o_d_i_n_g
              Specifies  the  encoding  used  for a given domain,
              overriding the default which depends on  the  envi-
              ronment  variables  LLCC__AALLLL, LLCC__CCTTYYPPEE, LLAANNGG.  _d_o_m_a_i_n
              can be ffiillee, affecting **ddeeffaauulltt--ffiillee--eennccooddiinngg**,  or
              ppaatthhnnaammee,  affecting **ppaatthhnnaammee--eennccooddiinngg**, or tteerrmmii--
              nnaall,  affecting  **tteerrmmiinnaall--eennccooddiinngg**,  or  ffoorreeiiggnn,
              affecting  **ffoorreeiiggnn--eennccooddiinngg**,  or  mmiisscc, affecting
              **mmiisscc--eennccooddiinngg**.

       --qq, ----qquuiieett, ----ssiilleenntt
              Quiet: cclliisspp displays no banner at startup  and  no
              good-bye message when quitting.

       --ww     Wait for keypress after program termination.

       --II     Be  ILISP  friendly.  ILISP is an alternative Emacs
              interface to Common Lisp systems. With this option,
              cclliisspp  interacts in a way that ILISP can deal with.
              Currently the only effect of this is that  unneces-
              sary  prompts are not suppressed.  Furthermore, the
              GNU readline library treats Tab as a  normal  self-
              inserting character.

       --aa     ANSI CL compliant: Comply with the ANSI CL specifi-
              cation even on those issues where ANSI CL  is  bro-
              ken.  This option is provided for maximum portabil-
              ity of Lisp programs, and is not useful for  actual
              everyday  work.  It  sets the variable _*_p_a_c_k_a_g_e_* to
              CCOOMMMMOONN--LLIISSPP--UUSSEERR, and the symbol macro _*_a_n_s_i_* to tt.
              See impnotes.html, section "Maximum ANSI CL compli-
              ance", for details.

       --pp _p_a_c_k_a_g_e_n_a_m_e
              At startup the value of the variable _*_p_a_c_k_a_g_e_* will



                         15 January 2000                        2





CLISP(1)                                                 CLISP(1)


              be  set  to  the  package  named  _p_a_c_k_a_g_e_n_a_m_e.  The
              default is the package which was  active  when  the
              image was saved, normally UUSSEERR, or CCOOMMMMOONN--LLIISSPP--UUSSEERR
              if the option --aa was specified.

       --CC     Compile when load: At  startup  the  value  of  the
              variable  _*_l_o_a_d_-_c_o_m_p_i_l_i_n_g_*  will be set to tt.  Code
              being _l_o_a_ded will then be compiled on the fly. This
              results in slower loading, but faster execution.

       --nnoorrcc  Normally  cclliisspp  loads a user run control (RC) file
              on startup (this happens after  the  --CC  option  is
              processed).       The      file      loaded      is
              $${{HHOOMMEE}}//..cclliisspprrcc..llsspp    or    $${{HHOOMMEE}}//..cclliisspprrcc..ffaass,
              whichever  is  newest. This option, --nnoorrcc,, prevents
              loading of the RC file.

       --ii _i_n_i_t_f_i_l_e _._._.
              Specifies initialization  files  to  be  _l_o_a_ded  at
              startup. These should be lisp files (source or com-
              piled). Several --ii options can be  given;  all  the
              specified files will be loaded in order.

       --cc _l_i_s_p_f_i_l_e _._._.
              Compiles   the   specified  _l_i_s_p_f_i_l_es  to  bytecode
              (*.fas). The compiled  files  can  then  be  _l_o_a_ded
              instead of the sources to gain efficiency.

       --oo _o_u_t_p_u_t_f_i_l_e
              Specifies the output file or directory for the com-
              pilation of the last specified _l_i_s_p_f_i_l_e.

       --ll     A bytecode listing (*.lis) of the files being  com-
              piled  will be produced.  Useful only for debugging
              purposes. See the documentation of _c_o_m_p_i_l_e_-_f_i_l_e for
              details.

       --xx _e_x_p_r_e_s_s_i_o_n_s
              Executes  a series of arbitrary expressions instead
              of a  read-eval-print  loop.   The  values  of  the
              expressions will be output to standard output.  Due
              to the argument processing done by the  shell,  the
              _e_x_p_r_e_s_s_i_o_n_s  must be enclosed in double quotes, and
              double quotes and backslashes must be  preceded  by
              backslashes.

       _l_i_s_p_f_i_l_e [_a_r_g_u_m_e_n_t _._._.]
              Loads  and  executes  a _l_i_s_p_f_i_l_e.  There will be no
              read-eval-print loop. Before  _l_i_s_p_f_i_l_e  is  loaded,
              the  variable  _*_a_r_g_s_*  will  be  bound to a list of
              strings, representing  the  _a_r_g_u_m_e_n_ts.   The  first
              line of _l_i_s_p_f_i_l_e may start with ##!!, thus permitting
              cclliisspp to be used as a script interpreter.  If _l_i_s_p_-
              _f_i_l_e  is --, the standard input is used instead of a



                         15 January 2000                        3





CLISP(1)                                                 CLISP(1)


              file.  This option must be the last one. No RC file
              will be executed.


RREEFFEERREENNCCEE
       The language implemented mostly conforms to
              ANSI Common Lisp standard X3.226-1994
              http://www.x3.org/tc_home/j13sd4.htm
       available online as the
              Common Lisp HyperSpec
              http://www.harlequin.com/education/books/HyperSpec/
              ("CLHS" for short)
       which supersedes the earlier specifications
              Guy L. Steele Jr.: Common Lisp - The Language.
              Digital Press. 2nd edition 1990, 1032 pages.
              http://www.cs.cmu.edu/afs/cs.cmu.edu/project/ai-
        repository/ai/html/cltl/cltl2.html
              ("CLtL2" for short)
       and
              Guy L. Steele Jr.: Common Lisp - The Language.
              Digital Press. 1st edition 1984, 465 pages.
              ("CLtL1" for short)

UUSSEE
       hheellpp   to get some on-line help.

       ((aapprrooppooss _n_a_m_e))
              lists the symbols relating to _n_a_m_e.

       ((eexxiitt)) or ((qquuiitt)) or ((bbyyee))
              to quit cclliisspp.

       EOF (Ctrl-D)
              to leave the current read-eval-print loop.

       arrow keys
              for editing and viewing the input history.

       Tab key
              to  complete the symbol's name you are just typing.

FFIILLEESS
       _c_l_i_s_p  startup script

       _l_i_s_p_._r_u_n
              main executable

       _l_i_s_p_i_n_i_t_._m_e_m
              initial memory image

       _c_o_n_f_i_g_._l_s_p
              site-dependent configuration

       _*_._l_s_p  lisp source



                         15 January 2000                        4





CLISP(1)                                                 CLISP(1)


       _*_._f_a_s  lisp code, compiled by cclliisspp

       _*_._l_i_b  lisp source library information, generated and used
              by the cclliisspp compiler

       _*_._c    C code, compiled from lisp source by cclliisspp

EENNVVIIRROONNMMEENNTT
       CCLLIISSPP__LLAANNGGUUAAGGEE
              specifies  the  language  cclliisspp uses to communicate
              with the user. The value may be  eenngglliisshh,  ddeeuuttsscchh,
              ffrraannccaaiiss  and  defaults  to eenngglliisshh.  The --LL option
              can be used to override this environment  variable.

       LLCC__CCTTYYPPEE
              specifies the locale which determines the character
              set in use.  The value can be of the form  _l_a_n_g_u_a_g_e
              or  _l_a_n_g_u_a_g_e___c_o_u_n_t_r_y  or  _l_a_n_g_u_a_g_e___c_o_u_n_t_r_y_._c_h_a_r_s_e_t,
              where _l_a_n_g_u_a_g_e is a  two-letter  ISO  639  language
              code  (lower case), and _c_o_u_n_t_r_y is a two-letter ISO
              3166 country code  (upper  case).   _c_h_a_r_s_e_t  is  an
              optional  character  set  specification,  and needs
              normally not be given because the character set can
              be inferred from the language and country.

       LLAANNGG   specifies  the  language  cclliisspp uses to communicate
              with the  user,  unless  it  is  already  specified
              through  the environment variable CCLLIISSPP__LLAANNGGUUAAGGEE or
              the --LL option.  It also specifies the locale deter-
              mining  the  character  set  in use, unless already
              specified   through   the   environment    variable
              LLCC__CCTTYYPPEE.   The  value  may begin with a two-letter
              ISO 639 language code, for example eenn, ddee, ffrr.

       HHOOMMEE and UUSSEERR
              are used for determining the value of the  function
              _u_s_e_r_-_h_o_m_e_d_i_r_-_p_a_t_h_n_a_m_e.  (Unix implementation only.)

       SSHHEELLLL (Unix implementation only)
              is used to find the interactive command interpreter
              called by _(_s_h_e_l_l_).

       TTEERRMM   determines the screen size recognized by the pretty
              printer.  This environment variable is also  manda-
              tory for the built-in screen editor.

SSEEEE AALLSSOO
       impnotes.html, _c_m_u_c_l(1), _x_e_m_a_c_s(1).

BBUUGGSS
       The function _i_n_s_p_e_c_t is not implemented.

       Not all extensions from CLtL2 are supported.




                         15 January 2000                        5





CLISP(1)                                                 CLISP(1)


       No  on-line  documentation  beyond _a_p_r_o_p_o_s and _d_e_s_c_r_i_b_e is
       available.

PPRROOJJEECCTTSS
       Writing on-line documentation.

       Write _i_n_s_p_e_c_t.

       Enhance the compiler such that it can inline  local  func-
       tions.

       Specify  a portable set of window and graphics operations.

AAUUTTHHOORRSS
       Bruno Haible <haible@clisp.cons.org> and Michael Stoll.










































                         15 January 2000                        6


