/* Rao, C.R. and Toutenberg, H. 1995
 * Linear Models: Least Squares and Alternatives
 * Springer-Verlag: New York. 352 pp.
 * Example pp. 50 - 60.
 */
#include <dap.h>

void main()
{
  infile("lm50.dat", " ")
    {
      double y, x[4];
      input("y x");
      outset("lm50", "");
      skip(1);
      while (step())
        output();
    }

  corr("lm50", "x[0] x[1] x[2] x[3] y", "");

  sort("lm50.cor", "_type_ _var1_ _var2_", "");
  title("Correlations");
  table("lm50.cor.srt", "_var1_", "_var2_ _corr_", "6.3", "_type_");

  title("Model building");
  linreg("lm50", "y", "", "x[3]", "", NULL, 0.95);
  linreg("lm50", "y", "x[3]", "x[0]", "", NULL, 0.95);
  linreg("lm50", "y", "x[3] x[0]", "x[2]", "", NULL, 0.95);
  linreg("lm50", "y", "x[0] x[3] x[2]", "x[1]", "", NULL, 0.95);
}
