/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc.strategy;

import com.sun.electric.tool.ncc.NccGlobals;
import com.sun.electric.tool.ncc.NccOptions;
import com.sun.electric.tool.ncc.jemNets.Part;
import com.sun.electric.tool.ncc.jemNets.Transistor;
import com.sun.electric.tool.ncc.lists.LeafList;
import com.sun.electric.tool.ncc.strategy.Strategy;
import com.sun.electric.tool.ncc.trees.EquivRecord;
import com.sun.electric.tool.ncc.trees.NetObject;

public class StratCheckSizes
extends Strategy {
    private final double absTol;
    private final double relTol;
    private double minWidth;
    private double maxWidth;
    private double minLength;
    private double maxLength;
    private Transistor minWidMos;
    private Transistor maxWidMos;
    private Transistor minLenMos;
    private Transistor maxLenMos;
    private boolean matches = true;

    private StratCheckSizes(NccGlobals globals) {
        super(globals);
        NccOptions options = globals.getOptions();
        this.absTol = options.absoluteSizeTolerance;
        this.relTol = options.relativeSizeTolerance / 100.0;
    }

    private void checkWidthMismatch() {
        double relWidErr = (this.maxWidth - this.minWidth) / this.minWidth;
        double absWidErr = this.maxWidth - this.minWidth;
        if (absWidErr > this.absTol && relWidErr > this.relTol) {
            System.out.println("MOS widths don't match.  relativeError=" + relWidErr + " absoluteError=" + absWidErr);
            System.out.println("   minimumWidth=" + this.minWidth + " maximumWidth=" + this.maxWidth);
            System.out.println("   narrowMOS=" + this.minWidMos.toString());
            System.out.println("   wideMOS=" + this.maxWidMos.toString());
            this.matches = false;
        }
    }

    private void checkLengthMismatch() {
        double relLenErr = (this.maxLength - this.minLength) / this.minLength;
        double absLenErr = this.maxLength - this.minLength;
        if (absLenErr > this.absTol && relLenErr > this.relTol) {
            System.out.println("MOS lengths don't match.  relativeError=" + relLenErr + " absoluteError=" + absLenErr);
            System.out.println("   minimumLength=" + this.minLength + " maximumLength=" + this.maxLength);
            System.out.println("   shortMOS=" + this.minLenMos.toString());
            System.out.println("   longMOS=" + this.maxLenMos.toString());
            this.matches = false;
        }
    }

    public LeafList doFor(EquivRecord j) {
        if (j.isLeaf()) {
            if (j.isRetired()) {
                this.minLength = Double.MAX_VALUE;
                this.minWidth = Double.MAX_VALUE;
                this.maxLength = Double.MIN_VALUE;
                this.maxWidth = Double.MIN_VALUE;
                super.doFor(j);
                this.checkWidthMismatch();
                this.checkLengthMismatch();
            }
        } else {
            super.doFor(j);
        }
        return new LeafList();
    }

    public Integer doFor(NetObject n) {
        double l;
        Part p = (Part)n;
        this.globals.error(!(p instanceof Transistor), "unimplemented part type");
        Transistor t = (Transistor)p;
        double w = t.getWidth();
        if (w < this.minWidth) {
            this.minWidth = w;
            this.minWidMos = t;
        }
        if (w > this.maxWidth) {
            this.maxWidth = w;
            this.maxWidMos = t;
        }
        if ((l = t.getLength()) < this.minLength) {
            this.minLength = l;
            this.minLenMos = t;
        }
        if (l > this.maxLength) {
            this.maxLength = l;
            this.maxLenMos = t;
        }
        return CODE_NO_CHANGE;
    }

    private boolean matches() {
        return this.matches;
    }

    public static boolean doYourJob(NccGlobals globals) {
        NccOptions options = globals.getOptions();
        if (!options.checkSizes) {
            return true;
        }
        EquivRecord parts = globals.getParts();
        if (parts == null) {
            return true;
        }
        StratCheckSizes jsf = new StratCheckSizes(globals);
        jsf.doFor(parts);
        return jsf.matches();
    }
}

