/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs;

import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.user.User;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Iterator;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;

public class TextAttributesPanel
extends JPanel {
    private static final String displaynone = "None";
    private Variable var;
    private TextDescriptor td;
    private String futureVarName;
    private ElectricObject owner;
    private TextDescriptor.Unit initialUnit;
    private Object initialDispPos;
    private Variable.Code initialCode;
    private JComboBox code;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JComboBox show;
    private JComboBox units;

    public TextAttributesPanel() {
        this.initComponents();
        Iterator it = Variable.Code.getCodes();
        while (it.hasNext()) {
            this.code.addItem(it.next());
        }
        it = TextDescriptor.Unit.getUnits();
        while (it.hasNext()) {
            this.units.addItem((TextDescriptor.Unit)it.next());
        }
        this.populateShowComboBox(true);
        this.initialCode = Variable.Code.NONE;
        this.code.setSelectedItem(Variable.Code.NONE);
        this.initialUnit = TextDescriptor.Unit.NONE;
        this.units.setSelectedItem(this.initialUnit);
        this.initialDispPos = TextDescriptor.DispPos.NAMEVALUE;
        this.show.setSelectedItem(this.initialDispPos);
        this.setVariable(null, null, null, null);
    }

    public synchronized void setVariable(Variable var, TextDescriptor tdesc, String futureVarName, ElectricObject owner) {
        if (futureVarName != null && futureVarName.trim().equals("")) {
            futureVarName = null;
        }
        this.var = var;
        this.td = tdesc;
        this.futureVarName = futureVarName;
        this.owner = owner;
        boolean enabled = var != null || this.td != null || futureVarName != null;
        this.code.setEnabled(enabled);
        this.units.setEnabled(enabled);
        this.show.setEnabled(enabled);
        if (!enabled) {
            return;
        }
        this.td = var != null ? var.getTextDescriptor() : tdesc;
        if (this.td == null && futureVarName != null) {
            return;
        }
        this.initialCode = Variable.Code.NONE;
        if (var != null) {
            this.initialCode = var.getCode();
            this.code.setSelectedItem(this.initialCode);
        } else {
            this.code.setEnabled(false);
        }
        this.initialUnit = this.td.getUnit();
        this.units.setSelectedItem(this.td.getUnit());
        this.initialDispPos = this.td.getDispPart();
        if (var != null) {
            this.populateShowComboBox(true);
            if (!var.isDisplay()) {
                this.show.setSelectedIndex(0);
            } else {
                this.show.setSelectedItem(this.initialDispPos);
            }
        } else {
            this.populateShowComboBox(false);
            this.show.setSelectedItem(this.initialDispPos);
        }
    }

    public synchronized boolean applyChanges() {
        Object newDisp;
        TextDescriptor.Unit newUnit;
        if (this.var == null && this.td == null && this.futureVarName == null) {
            return false;
        }
        boolean changed = false;
        Variable.Code newCode = (Variable.Code)this.code.getSelectedItem();
        if (newCode != this.initialCode) {
            changed = true;
        }
        if ((newUnit = (TextDescriptor.Unit)this.units.getSelectedItem()) != this.initialUnit) {
            changed = true;
        }
        if ((newDisp = this.show.getSelectedItem()) != this.initialDispPos) {
            changed = true;
        }
        if (this.futureVarName == null && !changed) {
            return false;
        }
        ChangeText job = new ChangeText(this.owner, this.var, this.td, this.futureVarName, newCode, newUnit, newDisp);
        this.initialCode = newCode;
        this.initialUnit = newUnit;
        this.initialDispPos = newDisp;
        return true;
    }

    private void populateShowComboBox(boolean includeNoneChoice) {
        this.show.removeAllItems();
        if (includeNoneChoice) {
            this.show.addItem(displaynone);
        }
        Iterator it = TextDescriptor.DispPos.getShowStyles();
        while (it.hasNext()) {
            this.show.addItem((TextDescriptor.DispPos)it.next());
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.code = new JComboBox();
        this.jLabel2 = new JLabel();
        this.units = new JComboBox();
        this.jLabel3 = new JLabel();
        this.show = new JComboBox();
        this.jPanel2 = new JPanel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.setLayout(new GridBagLayout());
        this.setBorder(new EtchedBorder());
        this.jPanel1.setLayout(new GridBagLayout());
        this.jLabel1.setText("Code:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.jPanel1.add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.1;
        this.jPanel1.add((Component)this.code, gridBagConstraints);
        this.jLabel2.setText("Units:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.jPanel1.add((Component)this.jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.1;
        this.jPanel1.add((Component)this.units, gridBagConstraints);
        this.jLabel3.setText("Show:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.jPanel1.add((Component)this.jLabel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.1;
        this.jPanel1.add((Component)this.show, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.jLabel4.setText("Attributes created on a cell");
        this.jPanel2.add((Component)this.jLabel4, new GridBagConstraints());
        this.jLabel5.setText("are inherited by instances");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.jPanel2.add((Component)this.jLabel5, gridBagConstraints);
        this.jLabel6.setText("of that cell");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.jPanel2.add((Component)this.jLabel6, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 10, 4, 4);
        this.add((Component)this.jPanel2, gridBagConstraints);
    }

    private static class ChangeText
    extends Job {
        private ElectricObject owner;
        private Variable var;
        private TextDescriptor td;
        private String futureVarName;
        private Variable.Code code;
        private TextDescriptor.Unit unit;
        private Object dispPos;

        private ChangeText(ElectricObject owner, Variable var, TextDescriptor td, String futureVarName, Variable.Code code, TextDescriptor.Unit unit, Object dispPos) {
            super("Modify Text Attribute", User.tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.owner = owner;
            this.var = var;
            this.td = td;
            this.futureVarName = futureVarName;
            this.code = code;
            this.unit = unit;
            this.dispPos = dispPos;
            this.startJob();
        }

        public boolean doIt() {
            if (this.var == null && this.td == null) {
                this.var = this.owner.getVar(this.futureVarName);
                if (this.var == null) {
                    return false;
                }
                this.td = this.var.getTextDescriptor();
            }
            if (this.var != null) {
                this.var.setCode(this.code);
            }
            this.td.setUnit(this.unit);
            if (this.dispPos == TextAttributesPanel.displaynone) {
                this.var.setDisplay(false);
            } else {
                this.var.setDisplay(true);
                this.td.setDispPart((TextDescriptor.DispPos)this.dispPos);
            }
            return true;
        }
    }
}

