/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs.projsettings;

import com.sun.electric.technology.Foundry;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.MoCMOS;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.projsettings.ProjSettingsPanel;
import com.sun.electric.tool.user.ui.TopLevel;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class TechnologyTab
extends ProjSettingsPanel {
    private JLabel defaultTechLabel;
    private JComboBox defaultTechPulldown;
    private JLabel jLabel49;
    private JLabel jLabel59;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel mosisPanel;
    private JCheckBox techMOCMOSAlternateContactRules;
    private JRadioButton techMOCMOSDeepRules;
    private JLabel techMOCMOSDefaultFoundryLabel;
    private JComboBox techMOCMOSDefaultFoundryPulldown;
    private JCheckBox techMOCMOSDisallowStackedVias;
    private JComboBox techMOCMOSMetalLayers;
    private ButtonGroup techMOCMOSRules;
    private JRadioButton techMOCMOSSCMOSRules;
    private JCheckBox techMOCMOSSecondPoly;
    private JRadioButton techMOCMOSSubmicronRules;
    private JPanel technology;
    private JComboBox technologyPopup;
    private JLabel tsmc90FoundryLabel;
    private JComboBox tsmc90FoundryPulldown;
    private JLabel tsmc90MetalLabel;
    private JComboBox tsmc90MetalLayers;
    private JPanel tsmc90Panel;

    public TechnologyTab(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    public JPanel getPanel() {
        return this.technology;
    }

    public String getName() {
        return "Technology";
    }

    public static void setFoundrySelected(Technology tech, JComboBox pulldown) {
        String selectedFoundry = tech.getPrefFoundry();
        Foundry.Type foundry = Foundry.Type.NONE;
        Iterator<Foundry> itF = tech.getFoundries();
        while (itF.hasNext()) {
            Foundry factory = itF.next();
            Foundry.Type type = factory.getType();
            pulldown.addItem(type);
            if (!selectedFoundry.equalsIgnoreCase(factory.getType().name())) continue;
            foundry = type;
        }
        pulldown.setEnabled(foundry != Foundry.Type.NONE);
        pulldown.setSelectedItem((Object)foundry);
    }

    public void init() {
        int initialTechRules = MoCMOS.getRuleSet();
        if (initialTechRules == 0) {
            this.techMOCMOSSCMOSRules.setSelected(true);
        } else if (initialTechRules == 1) {
            this.techMOCMOSSubmicronRules.setSelected(true);
        } else {
            this.techMOCMOSDeepRules.setSelected(true);
        }
        this.techMOCMOSMetalLayers.addItem("2 Layers");
        this.techMOCMOSMetalLayers.addItem("3 Layers");
        this.techMOCMOSMetalLayers.addItem("4 Layers");
        this.techMOCMOSMetalLayers.addItem("5 Layers");
        this.techMOCMOSMetalLayers.addItem("6 Layers");
        this.techMOCMOSMetalLayers.setSelectedIndex(MoCMOS.getNumMetal() - 2);
        this.techMOCMOSSecondPoly.setSelected(MoCMOS.isSecondPolysilicon());
        this.techMOCMOSDisallowStackedVias.setSelected(MoCMOS.isDisallowStackedVias());
        this.techMOCMOSAlternateContactRules.setSelected(MoCMOS.isAlternateActivePolyRules());
        Iterator<Technology> it = Technology.getTechnologies();
        while (it.hasNext()) {
            Technology tech = it.next();
            this.defaultTechPulldown.addItem(tech.getTechName());
            if (!tech.isScaleRelevant()) continue;
            this.technologyPopup.addItem(tech.getTechName());
        }
        this.defaultTechPulldown.setSelectedItem(User.getDefaultTechnology());
        this.technologyPopup.setSelectedItem(User.getSchematicTechnology().getTechName());
        TechnologyTab.setFoundrySelected(MoCMOS.tech, this.techMOCMOSDefaultFoundryPulldown);
        this.jPanel3.remove(this.tsmc90Panel);
        try {
            Class<?> extraTechClass = Class.forName("com.sun.electric.plugins.tsmc.TSMC90Tab");
            extraTechClass.getMethod("openTechnologyTab", JPanel.class).invoke(null, this.jPanel3);
        }
        catch (Exception e) {
            System.out.println("Exceptions while importing extra technologies");
        }
    }

    public void term() {
        String defaultTech;
        String currentTechName;
        Technology currentTech;
        boolean newVal;
        boolean changeInMoCMOS = false;
        int currentNumMetals = this.techMOCMOSMetalLayers.getSelectedIndex() + 2;
        int currentRules = 0;
        if (this.techMOCMOSSubmicronRules.isSelected()) {
            currentRules = 1;
        } else if (this.techMOCMOSDeepRules.isSelected()) {
            currentRules = 2;
        }
        switch (currentNumMetals) {
            case 2: 
            case 3: 
            case 4: {
                if (currentRules != 2) break;
                JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "Cannot use Deep rules if there are less than 5 layers of metal...using SubMicron rules.");
                currentRules = 1;
                break;
            }
            case 5: 
            case 6: {
                if (currentRules != 0) break;
                JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "Cannot use SCMOS rules if there are more than 4 layers of metal...using SubMicron rules.");
                currentRules = 1;
            }
        }
        if (currentNumMetals != MoCMOS.getNumMetal()) {
            MoCMOS.setNumMetal(currentNumMetals);
            changeInMoCMOS = true;
        }
        if (currentRules != MoCMOS.getRuleSet()) {
            MoCMOS.setRuleSet(currentRules);
            changeInMoCMOS = true;
        }
        if ((newVal = this.techMOCMOSSecondPoly.isSelected()) != MoCMOS.isSecondPolysilicon()) {
            MoCMOS.setSecondPolysilicon(newVal);
            changeInMoCMOS = true;
        }
        if ((newVal = this.techMOCMOSDisallowStackedVias.isSelected()) != MoCMOS.isDisallowStackedVias()) {
            MoCMOS.setDisallowStackedVias(newVal);
            changeInMoCMOS = true;
        }
        if ((newVal = this.techMOCMOSAlternateContactRules.isSelected()) != MoCMOS.isAlternateActivePolyRules()) {
            MoCMOS.setAlternateActivePolyRules(newVal);
            changeInMoCMOS = true;
        }
        if ((currentTech = Technology.findTechnology(currentTechName = (String)this.technologyPopup.getSelectedItem())) != User.getSchematicTechnology() && currentTech != null) {
            User.setSchematicTechnology(currentTech);
        }
        if (!(defaultTech = (String)this.defaultTechPulldown.getSelectedItem()).equals(User.getDefaultTechnology())) {
            User.setDefaultTechnology(defaultTech);
        }
        if (changeInMoCMOS || TechnologyTab.checkFoundry((Foundry.Type)((Object)this.techMOCMOSDefaultFoundryPulldown.getSelectedItem()), MoCMOS.tech)) {
            Technology.TechPref.technologyChanged(MoCMOS.tech, true);
        }
        try {
            Class<?> extraTechClass = Class.forName("com.sun.electric.plugins.tsmc.TSMC90Tab");
            extraTechClass.getMethod("closeTechnologyTab", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception e) {
            System.out.println("Exceptions while importing extra technologies: " + e.getMessage());
        }
    }

    public static boolean checkFoundry(Foundry.Type foundry, Technology tech) {
        if (foundry == null) {
            return false;
        }
        boolean changed = false;
        if (!foundry.name().equalsIgnoreCase(tech.getPrefFoundry())) {
            changed = true;
            String[] messages = new String[]{tech.getTechShortName() + " primitives in database might be resized according to values provided by " + (Object)((Object)foundry) + ".", "If you do not resize now, arc widths might not be optimal for " + (Object)((Object)foundry) + ".", "If you cancel the operation, the foundry will not be changed.", "Do you want to resize the database?"};
            Object[] options = new Object[]{"Yes", "No", "Cancel"};
            int val = JOptionPane.showOptionDialog(TopLevel.getCurrentJFrame(), messages, "Resize primitive Nodes and Arcs", -1, 2, null, options, options[0]);
            if (val != 2) {
                boolean modifyNodes = val == 0;
                tech.setPrefFoundryAndResize(foundry.name(), modifyNodes);
                changed = false;
            }
        }
        return changed;
    }

    private void initComponents() {
        this.techMOCMOSRules = new ButtonGroup();
        this.technology = new JPanel();
        this.jPanel2 = new JPanel();
        this.defaultTechLabel = new JLabel();
        this.defaultTechPulldown = new JComboBox();
        this.jLabel59 = new JLabel();
        this.technologyPopup = new JComboBox();
        this.mosisPanel = new JPanel();
        this.jLabel49 = new JLabel();
        this.techMOCMOSMetalLayers = new JComboBox();
        this.techMOCMOSSCMOSRules = new JRadioButton();
        this.techMOCMOSSubmicronRules = new JRadioButton();
        this.techMOCMOSDeepRules = new JRadioButton();
        this.techMOCMOSSecondPoly = new JCheckBox();
        this.techMOCMOSDisallowStackedVias = new JCheckBox();
        this.techMOCMOSAlternateContactRules = new JCheckBox();
        this.techMOCMOSDefaultFoundryLabel = new JLabel();
        this.techMOCMOSDefaultFoundryPulldown = new JComboBox();
        this.jPanel3 = new JPanel();
        this.tsmc90Panel = new JPanel();
        this.tsmc90MetalLabel = new JLabel();
        this.tsmc90MetalLayers = new JComboBox();
        this.tsmc90FoundryLabel = new JLabel();
        this.tsmc90FoundryPulldown = new JComboBox();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Edit Options");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                TechnologyTab.this.closeDialog(evt);
            }
        });
        this.technology.setLayout(new GridBagLayout());
        this.jPanel2.setLayout(new GridBagLayout());
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Defaults"));
        this.defaultTechLabel.setText("Startup technology:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 2, 4);
        this.jPanel2.add((Component)this.defaultTechLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 2, 4);
        this.jPanel2.add((Component)this.defaultTechPulldown, gridBagConstraints);
        this.jLabel59.setText("Layout technology to use for Schematics:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.jPanel2.add((Component)this.jLabel59, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.jPanel2.add((Component)this.technologyPopup, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.technology.add((Component)this.jPanel2, gridBagConstraints);
        this.mosisPanel.setLayout(new GridBagLayout());
        this.mosisPanel.setBorder(BorderFactory.createTitledBorder("MOSIS CMOS"));
        this.jLabel49.setText("Metal layers:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.mosisPanel.add((Component)this.jLabel49, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.mosisPanel.add((Component)this.techMOCMOSMetalLayers, gridBagConstraints);
        this.techMOCMOSRules.add(this.techMOCMOSSCMOSRules);
        this.techMOCMOSSCMOSRules.setText("SCMOS rules (4 metal or less)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 1, 4);
        this.mosisPanel.add((Component)this.techMOCMOSSCMOSRules, gridBagConstraints);
        this.techMOCMOSRules.add(this.techMOCMOSSubmicronRules);
        this.techMOCMOSSubmicronRules.setText("Submicron rules");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 4, 1, 4);
        this.mosisPanel.add((Component)this.techMOCMOSSubmicronRules, gridBagConstraints);
        this.techMOCMOSRules.add(this.techMOCMOSDeepRules);
        this.techMOCMOSDeepRules.setText("Deep rules (5 metal or more)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 4, 4, 4);
        this.mosisPanel.add((Component)this.techMOCMOSDeepRules, gridBagConstraints);
        this.techMOCMOSSecondPoly.setText("Second Polysilicon Layer");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 1, 4);
        this.mosisPanel.add((Component)this.techMOCMOSSecondPoly, gridBagConstraints);
        this.techMOCMOSDisallowStackedVias.setText("Disallow stacked vias");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 4, 1, 4);
        this.mosisPanel.add((Component)this.techMOCMOSDisallowStackedVias, gridBagConstraints);
        this.techMOCMOSAlternateContactRules.setText("Alternate Active and Poly contact rules");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 4, 4, 4);
        this.mosisPanel.add((Component)this.techMOCMOSAlternateContactRules, gridBagConstraints);
        this.techMOCMOSDefaultFoundryLabel.setText("Current foundry:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 4, 4);
        this.mosisPanel.add((Component)this.techMOCMOSDefaultFoundryLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 4, 4, 4);
        this.mosisPanel.add((Component)this.techMOCMOSDefaultFoundryPulldown, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 11;
        this.technology.add((Component)this.mosisPanel, gridBagConstraints);
        this.tsmc90Panel.setLayout(new GridBagLayout());
        this.tsmc90Panel.setBorder(BorderFactory.createTitledBorder("TSMC90"));
        this.tsmc90MetalLabel.setText("Metal layers:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.tsmc90Panel.add((Component)this.tsmc90MetalLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.tsmc90Panel.add((Component)this.tsmc90MetalLayers, gridBagConstraints);
        this.tsmc90FoundryLabel.setText("Current foundry:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 4, 4);
        this.tsmc90Panel.add((Component)this.tsmc90FoundryLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 4, 4, 4);
        this.tsmc90Panel.add((Component)this.tsmc90FoundryPulldown, gridBagConstraints);
        this.jPanel3.add(this.tsmc90Panel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 11;
        this.technology.add((Component)this.jPanel3, gridBagConstraints);
        this.getContentPane().add((Component)this.technology, new GridBagConstraints());
        this.pack();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }
}

