/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.output;

import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Artwork;
import com.sun.electric.tool.io.IOTool;
import com.sun.electric.tool.io.output.Output;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class DXF
extends Output {
    public static final Variable.Key DXF_LAYER_KEY = Variable.newKey("IO_dxf_layer");
    public static final Variable.Key DXF_HEADER_TEXT_KEY = Variable.newKey("IO_dxf_header_text");
    public static final Variable.Key DXF_HEADER_ID_KEY = Variable.newKey("IO_dxf_header_ID");
    private int dxfEntityHandle;
    private Set<Cell> cellsSeen;
    private TextUtils.UnitScale dxfDispUnit;
    private String defaultDXFLayerName;
    private static String[] ignorefromheader = new String[]{"$DWGCODEPAGE", "$HANDSEED", "$SAVEIMAGES"};

    public static void writeDXFFile(Cell cell, String filePath) {
        DXF out = new DXF();
        if (out.openTextOutputStream(filePath)) {
            return;
        }
        out.writeDXF(cell);
        if (out.closeTextOutputStream()) {
            return;
        }
        System.out.println(filePath + " written");
    }

    DXF() {
    }

    private void writeDXF(Cell cell) {
        this.dxfDispUnit = TextUtils.UnitScale.findFromIndex(IOTool.getDXFScale());
        Variable varheadertext = cell.getLibrary().getVar(DXF_HEADER_TEXT_KEY);
        Variable varheaderid = cell.getLibrary().getVar(DXF_HEADER_ID_KEY);
        Layer defLay = Artwork.tech().findLayer("Graphics");
        this.defaultDXFLayerName = defLay.getDXFLayer();
        if (varheadertext != null && varheaderid != null) {
            this.printWriter.print("  0\nSECTION\n");
            this.printWriter.print("  2\nHEADER\n");
            int len = Math.min(varheadertext.getLength(), varheaderid.getLength());
            for (int i = 0; i < len; ++i) {
                String pt = (String)varheadertext.getObject(i);
                int code = (Integer)varheaderid.getObject(i);
                if (code == 9 && i <= len - 2) {
                    boolean found = false;
                    for (int j = 0; j < ignorefromheader.length; ++j) {
                        if (!pt.equals(ignorefromheader[j]) && !pt.substring(1).equals(ignorefromheader[j])) continue;
                        found = true;
                        break;
                    }
                    if (found) {
                        ++i;
                        continue;
                    }
                }
                if (pt.equals("$ACADVER") && i <= len - 2) {
                    this.printWriter.print(this.getThreeDigit(code) + "\n" + pt + "\n");
                    this.printWriter.print("  1\nAC1009\n");
                    ++i;
                    continue;
                }
                this.printWriter.print(this.getThreeDigit(code) + "\n" + pt + "\n");
            }
            this.printWriter.print("  0\nENDSEC\n");
        }
        this.dxfEntityHandle = 256;
        this.printWriter.print("  0\nSECTION\n");
        this.printWriter.print("  2\nBLOCKS\n");
        this.cellsSeen = new HashSet<Cell>();
        Iterator<NodeInst> it = cell.getNodes();
        while (it.hasNext()) {
            NodeProto np;
            NodeInst ni = it.next();
            if (!ni.isCellInstance() || this.cellsSeen.contains(np = ni.getProto())) continue;
            this.writeDXFCell((Cell)np, true);
        }
        this.printWriter.print("  0\nENDSEC\n");
        this.printWriter.print("  0\nSECTION\n");
        this.printWriter.print("  2\nENTITIES\n");
        this.writeDXFCell(cell, false);
        this.printWriter.print("  0\nENDSEC\n");
        this.printWriter.print("  0\nEOF\n");
    }

    private void writeDXFCell(Cell cell, boolean subCells) {
        NodeProto np;
        NodeInst ni;
        Iterator<NodeInst> it;
        if (subCells) {
            this.cellsSeen.add(cell);
            it = cell.getNodes();
            while (it.hasNext()) {
                ni = it.next();
                np = ni.getProto();
                if (!ni.isCellInstance() || this.cellsSeen.contains(np)) continue;
                this.writeDXFCell((Cell)np, true);
            }
            this.printWriter.print("  0\nBLOCK\n");
            this.printWriter.print("  2\n" + this.getDXFCellName(cell) + "\n");
            this.printWriter.print(" 10\n0\n");
            this.printWriter.print(" 20\n0\n");
            this.printWriter.print(" 30\n0\n");
            this.printWriter.print(" 70\n0\n");
        }
        it = cell.getNodes();
        while (it.hasNext()) {
            double yC;
            double xC;
            ni = it.next();
            np = ni.getProto();
            if (ni.isCellInstance()) {
                Cell subCell = (Cell)np;
                this.printWriter.print("  0\nINSERT\n");
                this.printWriter.print("  8\nUNKNOWN\n");
                this.printWriter.print("  5\n" + this.getThreeDigitHex(this.dxfEntityHandle++) + "\n");
                this.printWriter.print("  2\n" + this.getDXFCellName(subCell) + "\n");
                ERectangle cellBounds = subCell.getBounds();
                xC = TextUtils.convertDistance(ni.getAnchorCenterX() - cellBounds.getCenterX(), Technology.getCurrent(), this.dxfDispUnit);
                yC = TextUtils.convertDistance(ni.getAnchorCenterY() - cellBounds.getCenterY(), Technology.getCurrent(), this.dxfDispUnit);
                this.printWriter.print(" 10\n" + TextUtils.formatDouble(xC) + "\n");
                this.printWriter.print(" 20\n" + TextUtils.formatDouble(yC) + "\n");
                this.printWriter.print(" 30\n0\n");
                double rot = (double)ni.getAngle() / 10.0;
                this.printWriter.print(" 50\n" + TextUtils.formatDouble(rot) + "\n");
                continue;
            }
            String layerName = this.defaultDXFLayerName;
            Variable var = ni.getVar(DXF_LAYER_KEY);
            if (var != null) {
                layerName = var.getPureValue(-1);
            } else if (!ni.isCellInstance()) {
                PrimitiveNode pNp = (PrimitiveNode)ni.getProto();
                Technology.NodeLayer[] nodeLayers = pNp.getLayers();
                for (int i = 0; i < nodeLayers.length; ++i) {
                    Technology.NodeLayer nl = nodeLayers[i];
                    Layer layer = nl.getLayer();
                    String dxfLayerName = layer.getDXFLayer();
                    if (dxfLayerName == null || dxfLayerName.length() <= 0) continue;
                    layerName = dxfLayerName;
                    break;
                }
            }
            xC = ni.getAnchorCenterX();
            yC = ni.getAnchorCenterY();
            if (np == Artwork.tech().circleNode || np == Artwork.tech().thickCircleNode) {
                double[] angles = ni.getArcDegrees();
                double startOffset = angles[0];
                double endAngle = angles[1];
                if (startOffset != 0.0 || endAngle != 0.0) {
                    this.printWriter.print("  0\nARC\n");
                } else {
                    this.printWriter.print("  0\nCIRCLE\n");
                }
                this.printWriter.print("  8\n" + layerName + "\n");
                this.printWriter.print("  5\n" + this.getThreeDigitHex(this.dxfEntityHandle++) + "\n");
                xC = TextUtils.convertDistance(xC, Technology.getCurrent(), this.dxfDispUnit);
                yC = TextUtils.convertDistance(yC, Technology.getCurrent(), this.dxfDispUnit);
                double zC = TextUtils.convertDistance(ni.getYSize() / 2.0, Technology.getCurrent(), this.dxfDispUnit);
                this.printWriter.print(" 10\n" + TextUtils.formatDouble(xC) + "\n");
                this.printWriter.print(" 20\n" + TextUtils.formatDouble(yC) + "\n");
                this.printWriter.print(" 30\n0\n");
                this.printWriter.print(" 40\n" + TextUtils.formatDouble(zC) + "\n");
                if (startOffset == 0.0 && endAngle == 0.0) continue;
                startOffset = startOffset * 180.0 / Math.PI;
                endAngle = endAngle * 180.0 / Math.PI;
                double startAngle = (double)ni.getAngle() / 10.0 + startOffset;
                if (ni.isXMirrored() != ni.isYMirrored() && (startAngle = 270.0 - startAngle - endAngle) < 0.0) {
                    startAngle += 360.0;
                }
                if ((endAngle += startAngle) >= 360.0) {
                    endAngle -= 360.0;
                }
                this.printWriter.print(" 50\n" + TextUtils.formatDouble(startAngle) + "\n");
                this.printWriter.print(" 51\n" + TextUtils.formatDouble(endAngle) + "\n");
                continue;
            }
            if (np == Artwork.tech().openedPolygonNode || np == Artwork.tech().openedDashedPolygonNode || np == Artwork.tech().closedPolygonNode) {
                double y;
                AffineTransform trans = ni.rotateOut();
                Point2D[] points = ni.getTrace();
                int len = points.length;
                if (len == 2 && np != Artwork.tech().closedPolygonNode) {
                    this.printWriter.print("  0\nLINE\n");
                    this.printWriter.print("  8\n" + layerName + "\n");
                    this.printWriter.print("  5\n" + this.getThreeDigitHex(this.dxfEntityHandle++) + "\n");
                    Point2D.Double pt = new Point2D.Double(points[0].getX() + xC, points[0].getY() + yC);
                    trans.transform(pt, pt);
                    double x = TextUtils.convertDistance(((Point2D)pt).getX(), Technology.getCurrent(), this.dxfDispUnit);
                    y = TextUtils.convertDistance(((Point2D)pt).getY(), Technology.getCurrent(), this.dxfDispUnit);
                    this.printWriter.print(" 10\n" + TextUtils.formatDouble(x) + "\n");
                    this.printWriter.print(" 20\n" + TextUtils.formatDouble(y) + "\n");
                    this.printWriter.print(" 30\n0\n");
                    pt = new Point2D.Double(points[1].getX() + xC, points[1].getY() + yC);
                    trans.transform(pt, pt);
                    x = TextUtils.convertDistance(((Point2D)pt).getX(), Technology.getCurrent(), this.dxfDispUnit);
                    y = TextUtils.convertDistance(((Point2D)pt).getY(), Technology.getCurrent(), this.dxfDispUnit);
                    this.printWriter.print(" 11\n" + TextUtils.formatDouble(x) + "\n");
                    this.printWriter.print(" 21\n" + TextUtils.formatDouble(y) + "\n");
                    this.printWriter.print(" 31\n0\n");
                    continue;
                }
                for (int i = 0; i < len - 1; ++i) {
                    if (points[i] == null || points[i + 1] == null) continue;
                    this.printWriter.print("  0\nLINE\n");
                    this.printWriter.print("  8\n" + layerName + "\n");
                    this.printWriter.print("  5\n" + this.getThreeDigitHex(this.dxfEntityHandle++) + "\n");
                    Point2D.Double pt = new Point2D.Double(points[i].getX() + xC, points[i].getY() + yC);
                    trans.transform(pt, pt);
                    double x = TextUtils.convertDistance(((Point2D)pt).getX(), Technology.getCurrent(), this.dxfDispUnit);
                    double y2 = TextUtils.convertDistance(((Point2D)pt).getY(), Technology.getCurrent(), this.dxfDispUnit);
                    this.printWriter.print(" 10\n" + TextUtils.formatDouble(x) + "\n");
                    this.printWriter.print(" 20\n" + TextUtils.formatDouble(y2) + "\n");
                    this.printWriter.print(" 30\n0\n");
                    pt = new Point2D.Double(points[i + 1].getX() + xC, points[i + 1].getY() + yC);
                    trans.transform(pt, pt);
                    x = TextUtils.convertDistance(((Point2D)pt).getX(), Technology.getCurrent(), this.dxfDispUnit);
                    y2 = TextUtils.convertDistance(((Point2D)pt).getY(), Technology.getCurrent(), this.dxfDispUnit);
                    this.printWriter.print(" 11\n" + TextUtils.formatDouble(x) + "\n");
                    this.printWriter.print(" 21\n" + TextUtils.formatDouble(y2) + "\n");
                    this.printWriter.print(" 31\n0\n");
                }
                if (np != Artwork.tech().closedPolygonNode) continue;
                this.printWriter.print("  0\nLINE\n");
                this.printWriter.print("  8\n" + layerName + "\n");
                this.printWriter.print("  5\n" + this.getThreeDigitHex(this.dxfEntityHandle++) + "\n");
                Point2D.Double pt = new Point2D.Double(points[len - 1].getX() + xC, points[len - 1].getY() + yC);
                trans.transform(pt, pt);
                double x = TextUtils.convertDistance(((Point2D)pt).getX(), Technology.getCurrent(), this.dxfDispUnit);
                y = TextUtils.convertDistance(((Point2D)pt).getY(), Technology.getCurrent(), this.dxfDispUnit);
                this.printWriter.print(" 10\n" + TextUtils.formatDouble(x) + "\n");
                this.printWriter.print(" 20\n" + TextUtils.formatDouble(y) + "\n");
                this.printWriter.print(" 30\n0\n");
                pt = new Point2D.Double(points[0].getX() + xC, points[0].getY() + yC);
                trans.transform(pt, pt);
                x = TextUtils.convertDistance(((Point2D)pt).getX(), Technology.getCurrent(), this.dxfDispUnit);
                y = TextUtils.convertDistance(((Point2D)pt).getY(), Technology.getCurrent(), this.dxfDispUnit);
                this.printWriter.print(" 11\n" + TextUtils.formatDouble(x) + "\n");
                this.printWriter.print(" 21\n" + TextUtils.formatDouble(y) + "\n");
                this.printWriter.print(" 31\n0\n");
                continue;
            }
            Poly[] polys = ni.getProto().getTechnology().getShapeOfNode(ni);
            AffineTransform trans = ni.rotateOut();
            for (int i = 0; i < polys.length; ++i) {
                Poly poly = polys[i];
                poly.transform(trans);
                if (poly.getStyle() != Poly.Type.FILLED) continue;
                this.printWriter.print("  0\nSOLID\n");
                this.printWriter.print("  8\n" + layerName + "\n");
                Point2D[] points = poly.getPoints();
                for (int j = 0; j < points.length; ++j) {
                    this.printWriter.print(" 1" + j + "\n" + TextUtils.formatDouble(points[j].getX()) + "\n");
                    this.printWriter.print(" 2" + j + "\n" + TextUtils.formatDouble(points[j].getY()) + "\n");
                    this.printWriter.print(" 3" + j + "\n0\n");
                }
            }
        }
        if (subCells) {
            this.printWriter.print("  0\nENDBLK\n");
        }
    }

    private String getDXFCellName(Cell cell) {
        if (cell.getName().equalsIgnoreCase(cell.getLibrary().getName())) {
            String buf = null;
            for (int i = 1; i < 1000; ++i) {
                buf = cell.getName() + i;
                boolean found = false;
                Iterator<Cell> it = cell.getLibrary().getCells();
                while (it.hasNext()) {
                    Cell oCell = it.next();
                    if (!oCell.getName().equalsIgnoreCase(buf)) continue;
                    found = true;
                    break;
                }
                if (!found) break;
            }
            return buf;
        }
        return cell.getName();
    }

    private String getThreeDigit(int value) {
        String result = Integer.toString(value);
        while (result.length() < 3) {
            result = " " + result;
        }
        return result;
    }

    private String getThreeDigitHex(int value) {
        String result = Integer.toHexString(value).toUpperCase();
        while (result.length() < 3) {
            result = " " + result;
        }
        return result;
    }
}

