/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc.processing;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.tool.ncc.NccGlobals;
import com.sun.electric.tool.ncc.basic.NccCellAnnotations;
import com.sun.electric.tool.ncc.netlist.NetObject;
import com.sun.electric.tool.ncc.netlist.Part;
import com.sun.electric.tool.ncc.netlist.Wire;
import com.sun.electric.tool.ncc.strategy.Strategy;
import com.sun.electric.tool.ncc.trees.Circuit;
import com.sun.electric.tool.ncc.trees.EquivRecord;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForceMatch {
    private NccGlobals globals;

    private void getNamesOfPartsAndWiresToForceMatch(List<String> partNames, List<String> wireNames) {
        HashSet<String> forcePartNames = new HashSet<String>();
        HashSet<String> forceWireNames = new HashSet<String>();
        Cell[] cells = this.globals.getRootCells();
        for (int i = 0; i < cells.length; ++i) {
            Cell c = cells[i];
            NccCellAnnotations ann = NccCellAnnotations.getAnnotations(c);
            if (ann == null) continue;
            forcePartNames.addAll(ann.getForcePartMatches());
            forceWireNames.addAll(ann.getForceWireMatches());
        }
        partNames.addAll(forcePartNames);
        wireNames.addAll(forceWireNames);
    }

    private boolean nameMatches(String name, NetObject nObj) {
        if (nObj instanceof Wire) {
            return ((Wire)nObj).getNameProxy().getNet().hasName(name);
        }
        this.globals.error(!(nObj instanceof Part), "not Part or Wire");
        return ((Part)nObj).getNameProxy().leafName().equals(name);
    }

    private int indexOfMatchingName(List<String> forceNames, NetObject nObj) {
        for (int i = 0; i < forceNames.size(); ++i) {
            if (!this.nameMatches(forceNames.get(i), nObj)) continue;
            return i;
        }
        return -1;
    }

    private Map<NetObject, Integer> buildForceNetObjMap(List<String> forceNames, NetObject[][] forceNetObjs, String netObjType) {
        HashMap<NetObject, Integer> netObjToNdx = new HashMap<NetObject, Integer>();
        for (int nameNdx = 0; nameNdx < forceNames.size(); ++nameNdx) {
            int desNdx;
            String forceName = forceNames.get(nameNdx);
            boolean haveNetObjForEachRootCell = true;
            Cell[] rootCells = this.globals.getRootCells();
            for (desNdx = 0; desNdx < forceNetObjs.length; ++desNdx) {
                if (forceNetObjs[desNdx][nameNdx] != null) continue;
                this.globals.prln("  forceMatch: Can't find " + netObjType + " named: " + forceName + " in Cell: " + rootCells[desNdx].describe(false));
                haveNetObjForEachRootCell = false;
            }
            if (!haveNetObjForEachRootCell) continue;
            this.globals.pr("  Forcing match of " + netObjType + " named: " + forceName + " in Cells: ");
            for (desNdx = 0; desNdx < rootCells.length; ++desNdx) {
                this.globals.pr(rootCells[desNdx].describe(false) + " ");
            }
            this.globals.prln("");
            for (desNdx = 0; desNdx < forceNetObjs.length; ++desNdx) {
                netObjToNdx.put(forceNetObjs[desNdx][nameNdx], nameNdx);
            }
        }
        return netObjToNdx;
    }

    private Cell getParentCell(NetObject nObj) {
        if (nObj instanceof Wire) {
            return ((Wire)nObj).getNameProxy().leafCell();
        }
        this.globals.error(!(nObj instanceof Part), "not a Part or a Wire?");
        return ((Part)nObj).getNameProxy().leafCell();
    }

    private NetObject[][] findNetObjsToForceMatch(EquivRecord equivRec, List<String> forceNames) {
        NetObject[][] forceNetObjs = new NetObject[this.globals.getRootCells().length][];
        Cell[] rootCells = this.globals.getRootCells();
        int cktNdx = 0;
        Iterator<Circuit> cit = equivRec.getCircuits();
        while (cit.hasNext()) {
            Circuit ckt = cit.next();
            Cell rootCell = rootCells[cktNdx];
            forceNetObjs[cktNdx] = new NetObject[forceNames.size()];
            Iterator<NetObject> nit = ckt.getNetObjs();
            while (nit.hasNext()) {
                int ndx;
                NetObject nObj = nit.next();
                if (this.getParentCell(nObj) != rootCell || (ndx = this.indexOfMatchingName(forceNames, nObj)) == -1) continue;
                forceNetObjs[cktNdx][ndx] = nObj;
            }
            ++cktNdx;
        }
        return forceNetObjs;
    }

    private void forceWireMatches(Set<Part> forcedMatchParts, Set<Wire> forcedMatchWires) {
        ArrayList<String> forcePartNames = new ArrayList<String>();
        ArrayList<String> forceWireNames = new ArrayList<String>();
        this.getNamesOfPartsAndWiresToForceMatch(forcePartNames, forceWireNames);
        if (this.globals.getWires() != null) {
            NetObject[][] forceWires = this.findNetObjsToForceMatch(this.globals.getWires(), forceWireNames);
            Map<NetObject, Integer> wireToIndex = this.buildForceNetObjMap(forceWireNames, forceWires, "Wire");
            new PartitionEquivRecord(this.globals.getWires(), wireToIndex, this.globals);
            for (NetObject nObj : wireToIndex.keySet()) {
                forcedMatchWires.add((Wire)nObj);
            }
        }
        if (this.globals.getParts() != null) {
            NetObject[][] forceParts = this.findNetObjsToForceMatch(this.globals.getParts(), forcePartNames);
            Map<NetObject, Integer> partToIndex = this.buildForceNetObjMap(forcePartNames, forceParts, "Part");
            new PartitionEquivRecord(this.globals.getParts(), partToIndex, this.globals);
            for (NetObject nObj : partToIndex.keySet()) {
                forcedMatchParts.add((Part)nObj);
            }
        }
    }

    private ForceMatch(Set<Part> forcedMatchParts, Set<Wire> forcedMatchWires, NccGlobals g) {
        this.globals = g;
        this.forceWireMatches(forcedMatchParts, forcedMatchWires);
    }

    public static void doYourJob(Set<Part> forcedMatchParts, Set<Wire> forcedMatchWires, NccGlobals g) {
        new ForceMatch(forcedMatchParts, forcedMatchWires, g);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PartitionEquivRecord
    extends Strategy {
        private Map<NetObject, Integer> netObjToIndex;

        @Override
        public Integer doFor(NetObject n) {
            Integer index2 = this.netObjToIndex.get(n);
            return index2 == null ? 0 : 1000 + index2;
        }

        public PartitionEquivRecord(EquivRecord er, Map<NetObject, Integer> netObjToIndex, NccGlobals globals) {
            super(globals);
            this.netObjToIndex = netObjToIndex;
            this.doFor(er);
        }
    }
}

