/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool;

import com.sun.electric.database.EObjectInputStream;
import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.Snapshot;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.id.IdManager;
import com.sun.electric.database.id.IdWriter;
import com.sun.electric.tool.Client;
import com.sun.electric.tool.EJob;
import com.sun.electric.tool.Job;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class StreamClient
extends Client {
    private final IdWriter writer;
    private Snapshot currentSnapshot = EDatabase.serverDatabase().getInitialSnapshot();
    private final ServerEventDispatcher dispatcher;
    private final ClientReader reader;
    private static final long STACK_SIZE_EVENT = 0L;
    private static final int STACK_SIZE_READER = 0;

    StreamClient(int connectionId, InputStream inputStream, OutputStream outputStream) {
        super(connectionId);
        this.writer = new IdWriter(IdManager.stdIdManager, new DataOutputStream(outputStream));
        this.dispatcher = new ServerEventDispatcher();
        this.reader = inputStream != null ? new ClientReader(inputStream) : null;
    }

    void start() {
        this.dispatcher.start();
    }

    private void writeSnapshot(Client.ServerEvent event) throws IOException {
        this.writer.writeByte((byte)1);
        this.writer.writeLong(event.getTimeStamp());
        Snapshot newSnapshot = event.getSnapshot();
        newSnapshot.writeDiffs(this.writer, this.currentSnapshot);
        this.currentSnapshot = newSnapshot;
    }

    private class ClientReader
    extends Thread {
        private final DataInputStream in;

        private ClientReader(InputStream inputStream) {
            super(null, null, "ClientReader-" + StreamClient.this.connectionId, 0L);
            this.in = new DataInputStream(new BufferedInputStream(inputStream));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                int tag;
                EditingPreferences clientEp = null;
                block10: while ((tag = this.in.read()) != -1) {
                    switch (tag) {
                        case 1: {
                            int jobId = this.in.readInt();
                            Job.Type jobType = Job.Type.valueOf(this.in.readUTF());
                            String jobName = this.in.readUTF();
                            int len = this.in.readInt();
                            byte[] bytes = new byte[len];
                            this.in.readFully(bytes);
                            EJob ejob = new EJob(StreamClient.this, jobId, jobType, jobName, bytes);
                            ejob.editingPreferences = clientEp;
                            Job.serverJobManager.addJob(ejob, false);
                            continue block10;
                        }
                        case 2: {
                            byte[] serializedEp = new byte[this.in.readInt()];
                            this.in.readFully(serializedEp);
                            try {
                                EDatabase database = EDatabase.serverDatabase();
                                EObjectInputStream in = new EObjectInputStream(new ByteArrayInputStream(serializedEp), database);
                                EditingPreferences ep = (EditingPreferences)in.readObject();
                                in.close();
                                clientEp = ep;
                            }
                            catch (Throwable e) {
                                e.printStackTrace();
                            }
                            continue block10;
                        }
                    }
                    assert (false);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    class ServerEventDispatcher
    extends Thread {
        private Client.ServerEvent lastEvent;

        private ServerEventDispatcher() {
            super(null, null, "Dispatcher-" + StreamClient.this.connectionId, 0L);
            this.lastEvent = Client.getQueueTail();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                if (StreamClient.this.reader != null) {
                    StreamClient.this.reader.start();
                }
                StreamClient.this.writer.writeInt(20);
                StreamClient.this.writer.writeInt(StreamClient.this.connectionId);
                StreamClient.this.writeSnapshot(this.lastEvent);
                block6: while (true) {
                    StreamClient.this.writer.flush();
                    this.lastEvent = Client.getEvent(this.lastEvent);
                    while (true) {
                        if (this.lastEvent.getSnapshot() != StreamClient.this.currentSnapshot) {
                            assert (this.lastEvent instanceof Client.EJobEvent || this.lastEvent instanceof Client.SnapshotEvent);
                            StreamClient.this.writeSnapshot(this.lastEvent);
                        }
                        this.lastEvent.write(StreamClient.this.writer);
                        if (this.lastEvent instanceof Client.ShutdownEvent) {
                            StreamClient.this.writer.close();
                            return;
                        }
                        Client.ServerEvent event = this.lastEvent.getNext();
                        if (event == null) continue block6;
                        this.lastEvent = event;
                        continue;
                        break;
                    }
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
            finally {
                this.lastEvent = null;
                Job.serverJobManager.connectionClosed();
            }
        }
    }
}

