// 2007-02-04  Edward Smith-Rowland <3dw4rd@verizon.net>
//
// Copyright (C) 2007 Free Software Foundation, Inc.
//
// This file is part of the GNU ISO C++ Library.  This library is free
// software; you can redistribute it and/or modify it under the
// terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option)
// any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License along
// with this library; see the file COPYING.  If not, write to the Free
// Software Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307,
// USA.

//  assoc_laguerre


//  Compare against values generated by the GNU Scientific Library.
//  The GSL can be found on the web: http://www.gnu.org/software/gsl/

#include <tr1/cmath>
#if defined(__TEST_DEBUG)
#include <iostream>
#define VERIFY(A) \
if (!(A)) \
  { \
    std::cout << "line " << __LINE__ \
      << "  max_abs_frac = " << max_abs_frac \
      << std::endl; \
  }
#else
#include <testsuite_hooks.h>
#endif
#include "../testcase.h"


// Test data for n=0, m=0.
testcase_assoc_laguerre<double> data001[] = {
  { 1.0000000000000000, 0, 0, 
          0.0000000000000000 },
  { 1.0000000000000000, 0, 0, 
          10.000000000000000 },
  { 1.0000000000000000, 0, 0, 
          20.000000000000000 },
  { 1.0000000000000000, 0, 0, 
          30.000000000000000 },
  { 1.0000000000000000, 0, 0, 
          40.000000000000000 },
  { 1.0000000000000000, 0, 0, 
          50.000000000000000 },
  { 1.0000000000000000, 0, 0, 
          60.000000000000000 },
  { 1.0000000000000000, 0, 0, 
          70.000000000000000 },
  { 1.0000000000000000, 0, 0, 
          80.000000000000000 },
  { 1.0000000000000000, 0, 0, 
          90.000000000000000 },
  { 1.0000000000000000, 0, 0, 
          100.00000000000000 },
};

// Test function for n=0, m=0.
template <typename Tp>
void test001()
{
  const Tp eps = std::numeric_limits<Tp>::epsilon();
  Tp max_abs_diff = -Tp(1);
  Tp max_abs_frac = -Tp(1);
  unsigned int num_datum = sizeof(data001)
                         / sizeof(testcase_assoc_laguerre<double>);
  for (unsigned int i = 0; i < num_datum; ++i)
    {
      const Tp f = std::tr1::assoc_laguerre(Tp(data001[i].n), Tp(data001[i].m),
                   Tp(data001[i].x));
      const Tp f0 = data001[i].f0;
      const Tp diff = f - f0;
      if (std::abs(diff) > max_abs_diff)
        max_abs_diff = std::abs(diff);
      if (std::abs(f0) > Tp(10) * eps
       && std::abs(f) > Tp(10) * eps)
        {
          const Tp frac = diff / f0;
          if (std::abs(frac) > max_abs_frac)
            max_abs_frac = std::abs(frac);
        }
    }
  VERIFY(max_abs_frac < Tp(2.5000000000000020e-13));
}

// Test data for n=0, m=1.
testcase_assoc_laguerre<double> data002[] = {
  { 1.0000000000000000, 0, 1, 
          0.0000000000000000 },
  { 1.0000000000000000, 0, 1, 
          10.000000000000000 },
  { 1.0000000000000000, 0, 1, 
          20.000000000000000 },
  { 1.0000000000000000, 0, 1, 
          30.000000000000000 },
  { 1.0000000000000000, 0, 1, 
          40.000000000000000 },
  { 1.0000000000000000, 0, 1, 
          50.000000000000000 },
  { 1.0000000000000000, 0, 1, 
          60.000000000000000 },
  { 1.0000000000000000, 0, 1, 
          70.000000000000000 },
  { 1.0000000000000000, 0, 1, 
          80.000000000000000 },
  { 1.0000000000000000, 0, 1, 
          90.000000000000000 },
  { 1.0000000000000000, 0, 1, 
          100.00000000000000 },
};

// Test function for n=0, m=1.
template <typename Tp>
void test002()
{
  const Tp eps = std::numeric_limits<Tp>::epsilon();
  Tp max_abs_diff = -Tp(1);
  Tp max_abs_frac = -Tp(1);
  unsigned int num_datum = sizeof(data002)
                         / sizeof(testcase_assoc_laguerre<double>);
  for (unsigned int i = 0; i < num_datum; ++i)
    {
      const Tp f = std::tr1::assoc_laguerre(Tp(data002[i].n), Tp(data002[i].m),
                   Tp(data002[i].x));
      const Tp f0 = data002[i].f0;
      const Tp diff = f - f0;
      if (std::abs(diff) > max_abs_diff)
        max_abs_diff = std::abs(diff);
      if (std::abs(f0) > Tp(10) * eps
       && std::abs(f) > Tp(10) * eps)
        {
          const Tp frac = diff / f0;
          if (std::abs(frac) > max_abs_frac)
            max_abs_frac = std::abs(frac);
        }
    }
  VERIFY(max_abs_frac < Tp(2.5000000000000020e-13));
}

// Test data for n=0, m=2.
testcase_assoc_laguerre<double> data003[] = {
  { 1.0000000000000000, 0, 2, 
          0.0000000000000000 },
  { 1.0000000000000000, 0, 2, 
          10.000000000000000 },
  { 1.0000000000000000, 0, 2, 
          20.000000000000000 },
  { 1.0000000000000000, 0, 2, 
          30.000000000000000 },
  { 1.0000000000000000, 0, 2, 
          40.000000000000000 },
  { 1.0000000000000000, 0, 2, 
          50.000000000000000 },
  { 1.0000000000000000, 0, 2, 
          60.000000000000000 },
  { 1.0000000000000000, 0, 2, 
          70.000000000000000 },
  { 1.0000000000000000, 0, 2, 
          80.000000000000000 },
  { 1.0000000000000000, 0, 2, 
          90.000000000000000 },
  { 1.0000000000000000, 0, 2, 
          100.00000000000000 },
};

// Test function for n=0, m=2.
template <typename Tp>
void test003()
{
  const Tp eps = std::numeric_limits<Tp>::epsilon();
  Tp max_abs_diff = -Tp(1);
  Tp max_abs_frac = -Tp(1);
  unsigned int num_datum = sizeof(data003)
                         / sizeof(testcase_assoc_laguerre<double>);
  for (unsigned int i = 0; i < num_datum; ++i)
    {
      const Tp f = std::tr1::assoc_laguerre(Tp(data003[i].n), Tp(data003[i].m),
                   Tp(data003[i].x));
      const Tp f0 = data003[i].f0;
      const Tp diff = f - f0;
      if (std::abs(diff) > max_abs_diff)
        max_abs_diff = std::abs(diff);
      if (std::abs(f0) > Tp(10) * eps
       && std::abs(f) > Tp(10) * eps)
        {
          const Tp frac = diff / f0;
          if (std::abs(frac) > max_abs_frac)
            max_abs_frac = std::abs(frac);
        }
    }
  VERIFY(max_abs_frac < Tp(2.5000000000000020e-13));
}

// Test data for n=0, m=5.
testcase_assoc_laguerre<double> data004[] = {
  { 1.0000000000000000, 0, 5, 
          0.0000000000000000 },
  { 1.0000000000000000, 0, 5, 
          10.000000000000000 },
  { 1.0000000000000000, 0, 5, 
          20.000000000000000 },
  { 1.0000000000000000, 0, 5, 
          30.000000000000000 },
  { 1.0000000000000000, 0, 5, 
          40.000000000000000 },
  { 1.0000000000000000, 0, 5, 
          50.000000000000000 },
  { 1.0000000000000000, 0, 5, 
          60.000000000000000 },
  { 1.0000000000000000, 0, 5, 
          70.000000000000000 },
  { 1.0000000000000000, 0, 5, 
          80.000000000000000 },
  { 1.0000000000000000, 0, 5, 
          90.000000000000000 },
  { 1.0000000000000000, 0, 5, 
          100.00000000000000 },
};

// Test function for n=0, m=5.
template <typename Tp>
void test004()
{
  const Tp eps = std::numeric_limits<Tp>::epsilon();
  Tp max_abs_diff = -Tp(1);
  Tp max_abs_frac = -Tp(1);
  unsigned int num_datum = sizeof(data004)
                         / sizeof(testcase_assoc_laguerre<double>);
  for (unsigned int i = 0; i < num_datum; ++i)
    {
      const Tp f = std::tr1::assoc_laguerre(Tp(data004[i].n), Tp(data004[i].m),
                   Tp(data004[i].x));
      const Tp f0 = data004[i].f0;
      const Tp diff = f - f0;
      if (std::abs(diff) > max_abs_diff)
        max_abs_diff = std::abs(diff);
      if (std::abs(f0) > Tp(10) * eps
       && std::abs(f) > Tp(10) * eps)
        {
          const Tp frac = diff / f0;
          if (std::abs(frac) > max_abs_frac)
            max_abs_frac = std::abs(frac);
        }
    }
  VERIFY(max_abs_frac < Tp(2.5000000000000020e-13));
}

// Test data for n=0, m=10.
testcase_assoc_laguerre<double> data005[] = {
  { 1.0000000000000000, 0, 10, 
          0.0000000000000000 },
  { 1.0000000000000000, 0, 10, 
          10.000000000000000 },
  { 1.0000000000000000, 0, 10, 
          20.000000000000000 },
  { 1.0000000000000000, 0, 10, 
          30.000000000000000 },
  { 1.0000000000000000, 0, 10, 
          40.000000000000000 },
  { 1.0000000000000000, 0, 10, 
          50.000000000000000 },
  { 1.0000000000000000, 0, 10, 
          60.000000000000000 },
  { 1.0000000000000000, 0, 10, 
          70.000000000000000 },
  { 1.0000000000000000, 0, 10, 
          80.000000000000000 },
  { 1.0000000000000000, 0, 10, 
          90.000000000000000 },
  { 1.0000000000000000, 0, 10, 
          100.00000000000000 },
};

// Test function for n=0, m=10.
template <typename Tp>
void test005()
{
  const Tp eps = std::numeric_limits<Tp>::epsilon();
  Tp max_abs_diff = -Tp(1);
  Tp max_abs_frac = -Tp(1);
  unsigned int num_datum = sizeof(data005)
                         / sizeof(testcase_assoc_laguerre<double>);
  for (unsigned int i = 0; i < num_datum; ++i)
    {
      const Tp f = std::tr1::assoc_laguerre(Tp(data005[i].n), Tp(data005[i].m),
                   Tp(data005[i].x));
      const Tp f0 = data005[i].f0;
      const Tp diff = f - f0;
      if (std::abs(diff) > max_abs_diff)
        max_abs_diff = std::abs(diff);
      if (std::abs(f0) > Tp(10) * eps
       && std::abs(f) > Tp(10) * eps)
        {
          const Tp frac = diff / f0;
          if (std::abs(frac) > max_abs_frac)
            max_abs_frac = std::abs(frac);
        }
    }
  VERIFY(max_abs_frac < Tp(2.5000000000000020e-13));
}

// Test data for n=0, m=20.
testcase_assoc_laguerre<double> data006[] = {
  { 1.0000000000000000, 0, 20, 
          0.0000000000000000 },
  { 1.0000000000000000, 0, 20, 
          10.000000000000000 },
  { 1.0000000000000000, 0, 20, 
          20.000000000000000 },
  { 1.0000000000000000, 0, 20, 
          30.000000000000000 },
  { 1.0000000000000000, 0, 20, 
          40.000000000000000 },
  { 1.0000000000000000, 0, 20, 
          50.000000000000000 },
  { 1.0000000000000000, 0, 20, 
          60.000000000000000 },
  { 1.0000000000000000, 0, 20, 
          70.000000000000000 },
  { 1.0000000000000000, 0, 20, 
          80.000000000000000 },
  { 1.0000000000000000, 0, 20, 
          90.000000000000000 },
  { 1.0000000000000000, 0, 20, 
          100.00000000000000 },
};

// Test function for n=0, m=20.
template <typename Tp>
void test006()
{
  const Tp eps = std::numeric_limits<Tp>::epsilon();
  Tp max_abs_diff = -Tp(1);
  Tp max_abs_frac = -Tp(1);
  unsigned int num_datum = sizeof(data006)
                         / sizeof(testcase_assoc_laguerre<double>);
  for (unsigned int i = 0; i < num_datum; ++i)
    {
      const Tp f = std::tr1::assoc_laguerre(Tp(data006[i].n), Tp(data006[i].m),
                   Tp(data006[i].x));
      const Tp f0 = data006[i].f0;
      const Tp diff = f - f0;
      if (std::abs(diff) > max_abs_diff)
        max_abs_diff = std::abs(diff);
      if (std::abs(f0) > Tp(10) * eps
       && std::abs(f) > Tp(10) * eps)
        {
          const Tp frac = diff / f0;
          if (std::abs(frac) > max_abs_frac)
            max_abs_frac = std::abs(frac);
        }
    }
  VERIFY(max_abs_frac < Tp(2.5000000000000020e-13));
}

// Test data for n=0, m=50.
testcase_assoc_laguerre<double> data007[] = {
  { 1.0000000000000000, 0, 50, 
          0.0000000000000000 },
  { 1.0000000000000000, 0, 50, 
          10.000000000000000 },
  { 1.0000000000000000, 0, 50, 
          20.000000000000000 },
  { 1.0000000000000000, 0, 50, 
          30.000000000000000 },
  { 1.0000000000000000, 0, 50, 
          40.000000000000000 },
  { 1.0000000000000000, 0, 50, 
          50.000000000000000 },
  { 1.0000000000000000, 0, 50, 
          60.000000000000000 },
  { 1.0000000000000000, 0, 50, 
          70.000000000000000 },
  { 1.0000000000000000, 0, 50, 
          80.000000000000000 },
  { 1.0000000000000000, 0, 50, 
          90.000000000000000 },
  { 1.0000000000000000, 0, 50, 
          100.00000000000000 },
};

// Test function for n=0, m=50.
template <typename Tp>
void test007()
{
  const Tp eps = std::numeric_limits<Tp>::epsilon();
  Tp max_abs_diff = -Tp(1);
  Tp max_abs_frac = -Tp(1);
  unsigned int num_datum = sizeof(data007)
                         / sizeof(testcase_assoc_laguerre<double>);
  for (unsigned int i = 0; i < num_datum; ++i)
    {
      const Tp f = std::tr1::assoc_laguerre(Tp(data007[i].n), Tp(data007[i].m),
                   Tp(data007[i].x));
      const Tp f0 = data007[i].f0;
      const Tp diff = f - f0;
      if (std::abs(diff) > max_abs_diff)
        max_abs_diff = std::abs(diff);
      if (std::abs(f0) > Tp(10) * eps
       && std::abs(f) > Tp(10) * eps)
        {
          const Tp frac = diff / f0;
          if (std::abs(frac) > max_abs_frac)
            max_abs_frac = std::abs(frac);
        }
    }
  VERIFY(max_abs_frac < Tp(2.5000000000000020e-13));
}

// Test data for n=0, m=100.
testcase_assoc_laguerre<double> data008[] = {
  { 1.0000000000000000, 0, 100, 
          0.0000000000000000 },
  { 1.0000000000000000, 0, 100, 
          10.000000000000000 },
  { 1.0000000000000000, 0, 100, 
          20.000000000000000 },
  { 1.0000000000000000, 0, 100, 
          30.000000000000000 },
  { 1.0000000000000000, 0, 100, 
          40.000000000000000 },
  { 1.0000000000000000, 0, 100, 
          50.000000000000000 },
  { 1.0000000000000000, 0, 100, 
          60.000000000000000 },
  { 1.0000000000000000, 0, 100, 
          70.000000000000000 },
  { 1.0000000000000000, 0, 100, 
          80.000000000000000 },
  { 1.0000000000000000, 0, 100, 
          90.000000000000000 },
  { 1.0000000000000000, 0, 100, 
          100.00000000000000 },
};

// Test function for n=0, m=100.
template <typename Tp>
void test008()
{
  const Tp eps = std::numeric_limits<Tp>::epsilon();
  Tp max_abs_diff = -Tp(1);
  Tp max_abs_frac = -Tp(1);
  unsigned int num_datum = sizeof(data008)
                         / sizeof(testcase_assoc_laguerre<double>);
  for (unsigned int i = 0; i < num_datum; ++i)
    {
      const Tp f = std::tr1::assoc_laguerre(Tp(data008[i].n), Tp(data008[i].m),
                   Tp(data008[i].x));
      const Tp f0 = data008[i].f0;
      const Tp diff = f - f0;
      if (std::abs(diff) > max_abs_diff)
        max_abs_diff = std::abs(diff);
      if (std::abs(f0) > Tp(10) * eps
       && std::abs(f) > Tp(10) * eps)
        {
          const Tp frac = diff / f0;
          if (std::abs(frac) > max_abs_frac)
            max_abs_frac = std::abs(frac);
        }
    }
  VERIFY(max_abs_frac < Tp(2.5000000000000020e-13));
}

// Test data for n=1, m=0.
testcase_assoc_laguerre<double> data009[] = {
  { 1.0000000000000000, 1, 0, 
          0.0000000000000000 },
  { -9.0000000000000000, 1, 0, 
          10.000000000000000 },
  { -19.000000000000000, 1, 0, 
          20.000000000000000 },
  { -29.000000000000000, 1, 0, 
          30.000000000000000 },
  { -39.000000000000000, 1, 0, 
          40.000000000000000 },
  { -49.000000000000000, 1, 0, 
          50.000000000000000 },
  { -59.000000000000000, 1, 0, 
          60.000000000000000 },
  { -69.000000000000000, 1, 0, 
          70.000000000000000 },
  { -79.000000000000000, 1, 0, 
          80.000000000000000 },
  { -89.000000000000000, 1, 0, 
          90.000000000000000 },
  { -99.000000000000000, 1, 0, 
          100.00000000000000 },
};

// Test function for n=1, m=0.
template <typename Tp>
void test009()
{
  const Tp eps = std::numeric_limits<Tp>::epsilon();
  Tp max_abs_diff = -Tp(1);
  Tp max_abs_frac = -Tp(1);
  unsigned int num_datum = sizeof(data009)
                         / sizeof(testcase_assoc_laguerre<double>);
  for (unsigned int i = 0; i < num_datum; ++i)
    {
      const Tp f = std::tr1::assoc_laguerre(Tp(data009[i].n), Tp(data009[i].m),
                   Tp(data009[i].x));
      const Tp f0 = data009[i].f0;
      const Tp diff = f - f0;
      if (std::abs(diff) > max_abs_diff)
        max_abs_diff = std::abs(diff);
      if (std::abs(f0) > Tp(10) * eps
       && std::abs(f) > Tp(10) * eps)
        {
          const Tp frac = diff / f0;
          if (std::abs(frac) > max_abs_frac)
            max_abs_frac = std::abs(frac);
        }
    }
  VERIFY(max_abs_frac < Tp(2.5000000000000020e-13));
}

// Test data for n=1, m=1.
testcase_assoc_laguerre<double> data010[] = {
  { 2.0000000000000000, 1, 1, 
          0.0000000000000000 },
  { -8.0000000000000000, 1, 1, 
          10.000000000000000 },
  { -18.000000000000000, 1, 1, 
          20.000000000000000 },
  { -28.000000000000000, 1, 1, 
          30.000000000000000 },
  { -38.000000000000000, 1, 1, 
          40.000000000000000 },
  { -48.000000000000000, 1, 1, 
          50.000000000000000 },
  { -58.000000000000000, 1, 1, 
          60.000000000000000 },
  { -68.000000000000000, 1, 1, 
          70.000000000000000 },
  { -78.000000000000000, 1, 1, 
          80.000000000000000 },
  { -88.000000000000000, 1, 1, 
          90.000000000000000 },
  { -98.000000000000000, 1, 1, 
          100.00000000000000 },
};

// Test function for n=1, m=1.
template <typename Tp>
void test010()
{
  const Tp eps = std::numeric_limits<Tp>::epsilon();
  Tp max_abs_diff = -Tp(1);
  Tp max_abs_frac = -Tp(1);
  unsigned int num_datum = sizeof(data010)
                         / sizeof(testcase_assoc_laguerre<double>);
  for (unsigned int i = 0; i < num_datum; ++i)
    {
      const Tp f = std::tr1::assoc_laguerre(Tp(data010[i].n), Tp(data010[i].m),
                   Tp(data010[i].x));
      const Tp f0 = data010[i].f0;
      const Tp diff = f - f0;
      if (std::abs(diff) > max_abs_diff)
        max_abs_diff = std::abs(diff);
      if (std::abs(f0) > Tp(10) * eps
       && std::abs(f) > Tp(10) * eps)
        {
          const Tp frac = diff / f0;
          if (std::abs(frac) > max_abs_frac)
            max_abs_frac = std::abs(frac);
        }
    }
  VERIFY(max_abs_frac < Tp(2.5000000000000020e-13));
}

// Test data for n=1, m=2.
testcase_assoc_laguerre<double> data011[] = {
  { 3.0000000000000000, 1, 2, 
          0.0000000000000000 },
  { -7.0000000000000000, 1, 2, 
          10.000000000000000 },
  { -17.000000000000000, 1, 2, 
          20.000000000000000 },
  { -27.000000000000000, 1, 2, 
          30.000000000000000 },
  { -37.000000000000000, 1, 2, 
          40.000000000000000 },
  { -47.000000000000000, 1, 2, 
          50.000000000000000 },
  { -57.000000000000000, 1, 2, 
          60.000000000000000 },
  { -67.000000000000000, 1, 2, 
          70.000000000000000 },
  { -77.000000000000000, 1, 2, 
          80.000000000000000 },
  { -87.000000000000000, 1, 2, 
          90.000000000000000 },
  { -97.000000000000000, 1, 2, 
          100.00000000000000 },
};

// Test function for n=1, m=2.
template <typename Tp>
void test011()
{
  const Tp eps = std::numeric_limits<Tp>::epsilon();
  Tp max_abs_diff = -Tp(1);
  Tp max_abs_frac = -Tp(1);
  unsigned int num_datum = sizeof(data011)
                         / sizeof(testcase_assoc_laguerre<double>);
  for (unsigned int i = 0; i < num_datum; ++i)
    {
      const Tp f = std::tr1::assoc_laguerre(Tp(data011[i].n), Tp(data011[i].m),
                   Tp(data011[i].x));
      const Tp f0 = data011[i].f0;
      const Tp diff = f - f0;
      if (std::abs(diff) > max_abs_diff)
        max_abs_diff = std::abs(diff);
      if (std::abs(f0) > Tp(10) * eps
       && std::abs(f) > Tp(10) * eps)
        {
          const Tp frac = diff / f0;
          if (std::abs(frac) > max_abs_frac)
            max_abs_frac = std::abs(frac);
        }
    }
  VERIFY(max_abs_frac < Tp(2.5000000000000020e-13));
}

// Test data for n=1, m=5.
testcase_assoc_laguerre<double> data012[] = {
  { 6.0000000000000000, 1, 5, 
          0.0000000000000000 },
  { -4.0000000000000000, 1, 5, 
          10.000000000000000 },
  { -14.000000000000000, 1, 5, 
          20.000000000000000 },
  { -24.000000000000000, 1, 5, 
          30.000000000000000 },
  { -34.000000000000000, 1, 5, 
          40.000000000000000 },
  { -44.000000000000000, 1, 5, 
          50.000000000000000 },
  { -54.000000000000000, 1, 5, 
          60.000000000000000 },
  { -64.000000000000000, 1, 5, 
          70.000000000000000 },
  { -74.000000000000000, 1, 5, 
          80.000000000000000 },
  { -84.000000000000000, 1, 5, 
          90.000000000000000 },
  { -94.000000000000000, 1, 5, 
          100.00000000000000 },
};

// Test function for n=1, m=5.
template <typename Tp>
void test012()
{
  const Tp eps = std::numeric_limits<Tp>::epsilon();
  Tp max_abs_diff = -Tp(1);
  Tp max_abs_frac = -Tp(1);
  unsigned int num_datum = sizeof(data012)
                         / sizeof(testcase_assoc_laguerre<double>);
  for (unsigned int i = 0; i < num_datum; ++i)
    {
      const Tp f = std::tr1::assoc_laguerre(Tp(data012[i].n), Tp(data012[i].m),
                   Tp(data012[i].x));
      const Tp f0 = data012[i].f0;
      const Tp diff = f - f0;
      if (std::abs(diff) > max_abs_diff)
        max_abs_diff = std::abs(diff);
      if (std::abs(f0) > Tp(10) * eps
       && std::abs(f) > Tp(10) * eps)
        {
          const Tp frac = diff / f0;
          if (std::abs(frac) > max_abs_frac)
            max_abs_frac = std::abs(frac);
        }
    }
  VERIFY(max_abs_frac < Tp(2.5000000000000020e-13));
}

// Test data for n=1, m=10.
testcase_assoc_laguerre<double> data013[] = {
  { 11.000000000000000, 1, 10, 
          0.0000000000000000 },
  { 1.0000000000000000, 1, 10, 
          10.000000000000000 },
  { -9.0000000000000000, 1, 10, 
          20.000000000000000 },
  { -19.000000000000000, 1, 10, 
          30.000000000000000 },
  { -29.000000000000000, 1, 10, 
          40.000000000000000 },
  { -39.000000000000000, 1, 10, 
          50.000000000000000 },
  { -49.000000000000000, 1, 10, 
          60.000000000000000 },
  { -59.000000000000000, 1, 10, 
          70.000000000000000 },
  { -69.000000000000000, 1, 10, 
          80.000000000000000 },
  { -79.000000000000000, 1, 10, 
          90.000000000000000 },
  { -89.000000000000000, 1, 10, 
          100.00000000000000 },
};

// Test function for n=1, m=10.
template <typename Tp>
void test013()
{
  const Tp eps = std::numeric_limits<Tp>::epsilon();
  Tp max_abs_diff = -Tp(1);
  Tp max_abs_frac = -Tp(1);
  unsigned int num_datum = sizeof(data013)
                         / sizeof(testcase_assoc_laguerre<double>);
  for (unsigned int i = 0; i < num_datum; ++i)
    {
      const Tp f = std::tr1::assoc_laguerre(Tp(data013[i].n), Tp(data013[i].m),
                   Tp(data013[i].x));
      const Tp f0 = data013[i].f0;
      const Tp diff = f - f0;
      if (std::abs(diff) > max_abs_diff)
        max_abs_diff = std::abs(diff);
      if (std::abs(f0) > Tp(10) * eps
       && std::abs(f) > Tp(10) * eps)
        {
          const Tp frac = diff / f0;
          if (std::abs(frac) > max_abs_frac)
            max_abs_frac = std::abs(frac);
        }
    }
  VERIFY(max_abs_frac < Tp(2.5000000000000020e-13));
}

// Test data for n=1, m=20.
testcase_assoc_laguerre<double> data014[] = {
  { 21.000000000000000, 1, 20, 
          0.0000000000000000 },
  { 11.000000000000000, 1, 20, 
          10.000000000000000 },
  { 1.0000000000000000, 1, 20, 
          20.000000000000000 },
  { -9.0000000000000000, 1, 20, 
          30.000000000000000 },
  { -19.000000000000000, 1, 20, 
          40.000000000000000 },
  { -29.000000000000000, 1, 20, 
          50.000000000000000 },
  { -39.000000000000000, 1, 20, 
          60.000000000000000 },
  { -49.000000000000000, 1, 20, 
          70.000000000000000 },
  { -59.000000000000000, 1, 20, 
          80.000000000000000 },
  { -69.000000000000000, 1, 20, 
          90.000000000000000 },
  { -79.000000000000000, 1, 20, 
          100.00000000000000 },
};

// Test function for n=1, m=20.
template <typename Tp>
void test014()
{
  const Tp eps = std::numeric_limits<Tp>::epsilon();
  Tp max_abs_diff = -Tp(1);
  Tp max_abs_frac = -Tp(1);
  unsigned int num_datum = sizeof(data014)
                         / sizeof(testcase_assoc_laguerre<double>);
  for (unsigned int i = 0; i < num_datum; ++i)
    {
      const Tp f = std::tr1::assoc_laguerre(Tp(data014[i].n), Tp(data014[i].m),
                   Tp(data014[i].x));
      const Tp f0 = data014[i].f0;
      const Tp diff = f - f0;
      if (std::abs(diff) > max_abs_diff)
        max_abs_diff = std::abs(diff);
      if (std::abs(f0) > Tp(10) * eps
       && std::abs(f) > Tp(10) * eps)
        {
          const Tp frac = diff / f0;
          if (std::abs(frac) > max_abs_frac)
            max_abs_frac = std::abs(frac);
        }
    }
  VERIFY(max_abs_frac < Tp(2.5000000000000020e-13));
}

// Test data for n=1, m=50.
testcase_assoc_laguerre<double> data015[] = {
  { 51.000000000000000, 1, 50, 
          0.0000000000000000 },
  { 41.000000000000000, 1, 50, 
          10.000000000000000 },
  { 31.000000000000000, 1, 50, 
          20.000000000000000 },
  { 21.000000000000000, 1, 50, 
          30.000000000000000 },
  { 11.000000000000000, 1, 50, 
          40.000000000000000 },
  { 1.0000000000000000, 1, 50, 
          50.000000000000000 },
  { -9.0000000000000000, 1, 50, 
          60.000000000000000 },
  { -19.000000000000000, 1, 50, 
          70.000000000000000 },
  { -29.000000000000000, 1, 50, 
          80.000000000000000 },
  { -39.000000000000000, 1, 50, 
          90.000000000000000 },
  { -49.000000000000000, 1, 50, 
          100.00000000000000 },
};

// Test function for n=1, m=50.
template <typename Tp>
void test015()
{
  const Tp eps = std::numeric_limits<Tp>::epsilon();
  Tp max_abs_diff = -Tp(1);
  Tp max_abs_frac = -Tp(1);
  unsigned int num_datum = sizeof(data015)
                         / sizeof(testcase_assoc_laguerre<double>);
  for (unsigned int i = 0; i < num_datum; ++i)
    {
      const Tp f = std::tr1::assoc_laguerre(Tp(data015[i].n), Tp(data015[i].m),
                   Tp(data015[i].x));
      const Tp f0 = data015[i].f0;
      const Tp diff = f - f0;
      if (std::abs(diff) > max_abs_diff)
        max_abs_diff = std::abs(diff);
      if (std::abs(f0) > Tp(10) * eps
       && std::abs(f) > Tp(10) * eps)
        {
          const Tp frac = diff / f0;
          if (std::abs(frac) > max_abs_frac)
            max_abs_frac = std::abs(frac);
        }
    }
  VERIFY(max_abs_frac < Tp(2.5000000000000020e-13));
}

// Test data for n=1, m=100.
testcase_assoc_laguerre<double> data016[] = {
  { 101.00000000000000, 1, 100, 
          0.0000000000000000 },
  { 91.000000000000000, 1, 100, 
          10.000000000000000 },
  { 81.000000000000000, 1, 100, 
          20.000000000000000 },
  { 71.000000000000000, 1, 100, 
          30.000000000000000 },
  { 61.000000000000000, 1, 100, 
          40.000000000000000 },
  { 51.000000000000000, 1, 100, 
          50.000000000000000 },
  { 41.000000000000000, 1, 100, 
          60.000000000000000 },
  { 31.000000000000000, 1, 100, 
          70.000000000000000 },
  { 21.000000000000000, 1, 100, 
          80.000000000000000 },
  { 11.000000000000000, 1, 100, 
          90.000000000000000 },
  { 1.0000000000000000, 1, 100, 
          100.00000000000000 },
};

// Test function for n=1, m=100.
template <typename Tp>
void test016()
{
  const Tp eps = std::numeric_limits<Tp>::epsilon();
  Tp max_abs_diff = -Tp(1);
  Tp max_abs_frac = -Tp(1);
  unsigned int num_datum = sizeof(data016)
                         / sizeof(testcase_assoc_laguerre<double>);
  for (unsigned int i = 0; i < num_datum; ++i)
    {
      const Tp f = std::tr1::assoc_laguerre(Tp(data016[i].n), Tp(data016[i].m),
                   Tp(data016[i].x));
      const Tp f0 = data016[i].f0;
      const Tp diff = f - f0;
      if (std::abs(diff) > max_abs_diff)
        max_abs_diff = std::abs(diff);
      if (std::abs(f0) > Tp(10) * eps
       && std::abs(f) > Tp(10) * eps)
        {
          const Tp frac = diff / f0;
          if (std::abs(frac) > max_abs_frac)
            max_abs_frac = std::abs(frac);
        }
    }
  VERIFY(max_abs_frac < Tp(2.5000000000000020e-13));
}

// Test data for n=2, m=0.
testcase_assoc_laguerre<double> data017[] = {
  { 1.0000000000000000, 2, 0, 
          0.0000000000000000 },
  { 31.000000000000000, 2, 0, 
          10.000000000000000 },
  { 161.00000000000000, 2, 0, 
          20.000000000000000 },
  { 391.00000000000000, 2, 0, 
          30.000000000000000 },
  { 721.00000000000000, 2, 0, 
          40.000000000000000 },
  { 1151.0000000000000, 2, 0, 
          50.000000000000000 },
  { 1681.0000000000000, 2, 0, 
          60.000000000000000 },
  { 2311.0000000000000, 2, 0, 
          70.000000000000000 },
  { 3041.0000000000000, 2, 0, 
          80.000000000000000 },
  { 3871.0000000000000, 2, 0, 
          90.000000000000000 },
  { 4801.0000000000000, 2, 0, 
          100.00000000000000 },
};

// Test function for n=2, m=0.
template <typename Tp>
void test017()
{
  const Tp eps = std::numeric_limits<Tp>::epsilon();
  Tp max_abs_diff = -Tp(1);
  Tp max_abs_frac = -Tp(1);
  unsigned int num_datum = sizeof(data017)
                         / sizeof(testcase_assoc_laguerre<double>);
  for (unsigned int i = 0; i < num_datum; ++i)
    {
      const Tp f = std::tr1::assoc_laguerre(Tp(data017[i].n), Tp(data017[i].m),
                   Tp(data017[i].x));
      const Tp f0 = data017[i].f0;
      const Tp diff = f - f0;
      if (std::abs(diff) > max_abs_diff)
        max_abs_diff = std::abs(diff);
      if (std::abs(f0) > Tp(10) * eps
       && std::abs(f) > Tp(10) * eps)
        {
          const Tp frac = diff / f0;
          if (std::abs(frac) > max_abs_frac)
            max_abs_frac = std::abs(frac);
        }
    }
  VERIFY(max_abs_frac < Tp(2.5000000000000020e-13));
}

// Test data for n=2, m=1.
testcase_assoc_laguerre<double> data018[] = {
  { 3.0000000000000000, 2, 1, 
          0.0000000000000000 },
  { 23.000000000000000, 2, 1, 
          10.000000000000000 },
  { 143.00000000000000, 2, 1, 
          20.000000000000000 },
  { 363.00000000000000, 2, 1, 
          30.000000000000000 },
  { 683.00000000000000, 2, 1, 
          40.000000000000000 },
  { 1103.0000000000000, 2, 1, 
          50.000000000000000 },
  { 1623.0000000000000, 2, 1, 
          60.000000000000000 },
  { 2243.0000000000000, 2, 1, 
          70.000000000000000 },
  { 2963.0000000000000, 2, 1, 
          80.000000000000000 },
  { 3783.0000000000000, 2, 1, 
          90.000000000000000 },
  { 4703.0000000000000, 2, 1, 
          100.00000000000000 },
};

// Test function for n=2, m=1.
template <typename Tp>
void test018()
{
  const Tp eps = std::numeric_limits<Tp>::epsilon();
  Tp max_abs_diff = -Tp(1);
  Tp max_abs_frac = -Tp(1);
  unsigned int num_datum = sizeof(data018)
                         / sizeof(testcase_assoc_laguerre<double>);
  for (unsigned int i = 0; i < num_datum; ++i)
    {
      const Tp f = std::tr1::assoc_laguerre(Tp(data018[i].n), Tp(data018[i].m),
                   Tp(data018[i].x));
      const Tp f0 = data018[i].f0;
      const Tp diff = f - f0;
      if (std::abs(diff) > max_abs_diff)
        max_abs_diff = std::abs(diff);
      if (std::abs(f0) > Tp(10) * eps
       && std::abs(f) > Tp(10) * eps)
        {
          const Tp frac = diff / f0;
          if (std::abs(frac) > max_abs_frac)
            max_abs_frac = std::abs(frac);
        }
    }
  VERIFY(max_abs_frac < Tp(2.5000000000000020e-13));
}

// Test data for n=2, m=2.
testcase_assoc_laguerre<double> data019[] = {
  { 6.0000000000000000, 2, 2, 
          0.0000000000000000 },
  { 16.000000000000000, 2, 2, 
          10.000000000000000 },
  { 126.00000000000000, 2, 2, 
          20.000000000000000 },
  { 336.00000000000000, 2, 2, 
          30.000000000000000 },
  { 646.00000000000000, 2, 2, 
          40.000000000000000 },
  { 1056.0000000000000, 2, 2, 
          50.000000000000000 },
  { 1566.0000000000000, 2, 2, 
          60.000000000000000 },
  { 2176.0000000000000, 2, 2, 
          70.000000000000000 },
  { 2886.0000000000000, 2, 2, 
          80.000000000000000 },
  { 3696.0000000000000, 2, 2, 
          90.000000000000000 },
  { 4606.0000000000000, 2, 2, 
          100.00000000000000 },
};

// Test function for n=2, m=2.
template <typename Tp>
void test019()
{
  const Tp eps = std::numeric_limits<Tp>::epsilon();
  Tp max_abs_diff = -Tp(1);
  Tp max_abs_frac = -Tp(1);
  unsigned int num_datum = sizeof(data019)
                         / sizeof(testcase_assoc_laguerre<double>);
  for (unsigned int i = 0; i < num_datum; ++i)
    {
      const Tp f = std::tr1::assoc_laguerre(Tp(data019[i].n), Tp(data019[i].m),
                   Tp(data019[i].x));
      const Tp f0 = data019[i].f0;
      const Tp diff = f - f0;
      if (std::abs(diff) > max_abs_diff)
        max_abs_diff = std::abs(diff);
      if (std::abs(f0) > Tp(10) * eps
       && std::abs(f) > Tp(10) * eps)
        {
          const Tp frac = diff / f0;
          if (std::abs(frac) > max_abs_frac)
            max_abs_frac = std::abs(frac);
        }
    }
  VERIFY(max_abs_frac < Tp(2.5000000000000020e-13));
}

// Test data for n=2, m=5.
testcase_assoc_laguerre<double> data020[] = {
  { 21.000000000000000, 2, 5, 
          0.0000000000000000 },
  { 0.99999999999999645, 2, 5, 
          10.000000000000000 },
  { 81.000000000000000, 2, 5, 
          20.000000000000000 },
  { 261.00000000000000, 2, 5, 
          30.000000000000000 },
  { 541.00000000000000, 2, 5, 
          40.000000000000000 },
  { 921.00000000000000, 2, 5, 
          50.000000000000000 },
  { 1401.0000000000000, 2, 5, 
          60.000000000000000 },
  { 1981.0000000000000, 2, 5, 
          70.000000000000000 },
  { 2661.0000000000000, 2, 5, 
          80.000000000000000 },
  { 3441.0000000000000, 2, 5, 
          90.000000000000000 },
  { 4321.0000000000000, 2, 5, 
          100.00000000000000 },
};

// Test function for n=2, m=5.
template <typename Tp>
void test020()
{
  const Tp eps = std::numeric_limits<Tp>::epsilon();
  Tp max_abs_diff = -Tp(1);
  Tp max_abs_frac = -Tp(1);
  unsigned int num_datum = sizeof(data020)
                         / sizeof(testcase_assoc_laguerre<double>);
  for (unsigned int i = 0; i < num_datum; ++i)
    {
      const Tp f = std::tr1::assoc_laguerre(Tp(data020[i].n), Tp(data020[i].m),
                   Tp(data020[i].x));
      const Tp f0 = data020[i].f0;
      const Tp diff = f - f0;
      if (std::abs(diff) > max_abs_diff)
        max_abs_diff = std::abs(diff);
      if (std::abs(f0) > Tp(10) * eps
       && std::abs(f) > Tp(10) * eps)
        {
          const Tp frac = diff / f0;
          if (std::abs(frac) > max_abs_frac)
            max_abs_frac = std::abs(frac);
        }
    }
  VERIFY(max_abs_frac < Tp(2.5000000000000020e-13));
}

// Test data for n=2, m=10.
testcase_assoc_laguerre<double> data021[] = {
  { 66.000000000000000, 2, 10, 
          0.0000000000000000 },
  { -4.0000000000000089, 2, 10, 
          10.000000000000000 },
  { 25.999999999999964, 2, 10, 
          20.000000000000000 },
  { 156.00000000000000, 2, 10, 
          30.000000000000000 },
  { 386.00000000000000, 2, 10, 
          40.000000000000000 },
  { 716.00000000000000, 2, 10, 
          50.000000000000000 },
  { 1146.0000000000000, 2, 10, 
          60.000000000000000 },
  { 1676.0000000000000, 2, 10, 
          70.000000000000000 },
  { 2306.0000000000000, 2, 10, 
          80.000000000000000 },
  { 3036.0000000000000, 2, 10, 
          90.000000000000000 },
  { 3866.0000000000000, 2, 10, 
          100.00000000000000 },
};

// Test function for n=2, m=10.
template <typename Tp>
void test021()
{
  const Tp eps = std::numeric_limits<Tp>::epsilon();
  Tp max_abs_diff = -Tp(1);
  Tp max_abs_frac = -Tp(1);
  unsigned int num_datum = sizeof(data021)
                         / sizeof(testcase_assoc_laguerre<double>);
  for (unsigned int i = 0; i < num_datum; ++i)
    {
      const Tp f = std::tr1::assoc_laguerre(Tp(data021[i].n), Tp(data021[i].m),
                   Tp(data021[i].x));
      const Tp f0 = data021[i].f0;
      const Tp diff = f - f0;
      if (std::abs(diff) > max_abs_diff)
        max_abs_diff = std::abs(diff);
      if (std::abs(f0) > Tp(10) * eps
       && std::abs(f) > Tp(10) * eps)
        {
          const Tp frac = diff / f0;
          if (std::abs(frac) > max_abs_frac)
            max_abs_frac = std::abs(frac);
        }
    }
  VERIFY(max_abs_frac < Tp(2.5000000000000020e-13));
}

// Test data for n=2, m=20.
testcase_assoc_laguerre<double> data022[] = {
  { 231.00000000000000, 2, 20, 
          0.0000000000000000 },
  { 61.000000000000206, 2, 20, 
          10.000000000000000 },
  { -8.9999999999999982, 2, 20, 
          20.000000000000000 },
  { 21.000000000000135, 2, 20, 
          30.000000000000000 },
  { 151.00000000000054, 2, 20, 
          40.000000000000000 },
  { 381.00000000000000, 2, 20, 
          50.000000000000000 },
  { 711.00000000000000, 2, 20, 
          60.000000000000000 },
  { 1141.0000000000000, 2, 20, 
          70.000000000000000 },
  { 1670.9999999999998, 2, 20, 
          80.000000000000000 },
  { 2301.0000000000000, 2, 20, 
          90.000000000000000 },
  { 3031.0000000000000, 2, 20, 
          100.00000000000000 },
};

// Test function for n=2, m=20.
template <typename Tp>
void test022()
{
  const Tp eps = std::numeric_limits<Tp>::epsilon();
  Tp max_abs_diff = -Tp(1);
  Tp max_abs_frac = -Tp(1);
  unsigned int num_datum = sizeof(data022)
                         / sizeof(testcase_assoc_laguerre<double>);
  for (unsigned int i = 0; i < num_datum; ++i)
    {
      const Tp f = std::tr1::assoc_laguerre(Tp(data022[i].n), Tp(data022[i].m),
                   Tp(data022[i].x));
      const Tp f0 = data022[i].f0;
      const Tp diff = f - f0;
      if (std::abs(diff) > max_abs_diff)
        max_abs_diff = std::abs(diff);
      if (std::abs(f0) > Tp(10) * eps
       && std::abs(f) > Tp(10) * eps)
        {
          const Tp frac = diff / f0;
          if (std::abs(frac) > max_abs_frac)
            max_abs_frac = std::abs(frac);
        }
    }
  VERIFY(max_abs_frac < Tp(5.0000000000000039e-13));
}

// Test data for n=2, m=50.
testcase_assoc_laguerre<double> data023[] = {
  { 1326.0000000000000, 2, 50, 
          0.0000000000000000 },
  { 855.99999999999716, 2, 50, 
          10.000000000000000 },
  { 485.99999999999829, 2, 50, 
          20.000000000000000 },
  { 215.99999999999935, 2, 50, 
          30.000000000000000 },
  { 45.999999999999787, 2, 50, 
          40.000000000000000 },
  { -23.999999999999684, 2, 50, 
          50.000000000000000 },
  { 6.0000000000001217, 2, 50, 
          60.000000000000000 },
  { 135.99999999999972, 2, 50, 
          70.000000000000000 },
  { 365.99999999999892, 2, 50, 
          80.000000000000000 },
  { 695.99999999999784, 2, 50, 
          90.000000000000000 },
  { 1125.9999999999964, 2, 50, 
          100.00000000000000 },
};

// Test function for n=2, m=50.
template <typename Tp>
void test023()
{
  const Tp eps = std::numeric_limits<Tp>::epsilon();
  Tp max_abs_diff = -Tp(1);
  Tp max_abs_frac = -Tp(1);
  unsigned int num_datum = sizeof(data023)
                         / sizeof(testcase_assoc_laguerre<double>);
  for (unsigned int i = 0; i < num_datum; ++i)
    {
      const Tp f = std::tr1::assoc_laguerre(Tp(data023[i].n), Tp(data023[i].m),
                   Tp(data023[i].x));
      const Tp f0 = data023[i].f0;
      const Tp diff = f - f0;
      if (std::abs(diff) > max_abs_diff)
        max_abs_diff = std::abs(diff);
      if (std::abs(f0) > Tp(10) * eps
       && std::abs(f) > Tp(10) * eps)
        {
          const Tp frac = diff / f0;
          if (std::abs(frac) > max_abs_frac)
            max_abs_frac = std::abs(frac);
        }
    }
  VERIFY(max_abs_frac < Tp(2.5000000000000015e-12));
}

// Test data for n=2, m=100.
testcase_assoc_laguerre<double> data024[] = {
  { 5151.0000000000000, 2, 100, 
          0.0000000000000000 },
  { 4181.0000000000655, 2, 100, 
          10.000000000000000 },
  { 3311.0000000000518, 2, 100, 
          20.000000000000000 },
  { 2541.0000000000400, 2, 100, 
          30.000000000000000 },
  { 1871.0000000000291, 2, 100, 
          40.000000000000000 },
  { 1301.0000000000207, 2, 100, 
          50.000000000000000 },
  { 831.00000000001364, 2, 100, 
          60.000000000000000 },
  { 461.00000000000682, 2, 100, 
          70.000000000000000 },
  { 191.00000000000227, 2, 100, 
          80.000000000000000 },
  { 21.000000000000128, 2, 100, 
          90.000000000000000 },
  { -49.000000000000369, 2, 100, 
          100.00000000000000 },
};

// Test function for n=2, m=100.
template <typename Tp>
void test024()
{
  const Tp eps = std::numeric_limits<Tp>::epsilon();
  Tp max_abs_diff = -Tp(1);
  Tp max_abs_frac = -Tp(1);
  unsigned int num_datum = sizeof(data024)
                         / sizeof(testcase_assoc_laguerre<double>);
  for (unsigned int i = 0; i < num_datum; ++i)
    {
      const Tp f = std::tr1::assoc_laguerre(Tp(data024[i].n), Tp(data024[i].m),
                   Tp(data024[i].x));
      const Tp f0 = data024[i].f0;
      const Tp diff = f - f0;
      if (std::abs(diff) > max_abs_diff)
        max_abs_diff = std::abs(diff);
      if (std::abs(f0) > Tp(10) * eps
       && std::abs(f) > Tp(10) * eps)
        {
          const Tp frac = diff / f0;
          if (std::abs(frac) > max_abs_frac)
            max_abs_frac = std::abs(frac);
        }
    }
  VERIFY(max_abs_frac < Tp(1.0000000000000008e-12));
}

// Test data for n=5, m=0.
testcase_assoc_laguerre<double> data025[] = {
  { 1.0000000000000000, 5, 0, 
          0.0000000000000000 },
  { 34.333333333333329, 5, 0, 
          10.000000000000000 },
  { -4765.6666666666670, 5, 0, 
          20.000000000000000 },
  { -74399.000000000000, 5, 0, 
          30.000000000000000 },
  { -418865.66666666663, 5, 0, 
          40.000000000000000 },
  { -1498165.6666666665, 5, 0, 
          50.000000000000000 },
  { -4122299.0000000000, 5, 0, 
          60.000000000000000 },
  { -9551265.6666666679, 5, 0, 
          70.000000000000000 },
  { -19595065.666666664, 5, 0, 
          80.000000000000000 },
  { -36713699.000000000, 5, 0, 
          90.000000000000000 },
  { -64117165.666666664, 5, 0, 
          100.00000000000000 },
};

// Test function for n=5, m=0.
template <typename Tp>
void test025()
{
  const Tp eps = std::numeric_limits<Tp>::epsilon();
  Tp max_abs_diff = -Tp(1);
  Tp max_abs_frac = -Tp(1);
  unsigned int num_datum = sizeof(data025)
                         / sizeof(testcase_assoc_laguerre<double>);
  for (unsigned int i = 0; i < num_datum; ++i)
    {
      const Tp f = std::tr1::assoc_laguerre(Tp(data025[i].n), Tp(data025[i].m),
                   Tp(data025[i].x));
      const Tp f0 = data025[i].f0;
      const Tp diff = f - f0;
      if (std::abs(diff) > max_abs_diff)
        max_abs_diff = std::abs(diff);
      if (std::abs(f0) > Tp(10) * eps
       && std::abs(f) > Tp(10) * eps)
        {
          const Tp frac = diff / f0;
          if (std::abs(frac) > max_abs_frac)
            max_abs_frac = std::abs(frac);
        }
    }
  VERIFY(max_abs_frac < Tp(2.5000000000000020e-13));
}

// Test data for n=5, m=1.
testcase_assoc_laguerre<double> data026[] = {
  { 6.0000000000000000, 5, 1, 
          0.0000000000000000 },
  { 22.666666666666661, 5, 1, 
          10.000000000000000 },
  { -2960.6666666666661, 5, 1, 
          20.000000000000000 },
  { -58944.000000000000, 5, 1, 
          30.000000000000000 },
  { -357927.33333333326, 5, 1, 
          40.000000000000000 },
  { -1329910.6666666665, 5, 1, 
          50.000000000000000 },
  { -3744894.0000000000, 5, 1, 
          60.000000000000000 },
  { -8812877.3333333321, 5, 1, 
          70.000000000000000 },
  { -18283860.666666664, 5, 1, 
          80.000000000000000 },
  { -34547844.000000000, 5, 1, 
          90.000000000000000 },
  { -60734827.333333336, 5, 1, 
          100.00000000000000 },
};

// Test function for n=5, m=1.
template <typename Tp>
void test026()
{
  const Tp eps = std::numeric_limits<Tp>::epsilon();
  Tp max_abs_diff = -Tp(1);
  Tp max_abs_frac = -Tp(1);
  unsigned int num_datum = sizeof(data026)
                         / sizeof(testcase_assoc_laguerre<double>);
  for (unsigned int i = 0; i < num_datum; ++i)
    {
      const Tp f = std::tr1::assoc_laguerre(Tp(data026[i].n), Tp(data026[i].m),
                   Tp(data026[i].x));
      const Tp f0 = data026[i].f0;
      const Tp diff = f - f0;
      if (std::abs(diff) > max_abs_diff)
        max_abs_diff = std::abs(diff);
      if (std::abs(f0) > Tp(10) * eps
       && std::abs(f) > Tp(10) * eps)
        {
          const Tp frac = diff / f0;
          if (std::abs(frac) > max_abs_frac)
            max_abs_frac = std::abs(frac);
        }
    }
  VERIFY(max_abs_frac < Tp(2.5000000000000020e-13));
}

// Test data for n=5, m=2.
testcase_assoc_laguerre<double> data027[] = {
  { 21.000000000000000, 5, 2, 
          0.0000000000000000 },
  { 4.3333333333333339, 5, 2, 
          10.000000000000000 },
  { -1679.0000000000000, 5, 2, 
          20.000000000000000 },
  { -46029.000000000000, 5, 2, 
          30.000000000000000 },
  { -304045.66666666669, 5, 2, 
          40.000000000000000 },
  { -1176729.0000000002, 5, 2, 
          50.000000000000000 },
  { -3395079.0000000000, 5, 2, 
          60.000000000000000 },
  { -8120095.6666666660, 5, 2, 
          70.000000000000000 },
  { -17042778.999999996, 5, 2, 
          80.000000000000000 },
  { -32484129.000000000, 5, 2, 
          90.000000000000000 },
  { -57495145.666666664, 5, 2, 
          100.00000000000000 },
};

// Test function for n=5, m=2.
template <typename Tp>
void test027()
{
  const Tp eps = std::numeric_limits<Tp>::epsilon();
  Tp max_abs_diff = -Tp(1);
  Tp max_abs_frac = -Tp(1);
  unsigned int num_datum = sizeof(data027)
                         / sizeof(testcase_assoc_laguerre<double>);
  for (unsigned int i = 0; i < num_datum; ++i)
    {
      const Tp f = std::tr1::assoc_laguerre(Tp(data027[i].n), Tp(data027[i].m),
                   Tp(data027[i].x));
      const Tp f0 = data027[i].f0;
      const Tp diff = f - f0;
      if (std::abs(diff) > max_abs_diff)
        max_abs_diff = std::abs(diff);
      if (std::abs(f0) > Tp(10) * eps
       && std::abs(f) > Tp(10) * eps)
        {
          const Tp frac = diff / f0;
          if (std::abs(frac) > max_abs_frac)
            max_abs_frac = std::abs(frac);
        }
    }
  VERIFY(max_abs_frac < Tp(2.5000000000000020e-13));
}

// Test data for n=5, m=5.
testcase_assoc_laguerre<double> data028[] = {
  { 252.00000000000000, 5, 5, 
          0.0000000000000000 },
  { -14.666666666666657, 5, 5, 
          10.000000000000000 },
  { 51.999999999999957, 5, 5, 
          20.000000000000000 },
  { -19548.000000000000, 5, 5, 
          30.000000000000000 },
  { -178814.66666666660, 5, 5, 
          40.000000000000000 },
  { -797747.99999999977, 5, 5, 
          50.000000000000000 },
  { -2496348.0000000000, 5, 5, 
          60.000000000000000 },
  { -6294614.6666666660, 5, 5, 
          70.000000000000000 },
  { -13712547.999999996, 5, 5, 
          80.000000000000000 },
  { -26870147.999999993, 5, 5, 
          90.000000000000000 },
  { -48587414.666666672, 5, 5, 
          100.00000000000000 },
};

// Test function for n=5, m=5.
template <typename Tp>
void test028()
{
  const Tp eps = std::numeric_limits<Tp>::epsilon();
  Tp max_abs_diff = -Tp(1);
  Tp max_abs_frac = -Tp(1);
  unsigned int num_datum = sizeof(data028)
                         / sizeof(testcase_assoc_laguerre<double>);
  for (unsigned int i = 0; i < num_datum; ++i)
    {
      const Tp f = std::tr1::assoc_laguerre(Tp(data028[i].n), Tp(data028[i].m),
                   Tp(data028[i].x));
      const Tp f0 = data028[i].f0;
      const Tp diff = f - f0;
      if (std::abs(diff) > max_abs_diff)
        max_abs_diff = std::abs(diff);
      if (std::abs(f0) > Tp(10) * eps
       && std::abs(f) > Tp(10) * eps)
        {
          const Tp frac = diff / f0;
          if (std::abs(frac) > max_abs_frac)
            max_abs_frac = std::abs(frac);
        }
    }
  VERIFY(max_abs_frac < Tp(2.5000000000000020e-13));
}

// Test data for n=5, m=10.
testcase_assoc_laguerre<double> data029[] = {
  { 3003.0000000000000, 5, 10, 
          0.0000000000000000 },
  { 19.666666666666668, 5, 10, 
          10.000000000000000 },
  { 36.333333333333272, 5, 10, 
          20.000000000000000 },
  { -1947.0000000000000, 5, 10, 
          30.000000000000000 },
  { -60930.333333333314, 5, 10, 
          40.000000000000000 },
  { -381913.66666666651, 5, 10, 
          50.000000000000000 },
  { -1419897.0000000000, 5, 10, 
          60.000000000000000 },
  { -3979880.3333333330, 5, 10, 
          70.000000000000000 },
  { -9316863.6666666642, 5, 10, 
          80.000000000000000 },
  { -19235847.000000000, 5, 10, 
          90.000000000000000 },
  { -36191830.333333328, 5, 10, 
          100.00000000000000 },
};

// Test function for n=5, m=10.
template <typename Tp>
void test029()
{
  const Tp eps = std::numeric_limits<Tp>::epsilon();
  Tp max_abs_diff = -Tp(1);
  Tp max_abs_frac = -Tp(1);
  unsigned int num_datum = sizeof(data029)
                         / sizeof(testcase_assoc_laguerre<double>);
  for (unsigned int i = 0; i < num_datum; ++i)
    {
      const Tp f = std::tr1::assoc_laguerre(Tp(data029[i].n), Tp(data029[i].m),
                   Tp(data029[i].x));
      const Tp f0 = data029[i].f0;
      const Tp diff = f - f0;
      if (std::abs(diff) > max_abs_diff)
        max_abs_diff = std::abs(diff);
      if (std::abs(f0) > Tp(10) * eps
       && std::abs(f) > Tp(10) * eps)
        {
          const Tp frac = diff / f0;
          if (std::abs(frac) > max_abs_frac)
            max_abs_frac = std::abs(frac);
        }
    }
  VERIFY(max_abs_frac < Tp(2.5000000000000020e-13));
}

// Test data for n=5, m=20.
testcase_assoc_laguerre<double> data030[] = {
  { 53130.000000000000, 5, 20, 
          0.0000000000000000 },
  { 1213.3333333333335, 5, 20, 
          10.000000000000000 },
  { 129.99999999999963, 5, 20, 
          20.000000000000000 },
  { -119.99999999999974, 5, 20, 
          30.000000000000000 },
  { 463.33333333333320, 5, 20, 
          40.000000000000000 },
  { -48120.000000000015, 5, 20, 
          50.000000000000000 },
  { -345870.00000000017, 5, 20, 
          60.000000000000000 },
  { -1342786.6666666667, 5, 20, 
          70.000000000000000 },
  { -3838870.0000000009, 5, 20, 
          80.000000000000000 },
  { -9084120.0000000000, 5, 20, 
          90.000000000000000 },
  { -18878536.666666668, 5, 20, 
          100.00000000000000 },
};

// Test function for n=5, m=20.
template <typename Tp>
void test030()
{
  const Tp eps = std::numeric_limits<Tp>::epsilon();
  Tp max_abs_diff = -Tp(1);
  Tp max_abs_frac = -Tp(1);
  unsigned int num_datum = sizeof(data030)
                         / sizeof(testcase_assoc_laguerre<double>);
  for (unsigned int i = 0; i < num_datum; ++i)
    {
      const Tp f = std::tr1::assoc_laguerre(Tp(data030[i].n), Tp(data030[i].m),
                   Tp(data030[i].x));
      const Tp f0 = data030[i].f0;
      const Tp diff = f - f0;
      if (std::abs(diff) > max_abs_diff)
        max_abs_diff = std::abs(diff);
      if (std::abs(f0) > Tp(10) * eps
       && std::abs(f) > Tp(10) * eps)
        {
          const Tp frac = diff / f0;
          if (std::abs(frac) > max_abs_frac)
            max_abs_frac = std::abs(frac);
        }
    }
  VERIFY(max_abs_frac < Tp(2.5000000000000020e-13));
}

// Test data for n=5, m=50.
testcase_assoc_laguerre<double> data031[] = {
  { 3478761.0000000000, 5, 50, 
          0.0000000000000000 },
  { 1154544.3333333335, 5, 50, 
          10.000000000000000 },
  { 264661.00000000006, 5, 50, 
          20.000000000000000 },
  { 24111.000000000000, 5, 50, 
          30.000000000000000 },
  { -2105.6666666666665, 5, 50, 
          40.000000000000000 },
  { 1011.0000000000000, 5, 50, 
          50.000000000000000 },
  { -1538.9999999999955, 5, 50, 
          60.000000000000000 },
  { 5244.3333333333449, 5, 50, 
          70.000000000000000 },
  { -13639.000000000015, 5, 50, 
          80.000000000000000 },
  { -243189.00000000006, 5, 50, 
          90.000000000000000 },
  { -1118405.6666666667, 5, 50, 
          100.00000000000000 },
};

// Test function for n=5, m=50.
template <typename Tp>
void test031()
{
  const Tp eps = std::numeric_limits<Tp>::epsilon();
  Tp max_abs_diff = -Tp(1);
  Tp max_abs_frac = -Tp(1);
  unsigned int num_datum = sizeof(data031)
                         / sizeof(testcase_assoc_laguerre<double>);
  for (unsigned int i = 0; i < num_datum; ++i)
    {
      const Tp f = std::tr1::assoc_laguerre(Tp(data031[i].n), Tp(data031[i].m),
                   Tp(data031[i].x));
      const Tp f0 = data031[i].f0;
      const Tp diff = f - f0;
      if (std::abs(diff) > max_abs_diff)
        max_abs_diff = std::abs(diff);
      if (std::abs(f0) > Tp(10) * eps
       && std::abs(f) > Tp(10) * eps)
        {
          const Tp frac = diff / f0;
          if (std::abs(frac) > max_abs_frac)
            max_abs_frac = std::abs(frac);
        }
    }
  VERIFY(max_abs_frac < Tp(2.5000000000000020e-13));
}

// Test data for n=5, m=100.
testcase_assoc_laguerre<double> data032[] = {
  { 96560646.000000000, 5, 100, 
          0.0000000000000000 },
  { 57264262.666666649, 5, 100, 
          10.000000000000000 },
  { 31841379.333333332, 5, 100, 
          20.000000000000000 },
  { 16281996.000000000, 5, 100, 
          30.000000000000000 },
  { 7426112.6666666670, 5, 100, 
          40.000000000000000 },
  { 2863729.3333333330, 5, 100, 
          50.000000000000000 },
  { 834846.00000000000, 5, 100, 
          60.000000000000000 },
  { 129462.66666666663, 5, 100, 
          70.000000000000000 },
  { -12420.666666666666, 5, 100, 
          80.000000000000000 },
  { -804.00000000000000, 5, 100, 
          90.000000000000000 },
  { 4312.6666666666661, 5, 100, 
          100.00000000000000 },
};

// Test function for n=5, m=100.
template <typename Tp>
void test032()
{
  const Tp eps = std::numeric_limits<Tp>::epsilon();
  Tp max_abs_diff = -Tp(1);
  Tp max_abs_frac = -Tp(1);
  unsigned int num_datum = sizeof(data032)
                         / sizeof(testcase_assoc_laguerre<double>);
  for (unsigned int i = 0; i < num_datum; ++i)
    {
      const Tp f = std::tr1::assoc_laguerre(Tp(data032[i].n), Tp(data032[i].m),
                   Tp(data032[i].x));
      const Tp f0 = data032[i].f0;
      const Tp diff = f - f0;
      if (std::abs(diff) > max_abs_diff)
        max_abs_diff = std::abs(diff);
      if (std::abs(f0) > Tp(10) * eps
       && std::abs(f) > Tp(10) * eps)
        {
          const Tp frac = diff / f0;
          if (std::abs(frac) > max_abs_frac)
            max_abs_frac = std::abs(frac);
        }
    }
  VERIFY(max_abs_frac < Tp(2.5000000000000020e-13));
}

// Test data for n=10, m=0.
testcase_assoc_laguerre<double> data033[] = {
  { 1.0000000000000000, 10, 0, 
          0.0000000000000000 },
  { 27.984126984126981, 10, 0, 
          10.000000000000000 },
  { 3227.8077601410932, 10, 0, 
          20.000000000000000 },
  { 15129.571428571489, 10, 0, 
          30.000000000000000 },
  { 79724066.608465582, 10, 0, 
          40.000000000000000 },
  { 2037190065.3738980, 10, 0, 
          50.000000000000000 },
  { 21804200401.000000, 10, 0, 
          60.000000000000000 },
  { 144688291819.51855, 10, 0, 
          70.000000000000000 },
  { 703324772760.08276, 10, 0, 
          80.000000000000000 },
  { 2741055412243.8569, 10, 0, 
          90.000000000000000 },
  { 9051283795429.5723, 10, 0, 
          100.00000000000000 },
};

// Test function for n=10, m=0.
template <typename Tp>
void test033()
{
  const Tp eps = std::numeric_limits<Tp>::epsilon();
  Tp max_abs_diff = -Tp(1);
  Tp max_abs_frac = -Tp(1);
  unsigned int num_datum = sizeof(data033)
                         / sizeof(testcase_assoc_laguerre<double>);
  for (unsigned int i = 0; i < num_datum; ++i)
    {
      const Tp f = std::tr1::assoc_laguerre(Tp(data033[i].n), Tp(data033[i].m),
                   Tp(data033[i].x));
      const Tp f0 = data033[i].f0;
      const Tp diff = f - f0;
      if (std::abs(diff) > max_abs_diff)
        max_abs_diff = std::abs(diff);
      if (std::abs(f0) > Tp(10) * eps
       && std::abs(f) > Tp(10) * eps)
        {
          const Tp frac = diff / f0;
          if (std::abs(frac) > max_abs_frac)
            max_abs_frac = std::abs(frac);
        }
    }
  VERIFY(max_abs_frac < Tp(5.0000000000000039e-13));
}

// Test data for n=10, m=1.
testcase_assoc_laguerre<double> data034[] = {
  { 11.000000000000000, 10, 1, 
          0.0000000000000000 },
  { 14.791887125220455, 10, 1, 
          10.000000000000000 },
  { 2704.6507936507933, 10, 1, 
          20.000000000000000 },
  { -182924.71428571426, 10, 1, 
          30.000000000000000 },
  { 48066036.749559075, 10, 1, 
          40.000000000000000 },
  { 1486264192.2169311, 10, 1, 
          50.000000000000000 },
  { 17239562282.428574, 10, 1, 
          60.000000000000000 },
  { 119837491630.13579, 10, 1, 
          70.000000000000000 },
  { 600681375251.21167, 10, 1, 
          80.000000000000000 },
  { 2392908405632.4287, 10, 1, 
          90.000000000000000 },
  { 8033035722509.2373, 10, 1, 
          100.00000000000000 },
};

// Test function for n=10, m=1.
template <typename Tp>
void test034()
{
  const Tp eps = std::numeric_limits<Tp>::epsilon();
  Tp max_abs_diff = -Tp(1);
  Tp max_abs_frac = -Tp(1);
  unsigned int num_datum = sizeof(data034)
                         / sizeof(testcase_assoc_laguerre<double>);
  for (unsigned int i = 0; i < num_datum; ++i)
    {
      const Tp f = std::tr1::assoc_laguerre(Tp(data034[i].n), Tp(data034[i].m),
                   Tp(data034[i].x));
      const Tp f0 = data034[i].f0;
      const Tp diff = f - f0;
      if (std::abs(diff) > max_abs_diff)
        max_abs_diff = std::abs(diff);
      if (std::abs(f0) > Tp(10) * eps
       && std::abs(f) > Tp(10) * eps)
        {
          const Tp frac = diff / f0;
          if (std::abs(frac) > max_abs_frac)
            max_abs_frac = std::abs(frac);
        }
    }
  VERIFY(max_abs_frac < Tp(2.5000000000000020e-13));
}

// Test data for n=10, m=2.
testcase_assoc_laguerre<double> data035[] = {
  { 66.000000000000000, 10, 2, 
          0.0000000000000000 },
  { -14.511463844797174, 10, 2, 
          10.000000000000000 },
  { 1064.5890652557318, 10, 2, 
          20.000000000000000 },
  { -194569.71428571426, 10, 2, 
          30.000000000000000 },
  { 27343569.350970022, 10, 2, 
          40.000000000000000 },
  { 1067807661.6790125, 10, 2, 
          50.000000000000000 },
  { 13529451580.285713, 10, 2, 
          60.000000000000000 },
  { 98812724224.641937, 10, 2, 
          70.000000000000000 },
  { 511482736187.34021, 10, 2, 
          80.000000000000000 },
  { 2084478393087.4285, 10, 2, 
          90.000000000000000 },
  { 7117724862237.0752, 10, 2, 
          100.00000000000000 },
};

// Test function for n=10, m=2.
template <typename Tp>
void test035()
{
  const Tp eps = std::numeric_limits<Tp>::epsilon();
  Tp max_abs_diff = -Tp(1);
  Tp max_abs_frac = -Tp(1);
  unsigned int num_datum = sizeof(data035)
                         / sizeof(testcase_assoc_laguerre<double>);
  for (unsigned int i = 0; i < num_datum; ++i)
    {
      const Tp f = std::tr1::assoc_laguerre(Tp(data035[i].n), Tp(data035[i].m),
                   Tp(data035[i].x));
      const Tp f0 = data035[i].f0;
      const Tp diff = f - f0;
      if (std::abs(diff) > max_abs_diff)
        max_abs_diff = std::abs(diff);
      if (std::abs(f0) > Tp(10) * eps
       && std::abs(f) > Tp(10) * eps)
        {
          const Tp frac = diff / f0;
          if (std::abs(frac) > max_abs_frac)
            max_abs_frac = std::abs(frac);
        }
    }
  VERIFY(max_abs_frac < Tp(2.5000000000000020e-13));
}

// Test data for n=10, m=5.
testcase_assoc_laguerre<double> data036[] = {
  { 3003.0000000000000, 10, 5, 
          0.0000000000000000 },
  { 11.641975308642024, 10, 5, 
          10.000000000000000 },
  { -1137.5643738977069, 10, 5, 
          20.000000000000000 },
  { -9254.1428571428605, 10, 5, 
          30.000000000000000 },
  { 2121878.8377425023, 10, 5, 
          40.000000000000000 },
  { 352060171.43033499, 10, 5, 
          50.000000000000000 },
  { 6212028560.1428576, 10, 5, 
          60.000000000000000 },
  { 53782171674.604919, 10, 5, 
          70.000000000000000 },
  { 309720255837.56775, 10, 5, 
          80.000000000000000 },
  { 1359043035731.5713, 10, 5, 
          90.000000000000000 },
  { 4900625954398.9434, 10, 5, 
          100.00000000000000 },
};

// Test function for n=10, m=5.
template <typename Tp>
void test036()
{
  const Tp eps = std::numeric_limits<Tp>::epsilon();
  Tp max_abs_diff = -Tp(1);
  Tp max_abs_frac = -Tp(1);
  unsigned int num_datum = sizeof(data036)
                         / sizeof(testcase_assoc_laguerre<double>);
  for (unsigned int i = 0; i < num_datum; ++i)
    {
      const Tp f = std::tr1::assoc_laguerre(Tp(data036[i].n), Tp(data036[i].m),
                   Tp(data036[i].x));
      const Tp f0 = data036[i].f0;
      const Tp diff = f - f0;
      if (std::abs(diff) > max_abs_diff)
        max_abs_diff = std::abs(diff);
      if (std::abs(f0) > Tp(10) * eps
       && std::abs(f) > Tp(10) * eps)
        {
          const Tp frac = diff / f0;
          if (std::abs(frac) > max_abs_frac)
            max_abs_frac = std::abs(frac);
        }
    }
  VERIFY(max_abs_frac < Tp(2.5000000000000020e-13));
}

// Test data for n=10, m=10.
testcase_assoc_laguerre<double> data037[] = {
  { 184756.00000000000, 10, 10, 
          0.0000000000000000 },
  { -210.84303350970018, 10, 10, 
          10.000000000000000 },
  { 508.38095238095184, 10, 10, 
          20.000000000000000 },
  { 2098.8571428571431, 10, 10, 
          30.000000000000000 },
  { -536338.88536155189, 10, 10, 
          40.000000000000000 },
  { 24865988.804232784, 10, 10, 
          50.000000000000000 },
  { 1343756013.1428571, 10, 10, 
          60.000000000000000 },
  { 17298791247.358025, 10, 10, 
          70.000000000000000 },
  { 124528450897.79892, 10, 10, 
          80.000000000000000 },
  { 632674413641.71423, 10, 10, 
          90.000000000000000 },
  { 2533008935405.0298, 10, 10, 
          100.00000000000000 },
};

// Test function for n=10, m=10.
template <typename Tp>
void test037()
{
  const Tp eps = std::numeric_limits<Tp>::epsilon();
  Tp max_abs_diff = -Tp(1);
  Tp max_abs_frac = -Tp(1);
  unsigned int num_datum = sizeof(data037)
                         / sizeof(testcase_assoc_laguerre<double>);
  for (unsigned int i = 0; i < num_datum; ++i)
    {
      const Tp f = std::tr1::assoc_laguerre(Tp(data037[i].n), Tp(data037[i].m),
                   Tp(data037[i].x));
      const Tp f0 = data037[i].f0;
      const Tp diff = f - f0;
      if (std::abs(diff) > max_abs_diff)
        max_abs_diff = std::abs(diff);
      if (std::abs(f0) > Tp(10) * eps
       && std::abs(f) > Tp(10) * eps)
        {
          const Tp frac = diff / f0;
          if (std::abs(frac) > max_abs_frac)
            max_abs_frac = std::abs(frac);
        }
    }
  VERIFY(max_abs_frac < Tp(2.5000000000000020e-13));
}

// Test data for n=10, m=20.
testcase_assoc_laguerre<double> data038[] = {
  { 30045014.999999993, 10, 20, 
          0.0000000000000000 },
  { -23087.733686067022, 10, 20, 
          10.000000000000000 },
  { 207.23985890652347, 10, 20, 
          20.000000000000000 },
  { 1407.8571428571497, 10, 20, 
          30.000000000000000 },
  { -44618.156966490329, 10, 20, 
          40.000000000000000 },
  { 158690.04409171085, 10, 20, 
          50.000000000000000 },
  { -6870413.5714285728, 10, 20, 
          60.000000000000000 },
  { 793841351.41975331, 10, 20, 
          70.000000000000000 },
  { 13358288958.562618, 10, 20, 
          80.000000000000000 },
  { 106073722407.85715, 10, 20, 
          90.000000000000000 },
  { 566337213392.42493, 10, 20, 
          100.00000000000000 },
};

// Test function for n=10, m=20.
template <typename Tp>
void test038()
{
  const Tp eps = std::numeric_limits<Tp>::epsilon();
  Tp max_abs_diff = -Tp(1);
  Tp max_abs_frac = -Tp(1);
  unsigned int num_datum = sizeof(data038)
                         / sizeof(testcase_assoc_laguerre<double>);
  for (unsigned int i = 0; i < num_datum; ++i)
    {
      const Tp f = std::tr1::assoc_laguerre(Tp(data038[i].n), Tp(data038[i].m),
                   Tp(data038[i].x));
      const Tp f0 = data038[i].f0;
      const Tp diff = f - f0;
      if (std::abs(diff) > max_abs_diff)
        max_abs_diff = std::abs(diff);
      if (std::abs(f0) > Tp(10) * eps
       && std::abs(f) > Tp(10) * eps)
        {
          const Tp frac = diff / f0;
          if (std::abs(frac) > max_abs_frac)
            max_abs_frac = std::abs(frac);
        }
    }
  VERIFY(max_abs_frac < Tp(1.0000000000000008e-12));
}

// Test data for n=10, m=50.
testcase_assoc_laguerre<double> data039[] = {
  { 75394027566.000000, 10, 50, 
          0.0000000000000000 },
  { 8048106183.3721361, 10, 50, 
          10.000000000000000 },
  { 328045023.84832466, 10, 50, 
          20.000000000000000 },
  { -2568769.7142857141, 10, 50, 
          30.000000000000000 },
  { 6971.9964726631733, 10, 50, 
          40.000000000000000 },
  { 136111.41446208110, 10, 50, 
          50.000000000000000 },
  { -62462.571428570242, 10, 50, 
          60.000000000000000 },
  { -248167.95061728527, 10, 50, 
          70.000000000000000 },
  { 1941270.4091710777, 10, 50, 
          80.000000000000000 },
  { -8643512.5714285783, 10, 50, 
          90.000000000000000 },
  { -140863522.18342155, 10, 50, 
          100.00000000000000 },
};

// Test function for n=10, m=50.
template <typename Tp>
void test039()
{
  const Tp eps = std::numeric_limits<Tp>::epsilon();
  Tp max_abs_diff = -Tp(1);
  Tp max_abs_frac = -Tp(1);
  unsigned int num_datum = sizeof(data039)
                         / sizeof(testcase_assoc_laguerre<double>);
  for (unsigned int i = 0; i < num_datum; ++i)
    {
      const Tp f = std::tr1::assoc_laguerre(Tp(data039[i].n), Tp(data039[i].m),
                   Tp(data039[i].x));
      const Tp f0 = data039[i].f0;
      const Tp diff = f - f0;
      if (std::abs(diff) > max_abs_diff)
        max_abs_diff = std::abs(diff);
      if (std::abs(f0) > Tp(10) * eps
       && std::abs(f) > Tp(10) * eps)
        {
          const Tp frac = diff / f0;
          if (std::abs(frac) > max_abs_frac)
            max_abs_frac = std::abs(frac);
        }
    }
  VERIFY(max_abs_frac < Tp(1.0000000000000008e-12));
}

// Test data for n=10, m=100.
testcase_assoc_laguerre<double> data040[] = {
  { 46897636623981.000, 10, 100, 
          0.0000000000000000 },
  { 16444031323272.084, 10, 100, 
          10.000000000000000 },
  { 5020343986463.5391, 10, 100, 
          20.000000000000000 },
  { 1270977490645.2859, 10, 100, 
          30.000000000000000 },
  { 244835756822.62262, 10, 100, 
          40.000000000000000 },
  { 29786827693.962963, 10, 100, 
          50.000000000000000 },
  { 1127612095.2857144, 10, 100, 
          60.000000000000000 },
  { -66370555.419753075, 10, 100, 
          70.000000000000000 },
  { 10420852.957671957, 10, 100, 
          80.000000000000000 },
  { -3373097.5714285718, 10, 100, 
          90.000000000000000 },
  { 2065423.6807760142, 10, 100, 
          100.00000000000000 },
};

// Test function for n=10, m=100.
template <typename Tp>
void test040()
{
  const Tp eps = std::numeric_limits<Tp>::epsilon();
  Tp max_abs_diff = -Tp(1);
  Tp max_abs_frac = -Tp(1);
  unsigned int num_datum = sizeof(data040)
                         / sizeof(testcase_assoc_laguerre<double>);
  for (unsigned int i = 0; i < num_datum; ++i)
    {
      const Tp f = std::tr1::assoc_laguerre(Tp(data040[i].n), Tp(data040[i].m),
                   Tp(data040[i].x));
      const Tp f0 = data040[i].f0;
      const Tp diff = f - f0;
      if (std::abs(diff) > max_abs_diff)
        max_abs_diff = std::abs(diff);
      if (std::abs(f0) > Tp(10) * eps
       && std::abs(f) > Tp(10) * eps)
        {
          const Tp frac = diff / f0;
          if (std::abs(frac) > max_abs_frac)
            max_abs_frac = std::abs(frac);
        }
    }
  VERIFY(max_abs_frac < Tp(2.5000000000000020e-13));
}

// Test data for n=20, m=0.
testcase_assoc_laguerre<double> data041[] = {
  { 1.0000000000000000, 20, 0, 
          0.0000000000000000 },
  { -11.961333867812119, 20, 0, 
          10.000000000000000 },
  { 2829.4728613531738, 20, 0, 
          20.000000000000000 },
  { -18439.424502520938, 20, 0, 
          30.000000000000000 },
  { 24799805.877530701, 20, 0, 
          40.000000000000000 },
  { 7551960453.7672529, 20, 0, 
          50.000000000000000 },
  { -1379223608444.9155, 20, 0, 
          60.000000000000000 },
  { 165423821874449.94, 20, 0, 
          70.000000000000000 },
  { 29500368536981676., 20, 0, 
          80.000000000000000 },
  { 1.1292309514432899e+18, 20, 0, 
          90.000000000000000 },
  { 2.2061882785931735e+19, 20, 0, 
          100.00000000000000 },
};

// Test function for n=20, m=0.
template <typename Tp>
void test041()
{
  const Tp eps = std::numeric_limits<Tp>::epsilon();
  Tp max_abs_diff = -Tp(1);
  Tp max_abs_frac = -Tp(1);
  unsigned int num_datum = sizeof(data041)
                         / sizeof(testcase_assoc_laguerre<double>);
  for (unsigned int i = 0; i < num_datum; ++i)
    {
      const Tp f = std::tr1::assoc_laguerre(Tp(data041[i].n), Tp(data041[i].m),
                   Tp(data041[i].x));
      const Tp f0 = data041[i].f0;
      const Tp diff = f - f0;
      if (std::abs(diff) > max_abs_diff)
        max_abs_diff = std::abs(diff);
      if (std::abs(f0) > Tp(10) * eps
       && std::abs(f) > Tp(10) * eps)
        {
          const Tp frac = diff / f0;
          if (std::abs(frac) > max_abs_frac)
            max_abs_frac = std::abs(frac);
        }
    }
  VERIFY(max_abs_frac < Tp(2.5000000000000020e-13));
}

// Test data for n=20, m=1.
testcase_assoc_laguerre<double> data042[] = {
  { 21.000000000000000, 20, 1, 
          0.0000000000000000 },
  { 19.900488129734079, 20, 1, 
          10.000000000000000 },
  { 2208.0318569557589, 20, 1, 
          20.000000000000000 },
  { 263690.96303121914, 20, 1, 
          30.000000000000000 },
  { 40667285.630564235, 20, 1, 
          40.000000000000000 },
  { 1737442572.8115418, 20, 1, 
          50.000000000000000 },
  { -588280953643.28125, 20, 1, 
          60.000000000000000 },
  { 45617733778241.359, 20, 1, 
          70.000000000000000 },
  { 17293487114876860., 20, 1, 
          80.000000000000000 },
  { 7.6219135858585024e+17, 20, 1, 
          90.000000000000000 },
  { 1.6037288204336759e+19, 20, 1, 
          100.00000000000000 },
};

// Test function for n=20, m=1.
template <typename Tp>
void test042()
{
  const Tp eps = std::numeric_limits<Tp>::epsilon();
  Tp max_abs_diff = -Tp(1);
  Tp max_abs_frac = -Tp(1);
  unsigned int num_datum = sizeof(data042)
                         / sizeof(testcase_assoc_laguerre<double>);
  for (unsigned int i = 0; i < num_datum; ++i)
    {
      const Tp f = std::tr1::assoc_laguerre(Tp(data042[i].n), Tp(data042[i].m),
                   Tp(data042[i].x));
      const Tp f0 = data042[i].f0;
      const Tp diff = f - f0;
      if (std::abs(diff) > max_abs_diff)
        max_abs_diff = std::abs(diff);
      if (std::abs(f0) > Tp(10) * eps
       && std::abs(f) > Tp(10) * eps)
        {
          const Tp frac = diff / f0;
          if (std::abs(frac) > max_abs_frac)
            max_abs_frac = std::abs(frac);
        }
    }
  VERIFY(max_abs_frac < Tp(2.5000000000000020e-13));
}

// Test data for n=20, m=2.
testcase_assoc_laguerre<double> data043[] = {
  { 231.00000000000003, 20, 2, 
          0.0000000000000000 },
  { 47.009338065112935, 20, 2, 
          10.000000000000000 },
  { -652.51305461728566, 20, 2, 
          20.000000000000000 },
  { 285388.25895069109, 20, 2, 
          30.000000000000000 },
  { 28664069.685624726, 20, 2, 
          40.000000000000000 },
  { -1399631966.3144732, 20, 2, 
          50.000000000000000 },
  { -115357373248.28198, 20, 2, 
          60.000000000000000 },
  { -3357730872975.8545, 20, 2, 
          70.000000000000000 },
  { 9765808962855122.0, 20, 2, 
          80.000000000000000 },
  { 5.0717292945559181e+17, 20, 2, 
          90.000000000000000 },
  { 1.1564665701334458e+19, 20, 2, 
          100.00000000000000 },
};

// Test function for n=20, m=2.
template <typename Tp>
void test043()
{
  const Tp eps = std::numeric_limits<Tp>::epsilon();
  Tp max_abs_diff = -Tp(1);
  Tp max_abs_frac = -Tp(1);
  unsigned int num_datum = sizeof(data043)
                         / sizeof(testcase_assoc_laguerre<double>);
  for (unsigned int i = 0; i < num_datum; ++i)
    {
      const Tp f = std::tr1::assoc_laguerre(Tp(data043[i].n), Tp(data043[i].m),
                   Tp(data043[i].x));
      const Tp f0 = data043[i].f0;
      const Tp diff = f - f0;
      if (std::abs(diff) > max_abs_diff)
        max_abs_diff = std::abs(diff);
      if (std::abs(f0) > Tp(10) * eps
       && std::abs(f) > Tp(10) * eps)
        {
          const Tp frac = diff / f0;
          if (std::abs(frac) > max_abs_frac)
            max_abs_frac = std::abs(frac);
        }
    }
  VERIFY(max_abs_frac < Tp(2.5000000000000020e-13));
}

// Test data for n=20, m=5.
testcase_assoc_laguerre<double> data044[] = {
  { 53130.000000000000, 20, 5, 
          0.0000000000000000 },
  { -158.69554500944145, 20, 5, 
          10.000000000000000 },
  { 334.08012288038969, 20, 5, 
          20.000000000000000 },
  { -198372.47662554169, 20, 5, 
          30.000000000000000 },
  { -13627144.088579427, 20, 5, 
          40.000000000000000 },
  { -780579985.44731593, 20, 5, 
          50.000000000000000 },
  { 116648634237.73526, 20, 5, 
          60.000000000000000 },
  { -12347348707739.742, 20, 5, 
          70.000000000000000 },
  { 1199516248034090.8, 20, 5, 
          80.000000000000000 },
  { 1.3451503195078531e+17, 20, 5, 
          90.000000000000000 },
  { 4.1058904276111483e+18, 20, 5, 
          100.00000000000000 },
};

// Test function for n=20, m=5.
template <typename Tp>
void test044()
{
  const Tp eps = std::numeric_limits<Tp>::epsilon();
  Tp max_abs_diff = -Tp(1);
  Tp max_abs_frac = -Tp(1);
  unsigned int num_datum = sizeof(data044)
                         / sizeof(testcase_assoc_laguerre<double>);
  for (unsigned int i = 0; i < num_datum; ++i)
    {
      const Tp f = std::tr1::assoc_laguerre(Tp(data044[i].n), Tp(data044[i].m),
                   Tp(data044[i].x));
      const Tp f0 = data044[i].f0;
      const Tp diff = f - f0;
      if (std::abs(diff) > max_abs_diff)
        max_abs_diff = std::abs(diff);
      if (std::abs(f0) > Tp(10) * eps
       && std::abs(f) > Tp(10) * eps)
        {
          const Tp frac = diff / f0;
          if (std::abs(frac) > max_abs_frac)
            max_abs_frac = std::abs(frac);
        }
    }
  VERIFY(max_abs_frac < Tp(2.5000000000000020e-13));
}

// Test data for n=20, m=10.
testcase_assoc_laguerre<double> data045[] = {
  { 30045015.000000000, 20, 10, 
          0.0000000000000000 },
  { -1755.6226861258590, 20, 10, 
          10.000000000000000 },
  { -9081.6726644737901, 20, 10, 
          20.000000000000000 },
  { 95771.650912113109, 20, 10, 
          30.000000000000000 },
  { 5089151.9272779226, 20, 10, 
          40.000000000000000 },
  { 97400399.450206712, 20, 10, 
          50.000000000000000 },
  { -16009352450.477026, 20, 10, 
          60.000000000000000 },
  { 842271286905.01038, 20, 10, 
          70.000000000000000 },
  { -79901725466796.938, 20, 10, 
          80.000000000000000 },
  { 7944103675858638.0, 20, 10, 
          90.000000000000000 },
  { 5.7429821893388288e+17, 20, 10, 
          100.00000000000000 },
};

// Test function for n=20, m=10.
template <typename Tp>
void test045()
{
  const Tp eps = std::numeric_limits<Tp>::epsilon();
  Tp max_abs_diff = -Tp(1);
  Tp max_abs_frac = -Tp(1);
  unsigned int num_datum = sizeof(data045)
                         / sizeof(testcase_assoc_laguerre<double>);
  for (unsigned int i = 0; i < num_datum; ++i)
    {
      const Tp f = std::tr1::assoc_laguerre(Tp(data045[i].n), Tp(data045[i].m),
                   Tp(data045[i].x));
      const Tp f0 = data045[i].f0;
      const Tp diff = f - f0;
      if (std::abs(diff) > max_abs_diff)
        max_abs_diff = std::abs(diff);
      if (std::abs(f0) > Tp(10) * eps
       && std::abs(f) > Tp(10) * eps)
        {
          const Tp frac = diff / f0;
          if (std::abs(frac) > max_abs_frac)
            max_abs_frac = std::abs(frac);
        }
    }
  VERIFY(max_abs_frac < Tp(2.5000000000000020e-13));
}

// Test data for n=20, m=20.
testcase_assoc_laguerre<double> data046[] = {
  { 137846528819.99994, 20, 20, 
          0.0000000000000000 },
  { -136976.49571333214, 20, 20, 
          10.000000000000000 },
  { 113878.49908041637, 20, 20, 
          20.000000000000000 },
  { -342529.21778796182, 20, 20, 
          30.000000000000000 },
  { -350112.66981443466, 20, 20, 
          40.000000000000000 },
  { -10791735.172977794, 20, 20, 
          50.000000000000000 },
  { -1038073940.0811402, 20, 20, 
          60.000000000000000 },
  { 667312550.63616371, 20, 20, 
          70.000000000000000 },
  { 741537869902.29028, 20, 20, 
          80.000000000000000 },
  { -32378376755737.418, 20, 20, 
          90.000000000000000 },
  { -601760332167934.75, 20, 20, 
          100.00000000000000 },
};

// Test function for n=20, m=20.
template <typename Tp>
void test046()
{
  const Tp eps = std::numeric_limits<Tp>::epsilon();
  Tp max_abs_diff = -Tp(1);
  Tp max_abs_frac = -Tp(1);
  unsigned int num_datum = sizeof(data046)
                         / sizeof(testcase_assoc_laguerre<double>);
  for (unsigned int i = 0; i < num_datum; ++i)
    {
      const Tp f = std::tr1::assoc_laguerre(Tp(data046[i].n), Tp(data046[i].m),
                   Tp(data046[i].x));
      const Tp f0 = data046[i].f0;
      const Tp diff = f - f0;
      if (std::abs(diff) > max_abs_diff)
        max_abs_diff = std::abs(diff);
      if (std::abs(f0) > Tp(10) * eps
       && std::abs(f) > Tp(10) * eps)
        {
          const Tp frac = diff / f0;
          if (std::abs(frac) > max_abs_frac)
            max_abs_frac = std::abs(frac);
        }
    }
  VERIFY(max_abs_frac < Tp(1.0000000000000008e-12));
}

// Test data for n=20, m=50.
testcase_assoc_laguerre<double> data047[] = {
  { 1.6188460366265789e+17, 20, 50, 
          0.0000000000000000 },
  { 1599011936804291.5, 20, 50, 
          10.000000000000000 },
  { -131273880831.42412, 20, 50, 
          20.000000000000000 },
  { -3133213093.6903501, 20, 50, 
          30.000000000000000 },
  { -213935628.04985175, 20, 50, 
          40.000000000000000 },
  { -47375578.495921209, 20, 50, 
          50.000000000000000 },
  { -115731015.14034875, 20, 50, 
          60.000000000000000 },
  { -737415147.29420292, 20, 50, 
          70.000000000000000 },
  { -2123455626.8621781, 20, 50, 
          80.000000000000000 },
  { 29801266858.608925, 20, 50, 
          90.000000000000000 },
  { -132886631026.82561, 20, 50, 
          100.00000000000000 },
};

// Test function for n=20, m=50.
template <typename Tp>
void test047()
{
  const Tp eps = std::numeric_limits<Tp>::epsilon();
  Tp max_abs_diff = -Tp(1);
  Tp max_abs_frac = -Tp(1);
  unsigned int num_datum = sizeof(data047)
                         / sizeof(testcase_assoc_laguerre<double>);
  for (unsigned int i = 0; i < num_datum; ++i)
    {
      const Tp f = std::tr1::assoc_laguerre(Tp(data047[i].n), Tp(data047[i].m),
                   Tp(data047[i].x));
      const Tp f0 = data047[i].f0;
      const Tp diff = f - f0;
      if (std::abs(diff) > max_abs_diff)
        max_abs_diff = std::abs(diff);
      if (std::abs(f0) > Tp(10) * eps
       && std::abs(f) > Tp(10) * eps)
        {
          const Tp frac = diff / f0;
          if (std::abs(frac) > max_abs_frac)
            max_abs_frac = std::abs(frac);
        }
    }
  VERIFY(max_abs_frac < Tp(1.0000000000000008e-12));
}

// Test data for n=20, m=100.
testcase_assoc_laguerre<double> data048[] = {
  { 2.9462227291176643e+22, 20, 100, 
          0.0000000000000000 },
  { 3.5777890748701244e+21, 20, 100, 
          10.000000000000000 },
  { 3.1584925521456765e+20, 20, 100, 
          20.000000000000000 },
  { 1.7389599388424860e+19, 20, 100, 
          30.000000000000000 },
  { 4.1401342745980646e+17, 20, 100, 
          40.000000000000000 },
  { -79359706102062.672, 20, 100, 
          50.000000000000000 },
  { 22736203650743.145, 20, 100, 
          60.000000000000000 },
  { 65679006380.095215, 20, 100, 
          70.000000000000000 },
  { -236263257610.77969, 20, 100, 
          80.000000000000000 },
  { -38072644585.303085, 20, 100, 
          90.000000000000000 },
  { 68236474365.173950, 20, 100, 
          100.00000000000000 },
};

// Test function for n=20, m=100.
template <typename Tp>
void test048()
{
  const Tp eps = std::numeric_limits<Tp>::epsilon();
  Tp max_abs_diff = -Tp(1);
  Tp max_abs_frac = -Tp(1);
  unsigned int num_datum = sizeof(data048)
                         / sizeof(testcase_assoc_laguerre<double>);
  for (unsigned int i = 0; i < num_datum; ++i)
    {
      const Tp f = std::tr1::assoc_laguerre(Tp(data048[i].n), Tp(data048[i].m),
                   Tp(data048[i].x));
      const Tp f0 = data048[i].f0;
      const Tp diff = f - f0;
      if (std::abs(diff) > max_abs_diff)
        max_abs_diff = std::abs(diff);
      if (std::abs(f0) > Tp(10) * eps
       && std::abs(f) > Tp(10) * eps)
        {
          const Tp frac = diff / f0;
          if (std::abs(frac) > max_abs_frac)
            max_abs_frac = std::abs(frac);
        }
    }
  VERIFY(max_abs_frac < Tp(2.5000000000000015e-12));
}

// Test data for n=50, m=0.
testcase_assoc_laguerre<double> data049[] = {
  { 1.0000000000000000, 50, 0, 
          0.0000000000000000 },
  { 17.534183446338233, 50, 0, 
          10.000000000000000 },
  { 980.26961889790766, 50, 0, 
          20.000000000000000 },
  { 293000.50735962350, 50, 0, 
          30.000000000000000 },
  { -14896937.968694847, 50, 0, 
          40.000000000000000 },
  { 2513677852.6916885, 50, 0, 
          50.000000000000000 },
  { -883876565337.99207, 50, 0, 
          60.000000000000000 },
  { -80967880733583.219, 50, 0, 
          70.000000000000000 },
  { -8217471769564850.0, 50, 0, 
          80.000000000000000 },
  { -2.1140031308048906e+18, 50, 0, 
          90.000000000000000 },
  { -3.9710103487094673e+20, 50, 0, 
          100.00000000000000 },
};

// Test function for n=50, m=0.
template <typename Tp>
void test049()
{
  const Tp eps = std::numeric_limits<Tp>::epsilon();
  Tp max_abs_diff = -Tp(1);
  Tp max_abs_frac = -Tp(1);
  unsigned int num_datum = sizeof(data049)
                         / sizeof(testcase_assoc_laguerre<double>);
  for (unsigned int i = 0; i < num_datum; ++i)
    {
      const Tp f = std::tr1::assoc_laguerre(Tp(data049[i].n), Tp(data049[i].m),
                   Tp(data049[i].x));
      const Tp f0 = data049[i].f0;
      const Tp diff = f - f0;
      if (std::abs(diff) > max_abs_diff)
        max_abs_diff = std::abs(diff);
      if (std::abs(f0) > Tp(10) * eps
       && std::abs(f) > Tp(10) * eps)
        {
          const Tp frac = diff / f0;
          if (std::abs(frac) > max_abs_frac)
            max_abs_frac = std::abs(frac);
        }
    }
  VERIFY(max_abs_frac < Tp(2.5000000000000020e-13));
}

// Test data for n=50, m=1.
testcase_assoc_laguerre<double> data050[] = {
  { 51.000000000000021, 50, 1, 
          0.0000000000000000 },
  { 1.4214573271640045, 50, 1, 
          10.000000000000000 },
  { -2574.8072295127863, 50, 1, 
          20.000000000000000 },
  { 35846.479728359256, 50, 1, 
          30.000000000000000 },
  { -48263698.768318526, 50, 1, 
          40.000000000000000 },
  { 6161525870.2738571, 50, 1, 
          50.000000000000000 },
  { -382655486658.47101, 50, 1, 
          60.000000000000000 },
  { -109635579833241.69, 50, 1, 
          70.000000000000000 },
  { -14623805817283476., 50, 1, 
          80.000000000000000 },
  { -2.0666847190878118e+18, 50, 1, 
          90.000000000000000 },
  { -1.4385187953997626e+20, 50, 1, 
          100.00000000000000 },
};

// Test function for n=50, m=1.
template <typename Tp>
void test050()
{
  const Tp eps = std::numeric_limits<Tp>::epsilon();
  Tp max_abs_diff = -Tp(1);
  Tp max_abs_frac = -Tp(1);
  unsigned int num_datum = sizeof(data050)
                         / sizeof(testcase_assoc_laguerre<double>);
  for (unsigned int i = 0; i < num_datum; ++i)
    {
      const Tp f = std::tr1::assoc_laguerre(Tp(data050[i].n), Tp(data050[i].m),
                   Tp(data050[i].x));
      const Tp f0 = data050[i].f0;
      const Tp diff = f - f0;
      if (std::abs(diff) > max_abs_diff)
        max_abs_diff = std::abs(diff);
      if (std::abs(f0) > Tp(10) * eps
       && std::abs(f) > Tp(10) * eps)
        {
          const Tp frac = diff / f0;
          if (std::abs(frac) > max_abs_frac)
            max_abs_frac = std::abs(frac);
        }
    }
  VERIFY(max_abs_frac < Tp(5.0000000000000029e-12));
}

// Test data for n=50, m=2.
testcase_assoc_laguerre<double> data051[] = {
  { 1326.0000000000000, 50, 2, 
          0.0000000000000000 },
  { -87.860732516444671, 50, 2, 
          10.000000000000000 },
  { -5203.2351191780890, 50, 2, 
          20.000000000000000 },
  { -461059.50012538873, 50, 2, 
          30.000000000000000 },
  { -30476695.327440601, 50, 2, 
          40.000000000000000 },
  { 3720804977.9338136, 50, 2, 
          50.000000000000000 },
  { 362262002434.51440, 50, 2, 
          60.000000000000000 },
  { -52210917867820.273, 50, 2, 
          70.000000000000000 },
  { -9567965136901918.0, 50, 2, 
          80.000000000000000 },
  { -8.9171277517712806e+17, 50, 2, 
          90.000000000000000 },
  { 5.7231129448807039e+19, 50, 2, 
          100.00000000000000 },
};

// Test function for n=50, m=2.
template <typename Tp>
void test051()
{
  const Tp eps = std::numeric_limits<Tp>::epsilon();
  Tp max_abs_diff = -Tp(1);
  Tp max_abs_frac = -Tp(1);
  unsigned int num_datum = sizeof(data051)
                         / sizeof(testcase_assoc_laguerre<double>);
  for (unsigned int i = 0; i < num_datum; ++i)
    {
      const Tp f = std::tr1::assoc_laguerre(Tp(data051[i].n), Tp(data051[i].m),
                   Tp(data051[i].x));
      const Tp f0 = data051[i].f0;
      const Tp diff = f - f0;
      if (std::abs(diff) > max_abs_diff)
        max_abs_diff = std::abs(diff);
      if (std::abs(f0) > Tp(10) * eps
       && std::abs(f) > Tp(10) * eps)
        {
          const Tp frac = diff / f0;
          if (std::abs(frac) > max_abs_frac)
            max_abs_frac = std::abs(frac);
        }
    }
  VERIFY(max_abs_frac < Tp(2.5000000000000020e-13));
}

// Test data for n=50, m=5.
testcase_assoc_laguerre<double> data052[] = {
  { 3478761.0000000000, 50, 5, 
          0.0000000000000000 },
  { 1055.8381917651493, 50, 5, 
          10.000000000000000 },
  { 15264.646660345048, 50, 5, 
          20.000000000000000 },
  { 1229651.8966600855, 50, 5, 
          30.000000000000000 },
  { 39270451.823656857, 50, 5, 
          40.000000000000000 },
  { -4424062601.1152067, 50, 5, 
          50.000000000000000 },
  { -186017434284.19220, 50, 5, 
          60.000000000000000 },
  { 50972853949302.602, 50, 5, 
          70.000000000000000 },
  { 6530702754012518.0, 50, 5, 
          80.000000000000000 },
  { 6.8387592714678016e+17, 50, 5, 
          90.000000000000000 },
  { 3.9198742504338366e+19, 50, 5, 
          100.00000000000000 },
};

// Test function for n=50, m=5.
template <typename Tp>
void test052()
{
  const Tp eps = std::numeric_limits<Tp>::epsilon();
  Tp max_abs_diff = -Tp(1);
  Tp max_abs_frac = -Tp(1);
  unsigned int num_datum = sizeof(data052)
                         / sizeof(testcase_assoc_laguerre<double>);
  for (unsigned int i = 0; i < num_datum; ++i)
    {
      const Tp f = std::tr1::assoc_laguerre(Tp(data052[i].n), Tp(data052[i].m),
                   Tp(data052[i].x));
      const Tp f0 = data052[i].f0;
      const Tp diff = f - f0;
      if (std::abs(diff) > max_abs_diff)
        max_abs_diff = std::abs(diff);
      if (std::abs(f0) > Tp(10) * eps
       && std::abs(f) > Tp(10) * eps)
        {
          const Tp frac = diff / f0;
          if (std::abs(frac) > max_abs_frac)
            max_abs_frac = std::abs(frac);
        }
    }
  VERIFY(max_abs_frac < Tp(2.5000000000000020e-13));
}

// Test data for n=50, m=10.
testcase_assoc_laguerre<double> data053[] = {
  { 75394027565.999985, 50, 10, 
          0.0000000000000000 },
  { 91833.924098770134, 50, 10, 
          10.000000000000000 },
  { 330501.87929778261, 50, 10, 
          20.000000000000000 },
  { 3625088.1635972545, 50, 10, 
          30.000000000000000 },
  { 213954727.28632003, 50, 10, 
          40.000000000000000 },
  { -9381006937.7517643, 50, 10, 
          50.000000000000000 },
  { 535333683777.48627, 50, 10, 
          60.000000000000000 },
  { 18824406573722.156, 50, 10, 
          70.000000000000000 },
  { -533858276780012.81, 50, 10, 
          80.000000000000000 },
  { -52995774666704024., 50, 10, 
          90.000000000000000 },
  { 6.0504182862448855e+18, 50, 10, 
          100.00000000000000 },
};

// Test function for n=50, m=10.
template <typename Tp>
void test053()
{
  const Tp eps = std::numeric_limits<Tp>::epsilon();
  Tp max_abs_diff = -Tp(1);
  Tp max_abs_frac = -Tp(1);
  unsigned int num_datum = sizeof(data053)
                         / sizeof(testcase_assoc_laguerre<double>);
  for (unsigned int i = 0; i < num_datum; ++i)
    {
      const Tp f = std::tr1::assoc_laguerre(Tp(data053[i].n), Tp(data053[i].m),
                   Tp(data053[i].x));
      const Tp f0 = data053[i].f0;
      const Tp diff = f - f0;
      if (std::abs(diff) > max_abs_diff)
        max_abs_diff = std::abs(diff);
      if (std::abs(f0) > Tp(10) * eps
       && std::abs(f) > Tp(10) * eps)
        {
          const Tp frac = diff / f0;
          if (std::abs(frac) > max_abs_frac)
            max_abs_frac = std::abs(frac);
        }
    }
  VERIFY(max_abs_frac < Tp(2.5000000000000020e-13));
}

// Test data for n=50, m=20.
testcase_assoc_laguerre<double> data054[] = {
  { 1.6188460366265779e+17, 50, 20, 
          0.0000000000000000 },
  { -307637087.25169420, 50, 20, 
          10.000000000000000 },
  { 12524651.102974579, 50, 20, 
          20.000000000000000 },
  { -315460483.86210549, 50, 20, 
          30.000000000000000 },
  { -1889683587.3459976, 50, 20, 
          40.000000000000000 },
  { 37457044404.200340, 50, 20, 
          50.000000000000000 },
  { -843831858224.71826, 50, 20, 
          60.000000000000000 },
  { -92231643172.313248, 50, 20, 
          70.000000000000000 },
  { 904211757769501.25, 50, 20, 
          80.000000000000000 },
  { 46508193600283288., 50, 20, 
          90.000000000000000 },
  { 2.3216887928162714e+18, 50, 20, 
          100.00000000000000 },
};

// Test function for n=50, m=20.
template <typename Tp>
void test054()
{
  const Tp eps = std::numeric_limits<Tp>::epsilon();
  Tp max_abs_diff = -Tp(1);
  Tp max_abs_frac = -Tp(1);
  unsigned int num_datum = sizeof(data054)
                         / sizeof(testcase_assoc_laguerre<double>);
  for (unsigned int i = 0; i < num_datum; ++i)
    {
      const Tp f = std::tr1::assoc_laguerre(Tp(data054[i].n), Tp(data054[i].m),
                   Tp(data054[i].x));
      const Tp f0 = data054[i].f0;
      const Tp diff = f - f0;
      if (std::abs(diff) > max_abs_diff)
        max_abs_diff = std::abs(diff);
      if (std::abs(f0) > Tp(10) * eps
       && std::abs(f) > Tp(10) * eps)
        {
          const Tp frac = diff / f0;
          if (std::abs(frac) > max_abs_frac)
            max_abs_frac = std::abs(frac);
        }
    }
  VERIFY(max_abs_frac < Tp(2.5000000000000015e-12));
}

// Test data for n=50, m=50.
testcase_assoc_laguerre<double> data055[] = {
  { 1.0089134454556417e+29, 50, 50, 
          0.0000000000000000 },
  { 1.3822795753070569e+23, 50, 50, 
          10.000000000000000 },
  { 95817260381628416., 50, 50, 
          20.000000000000000 },
  { -910798580856013.88, 50, 50, 
          30.000000000000000 },
  { 50513254049166.719, 50, 50, 
          40.000000000000000 },
  { 84159703903349.859, 50, 50, 
          50.000000000000000 },
  { -138805244691822.69, 50, 50, 
          60.000000000000000 },
  { 181046391269246.25, 50, 50, 
          70.000000000000000 },
  { 2086884905317107.2, 50, 50, 
          80.000000000000000 },
  { -2765620139862432.5, 50, 50, 
          90.000000000000000 },
  { -1.3706751678146291e+17, 50, 50, 
          100.00000000000000 },
};

// Test function for n=50, m=50.
template <typename Tp>
void test055()
{
  const Tp eps = std::numeric_limits<Tp>::epsilon();
  Tp max_abs_diff = -Tp(1);
  Tp max_abs_frac = -Tp(1);
  unsigned int num_datum = sizeof(data055)
                         / sizeof(testcase_assoc_laguerre<double>);
  for (unsigned int i = 0; i < num_datum; ++i)
    {
      const Tp f = std::tr1::assoc_laguerre(Tp(data055[i].n), Tp(data055[i].m),
                   Tp(data055[i].x));
      const Tp f0 = data055[i].f0;
      const Tp diff = f - f0;
      if (std::abs(diff) > max_abs_diff)
        max_abs_diff = std::abs(diff);
      if (std::abs(f0) > Tp(10) * eps
       && std::abs(f) > Tp(10) * eps)
        {
          const Tp frac = diff / f0;
          if (std::abs(frac) > max_abs_frac)
            max_abs_frac = std::abs(frac);
        }
    }
  VERIFY(max_abs_frac < Tp(5.0000000000000039e-13));
}

// Test data for n=50, m=100.
testcase_assoc_laguerre<double> data056[] = {
  { 2.0128660909731929e+40, 50, 100, 
          0.0000000000000000 },
  { 9.3675094807695474e+37, 50, 100, 
          10.000000000000000 },
  { 1.3009321481877196e+35, 50, 100, 
          20.000000000000000 },
  { 7.3720026893233823e+30, 50, 100, 
          30.000000000000000 },
  { -6.0824679079634607e+25, 50, 100, 
          40.000000000000000 },
  { -6.0053188793543624e+23, 50, 100, 
          50.000000000000000 },
  { 1.4178129287264701e+22, 50, 100, 
          60.000000000000000 },
  { -5.4652099341566765e+20, 50, 100, 
          70.000000000000000 },
  { -1.0817271759263398e+20, 50, 100, 
          80.000000000000000 },
  { 3.8058734007924187e+19, 50, 100, 
          90.000000000000000 },
  { 4.7439240848028353e+19, 50, 100, 
          100.00000000000000 },
};

// Test function for n=50, m=100.
template <typename Tp>
void test056()
{
  const Tp eps = std::numeric_limits<Tp>::epsilon();
  Tp max_abs_diff = -Tp(1);
  Tp max_abs_frac = -Tp(1);
  unsigned int num_datum = sizeof(data056)
                         / sizeof(testcase_assoc_laguerre<double>);
  for (unsigned int i = 0; i < num_datum; ++i)
    {
      const Tp f = std::tr1::assoc_laguerre(Tp(data056[i].n), Tp(data056[i].m),
                   Tp(data056[i].x));
      const Tp f0 = data056[i].f0;
      const Tp diff = f - f0;
      if (std::abs(diff) > max_abs_diff)
        max_abs_diff = std::abs(diff);
      if (std::abs(f0) > Tp(10) * eps
       && std::abs(f) > Tp(10) * eps)
        {
          const Tp frac = diff / f0;
          if (std::abs(frac) > max_abs_frac)
            max_abs_frac = std::abs(frac);
        }
    }
  VERIFY(max_abs_frac < Tp(2.5000000000000015e-12));
}

// Test data for n=100, m=0.
testcase_assoc_laguerre<double> data057[] = {
  { 1.0000000000000000, 100, 0, 
          0.0000000000000000 },
  { 13.277662844303402, 100, 0, 
          10.000000000000000 },
  { 1854.0367283243393, 100, 0, 
          20.000000000000000 },
  { 170141.86987046539, 100, 0, 
          30.000000000000000 },
  { -7272442.3156007063, 100, 0, 
          40.000000000000000 },
  { 4847420871.2690468, 100, 0, 
          50.000000000000000 },
  { 693492765740.29736, 100, 0, 
          60.000000000000000 },
  { 17125518672239.707, 100, 0, 
          70.000000000000000 },
  { -13763178176383754., 100, 0, 
          80.000000000000000 },
  { 2.1307220490380198e+18, 100, 0, 
          90.000000000000000 },
  { -2.6292260693068920e+20, 100, 0, 
          100.00000000000000 },
};

// Test function for n=100, m=0.
template <typename Tp>
void test057()
{
  const Tp eps = std::numeric_limits<Tp>::epsilon();
  Tp max_abs_diff = -Tp(1);
  Tp max_abs_frac = -Tp(1);
  unsigned int num_datum = sizeof(data057)
                         / sizeof(testcase_assoc_laguerre<double>);
  for (unsigned int i = 0; i < num_datum; ++i)
    {
      const Tp f = std::tr1::assoc_laguerre(Tp(data057[i].n), Tp(data057[i].m),
                   Tp(data057[i].x));
      const Tp f0 = data057[i].f0;
      const Tp diff = f - f0;
      if (std::abs(diff) > max_abs_diff)
        max_abs_diff = std::abs(diff);
      if (std::abs(f0) > Tp(10) * eps
       && std::abs(f) > Tp(10) * eps)
        {
          const Tp frac = diff / f0;
          if (std::abs(frac) > max_abs_frac)
            max_abs_frac = std::abs(frac);
        }
    }
  VERIFY(max_abs_frac < Tp(2.5000000000000020e-13));
}

// Test data for n=100, m=1.
testcase_assoc_laguerre<double> data058[] = {
  { 101.00000000000003, 100, 1, 
          0.0000000000000000 },
  { -14.650661983680466, 100, 1, 
          10.000000000000000 },
  { 1626.5010939361609, 100, 1, 
          20.000000000000000 },
  { 417884.77658268705, 100, 1, 
          30.000000000000000 },
  { -55617646.951649830, 100, 1, 
          40.000000000000000 },
  { 884829874.26626098, 100, 1, 
          50.000000000000000 },
  { 154466082750.32114, 100, 1, 
          60.000000000000000 },
  { -101423973484646.05, 100, 1, 
          70.000000000000000 },
  { -1388352348671755.5, 100, 1, 
          80.000000000000000 },
  { 7.8048705513268326e+17, 100, 1, 
          90.000000000000000 },
  { 1.6948925059042787e+19, 100, 1, 
          100.00000000000000 },
};

// Test function for n=100, m=1.
template <typename Tp>
void test058()
{
  const Tp eps = std::numeric_limits<Tp>::epsilon();
  Tp max_abs_diff = -Tp(1);
  Tp max_abs_frac = -Tp(1);
  unsigned int num_datum = sizeof(data058)
                         / sizeof(testcase_assoc_laguerre<double>);
  for (unsigned int i = 0; i < num_datum; ++i)
    {
      const Tp f = std::tr1::assoc_laguerre(Tp(data058[i].n), Tp(data058[i].m),
                   Tp(data058[i].x));
      const Tp f0 = data058[i].f0;
      const Tp diff = f - f0;
      if (std::abs(diff) > max_abs_diff)
        max_abs_diff = std::abs(diff);
      if (std::abs(f0) > Tp(10) * eps
       && std::abs(f) > Tp(10) * eps)
        {
          const Tp frac = diff / f0;
          if (std::abs(frac) > max_abs_frac)
            max_abs_frac = std::abs(frac);
        }
    }
  VERIFY(max_abs_frac < Tp(1.0000000000000008e-12));
}

// Test data for n=100, m=2.
testcase_assoc_laguerre<double> data059[] = {
  { 5151.0000000000055, 100, 2, 
          0.0000000000000000 },
  { -150.22012290951341, 100, 2, 
          10.000000000000000 },
  { -7655.0593294049440, 100, 2, 
          20.000000000000000 },
  { -140996.69276179170, 100, 2, 
          30.000000000000000 },
  { -38645171.278549291, 100, 2, 
          40.000000000000000 },
  { -8889263688.2118778, 100, 2, 
          50.000000000000000 },
  { -1010338971533.3397, 100, 2, 
          60.000000000000000 },
  { -127582564332943.91, 100, 2, 
          70.000000000000000 },
  { 15970305694654336., 100, 2, 
          80.000000000000000 },
  { -1.6019844992862840e+18, 100, 2, 
          90.000000000000000 },
  { 2.8267024730962919e+20, 100, 2, 
          100.00000000000000 },
};

// Test function for n=100, m=2.
template <typename Tp>
void test059()
{
  const Tp eps = std::numeric_limits<Tp>::epsilon();
  Tp max_abs_diff = -Tp(1);
  Tp max_abs_frac = -Tp(1);
  unsigned int num_datum = sizeof(data059)
                         / sizeof(testcase_assoc_laguerre<double>);
  for (unsigned int i = 0; i < num_datum; ++i)
    {
      const Tp f = std::tr1::assoc_laguerre(Tp(data059[i].n), Tp(data059[i].m),
                   Tp(data059[i].x));
      const Tp f0 = data059[i].f0;
      const Tp diff = f - f0;
      if (std::abs(diff) > max_abs_diff)
        max_abs_diff = std::abs(diff);
      if (std::abs(f0) > Tp(10) * eps
       && std::abs(f) > Tp(10) * eps)
        {
          const Tp frac = diff / f0;
          if (std::abs(frac) > max_abs_frac)
            max_abs_frac = std::abs(frac);
        }
    }
  VERIFY(max_abs_frac < Tp(2.5000000000000020e-13));
}

// Test data for n=100, m=5.
testcase_assoc_laguerre<double> data060[] = {
  { 96560646.000000030, 100, 5, 
          0.0000000000000000 },
  { 2430.6732236677576, 100, 5, 
          10.000000000000000 },
  { 111162.32026994640, 100, 5, 
          20.000000000000000 },
  { 4036708.2599413753, 100, 5, 
          30.000000000000000 },
  { -34055982.664405435, 100, 5, 
          40.000000000000000 },
  { 30110688343.562344, 100, 5, 
          50.000000000000000 },
  { 2651429940558.2920, 100, 5, 
          60.000000000000000 },
  { 192108556058942.84, 100, 5, 
          70.000000000000000 },
  { -25410533973455528., 100, 5, 
          80.000000000000000 },
  { 2.1072955633564431e+18, 100, 5, 
          90.000000000000000 },
  { -2.9434005355877260e+20, 100, 5, 
          100.00000000000000 },
};

// Test function for n=100, m=5.
template <typename Tp>
void test060()
{
  const Tp eps = std::numeric_limits<Tp>::epsilon();
  Tp max_abs_diff = -Tp(1);
  Tp max_abs_frac = -Tp(1);
  unsigned int num_datum = sizeof(data060)
                         / sizeof(testcase_assoc_laguerre<double>);
  for (unsigned int i = 0; i < num_datum; ++i)
    {
      const Tp f = std::tr1::assoc_laguerre(Tp(data060[i].n), Tp(data060[i].m),
                   Tp(data060[i].x));
      const Tp f0 = data060[i].f0;
      const Tp diff = f - f0;
      if (std::abs(diff) > max_abs_diff)
        max_abs_diff = std::abs(diff);
      if (std::abs(f0) > Tp(10) * eps
       && std::abs(f) > Tp(10) * eps)
        {
          const Tp frac = diff / f0;
          if (std::abs(frac) > max_abs_frac)
            max_abs_frac = std::abs(frac);
        }
    }
  VERIFY(max_abs_frac < Tp(5.0000000000000039e-13));
}

// Test data for n=100, m=10.
testcase_assoc_laguerre<double> data061[] = {
  { 46897636623981.039, 100, 10, 
          0.0000000000000000 },
  { 529208.11550990446, 100, 10, 
          10.000000000000000 },
  { 7402892.1748803742, 100, 10, 
          20.000000000000000 },
  { 88369632.083243459, 100, 10, 
          30.000000000000000 },
  { 822187797.59096730, 100, 10, 
          40.000000000000000 },
  { 180231446033.06866, 100, 10, 
          50.000000000000000 },
  { 7922942703798.1309, 100, 10, 
          60.000000000000000 },
  { 784424250559043.38, 100, 10, 
          70.000000000000000 },
  { -16325634720239362., 100, 10, 
          80.000000000000000 },
  { -1.0879588307443181e+18, 100, 10, 
          90.000000000000000 },
  { 3.0114394463610495e+19, 100, 10, 
          100.00000000000000 },
};

// Test function for n=100, m=10.
template <typename Tp>
void test061()
{
  const Tp eps = std::numeric_limits<Tp>::epsilon();
  Tp max_abs_diff = -Tp(1);
  Tp max_abs_frac = -Tp(1);
  unsigned int num_datum = sizeof(data061)
                         / sizeof(testcase_assoc_laguerre<double>);
  for (unsigned int i = 0; i < num_datum; ++i)
    {
      const Tp f = std::tr1::assoc_laguerre(Tp(data061[i].n), Tp(data061[i].m),
                   Tp(data061[i].x));
      const Tp f0 = data061[i].f0;
      const Tp diff = f - f0;
      if (std::abs(diff) > max_abs_diff)
        max_abs_diff = std::abs(diff);
      if (std::abs(f0) > Tp(10) * eps
       && std::abs(f) > Tp(10) * eps)
        {
          const Tp frac = diff / f0;
          if (std::abs(frac) > max_abs_frac)
            max_abs_frac = std::abs(frac);
        }
    }
  VERIFY(max_abs_frac < Tp(1.0000000000000008e-12));
}

// Test data for n=100, m=20.
testcase_assoc_laguerre<double> data062[] = {
  { 2.9462227291176614e+22, 100, 20, 
          0.0000000000000000 },
  { 313694958939.90436, 100, 20, 
          10.000000000000000 },
  { 45396489338.096252, 100, 20, 
          20.000000000000000 },
  { -7215826758.0078783, 100, 20, 
          30.000000000000000 },
  { 825949194005.88831, 100, 20, 
          40.000000000000000 },
  { -2764742119971.0747, 100, 20, 
          50.000000000000000 },
  { -219802198273516.03, 100, 20, 
          60.000000000000000 },
  { -1699053306145266.0, 100, 20, 
          70.000000000000000 },
  { 3.5495709345023853e+17, 100, 20, 
          80.000000000000000 },
  { -9.6128675110292439e+18, 100, 20, 
          90.000000000000000 },
  { 4.3619868422072153e+20, 100, 20, 
          100.00000000000000 },
};

// Test function for n=100, m=20.
template <typename Tp>
void test062()
{
  const Tp eps = std::numeric_limits<Tp>::epsilon();
  Tp max_abs_diff = -Tp(1);
  Tp max_abs_frac = -Tp(1);
  unsigned int num_datum = sizeof(data062)
                         / sizeof(testcase_assoc_laguerre<double>);
  for (unsigned int i = 0; i < num_datum; ++i)
    {
      const Tp f = std::tr1::assoc_laguerre(Tp(data062[i].n), Tp(data062[i].m),
                   Tp(data062[i].x));
      const Tp f0 = data062[i].f0;
      const Tp diff = f - f0;
      if (std::abs(diff) > max_abs_diff)
        max_abs_diff = std::abs(diff);
      if (std::abs(f0) > Tp(10) * eps
       && std::abs(f) > Tp(10) * eps)
        {
          const Tp frac = diff / f0;
          if (std::abs(frac) > max_abs_frac)
            max_abs_frac = std::abs(frac);
        }
    }
  VERIFY(max_abs_frac < Tp(2.5000000000000020e-13));
}

// Test data for n=100, m=50.
testcase_assoc_laguerre<double> data063[] = {
  { 2.0128660909731931e+40, 100, 50, 
          0.0000000000000000 },
  { -4.0151443913473681e+28, 100, 50, 
          10.000000000000000 },
  { 3.2199632594552201e+22, 100, 50, 
          20.000000000000000 },
  { -2.7568702092659717e+20, 100, 50, 
          30.000000000000000 },
  { 7.5553066015421530e+19, 100, 50, 
          40.000000000000000 },
  { -2.7651625252388041e+19, 100, 50, 
          50.000000000000000 },
  { -5.8963680147283821e+19, 100, 50, 
          60.000000000000000 },
  { -1.8082798163033126e+20, 100, 50, 
          70.000000000000000 },
  { -3.9044276986817249e+20, 100, 50, 
          80.000000000000000 },
  { 6.9926310700401904e+21, 100, 50, 
          90.000000000000000 },
  { -5.5727272809923697e+22, 100, 50, 
          100.00000000000000 },
};

// Test function for n=100, m=50.
template <typename Tp>
void test063()
{
  const Tp eps = std::numeric_limits<Tp>::epsilon();
  Tp max_abs_diff = -Tp(1);
  Tp max_abs_frac = -Tp(1);
  unsigned int num_datum = sizeof(data063)
                         / sizeof(testcase_assoc_laguerre<double>);
  for (unsigned int i = 0; i < num_datum; ++i)
    {
      const Tp f = std::tr1::assoc_laguerre(Tp(data063[i].n), Tp(data063[i].m),
                   Tp(data063[i].x));
      const Tp f0 = data063[i].f0;
      const Tp diff = f - f0;
      if (std::abs(diff) > max_abs_diff)
        max_abs_diff = std::abs(diff);
      if (std::abs(f0) > Tp(10) * eps
       && std::abs(f) > Tp(10) * eps)
        {
          const Tp frac = diff / f0;
          if (std::abs(frac) > max_abs_frac)
            max_abs_frac = std::abs(frac);
        }
    }
  VERIFY(max_abs_frac < Tp(1.0000000000000008e-12));
}

// Test data for n=100, m=100.
testcase_assoc_laguerre<double> data064[] = {
  { 9.0548514656103225e+58, 100, 100, 
          0.0000000000000000 },
  { 1.3334078033060576e+54, 100, 100, 
          10.000000000000000 },
  { 2.1002639254211231e+46, 100, 100, 
          20.000000000000000 },
  { -1.1073158068796240e+39, 100, 100, 
          30.000000000000000 },
  { -8.3640937363981405e+35, 100, 100, 
          40.000000000000000 },
  { -6.5879339429312671e+32, 100, 100, 
          50.000000000000000 },
  { -2.4190645077698453e+30, 100, 100, 
          60.000000000000000 },
  { -7.9224960465662002e+29, 100, 100, 
          70.000000000000000 },
  { -2.8605772478408853e+29, 100, 100, 
          80.000000000000000 },
  { 2.4149589189610125e+28, 100, 100, 
          90.000000000000000 },
  { 5.1146476014859003e+28, 100, 100, 
          100.00000000000000 },
};

// Test function for n=100, m=100.
template <typename Tp>
void test064()
{
  const Tp eps = std::numeric_limits<Tp>::epsilon();
  Tp max_abs_diff = -Tp(1);
  Tp max_abs_frac = -Tp(1);
  unsigned int num_datum = sizeof(data064)
                         / sizeof(testcase_assoc_laguerre<double>);
  for (unsigned int i = 0; i < num_datum; ++i)
    {
      const Tp f = std::tr1::assoc_laguerre(Tp(data064[i].n), Tp(data064[i].m),
                   Tp(data064[i].x));
      const Tp f0 = data064[i].f0;
      const Tp diff = f - f0;
      if (std::abs(diff) > max_abs_diff)
        max_abs_diff = std::abs(diff);
      if (std::abs(f0) > Tp(10) * eps
       && std::abs(f) > Tp(10) * eps)
        {
          const Tp frac = diff / f0;
          if (std::abs(frac) > max_abs_frac)
            max_abs_frac = std::abs(frac);
        }
    }
  VERIFY(max_abs_frac < Tp(2.5000000000000015e-12));
}

int main(int, char**)
{
  test001<double>();
  test002<double>();
  test003<double>();
  test004<double>();
  test005<double>();
  test006<double>();
  test007<double>();
  test008<double>();
  test009<double>();
  test010<double>();
  test011<double>();
  test012<double>();
  test013<double>();
  test014<double>();
  test015<double>();
  test016<double>();
  test017<double>();
  test018<double>();
  test019<double>();
  test020<double>();
  test021<double>();
  test022<double>();
  test023<double>();
  test024<double>();
  test025<double>();
  test026<double>();
  test027<double>();
  test028<double>();
  test029<double>();
  test030<double>();
  test031<double>();
  test032<double>();
  test033<double>();
  test034<double>();
  test035<double>();
  test036<double>();
  test037<double>();
  test038<double>();
  test039<double>();
  test040<double>();
  test041<double>();
  test042<double>();
  test043<double>();
  test044<double>();
  test045<double>();
  test046<double>();
  test047<double>();
  test048<double>();
  test049<double>();
  test050<double>();
  test051<double>();
  test052<double>();
  test053<double>();
  test054<double>();
  test055<double>();
  test056<double>();
  test057<double>();
  test058<double>();
  test059<double>();
  test060<double>();
  test061<double>();
  test062<double>();
  test063<double>();
  test064<double>();
  return 0;
}
