%define ver      	1.1.0
%define RELEASE 	1
%define rel     	%{?CUSTOM_RELEASE} %{!?CUSTOM_RELEASE:%RELEASE}
%define prefix		/usr
%define canvaspackage	%(if rpm -q redhat-release &> /dev/null; then echo gdk-pixbuf-gnome; elif rpm -q mandrake-release &> /dev/null; then echo gdk-pixbuf-gnomecanvas; else echo; fi)

Summary: GCompris / I Have Understood.
Name: 		gcompris
Version: 	%ver
Release: 	%rel
Copyright: 	GPL
Group: 		Amusements/Games
Source:		ftp://gcompris.sourceforge.net/gcompris-%{PACKAGE_VERSION}.tgz
BuildRoot: 	/var/tmp/gcompris-%{PACKAGE_VERSION}-root
URL: 		http://savannah.gnu.org
Docdir: 	%{prefix}/share/doc/gcompris-%{PACKAGE_VERSION}
Requires:	gnome-libs libxml2 gdk-pixbuf %canvaspackage
Packager:       Bruno Coudoin <bcoudoin.coudoin@free.fr>

%description
GCompris / I Have Understood is an educationnal game for children starting at 3.
Today several Boards are implemented:
* Click on the animals => learn the mouse/click usage
* Type the falling letters => learn the keyboard usage
* Falling Dices
* Falling words
* Basic algebra
* Time learning with an analog clock
* Puzzle game with famous paintings
* Drive Plane to catch clouds in increasing number
* Balance the scales
* And much more ...

The Game is included in the Gnome Desktop under the Game menu.

You should install it only if you have children using this computer.

%description -l fr
GCompris / J'ai Compris est un logiciel ducatif pour les enfants 
 partir de 3 ans.

Aujourd'hui, plusieurs tableaux sont implments :
* Cliquer sur les animaux => apprentissage du click et de la souris
* Entrer les lettres qui tombent => Apprentissage du clavier
* Les ds qui tombent
* Les mots qui tombent
* Algbre simple
* Apprentissage de la lecture de l'heure sur une horloge analogique
* Puzzle avec des tableaux clbres
* Pilote un avion pour attraper les nuages dans l'ordre
* Equilibre la balance

Le jeu est inclus dans le bureau Gnome sous le menu Jeux.

 installer si vous avez des enfants utilisant cet ordinateur.

%changelog
* Thu Dec 27 2001  Christian Rose  <menthos@menthos.com>
- gcompris.spec.in: Added fix for the different namings of
-                   the gnomecanvas packages on Mandrake
-                   and Red Hat systems. Also removed references
-                   to dependencies in the descriptions.
* Sun Sep 30 2001  Bruno Coudoin  <bruno.coudoin@free.fr>
- GCompris: Release 0.7.5
- TRANSLATION IS FIXED

* Fri May 25 2001  Bruno Coudoin  <bruno.coudoin@free.fr>
- TRANSLATION IS BROKEN
- WARNING: THE HIGHLIGHTING IS BROKEN
- ALL: Replace the imlib for images by the gdk-pixbuf library
- gcompris.spec.in: Added back the gcompris icon pixmap
- clickgame.c: Limit the number of fish to 5
- clickgame.c: Simplified the code by removing one hashtable.
- shapegame.c: Changed the board order to have the most difficult
               at the higher level (as suggested by Yann Dirson)
	       Added the method shuffle_shape_list()
- gcompris.c (end_game): reset the timer in the status bar
- Makefile.am: Added DESTDIR prefix in the install hooks
- ALL: Boards are now separated from gcompris in src/
- boards/*: All boards are defined as independant plugins
- gcompris/*: Added the necessary glue to load the plugins
- configure.in: Removed PACKAGE_PIXMAPS_DIR
- data/*: The data directory has been renamed in boards
- pixmaps/*: The pixmaps directory has been moved to board/gcompris
             This will be the default gcompris icons. Other icons
             have been moved in a dir specific to their boards.
- boards/planegame.c: Set a max speed for the plane because children
		      have difficulties to manipulate it.
- docs/C/gcompris.texi: Update of the doc to explain the new plugin
                        mecanism

* Wed Apr 11 2001  Bruno Coudoin  <bruno.coudoin@free.fr>
- GCompris: Release 0.4.2
- gcompris.c: adjusted main window size calculation.
              it fixes a bug was making gcompris hardly
	      unusable under 640x400
	      Changed to not use the Gnome standard menu for loading
	      help. Implemented my own to be able to be relocatable.
	      This hack does not implement I18N for the help file.
- fi.po: Created by Jyrki Kuoppala <jkp@kaapeli.fi>
- data/wordsgame/*.fi:Created by Jyrki Kuoppala <jkp@kaapeli.fi>
- gcompris.soundlist: deleted. I now use direct sound call instead
	                      of gnome .soundlist API
- sounds/*: now sounds are local to gcompris.
- configure.in: Changed to use local relative pixmaps and sounds
	                instead of gnome api
- src/*.c: Changed to use relative pixmaps and sounds

%package sounds-fr
Summary:        French sounds for GCompris
Group: 		Amusements/Games
Requires:       %name

%description sounds-fr
French sounds for gcompris.

%package sounds-es
Summary:        Spanish sounds for GCompris
Group: 		Amusements/Games
Requires:       %name

%description sounds-es
Spanish sounds for gcompris.

%package sounds-de
Summary:        German sounds for GCompris
Group: 		Amusements/Games
Requires:       %name

%description sounds-de
German sounds for gcompris.

%package sounds-en
Summary:        English sounds for GCompris
Group: 		Amusements/Games
Requires:       %name

%description sounds-en
English sounds for gcompris.

%prep
%setup -q

%build
%ifarch alpha
  MYARCH_FLAGS="--host=alpha-redhat-linux"
%endif

CFLAGS="$RPM_OPT_FLAGS" ./configure --quiet $MYARCH_FLAGS --prefix=%{prefix} \
	 --localstatedir=/var/lib

if [ "$SMP" != "" ]; then
  make -j$SMP MAKE="make -j$SMP"
else
  make
fi

%install
rm -rf $RPM_BUILD_ROOT

make prefix=$RPM_BUILD_ROOT%{prefix} install >install.log 2>&1

%clean
rm -rf $RPM_BUILD_ROOT

%post 

%postun 

%files
%defattr(-, root, root)
%doc ABOUT-NLS AUTHORS COPYING ChangeLog INSTALL NEWS README TODO THANKS
%attr(-, root, games) %{prefix}/bin/*
%{prefix}/lib/gcompris
%{prefix}/lib/menu/*
%dir %{prefix}/share/gcompris
%dir %{prefix}/share/gcompris/boards
%{prefix}/share/gcompris/boards/[^s]*
%{prefix}/share/gcompris/boards/s[cm]*
%dir %{prefix}/share/gcompris/boards/sounds
%{prefix}/share/gcompris/boards/sounds/HOWTO_ENCODE
%{prefix}/share/gcompris/sounds
%{prefix}/share/gnome/apps/Games/*
%{prefix}/share/gnome/help/*
%{prefix}/info/*
%{prefix}/share/locale/*/*/*
%{prefix}/share/pixmaps/*

%files sounds-de
%defattr(-, root, root)
%{prefix}/share/gcompris/boards/sounds/de

%files sounds-en
%defattr(-, root, root)
%{prefix}/share/gcompris/boards/sounds/en

%files sounds-es
%defattr(-, root, root)
%{prefix}/share/gcompris/boards/sounds/es

%files sounds-fr
%defattr(-, root, root)
%{prefix}/share/gcompris/boards/sounds/fr
