// 
//   Copyright (C) 2005, 2006, 2007 Free Software Foundation, Inc.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
//

// Test case for Object ActionScript class
// compile this test case with Ming makeswf, and then
// execute it like this gnash -1 -r 0 -v out.swf

rcsid="$Id: Object.as,v 1.26 2007/07/26 03:41:19 strk Exp $";

#include "check.as"

// Test existance of methods
check_equals(typeof(Object), 'function');
check_equals(typeof(Object.prototype), 'object');
check_equals(typeof(Object.prototype.toString), 'function');
check_equals(typeof(Object.prototype.valueOf), 'function');
#if OUTPUT_VERSION > 5
check_equals(typeof(Object.prototype.addProperty), 'function');
check_equals(typeof(Object.prototype.hasOwnProperty), 'function');
check_equals(typeof(Object.prototype.isPropertyEnumerable), 'function');
check_equals(typeof(Object.prototype.isPrototypeOf), 'function');
check_equals(typeof(Object.prototype.watch), 'function');
check_equals(typeof(Object.prototype.unwatch), 'function');
#else
check_equals(typeof(Object.prototype.addProperty), 'undefined');
check_equals(typeof(Object.prototype.hasOwnProperty), 'undefined');
check_equals(typeof(Object.prototype.isPropertyEnumerable), 'undefined');
check_equals(typeof(Object.prototype.isPrototypeOf), 'undefined');
check_equals(typeof(Object.prototype.watch), 'undefined');
check_equals(typeof(Object.prototype.unwatch), 'undefined');
#endif

// Test Object creation using 'new'
var obj = new Object; // uses SWFACTION_NEWOBJECT
check (obj != undefined);
check (typeof(obj) == "object");
check (obj.__proto__.constructor == Object);

// Test instantiated Object methods
check_equals(typeof(obj.toString), 'function');
check_equals(typeof(obj.valueOf), 'function');
#if OUTPUT_VERSION > 5
check_equals(typeof(obj.addProperty), 'function');
#else
check_equals(typeof(obj.addProperty), 'undefined');
#endif

// Test instantiated Object members
obj.member = 1;
check (obj.member == 1)
check_equals(typeof(obj.toString()), 'string');
check_equals(obj.toString(), '[object Object]');
check_equals(typeof(obj.valueOf()), 'object');
check_equals(obj.valueOf(), obj);

// Test Object creation using literal initialization
var obj2 = { member:1 }; // uses SWFACTION_INITOBJECT
check (obj2 != undefined );
check (typeof(obj2) == "object");
check (obj2.__proto__.constructor == Object);

// Test initialized object members
check ( obj2.member == 1 )

// Test Object creation using initializing constructor
var obj3 = new Object({ member:1 });
check (obj3 != undefined);
check (typeof(obj3) == "object");
check (obj3.__proto__.constructor == Object);

// Test initialized object members
check ( obj3.member != undefined );
check ( obj3.member == 1 );

// Test after-initialization members set/get
obj3.member2 = 3;
check ( obj3.member2 != undefined );
check ( obj3.member2 == 3 );

//----------------------
// Test copy ctors
//----------------------

var copy = new Object(obj3);
check_equals( copy.member2, 3 );
copy.test = 4;
check_equals( copy.test, 4 );
check_equals( obj3.test, 4 );
check (copy.__proto__.constructor == Object);


//---------------------------------------------
// Test addProperty / hasOwnProperty (SWF6 up)
//---------------------------------------------

// Object.addProperty wasn't in SWF5
#if OUTPUT_VERSION > 5

// the 'getter' function
function getLen() {
	return this._len;
}

// the 'setter' function
function setLen(l) {
	this._len = l;
}

// add the "len" property
var ret = obj3.addProperty("len", getLen, setLen);
check_equals(ret, true);

// toString is not obj3 "own" property, but it's inherited !
check_equals(typeof(obj3.toString), 'function');
ownPropertyCheck = obj3.hasOwnProperty("toString");
check_equals(typeof(ownPropertyCheck), 'boolean');
check(!ownPropertyCheck);

// 'member' is an obj3 "own" member (not inherited) 
ownPropertyCheck = obj3.hasOwnProperty("member");
check_equals(typeof(ownPropertyCheck), 'boolean');
check(ownPropertyCheck);

// 'len' is an obj3 "own" property (not inherited) 
ownPropertyCheck = obj3.hasOwnProperty("len");
check_equals(typeof(ownPropertyCheck), 'boolean');
check(ownPropertyCheck);

check_equals (obj3.len, undefined);
obj3._len = 3;
check_equals (obj3.len, 3);
obj3.len = 5;
check_equals (obj3._len, 5);
check_equals (obj3.len, 5);

// TODO: try omitting the "setter" argument
var ret = obj3.addProperty("len2", getLen);
check_equals(ret, false);
check_equals (obj3.len2, undefined);
obj3.len2 = 'test';
check_equals (obj3.len2, 'test');

// TODO: try using the name of an existing property

// Try property inheritance

var proto = new Object();
check(proto.addProperty("len", getLen, setLen));
var inh1 = new Object();
inh1.__proto__ = proto;
var inh2 = new Object();
inh2.__proto__ = proto;
check_equals (inh1._len, undefined);
check_equals (inh2._len, undefined);
inh1.len = 4; 
inh2.len = 9;
check_equals (inh1._len, 4);
check_equals (inh2._len, 9);
check_equals (proto._len, undefined);
inh1._len = 5;
inh2._len = 7;
check_equals (inh1.len, 5);
check_equals (inh2.len, 7);
check_equals (proto.len, undefined);

// Override addProperty member
var o = new Object();
o.addProperty = function(a, b) { return a+b; };
var c = o.addProperty(2,5);
check_equals(c, 7);
check(o.addProperty != Object.prototype.addProperty );

// Object.addProperty wasn't in SWF5
#endif // OUTPUT_VERSION > 5

//----------------------------------------------------
// Test Object.toString 
//----------------------------------------------------

check_equals(Object.prototype.toString(), '[object Object]');
backup = Object.prototype.toString;
Object.prototype.toString = function() { return new Object; };
check_equals(typeof(Object.prototype.toString()), 'object');
Object.prototype.toString = function() { return new Number; };
check_equals(Object.prototype.toString(), 0);
Object.prototype.toString = backup;

//----------------------
// Test enumeration
//----------------------

function enumerate(obj, enum)
{
	var enumlen = 0;
	for (var i in obj) {
		enum[i] = obj[i];
		++enumlen;
	}
	return enumlen;
}

var l0 = new Object({a:1, b:2});
var l1 = new Object({c:3, d:4});
l1.__proto__ = l0;
var l2 = new Object({e:5, f:6});
l2.__proto__ = l1;

// check properties
var enum = new Object;
var enumlen = enumerate(l2, enum);
check_equals( enumlen, 6);
check_equals( enum["a"], 1);
check_equals( enum["b"], 2);
check_equals( enum["c"], 3);
check_equals( enum["d"], 4);
check_equals( enum["e"], 5);
check_equals( enum["f"], 6);

// Hide a property of a base object
var ret = ASSetPropFlags(l0, "a", 1);

var enum = new Object;
var enumlen = enumerate(l2, enum);
check_equals( enumlen, 5);
check_equals( enum["a"], undefined);

var obj5 = new Object();
obj5['a'] = 1;
check_equals(obj5['a'], 1);
#if OUTPUT_VERSION < 7
check_equals(obj5['A'], 1);
#else
check_equals(obj5['A'], undefined);
#endif

//----------------------------------------------------
// Test Object.isPropertyEnumerable (SWF6 up)
//----------------------------------------------------

#if OUTPUT_VERSION > 5

// quick built-ins check
check( Object.prototype.hasOwnProperty("isPropertyEnumerable") );
check( ! Object.prototype.isPropertyEnumerable("isPropertyEnumerable") );
check( Object.prototype.hasOwnProperty("addProperty") );
check( ! Object.prototype.isPropertyEnumerable("addProperty") );
check( Object.prototype.hasOwnProperty("hasOwnProperty") );
check( ! Object.prototype.isPropertyEnumerable("hasOwnProperty") );

obj6 = new Object();
obj6.member = "a member";

ret = obj6.isPropertyEnumerable('unexistent');
check_equals(typeof(ret), 'boolean');
check( ! ret ); // non-existant

ret = obj6.isPropertyEnumerable('member');
check_equals(typeof(ret), 'boolean');
check( ret );

function enumerableThings()
{
	this.member1 = "a string";
	this.member2 = 3;
	ASSetPropFlags(this, "member2", 1); // hide member2
}
enumerableThings.prototype.member3 = new Object;

ret = enumerableThing.isPropertyEnumerable('member1');
check_equals( typeof(ret), 'undefined' );

obj7 = new enumerableThings();
check( obj7.isPropertyEnumerable('member1') );
check( ! obj7.isPropertyEnumerable('member2') );
check_equals( typeof(obj7.member3), 'object' );
check( ! obj7.isPropertyEnumerable('member3') );

#endif // OUTPUT_VERSION > 5

//----------------------------------------------------
// Test Object.isPrototypeOf (SWF6 up)
//----------------------------------------------------

#if OUTPUT_VERSION > 5

obj8 = function() {};
obj9 = function() {};
obj9.__proto__ = new obj8;
obj10 = new obj9;

check_equals( typeof(obj8.isPrototypeOf(obj8)), 'boolean' );
check_equals( typeof(obj8.isPrototypeOf(undefined)), 'boolean' );
check( obj9.prototype.isPrototypeOf(obj10) );
check( ! obj8.prototype.isPrototypeOf(obj10) );
check( obj8.prototype.isPrototypeOf(obj9) );
// TODO: add tests here !

#endif // OUTPUT_VERSION > 5

//----------------------------------------------------
// Test Object.watch (SWF6 up)
//----------------------------------------------------

#if OUTPUT_VERSION > 5

// TODO: add tests here !

#endif // OUTPUT_VERSION > 5

//----------------------------------------------------
// Test Object.unwatch (SWF6 up)
//----------------------------------------------------

#if OUTPUT_VERSION > 5

// TODO: add tests here !

#endif // OUTPUT_VERSION > 5
