#!/bin/sh
# Create directories for each category in a GNATS categories file. 
# Copyright (C) 1993 Free Software Foundation, Inc.
# Contributed by Brendan Kehoe (brendan@cygnus.com) and
# Tim Wicinski (wicinski@barn.com).
#
# This file is part of GNU GNATS.
#
# GNU GNATS is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
#
# GNU GNATS is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with GNU GNATS; see the file COPYING.  If not, write to
# the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

GNATS_ROOT=xGNATS_ROOTx
GNATS_SITE=xGNATS_SITEx
DATADIR=xDATADIRx

CATEGORIES=`grep -v '^#' $GNATS_ROOT/gnats-adm/categories | sed -e 's/:.*//g'`

# Newer config information?
[ -f ${GNATS_ROOT}/gnats-adm/config ] && . ${GNATS_ROOT}/gnats-adm/config

if [ ! -d $DATADIR/gnats ]; then
  echo "$0: No directory $DATADIR/gnats!"
  exit 1
fi

if [ ! -d $DATADIR/gnats/dist ]; then
  echo "$0: No directory $DATADIR/gnats/dist!"
  exit 1
fi

rm -f $DATADIR/gnats/dist/categories $DATADIR/gnats/$GNATS_SITE
touch $DATADIR/gnats/dist/categories $DATADIR/gnats/$GNATS_SITE

for i in $CATEGORIES; do
    
    if test -d $GNATS_ROOT/$i; then
	true
    else
	mkdir $GNATS_ROOT/$i
        echo creating category $GNATS_ROOT/$i
    fi

    echo $i >> $DATADIR/gnats/dist/categories
    echo $i >> $DATADIR/gnats/$GNATS_SITE

done

exit 0
