/*
    GNUbik -- A 3 dimensional magic cube game.
    Copyright (C) 1998, 2003  John Darrington

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
*/
#ifndef GNUBIK_H
#define GNUBIK_H


#include "../config.h"
#include <libintl.h>
#define _(String) gettext(String)

#ifdef WIDGET_SET_gtk
#include <gtk/gtk.h>
typedef GtkWidget * t_widget;
typedef  gpointer ptr_t;
#elif defined(WIDGET_SET_athena)
#include <X11/Intrinsic.h>
#define t_widget Widget 
typedef XtPointer ptr_t;
extern XtAppContext app;
#endif




#define ERR_CHECK(string)  error_check(__FILE__,__LINE__,string)

void error_check(const char *file, int line_no, const char *string);

extern int cube_dimension;
extern int number_of_blocks;


/* A structure containing information about a movement taking place */
struct move_data {
  int block; 
  int dir; 
  int axis;
};


#ifndef M_PI
# define M_PI           3.14159265358979323846
#endif



#endif


