/*
    GNUbik -- A 3 dimensional Gmagic cube game.
    Copyright (C) 2003  John Darrington

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
*/
static const char RCSID[]="$Id: widget-set-athena.c,v 1.6 2004/01/05 13:36:17 dale_mellor Exp $";

#include "widget-set.h"
#include "menus.h"
#include "menutree.h"
#include "version.h"
#include "drwBlock.h"

#include <X11/StringDefs.h>
#include <X11/Xmu/Editres.h>


#include <X11/Xaw/Box.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Command.h>

#include <stdio.h>


static String fallbackresources[] = {
    "*glxarea*width: 300",
    "*glxarea*height: 300",
    "*help.label: Help",
    "*quit.label: Quit",
    "*animation.label: Animation",
    "*background: lightgrey",
    NULL
}; 


static Menu menu1;
static Menu menu2;


static Widget toplevel;



/* quit the program */
static void 
stop(Widget w, XtPointer client_data, XtPointer call_data)
{
  exit(0);
}


void
widget_set_init(int *argc, char *** argv)
{

  toplevel = XtAppInitialize(&app, "gnubik",NULL,0,argc, *argv,
			     fallbackresources, NULL,0);


  XtSetLanguageProc(NULL, (XtLanguageProc)NULL, NULL);



  XtAddEventHandler(toplevel,
		    (EventMask) 0,
		    True,
		    _XEditResCheckMessages,
		    NULL);


}


t_widget
create_top_level_widget(void)
{
  return toplevel;
}


void
update_statusbar(void)
{
  /* Not supported */
}

t_widget
create_statusbar(t_widget container)
{
  /* Not supported */

  return 0;
}

t_widget
create_container_widget(t_widget parent)
{
  t_widget form ;
  /* create a form to hold the drawing area and the menubar */
  form = XtVaCreateManagedWidget(
				 "form",
				 formWidgetClass,
				 parent,
				 NULL);

  return form;

}


t_widget
create_menubar(t_widget container, t_widget toplevel)
{

  static struct MessageBoxData versionData = {
    50, 100,0
  };


  /* define  a  message box for help */
  static struct MessageBoxData optionSyntaxData = {
    260, 550,help_string
  };


  /* define a message box for copyright notice */
  static struct MessageBoxData  copyrightBoxData= {
    300,550,copyleft_notice
  };

  /* define the animate menu */
  struct MenuDef animateMenu[]=
  {
    {"Increase",animation_inc},
    {"Decrease",animation_dec},
    {"Done",popDown}
  };

  /* define the help menu */
  struct MenuDef helpMenu[]=
  {
    {"Copying",   showBox,   &copyrightBoxData},
    {"Options",   showBox,    &optionSyntaxData},
    {"Version",showBox,&versionData}
  };



  Widget help, animation, quit;

  t_widget menubar;

  versionData.message = get_version_string();

  menubar = XtVaCreateManagedWidget(
				    "menubar",
				    boxWidgetClass,
				    container,
				    NULL);
				 

  /* set contraints on menubar */
  XtVaSetValues(menubar,
        	XtNresizable, False,
		XtNtop, XtChainTop,
		XtNbottom, XtChainTop,
		XtNleft, XtChainLeft ,
		XtNright, XtChainLeft,
		XtNorientation, "horizontal",
		XtNborderWidth, 0,
		NULL);


  /* create the quit button */
  quit = XtVaCreateManagedWidget(
				 "quit",
				 commandWidgetClass,
				 menubar,
				 NULL);

  /* create the animate button */
  animation = XtVaCreateManagedWidget(
				      "animation",
				      commandWidgetClass,
				      menubar,
				      NULL);


  /* create the help button */
  help = XtVaCreateManagedWidget(
				 "help",
				 commandWidgetClass,
				 menubar,
				 NULL);


  /* bind the menu definitions to the appropriate buttons */
  menu1 = createMenu(toplevel, help, helpMenu, XtNumber(helpMenu) );
  menu2 = createMenu(toplevel, animation, animateMenu, XtNumber(animateMenu) );

  /* bind stop function to quit button */
  XtAddCallback(quit, XtNcallback, stop, 0);



  return menubar;

}

void cleanup(void)
{
  destroyMenu(menu1);
  destroyMenu(menu2);
}


void
show_widget(t_widget w)
{
  XtRealizeWidget(w);


}


void
start_main_loop()
{
  XtAppMainLoop(app);
}



/* set the colours of the faces from the X resource database */
void
setCubeColours(char *progname)
{
  int i;

  Colormap colmap;

  Display *dpy;

  dpy = XtDisplay(toplevel);

  colmap = DefaultColormap(dpy,DefaultScreen(dpy));


  /* colours for the faces of the cube can be defined in the resource database.
     A definition should look like 
      gnubik.color0: pink
      gnubik.color1: blue
      .
      .
      gnubik.color5: purple

    I've gone against by patriotic judgement and have accepted US spelling for the resources :)
  */
      
  for(i=0;i<6;++i){
    char *colour;
    char resname[20];
    XColor xcolour;

    sprintf(resname,"color%d",i);
    colour=XGetDefault(dpy,progname,resname);

    if(!XParseColor(dpy,colmap,colour,&xcolour)) {
	if (colour)
	      fprintf(stderr,"colour %s not in database\n",colour);
    }
    else{
      /* convert colours to GLfloat values, and set them*/
      const unsigned short full = ~0;


      GLfloat red =   (GLfloat) xcolour.red/full ;
      GLfloat green = (GLfloat) xcolour.green/full ;
      GLfloat blue =  (GLfloat) xcolour.blue/full ;

      setColour(i,red,green,blue);
    }
  }
}


void
declare_win(Cube_Status status)
{
  /* Placeholder */
}
