/*
 * This file is part of the coreboot project.
 *
 * Copyright 2018 MediaTek Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#ifndef SOC_MEDIATEK_MT8183_INFRACFG_H
#define SOC_MEDIATEK_MT8183_INFRACFG_H

#include <soc/addressmap.h>
#include <types.h>

struct mt8183_infracfg_regs {
	u32 reserved1[20];
	u32 infra_globalcon_dcmctl;
	u32 reserved2[7];
	u32 infra_bus_dcm_ctrl;
	u32 peri_bus_dcm_ctrl;
	u32 mem_dcm_ctrl;
	u32 dfs_mem_dcm_ctrl;
	u32 module_sw_cg_0_set;
	u32 module_sw_cg_0_clr;
	u32 module_sw_cg_1_set;
	u32 module_sw_cg_1_clr;
	u32 module_sw_cg_0_sta;
	u32 module_sw_cg_1_sta;
	u32 module_clk_sel;
	u32 mem_cg_ctrl;
	u32 p2p_rx_clk_on;
	u32 module_sw_cg_2_set;
	u32 module_sw_cg_2_clr;
	u32 module_sw_cg_2_sta;
	u32 reserved3[1];
	u32 dramc_wbr;
	u32 reserved4[2];
	u32 module_sw_cg_3_set;
	u32 module_sw_cg_3_clr;
	u32 module_sw_cg_3_sta;
	u32 reserved5[13];
	u32 i2c_dbtool_misc;
	u32 md_sleep_ctrl_mask;
	u32 pmicw_clock_ctrl;
	u32 reserved6[5];
	u32 infra_globalcon_rst0_set;
	u32 infra_globalcon_rst0_clr;
	u32 infra_globalcon_rst0_sta;
	u32 reserved7[1];
	u32 infra_globalcon_rst1_set;
	u32 infra_globalcon_rst1_clr;
	u32 infra_globalcon_rst1_sta;
	u32 reserved8[1];
	u32 infra_globalcon_rst2_set;
	u32 infra_globalcon_rst2_clr;
	u32 infra_globalcon_rst2_sta;
	u32 reserved9[1];
	u32 infra_globalcon_rst3_set;
	u32 infra_globalcon_rst3_clr;
	u32 infra_globalcon_rst3_sta;
	u32 reserved10[41];
	u32 infra_topaxi_si0_ctl;
	u32 infra_topaxi_si1_ctl;
	u32 infra_topaxi_mdbus_ctl;
	u32 infra_mci_si0_ctl;
	u32 infra_mci_si1_ctl;
	u32 infra_mci_si2_ctl;
	u32 infra_mci_async_ctl;
	u32 infra_mci_cg_mfg_sec_sta;
	u32 infra_topaxi_protecten;
	u32 infra_topaxi_protecten_sta0;
	u32 infra_topaxi_protecten_sta1;
	u32 infra_axi_aslice_ctrl;
	u32 infra_apb_async_sta;
	u32 infra_topaxi_si2_ctl;
	u32 reserved11[2];
	u32 infra_mci_trans_con_read;
	u32 infra_mci_trans_con_write;
	u32 infra_mci_id_remap_con;
	u32 infra_mci_emi_trans_con;
	u32 infra_topaxi_protecten_1;
	u32 infra_topaxi_protecten_sta0_1;
	u32 infra_topaxi_protecten_sta1_1;
	u32 reserved12[1];
	u32 infra_topaxi_aslice_ctrl;
	u32 reserved13[3];
	u32 infra_topaxi_mi_ctrl;
	u32 infra_topaxi_cbip_aslice_ctrl;
	u32 infra_topaxi_cbip_slice_ctrl;
	u32 infra_top_master_sideband;
	u32 reserved14[1];
	u32 infra_topaxi_trans_limiter;
	u32 infra_topaxi_emi_gmc_l2c_ctrl;
	u32 infra_topaxi_cbip_slice_ctrl_1;
	u32 infra_mfg_slave_gals_ctrl;
	u32 infra_mfg_master_m0_gals_ctrl;
	u32 infra_mfg_master_m1_gals_ctrl;
	u32 infra_top_master_sideband_1;
	u32 infra_topaxi_protecten_set;
	u32 infra_topaxi_protecten_clr;
	u32 infra_topaxi_protecten_1_set;
	u32 infra_topaxi_protecten_1_clr;
	u32 infra_topaxi_cbip_slice_ctrl_2;
	u32 reserved15[3];
	u32 infra_topaxi_protecten_mcu;
	u32 infra_topaxi_protecten_mcu_set;
	u32 infra_topaxi_protecten_mcu_clr;
	u32 reserved16[1];
	u32 infra_topaxi_protecten_mm;
	u32 infra_topaxi_protecten_mm_set;
	u32 infra_topaxi_protecten_mm_clr;
	u32 reserved17[1];
	u32 infra_topaxi_protecten_mcu_sta0;
	u32 infra_topaxi_protecten_mcu_sta1;
	u32 infra_topaxi_protecten_mm_sta0;
	u32 infra_topaxi_protecten_mm_sta1;
	u32 reserved18[4];
	u32 md1_bank0_map0;
	u32 md1_bank0_map1;
	u32 md1_bank0_map2;
	u32 md1_bank0_map3;
	u32 md1_bank1_map0;
	u32 md1_bank1_map1;
	u32 md1_bank1_map2;
	u32 md1_bank1_map3;
	u32 md1_bank4_map0;
	u32 md1_bank4_map1;
	u32 md1_bank4_map2;
	u32 md1_bank4_map3;
	u32 md2_bank0_map0;
	u32 md2_bank0_map1;
	u32 md2_bank0_map2;
	u32 md2_bank0_map3;
	u32 reserved19[4];
	u32 md2_bank4_map0;
	u32 md2_bank4_map1;
	u32 md2_bank4_map2;
	u32 md2_bank4_map3;
	u32 c2k_config;
	u32 c2k_status;
	u32 c2k_spm_ctrl;
	u32 reserved20[1];
	u32 ap2md_dummy;
	u32 reserved21[3];
	u32 conn_map0;
	u32 cldma_map0;
	u32 conn_map1;
	u32 conn_bus_con;
	u32 mcusys_dfd_map;
	u32 conn_map2;
	u32 reserved22[26];
	u32 peri_cci_sideband_con;
	u32 mfg_cci_sideband_con;
	u32 reserved23[62];
	u32 infra_ao_dbg_con0;
	u32 infra_ao_dbg_con1;
	u32 infra_ao_dbg_con2;
	u32 infra_ao_dbg_con3;
	u32 md_dbg_ck_con;
	u32 infra_ao_dbg_sta;
	u32 reserved24[58];
	u32 mfg_misc_con;
	u32 reserved25[63];
	u32 infra_rsvd0;
	u32 infra_rsvd1;
	u32 infra_rsvd2;
	u32 infra_rsvd3;
	u32 reserved26[92];
	u32 md1_sbc_key0;
	u32 md1_sbc_key1;
	u32 md1_sbc_key2;
	u32 md1_sbc_key3;
	u32 md1_sbc_key4;
	u32 md1_sbc_key5;
	u32 md1_sbc_key6;
	u32 md1_sbc_key7;
	u32 md1_sbc_key_lock;
	u32 reserved27[1];
	u32 md1_misc_lock;
	u32 md1_misc;
	u32 c2k_sbc_key0;
	u32 c2k_sbc_key1;
	u32 c2k_sbc_key2;
	u32 c2k_sbc_key3;
	u32 c2k_sbc_key4;
	u32 c2k_sbc_key5;
	u32 c2k_sbc_key6;
	u32 c2k_sbc_key7;
	u32 c2k_sbc_key_lock;
	u32 reserved28[11];
	u32 infra_bonding;
	u32 reserved29[63];
	u32 infra_ao_scpsys_apb_async_sta;
	u32 infra_ao_md32_tx_apb_async_sta;
	u32 infra_ao_md32_rx_apb_async_sta;
	u32 infra_ao_cksys_apb_async_sta;
	u32 infra_ao_pmic_wrap_tx_apb_async_sta;
	u32 reserved30[59];
	u32 pll_ulposc_con0;
	u32 pll_ulposc_con1;
	u32 reserved31[2];
	u32 pll_auxadc_con0;
	u32 scp_infra_irq_set;
	u32 scp_infra_irq_clr;
	u32 scp_infra_ctrl;
	u32 reserved32[56];
	u32 cldma_ctrl;
	u32 reserved33[63];
	u32 infrabus_dbg0;
	u32 infrabus_dbg1;
	u32 infrabus_dbg2;
	u32 infrabus_dbg3;
	u32 infrabus_dbg4;
	u32 infrabus_dbg5;
	u32 infrabus_dbg6;
	u32 infrabus_dbg7;
	u32 infrabus_dbg8;
	u32 infrabus_dbg9;
	u32 infrabus_dbg10;
	u32 infrabus_dbg11;
	u32 infrabus_dbg12;
	u32 infrabus_dbg13;
	u32 infrabus_dbg14;
	u32 infrabus_dbg15;
	u32 infrabus_dbg16;
	u32 infrabus_dbg17;
	u32 infrabus_dbg18;
	u32 infrabus_dbg19;
	u32 infrabus_dbg20;
	u32 infrabus_dbg21;
	u32 infrabus_dbg22;
	u32 infrabus_dbg23;
	u32 reserved34[104];
	u32 infra_misc;
	u32 infra_acp;
	u32 misc_config;
	u32 infra_misc2;
	u32 mdsys_misc_con;
	u32 reserved35[27];
	u32 infra_ao_sec_con;
	u32 infra_ao_sec_cg_con0;
	u32 infra_ao_sec_cg_con1;
	u32 infra_ao_sec_rst_con0;
	u32 infra_ao_sec_rst_con1;
	u32 infra_ao_sec_rst_con2;
	u32 reserved36[1];
	u32 infra_ao_sec_cg_con2;
	u32 infra_ao_sec_rst_con3;
	u32 infra_ao_sec_cg_con3;
	u32 reserved37[2];
	u32 infra_ao_sec_hyp;
};

check_member(mt8183_infracfg_regs, infra_globalcon_dcmctl, 0x0050);
check_member(mt8183_infracfg_regs, infra_bus_dcm_ctrl, 0x0070);
check_member(mt8183_infracfg_regs, module_sw_cg_3_set, 0x00c0);
check_member(mt8183_infracfg_regs, i2c_dbtool_misc, 0x0100);
check_member(mt8183_infracfg_regs, infra_globalcon_rst0_set, 0x0120);
check_member(mt8183_infracfg_regs, infra_topaxi_si0_ctl, 0x0200);
check_member(mt8183_infracfg_regs, infra_mci_trans_con_read, 0x0240);
check_member(mt8183_infracfg_regs, infra_topaxi_mi_ctrl, 0x0270);
check_member(mt8183_infracfg_regs, infra_topaxi_protecten_mcu, 0x02c0);
check_member(mt8183_infracfg_regs, md1_bank0_map0, 0x0300);
check_member(mt8183_infracfg_regs, md2_bank4_map0, 0x0350);
check_member(mt8183_infracfg_regs, conn_map0, 0x0380);
check_member(mt8183_infracfg_regs, peri_cci_sideband_con, 0x0400);
check_member(mt8183_infracfg_regs, infra_ao_dbg_con0, 0x0500);
check_member(mt8183_infracfg_regs, mfg_misc_con, 0x0600);
check_member(mt8183_infracfg_regs, infra_rsvd0, 0x0700);
check_member(mt8183_infracfg_regs, md1_sbc_key0, 0x0880);
check_member(mt8183_infracfg_regs, infra_bonding, 0x0900);
check_member(mt8183_infracfg_regs, infra_ao_scpsys_apb_async_sta, 0x0a00);
check_member(mt8183_infracfg_regs, pll_ulposc_con0, 0x0b00);
check_member(mt8183_infracfg_regs, pll_auxadc_con0, 0x0b10);
check_member(mt8183_infracfg_regs, cldma_ctrl, 0x0c00);
check_member(mt8183_infracfg_regs, infrabus_dbg0, 0x0d00);
check_member(mt8183_infracfg_regs, infra_misc, 0x0f00);
check_member(mt8183_infracfg_regs, infra_ao_sec_con, 0x0f80);
check_member(mt8183_infracfg_regs, infra_ao_sec_hyp, 0x0fb0);

static struct mt8183_infracfg_regs *const mt8183_infracfg =
	(void *)INFRACFG_AO_BASE;

#endif	/* SOC_MEDIATEK_MT8183_INFRACFG_H */
