/* 
 *    Programmed By: Mohammed Isam Mohammed [mohammed_isam1984@yahoo.com]
 *    Copyright 2014 (c)
 * 
 *    file: options.c
 *    This file is part of mino (Mino).
 *
 *    mino (Mino) is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    mino (Mino) is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with mino (Mino).  If not, see <http://www.gnu.org/licenses/>.
 */    
#include "defs.h"
#include "options.h"
#include "kbd.h"
#include <pwd.h>
#include <string.h>
#include <unistd.h>
#include <stdlib.h>

struct passwd *pass;//will be used to find the home dir

int x, y, w, x, sel;
int oldFGColors[6];
int oldBGColors[6];

char *changeColorsDialogOptions[6] =
      { "Window          ",
	"Highlighted text",
	"Menu bar        ",
	"Status bar      ",
	"Buttons         ",
	"Selected Button "
      };

char* findColorName(int c) 
{
  switch(c) 
  {
    case(30):case(40): return "BLACK  "; break;
    case(31):case(41): return "RED    "; break;
    case(32):case(42): return "GREEN  "; break;
    case(33):case(43): return "BROWN  "; break;
    case(34):case(44): return "BLUE   "; break;
    case(35):case(45): return "MAGENTA"; break;
    case(36):case(46): return "CYAN   "; break;
    case(37):case(47): return "WHITE  "; break;
  }//end switch
  return NULL;
}

void saveOldColors() 
{
  int i;
  for(i = 0; i < 6; i++) 
  {
    oldFGColors[i] = FG_COLOR[i];
    oldBGColors[i] = BG_COLOR[i];
  }
}

void resetColors() 
{
  int i;
  for(i = 0; i < 6; i++) 
  {
    FG_COLOR[i] = oldFGColors[i];
    BG_COLOR[i] = oldBGColors[i];
  }
}

int showColorChooserDialog() 
{
  int i;
  int x1 = (SCREEN_H/2)-5;
  int y1 = (SCREEN_W/2)-10;
  drawBox(x1, y1, x1+10, y1+16, " Choose color ", YES);
  for(i = 30; i < 38; i++)
    printf("\e[%d;%dH%s", ++x1, y1+1, findColorName(i));
  printf("\e[%d;%dHCANCEL", ++x1, y1+1);
  x1 = (SCREEN_H/2)-4; i = 30;
  setScreenColors(FG_COLOR[COLOR_HIGHLIGHT_TEXT], BG_COLOR[COLOR_HIGHLIGHT_TEXT]);
  printf("\e[%d;%dH%s", x1, y1+1, findColorName(i));
  fflush(stdout);
  int endme = 0;
  char *c;
  
  while(!endme) 
  {
    c = getKey();
    //printf("         %c,%d", c, c);
    switch(c[0]) 
    {
      case('p'):
	if(GNU_DOS_LEVEL > 1 && CTRL) goto do_up;
	break;
      case(UP_KEY):
	if(GNU_DOS_LEVEL > 1) break;
do_up:
	//msgBox("UP", OK, INFO);
	if(i <= 30) 
	{
	  setScreenColors(FG_COLOR[COLOR_WINDOW], BG_COLOR[COLOR_WINDOW]);
	  printf("\e[%d;%dH%s", x1, y1+1, findColorName(i));
	  i = 38;
	  setScreenColors(FG_COLOR[COLOR_HIGHLIGHT_TEXT], BG_COLOR[COLOR_HIGHLIGHT_TEXT]);
	  printf("\e[%d;%dHCANCEL", x1+i-30, y1+1);
	  //printf("\e[%d;%dH%s", x1+i-30, y1+1, findColorName(i));
	} 
	else if(i == 38) 
	{
	  setScreenColors(FG_COLOR[COLOR_WINDOW], BG_COLOR[COLOR_WINDOW]);
	  printf("\e[%d;%dHCANCEL", x1+i-30, y1+1);
	  i = 37;
	  setScreenColors(FG_COLOR[COLOR_HIGHLIGHT_TEXT], BG_COLOR[COLOR_HIGHLIGHT_TEXT]);
	  printf("\e[%d;%dH%s", x1+i-30, y1+1, findColorName(i));
	} 
	else 
	{
	  setScreenColors(FG_COLOR[COLOR_WINDOW], BG_COLOR[COLOR_WINDOW]);
	  printf("\e[%d;%dH%s", x1+i-30, y1+1, findColorName(i));
	  i--;
	  setScreenColors(FG_COLOR[COLOR_HIGHLIGHT_TEXT], BG_COLOR[COLOR_HIGHLIGHT_TEXT]);
	  printf("\e[%d;%dH%s", x1+i-30, y1+1, findColorName(i));
	}//end if
	fflush(stdout);
	endme = 0;
	break;
      case('n'):
	if(GNU_DOS_LEVEL > 1 && CTRL) goto do_down;
	break;
      case(DOWN_KEY):
	if(GNU_DOS_LEVEL > 1) break;
do_down:
	//msgBox("DOWN", OK, INFO);
	if(i >= 38) 
	{
	  setScreenColors(FG_COLOR[COLOR_WINDOW], BG_COLOR[COLOR_WINDOW]);
	  printf("\e[%d;%dHCANCEL", x1+i-30, y1+1);
	  //printf("\e[%d;%dH%s", x1+i-30, y1+1, findColorName(i));
	  i = 30;
	  setScreenColors(FG_COLOR[COLOR_HIGHLIGHT_TEXT], BG_COLOR[COLOR_HIGHLIGHT_TEXT]);
	  printf("\e[%d;%dH%s", x1+i-30, y1+1, findColorName(i));
	} 
	else if(i == 37) 
	{
	  setScreenColors(FG_COLOR[COLOR_WINDOW], BG_COLOR[COLOR_WINDOW]);
	  printf("\e[%d;%dH%s", x1+i-30, y1+1, findColorName(i));
	  //printf("\e[%d;%dH%s", x1+i-30, y1+1, findColorName(i));
	  i = 38;
	  setScreenColors(FG_COLOR[COLOR_HIGHLIGHT_TEXT], BG_COLOR[COLOR_HIGHLIGHT_TEXT]);
	  printf("\e[%d;%dHCANCEL", x1+i-30, y1+1);
	} 
	else 
	{
	  setScreenColors(FG_COLOR[COLOR_WINDOW], BG_COLOR[COLOR_WINDOW]);
	  printf("\e[%d;%dH%s", x1+i-30, y1+1, findColorName(i));
	  i++;
	  setScreenColors(FG_COLOR[COLOR_HIGHLIGHT_TEXT], BG_COLOR[COLOR_HIGHLIGHT_TEXT]);
	  printf("\e[%d;%dH%s", x1+i-30, y1+1, findColorName(i));
	}//end if
	endme = 0;
	fflush(stdout);
	break;
      case(ENTER_KEY):
      case(SPACE_KEY):
	//msgBox("ENTER", OK, INFO);
	//c = getKey();
	if(i == 38) { i = 0; return 0; break; }
	endme = 1; //fflush(stdin);
	return i; break;
      case(0):
	continue; break;
      case('g'):
	if(GNU_DOS_LEVEL > 2 && CTRL) goto do_esc;
	break;
      case(ESC_KEY):
	if(GNU_DOS_LEVEL > 2) break;
do_esc:
      default:
	//msgBox("DEFAULT", OK, INFO);
	endme = 1; //i = 0; //fflush(stdin);
	return 0; break;
    }//end switch
  }//end while
  return i;
}

void refreshChangeColorsDialog() 
{
  int i;
  drawBox(x, y, h, w, "Change colors", YES);
  fprintf(stdout, "\e[%d;%dHForeground  Background", x+1, y+16);
  fprintf(stdout, "\e[%d;%dH  OK   RESET", h-1, y+12);
  setScreenColors(FG_COLOR[COLOR_WINDOW], BG_COLOR[COLOR_WINDOW]);
  for(i = 0; i < changeColorsDialogOptionsN; i++) 
  {
    fprintf(stdout, "\e[%d;%dH", x+i+2, y+1);
    fprintf(stdout, "%s  %s  %s", changeColorsDialogOptions[i],
		    findColorName(FG_COLOR[i]),
		    findColorName(BG_COLOR[i]));
  }//end for
  setScreenColors(FG_COLOR[COLOR_HIGHLIGHT_TEXT], BG_COLOR[COLOR_HIGHLIGHT_TEXT]);
  if(sel == 12)
    fprintf(stdout, "\e[%d;%dH  OK  ", h-1, y+12);
  else if(sel == 13)
    fprintf(stdout, "\e[%d;%dHRESET", h-1, y+19);
  else if(sel >= 0 && sel <= 5)
    fprintf(stdout, "\e[%d;%dH%s", x+sel+2, y+19, findColorName(FG_COLOR[sel]));
  else if(sel >= 6 && sel <= 11)
    fprintf(stdout, "\e[%d;%dH%s", x+(sel-6)+2, y+28, findColorName(BG_COLOR[sel-6]));
  fflush(stdout);
}


void optionsMenu_Change_Colors() 
{
  x = (SCREEN_H/2)-5;
  y = (SCREEN_W/2)-18;
  w = y+38;
  h = x+10;
  //int i;
  sel = 0;//selected item: 0-5 FG_COLORS, 6-11 BG_COLORS,
	      //12 OK, 13 RESET
  saveOldColors();
  refreshChangeColorsDialog();
  int endme = 0;
  int enter_error = 0;
  //infinite loop to get user input
  while(!endme) 
  {
    char *c = getKey();
    //printf("         ..%c,%d", c, c);
    switch(c[0]) 
    {
      case(0):
	//continue; 
	break;
      case('p'):
	if(GNU_DOS_LEVEL > 1 && CTRL) goto do_up;
	break;
      case(UP_KEY):
	if(GNU_DOS_LEVEL > 1) break;
do_up:
	if(sel == 0 || sel == 6) sel = 12;
	else if(sel == 12) sel = 5;
	else if(sel == 13) sel = 11;
	else sel--;
	refreshChangeColorsDialog();
	enter_error = 0;
	break;
      case('n'):
	if(GNU_DOS_LEVEL > 1 && CTRL) goto do_down;
	break;
      case(DOWN_KEY):
	if(GNU_DOS_LEVEL > 1) break;
do_down:
	if(sel == 12) sel = 0;
	else if(sel == 13) sel = 6;
	else if(sel == 5 || sel == 6) sel = 12;
	else sel++;
	refreshChangeColorsDialog();
	enter_error = 0;
	break;
      case('b'):
      case('f'):
	if(GNU_DOS_LEVEL > 1 && CTRL) goto do_left_right;
	break;
      case(LEFT_KEY):
      case(RIGHT_KEY):
	if(GNU_DOS_LEVEL > 1) break;
do_left_right:
	if(sel == 12) sel = 13;
	else if(sel == 13) sel = 12;
	else if(sel >= 0 && sel <= 5) sel += 6;
	else sel -= 6;
	refreshChangeColorsDialog();
	enter_error = 0;
	break;
      case('g'):
	if(GNU_DOS_LEVEL > 2 && CTRL) goto do_esc;
	break;
      case(ESC_KEY):
	if(GNU_DOS_LEVEL > 2) break;
do_esc:
	resetColors();
	//write_config_file();
	refreshView();
	endme = 1;
	return; break;
      case(SPACE_KEY):
      case(ENTER_KEY):
	if(enter_error) continue;
	if(sel == 12) 
	{
	  write_config_file();
	  refreshView();
	  endme = 1;
	  return;
	} 
	else if(sel == 13) 
	{
	  resetColors();
	  refreshChangeColorsDialog();
	  //write_config_file();
	} 
	else 
	{
	  int tmp;
	  enter_error = !enter_error;
	  if(!enter_error) continue;
	  if(sel >= 0 && sel <= 5) 
	  {
	    tmp = showColorChooserDialog();
	    if(tmp) FG_COLOR[sel] = tmp;
	    //else { sprintf(lines[0], "%d", tmp); return; }
	    //c = DOWN_KEY;
	    //msgBox("1", OK, INFO);
	    refreshChangeColorsDialog();
	    //msgBox("2", OK, INFO);
	    //if(!X_IS_RUNNING) c = getKey();
	    break;
	  } 
	  else if(sel >= 6 && sel <= 11) 
	  {
	    tmp = showColorChooserDialog();
	    if(tmp) BG_COLOR[sel-6] = tmp+10;
	    //else { sprintf(lines[0], "%d", tmp); return; }
	    //c = DOWN_KEY;
	    refreshChangeColorsDialog();
	    //if(!X_IS_RUNNING) c = getKey();
	    break;
	  }
	}//end if
	break;
    }//end switch
    //printf("%d..%c", c, c);
    //msgBox("3", OK, INFO);
    //refreshChangeColorsDialog();
    //printf("         ..%c,%d", c, c);
  }//end while
  
}

/****************************************
 * Takes new definition for number of
 * spaces in a tab character and writes
 * configuration into ~/.mino.conf file.
 * **************************************/
void optionsMenu_Tab_Spaces() 
{
  char *t;
  t = inputBox("Enter number of spaces in a tab:", " Tab spaces ");
  if(t) 
  {
    char *t2 = (char *) malloc(10);
    if(!t2) { msgBox("Insufficient memory", OK, ERROR); return; }
    makestr(t2, t);
    if(atoi(t2) <= 0) return;
    TAB_CHARS = atoi(t2);
    write_config_file();
    free(t2);
    //msgBox("Finished writing default values to ~/.mino.conf", OK, INFO);
  }
}

/******************************************
 * Resets configuration file ~/.mino.conf
 * to default values.
 * ****************************************/
void optionsMenu_Reset_Config() 
{
      if(!(pass = getpwuid(geteuid()))) 
      {
	msgBox("Couldn't open home directory to write config file.", OK, ERROR);
	refreshView();
	return;
      }
      config_file_name = (char *) malloc(strlen(pass->pw_dir)+11);
      if(!config_file_name) { msgBox("Insufficient memory", OK, ERROR); refreshView(); return; }
      strcpy(config_file_name, pass->pw_dir);
      strcat(config_file_name, "/");
      strcat(config_file_name, ".mino.conf");
      if(!(config_file = fopen(config_file_name, "w"))) 
      {
	msgBox("Couldn't write to config file in home directory.", OK, ERROR);
	refreshView();
	return;
      }
      fprintf(config_file, "#Configuration file for mino program\n");
      fprintf(config_file, "#Please do not modify this file by hand\n");
      fprintf(config_file, "#Use the Options menu in mino to change program configuration.\n\n");
      fprintf(config_file, "#Line Wrapping\n");
      fprintf(config_file, "#If TRUE, lines cannot be longer than the screen width\n");
      fprintf(config_file, "#If FALSE, lines cannot be upto MAX_CHARS_PER_LINE characters\n");
      fprintf(config_file, "#Note this value is omitted if WRAP_LINES is TRUE\n");
      fprintf(config_file, "MAX_CHARS_PER_LINE = 100\n");
      fprintf(config_file, "WRAP_LINES = TRUE\n\n");
      fprintf(config_file, "#Number of spaces to insert when user presses TAB key\n");
      fprintf(config_file, "TAB_CHARS = 8\n\n");
      fprintf(config_file, "#Default title for newly opened documents, no quotes\n");
      fprintf(config_file, "DEFAULT_TITLE = untitled\n\n");
      fprintf(config_file, "#Start mino with CAPS and INSERT set to OFF/ON\n");
      fprintf(config_file, "CAPS = OFF\n");
      fprintf(config_file, "INSERT = OFF\n\n");
      fprintf(config_file, "#Display colors\n");
      fprintf(config_file, "FG_COLOR_WIN = 37\n");
      fprintf(config_file, "FG_COLOR_HLT = 34\n");
      fprintf(config_file, "FG_COLOR_MBAR = 34\n");
      fprintf(config_file, "FG_COLOR_SBAR = 34\n");
      fprintf(config_file, "FG_COLOR_HBUT = 32\n");
      fprintf(config_file, "FG_COLOR_BUT = 37\n");
      fprintf(config_file, "BG_COLOR_WIN = 44\n");
      fprintf(config_file, "BG_COLOR_HLT = 47\n");
      fprintf(config_file, "BG_COLOR_MBAR = 47\n");
      fprintf(config_file, "BG_COLOR_SBAR = 47\n");
      fprintf(config_file, "BG_COLOR_HBUT = 41\n");
      fprintf(config_file, "BG_COLOR_BUT = 41\n");
      fprintf(config_file, "#Show README on startup\n");
      fprintf(config_file, "SHOW_README\n");
      fprintf(config_file, "#GnuDOS Level\n");
      fprintf(config_file, "GNU_DOS_LEVEL = 1\n");
      fprintf(config_file, "#Auto-indentation\n");
      fprintf(config_file, "AUTO_INDENT = 1\n");
      fclose(config_file);
      msgBox("Finished writing default values to ~/.mino.conf", OK, INFO);
      free(config_file_name);
      refreshView();
      return;
}

void write_config_file() 
{
      if(!(pass = getpwuid(geteuid()))) 
      {
	msgBox("Couldn't open home directory to write config file.", OK, ERROR);
	refreshView();
	return;
      }
      config_file_name = (char *) malloc(strlen(pass->pw_dir)+11);
      if(!config_file_name) { msgBox("Insufficient memory", OK, ERROR); refreshView(); return; }
      strcpy(config_file_name, pass->pw_dir);
      strcat(config_file_name, "/");
      strcat(config_file_name, ".mino.conf");
      if(!(config_file = fopen(config_file_name, "w"))) 
      {
	msgBox("Couldn't write to config file in home directory.", OK, ERROR);
	refreshView();
	return;
      }
      fprintf(config_file, "#Configuration file for mino program\n");
      fprintf(config_file, "#Please do not modify this file by hand\n");
      fprintf(config_file, "#Use the Options menu in mino to change program configuration.\n\n");
      fprintf(config_file, "#Line Wrapping\n");
      fprintf(config_file, "#If TRUE, lines cannot be longer than the screen width\n");
      fprintf(config_file, "#If FALSE, lines cannot be upto MAX_CHARS_PER_LINE characters\n");
      fprintf(config_file, "#Note this value is omitted if WRAP_LINES is TRUE\n");
      fprintf(config_file, "MAX_CHARS_PER_LINE = 100\n");
      fprintf(config_file, "WRAP_LINES = TRUE\n\n");
      fprintf(config_file, "#Number of spaces to insert when user presses TAB key\n");
      fprintf(config_file, "TAB_CHARS = %d\n\n", TAB_CHARS);
      fprintf(config_file, "#Default title for newly opened documents, no quotes\n");
      fprintf(config_file, "DEFAULT_TITLE = untitled\n\n");
      fprintf(config_file, "#Start mino with CAPS and INSERT set to OFF/ON\n");
      fprintf(config_file, "CAPS = OFF\n");
      fprintf(config_file, "INSERT = OFF\n\n");
      fprintf(config_file, "#Display colors\n");
      fprintf(config_file, "FG_COLOR_WIN = %d\n", FG_COLOR[COLOR_WINDOW]);
      fprintf(config_file, "FG_COLOR_HLT = %d\n", FG_COLOR[COLOR_HIGHLIGHT_TEXT]);
      fprintf(config_file, "FG_COLOR_MBAR = %d\n", FG_COLOR[COLOR_MENU_BAR]);
      fprintf(config_file, "FG_COLOR_SBAR = %d\n", FG_COLOR[COLOR_STATUS_BAR]);
      fprintf(config_file, "FG_COLOR_HBUT = %d\n", FG_COLOR[COLOR_HBUTTONS]);
      fprintf(config_file, "FG_COLOR_BUT = %d\n", FG_COLOR[COLOR_BUTTONS]);
      fprintf(config_file, "BG_COLOR_WIN = %d\n", BG_COLOR[COLOR_WINDOW]);
      fprintf(config_file, "BG_COLOR_HLT = %d\n", BG_COLOR[COLOR_HIGHLIGHT_TEXT]);
      fprintf(config_file, "BG_COLOR_MBAR = %d\n", BG_COLOR[COLOR_MENU_BAR]);
      fprintf(config_file, "BG_COLOR_SBAR = %d\n", BG_COLOR[COLOR_STATUS_BAR]);
      fprintf(config_file, "BG_COLOR_HBUT = %d\n", BG_COLOR[COLOR_HBUTTONS]);
      fprintf(config_file, "BG_COLOR_BUT = %d\n", BG_COLOR[COLOR_BUTTONS]);
      if(SHOW_README) 
      {
	fprintf(config_file, "#Show README on startup\n");
	fprintf(config_file, "SHOW_README\n");
      }
      fprintf(config_file, "#GnuDOS Level\n");
      fprintf(config_file, "GNU_DOS_LEVEL = %d\n", GNU_DOS_LEVEL);
      fprintf(config_file, "#Auto-indentation\n");
      fprintf(config_file, "AUTO_INDENT = %d\n", AUTO_INDENT);
      fclose(config_file);
      //msgBox("Finished writing default values to ~/.mino.conf", OK, INFO);
      free(config_file_name);
      refreshView();
      return;    
}


void loadKeywords(hmode mode) 
{
  switch(mode) 
  {
    case(C_MODE):
      //basic C language keywords
      keyword[0] = "auto";
      keyword[1] = "break";
      keyword[2] = "case";
      keyword[3] = "char";
      keyword[4] = "const";
      keyword[5] = "continue";
      keyword[6] = "default";
      keyword[8] = "do";
      keyword[7] = "double";
      keyword[9] = "else";
      keyword[10] = "enum";
      keyword[11] = "extern";
      keyword[12] = "float";
      keyword[13] = "for";
      keyword[14] = "goto";
      keyword[15] = "if";
      keyword[16] = "int";
      keyword[17] = "long";
      keyword[18] = "register";
      keyword[19] = "return";
      keyword[20] = "short";
      keyword[21] = "signed";
      keyword[22] = "sizeof";
      keyword[23] = "static";
      keyword[24] = "struct";
      keyword[25] = "switch";
      keyword[26] = "typedef";
      keyword[27] = "union";
      keyword[28] = "unsigned";
      keyword[29] = "void";
      keyword[30] = "volatile";
      keyword[31] = "while";
      //math function names
      keyword[32] = "acos";
      keyword[33] = "asin";
      keyword[35] = "atan";
      keyword[34] = "atan2";
      keyword[37] = "cos";
      keyword[36] = "cosh";
      keyword[39] = "sin";
      keyword[38] = "sinh";
      keyword[41] = "tan";
      keyword[40] = "tanh";
      keyword[44] = "exp";
      keyword[42] = "frexp";
      keyword[43] = "ldexp";
      keyword[46] = "log";
      keyword[45] = "log10";
      keyword[47] = "modf";
      keyword[48] = "pow";
      keyword[49] = "sqrt";
      keyword[50] = "ceil";
      keyword[51] = "fabs";
      keyword[52] = "floor";
      keyword[53] = "fmod";
      //file function names
      keyword[54] = "clearerr";
      keyword[55] = "fclose";
      keyword[56] = "feof";
      keyword[57] = "ferror";
      keyword[58] = "fflush";
      keyword[59] = "fgetpos";
      keyword[60] = "fopen";
      keyword[61] = "fread";
      keyword[62] = "freopen";
      keyword[63] = "fseek";
      keyword[64] = "fsetpos";
      keyword[65] = "ftell";
      keyword[66] = "fwrite";
      keyword[67] = "remove";
      keyword[68] = "rename";
      keyword[69] = "rewind";
      keyword[70] = "setbuf";
      keyword[71] = "setvbuf";
      keyword[72] = "tmpfile";
      keyword[73] = "tmpnam";
      //printf function names
      keyword[74] = "fprintf";
      keyword[79] = "printf";
      keyword[75] = "sprintf";
      keyword[76] = "vfprintf";
      keyword[77] = "vprintf";
      keyword[78] = "vsprintf";
      keyword[80] = "fscanf";
      keyword[82] = "scanf";
      keyword[81] = "sscanf";
      keyword[83] = "fgetc";
      keyword[84] = "fgets";
      keyword[85] = "fputc";
      keyword[86] = "fputs";
      keyword[88] = "getc";
      keyword[87] = "getchar";
      keyword[89] = "gets";
      keyword[91] = "putc";
      keyword[90] = "putchar";
      keyword[92] = "puts";
      keyword[93] = "ungetc";
      keyword[94] = "perror";
      //stdlib function names
      keyword[95] = "atof";
      keyword[96] = "atoi";
      keyword[97] = "atol";
      keyword[98] = "strtod";
      keyword[99] = "strtol";
      keyword[100] = "strtoul";
      keyword[101] = "calloc";
      keyword[102] = "free";
      keyword[103] = "malloc";
      keyword[104] = "realloc";
      keyword[105] = "abort";
      keyword[106] = "atexit";
      keyword[107] = "exit";
      keyword[108] = "getenv";
      keyword[109] = "system";
      keyword[110] = "bsearch";
      keyword[111] = "qsort";
      keyword[112] = "abs";
      keyword[113] = "div";
      keyword[114] = "labs";
      keyword[115] = "ldiv";
      keyword[117] = "rand";
      keyword[116] = "srand";
      keyword[118] = "mblen";
      keyword[119] = "mbstowcs";
      keyword[120] = "mbtowc";
      keyword[121] = "wcstombs";
      keyword[122] = "wctomb";
      //string function names
      keyword[123] = "memchr";
      keyword[124] = "memcmp";
      keyword[125] = "memcpy";
      keyword[126] = "memmove";
      keyword[127] = "memset";
      keyword[128] = "strcat";
      keyword[129] = "strncat";
      keyword[130] = "strchr";
      keyword[131] = "strcmp";
      keyword[132] = "strcoll";
      keyword[133] = "strcpy";
      keyword[134] = "strncpy";
      keyword[135] = "strcspn";
      keyword[136] = "strerror";
      keyword[137] = "strlen";
      keyword[138] = "strpbrk";
      keyword[139] = "strrchr";
      keyword[140] = "strspn";
      keyword[141] = "strstr";
      keyword[142] = "strtok";
      keyword[143] = "strxfrm";
      //time function names
      keyword[144] = "asctime";
      keyword[145] = "clock";
      keyword[146] = "ctime";
      keyword[147] = "difftime";
      keyword[148] = "gmtime";
      keyword[149] = "localtime";
      keyword[150] = "mktime";
      keyword[151] = "strftime";
      keyword[152] = "time";
      ////////
      keyword[153] = "stdin";
      keyword[154] = "stdout";
      keyword[155] = "stderr";
      total_keywords = 156;
      break;
      /////////////////////////////////////////////////
      /////////////////////////////////////////////////
      /////////////////////////////////////////////////
    case(CPP_MODE):
      //basic C++ language keywords
      keyword[0] = "alignas";
      keyword[1] = "alignof";
      keyword[3] = "and";
      keyword[2] = "and_eq";
      keyword[4] = "asm";
      keyword[5] = "auto";
      keyword[6] = "bitand";
      keyword[7] = "bitor";
      keyword[8] = "bool";
      keyword[9] = "break";
      keyword[10] = "case";
      keyword[11] = "catch";
      keyword[14] = "char";
      keyword[12] = "char16_t";
      keyword[13] = "char32_t";
      keyword[15] = "class";
      keyword[16] = "compl";
      keyword[19] = "const";
      keyword[17] = "constexpr";
      keyword[18] = "const_cast";
      keyword[20] = "continue";
      keyword[21] = "decltype";
      keyword[22] = "default";
      keyword[23] = "delete";
      keyword[25] = "do";
      keyword[24] = "double";
      keyword[26] = "dynamic_cast";
      keyword[27] = "else";
      keyword[28] = "enum";
      keyword[29] = "explicit";
      keyword[30] = "extern";
      keyword[31] = "export";
      keyword[32] = "false";
      keyword[33] = "float";
      keyword[34] = "for";
      keyword[35] = "friend";
      keyword[36] = "goto";
      keyword[37] = "if";
      keyword[38] = "inline";
      keyword[39] = "int";
      keyword[40] = "long";
      keyword[41] = "mutable";
      keyword[42] = "namespace";
      keyword[43] = "new";
      keyword[44] = "noexcept";
      keyword[46] = "not";
      keyword[45] = "not_eq";
      keyword[47] = "nullptr";
      keyword[48] = "operator";
      keyword[50] = "or";
      keyword[49] = "or_eq";
      keyword[51] = "private";
      keyword[52] = "protected";
      keyword[53] = "public";
      keyword[54] = "register";
      keyword[55] = "reinterpret_cast";
      keyword[56] = "return";
      keyword[57] = "short";
      keyword[58] = "signed";
      keyword[59] = "sizeof";
      keyword[62] = "static";
      keyword[60] = "static_assert";
      keyword[61] = "static_cast";
      keyword[63] = "struct";
      keyword[64] = "switch";
      keyword[65] = "template";
      keyword[66] = "this";
      keyword[67] = "thread_local";
      keyword[68] = "throw";
      keyword[69] = "true";
      keyword[70] = "try";
      keyword[71] = "typedef";
      keyword[72] = "typeid";
      keyword[73] = "typename";
      keyword[74] = "union";
      keyword[75] = "unsigned";
      keyword[76] = "using";
      keyword[77] = "virtual";
      keyword[78] = "void";
      keyword[79] = "volatile";
      keyword[80] = "wchar_t";
      keyword[81] = "while";
      keyword[83] = "xor";
      keyword[82] = "xor_eq";
      keyword[84] = "overried";
      keyword[85] = "final";
      //strings library
      keyword[89] = "string";
      keyword[86] = "wstring";
      keyword[87] = "u16string";
      keyword[88] = "u32string";
      //containers library
      keyword[90] = "array";
      keyword[91] = "vector";
      keyword[92] = "deque";
      keyword[93] = "forward_list";
      keyword[94] = "list";
      keyword[95] = "set";
      keyword[96] = "map";
      /*keyword[90] = "multiset";
      keyword[90] = "multimap";
      keyword[90] = "unordered_set";
      keyword[100] = "unordered_map";
      keyword[100] = "unordered_multiset";
      keyword[100] = "unordered_multimap";
      keyword[100] = "stack";
      keyword[100] = "queue";
      keyword[100] = "all_of";
      keyword[100] = "any_of";
      keyword[100] = "none_of";
      keyword[100] = "for_each";
      keyword[100] = "count_if";
      keyword[110] = "count";
      keyword[110] = "mismatch";
      keyword[110] = "equal";
      keyword[110] = "find";
      keyword[110] = "find_if";
      keyword[110] = "find_if_not";
      keyword[110] = "find_end";
      keyword[110] = "find_first_of";
      keyword[110] = "adjacent_find";
      keyword[110] = "search";
      keyword[120] = "search_n";
      keyword[120] = "copy";
      keyword[120] = "copy_if";
      keyword[120] = "copy_n";
      keyword[120] = "copy_backward";
      keyword[120] = "move";
      keyword[120] = "move_backward";
      keyword[120] = "fill";
      keyword[120] = "fill_n";
      keyword[120] = "transform";
      keyword[130] = "generate";
      keyword[] = "generate_n";
      keyword[] = "remove";
      keyword[] = "remove_if";
      keyword[] = "remove_copy";
      keyword[] = "remove_copy_if";
      keyword[] = "replace";
      keyword[] = "replace_if";
      keyword[] = "replace_copy";
      keyword[] = "replace_copy_if";
      keyword[] = "swap";
      keyword[] = "swap_ranges";
      keyword[] = "iter_swap";
      keyword[] = "reverse";
      keyword[] = "reverse_copy";
      keyword[] = "rotate";
      keyword[] = "rotate_copy";
      keyword[] = "random_shuffle";
      keyword[] = "shuffle";
      keyword[] = "unique";
      keyword[] = "unique_copy";
      keyword[] = "is_partitioned";
      keyword[] = "partition";
      keyword[] = "partition_copy";
      keyword[] = "stable_partition";
      keyword[] = "partition_point";
      keyword[] = "is_sorted";
      keyword[] = "is_sorted_until";
      keyword[] = "sort";
      keyword[] = "partial_sort";
      keyword[] = "partial_sort_copy";
      keyword[] = "stable_sort";
      keyword[] = "nth_element";
      keyword[] = "lower_bound";
      keyword[] = "upper_bound";
      keyword[] = "binary_search";
      keyword[] = "equal_range";
      keyword[] = "merge";
      keyword[] = "inplace_merge";
      keyword[] = "includes";
      keyword[] = "set_difference";
      keyword[] = "set_intersection";
      keyword[] = "set_symmetric_difference";
      keyword[] = "set_union";
      keyword[] = "is_heap";
      keyword[] = "is_heap_until";
      keyword[] = "make_heap";
      keyword[] = "push_heap";
      keyword[] = "pop_heap";
      keyword[] = "sort_heap";
      keyword[] = "max";
      keyword[] = "max_element";
      keyword[] = "min";
      keyword[] = "min_element";
      keyword[] = "minmax";
      keyword[] = "minmax_element";
      keyword[] = "lexicographical_compare";
      keyword[] = "is_permutation";
      keyword[] = "next_permutation";
      keyword[] = "prev_permutation";
      keyword[] = "itoa";
      keyword[] = "accumulate";
      keyword[] = "inner_product";
      keyword[] = "adjacent_difference";
      keyword[] = "partial_sum";*/
      keyword[97] = "qsort";
      keyword[98] = "bsearch";
      //I/O functions
      keyword[99] = "srand";
      keyword[100] = "rand";
      keyword[101] = "std";
      keyword[102] = "fopen";
      keyword[103] = "freopen";
      keyword[104] = "fclose";
      keyword[105] = "fflush";
      keyword[106] = "fwide";
      keyword[107] = "setbuf";
      keyword[108] = "setvbuf";
      keyword[109] = "fread";
      keyword[110] = "fwrite";
      keyword[111] = "fgetc";
      keyword[112] = "getc";
      keyword[113] = "fgets";
      keyword[114] = "fputc";
      keyword[115] = "putc";
      keyword[116] = "fputs";
      keyword[117] = "getchar";
      keyword[118] = "gets";
      keyword[119] = "putchar";
      keyword[120] = "puts";
      keyword[121] = "ungetc";
      keyword[122] = "fgetwc";
      keyword[130] = "getwc";
      keyword[124] = "fgetws";
      keyword[125] = "fputwc";
      keyword[126] = "putwc";
      keyword[127] = "fputws";
      keyword[128] = "getwchar";
      keyword[129] = "putwchar";
      keyword[123] = "ungetwc";
      keyword[136] = "scanf";
      keyword[131] = "fscanf";
      keyword[132] = "sscanf";
      keyword[133] = "vscanf";
      keyword[134] = "vfscanf";
      keyword[135] = "vsscanf";
      keyword[144] = "printf";
      keyword[137] = "fprintf";
      keyword[138] = "sprintf";
      keyword[139] = "snprintf";
      keyword[140] = "vprintf";
      keyword[141] = "vfprintf";
      keyword[142] = "vsprintf";
      keyword[143] = "vsnprintf";
      keyword[150] = "wscanf";
      keyword[145] = "fwscanf";
      keyword[146] = "swscanf";
      keyword[147] = "vwscanf";
      keyword[148] = "vfwscanf";
      keyword[149] = "vswscanf";
      keyword[156] = "wprintf";
      keyword[151] = "fwprintf";
      keyword[152] = "swprintf";
      keyword[153] = "vwprintf";
      keyword[154] = "vfwprintf";
      keyword[155] = "vswprintf";
      keyword[157] = "ftell";
      keyword[158] = "fgetpos";
      keyword[159] = "fseek";
      keyword[160] = "fsetpos";
      keyword[161] = "rewind";
      keyword[162] = "clearerr";
      keyword[163] = "feof";
      keyword[164] = "ferror";
      keyword[165] = "perror";
      keyword[166] = "remove";
      keyword[167] = "rename";
      keyword[168] = "tmpfile";
      keyword[169] = "tmpnam";
      keyword[170] = "stdin";
      keyword[171] = "stdout";
      keyword[172] = "stderr";
      total_keywords = 173;
      break;
      /////////////////////////////////////////////////
      /////////////////////////////////////////////////
      /////////////////////////////////////////////////
    case(SHELL_MODE):
      //shell keywords
      keyword[0] = "!";
      keyword[1] = "case";
      keyword[3] = "do";
      keyword[2] = "done";
      keyword[4] = "elif";
      keyword[5] = "else";
      keyword[6] = "esac";
      keyword[7] = "fi";
      keyword[8] = "for";
      keyword[9] = "function";
      keyword[10] = "if";
      keyword[11] = "in";
      keyword[12] = "select";
      keyword[13] = "then";
      keyword[14] = "until";
      keyword[15] = "while";
      keyword[16] = "time";
      keyword[17] = "[[";
      keyword[18] = "]]";
      //shell builtin functions
      keyword[19] = ".";
      keyword[20] = ":";
      keyword[21] = "[";
      keyword[22] = "alias";
      keyword[23] = "bg";
      keyword[24] = "bind";
      keyword[25] = "break";
      keyword[26] = "builtin";
      keyword[27] = "caller";
      keyword[28] = "cd";
      keyword[29] = "command";
      keyword[30] = "compgen";
      keyword[31] = "complete";
      keyword[32] = "compopt";
      keyword[33] = "continue";
      keyword[34] = "declare";
      keyword[35] = "dirs";
      keyword[36] = "disown";
      keyword[37] = "echo";
      keyword[38] = "enable";
      keyword[39] = "eval";
      keyword[40] = "exec";
      keyword[41] = "exit";
      keyword[42] = "export";
      keyword[43] = "false";
      keyword[44] = "fc";
      keyword[45] = "fg";
      keyword[46] = "getopts";
      keyword[47] = "hash";
      keyword[48] = "help";
      keyword[49] = "history";
      keyword[50] = "jobs";
      keyword[51] = "kill";
      keyword[52] = "let";
      keyword[53] = "local";
      keyword[54] = "logout";
      keyword[55] = "mapfile";
      keyword[56] = "popd";
      keyword[57] = "printf";
      keyword[58] = "pushd";
      keyword[59] = "pwd";
      keyword[62] = "read";
      keyword[60] = "readarray";
      keyword[61] = "readonly";
      keyword[63] = "return";
      keyword[64] = "set";
      keyword[65] = "shift";
      keyword[66] = "shopt";
      keyword[67] = "source";
      keyword[68] = "suspend";
      keyword[69] = "test";
      keyword[70] = "times";
      keyword[71] = "trap";
      keyword[72] = "true";
      keyword[74] = "type";
      keyword[73] = "typeset";
      keyword[75] = "ulimit";
      keyword[76] = "umask";
      keyword[77] = "unalias";
      keyword[78] = "unset";
      keyword[79] = "wait";
      keyword[80] = "{";
      keyword[81] = "}";
      total_keywords = 82;
      break;
      /////////////////////////////////////////////////
      /////////////////////////////////////////////////
      /////////////////////////////////////////////////
    case(PERL_MODE):
      //PERL functions
      keyword[0] = "-A";
      keyword[1] = "-B";
      keyword[2] = "-b";
      keyword[3] = "-C";
      keyword[4] = "-c";
      keyword[5] = "-d";
      keyword[6] = "-e";
      keyword[7] = "-f";
      keyword[8] = "-g";
      keyword[9] = "-k";
      keyword[10] = "-l";
      keyword[11] = "-M";
      keyword[12] = "-O";
      keyword[13] = "-o";
      keyword[14] = "-p";
      keyword[15] = "-r";
      keyword[16] = "-R";
      keyword[17] = "-s";
      keyword[18] = "-S";
      keyword[19] = "-T";
      keyword[20] = "-t";
      keyword[21] = "-u";
      keyword[22] = "-w";
      keyword[23] = "-W";
      keyword[24] = "-X";
      keyword[25] = "-x";
      keyword[26] = "-z";
      keyword[27] = "abs";
      keyword[28] = "accept";
      keyword[29] = "alarm";
      keyword[30] = "atan2";
      keyword[31] = "AUTOLOAD";
      keyword[32] = "BEGIN";
      keyword[33] = "bind";
      keyword[34] = "binmode";
      keyword[35] = "bless";
      keyword[36] = "break";
      keyword[37] = "caller";
      keyword[38] = "chdir";
      keyword[39] = "CHECK";
      keyword[40] = "chmod";
      keyword[41] = "chomp";
      keyword[42] = "chop";
      keyword[43] = "chown";
      keyword[45] = "chr";
      keyword[44] = "chroot";
      keyword[47] = "close";
      keyword[46] = "closedir";
      keyword[48] = "connect";
      keyword[49] = "cos";
      keyword[50] = "crypt";
      keyword[51] = "dbmclose";
      keyword[52] = "dbmopen";
      keyword[53] = "defined";
      keyword[54] = "delete";
      keyword[55] = "DESTROY";
      keyword[56] = "die";
      keyword[57] = "dump";
      keyword[58] = "each";
      keyword[59] = "END";
      keyword[60] = "endgrent";
      keyword[61] = "endhostent";
      keyword[62] = "endprotoent";
      keyword[63] = "endpwent";
      keyword[64] = "endservent";
      keyword[65] = "eof";
      keyword[66] = "eval";
      keyword[67] = "exec";
      keyword[68] = "exists";
      keyword[69] = "exit";
      keyword[70] = "fcntl";
      keyword[71] = "fileno";
      keyword[72] = "flock";
      keyword[73] = "fork";
      keyword[74] = "format";
      keyword[75] = "formline";
      keyword[76] = "getc";
      keyword[77] = "getgrent";
      keyword[78] = "getgrgid";
      keyword[79] = "getgrnam";
      keyword[80] = "gethostbyaddr";
      keyword[81] = "gethostbyname";
      keyword[82] = "gethostent";
      keyword[83] = "getlogin";
      keyword[84] = "getnetbyaddr";
      keyword[85] = "getnetbyname";
      keyword[86] = "getnetent";
      keyword[87] = "getpeername";
      keyword[88] = "getpgrp";
      keyword[89] = "getppid";
      keyword[90] = "getpriority";
      keyword[91] = "getprotobyname";
      keyword[92] = "getprotobynumber";
      keyword[93] = "getprotoent";
      keyword[94] = "getpwent";
      keyword[95] = "getpwnam";
      keyword[96] = "getpwuid";
      keyword[97] = "getservbyname";
      keyword[98] = "getservbyport";
      keyword[99] = "getservent";
      keyword[100] = "getsockname";
      keyword[101] = "getsockopt";
      keyword[102] = "glob";
      keyword[103] = "gmtime";
      keyword[104] = "goto";
      keyword[105] = "grep";
      keyword[106] = "hex";
      keyword[107] = "index";
      keyword[108] = "INIT";
      keyword[109] = "int";
      keyword[110] = "ioctl";
      keyword[111] = "join";
      keyword[112] = "keys";
      keyword[113] = "kill";
      keyword[114] = "last";
      keyword[116] = "lc";
      keyword[115] = "lcfirst";
      keyword[117] = "length";
      keyword[118] = "link";
      keyword[119] = "listen";
      keyword[121] = "local";
      keyword[120] = "localtime";
      keyword[122] = "log";
      keyword[123] = "lstat";
      keyword[124] = "map";
      keyword[125] = "mkdir";
      keyword[126] = "msgctl";
      keyword[127] = "msgget";
      keyword[128] = "msgrcv";
      keyword[129] = "msgsnd";
      keyword[130] = "my";
      keyword[131] = "next";
      keyword[132] = "not";
      keyword[133] = "oct";
      keyword[135] = "open";
      keyword[134] = "opendir";
      keyword[136] = "ord";
      keyword[137] = "our";
      keyword[138] = "pack";
      keyword[139] = "pipe";
      keyword[140] = "pop";
      keyword[141] = "pos";
      keyword[143] = "print";
      keyword[142] = "printf";
      keyword[144] = "prototype";
      keyword[145] = "push";
      keyword[146] = "quotemeta";
      keyword[147] = "rand";
      keyword[152] = "read";
      keyword[148] = "readdir";
      keyword[149] = "readline";
      keyword[150] = "readlink";
      keyword[151] = "readpipe";
      keyword[153] = "recv";
      keyword[154] = "redo";
      keyword[155] = "ref";
      keyword[156] = "rename";
      keyword[157] = "require";
      keyword[158] = "reset";
      keyword[159] = "return";
      keyword[160] = "reverse";
      keyword[161] = "rewinddir";
      keyword[162] = "rindex";
      keyword[163] = "rmdir";
      keyword[164] = "say";
      keyword[165] = "scalar";
      keyword[167] = "seek";
      keyword[166] = "seekdir";
      keyword[168] = "select";
      keyword[169] = "semctl";
      keyword[170] = "semget";
      keyword[171] = "semop";
      keyword[172] = "send";
      keyword[173] = "setgrent";
      keyword[174] = "sethostent";
      keyword[175] = "setnetent";
      keyword[176] = "setpgrp";
      keyword[177] = "setpriority";
      keyword[178] = "setprotoent";
      keyword[179] = "setpwent";
      keyword[180] = "setservent";
      keyword[181] = "setsockopt";
      keyword[182] = "shift";
      keyword[183] = "shmctl";
      keyword[184] = "shmget";
      keyword[185] = "shmread";
      keyword[186] = "shmwrite";
      keyword[187] = "shutdown";
      keyword[188] = "sin";
      keyword[189] = "sleep";
      keyword[191] = "socket";
      keyword[190] = "socketpair";
      keyword[192] = "sort";
      keyword[193] = "splice";
      keyword[194] = "split";
      keyword[195] = "sprintf";
      keyword[196] = "sqrt";
      keyword[197] = "srand";
      keyword[199] = "stat";
      keyword[198] = "state";
      keyword[200] = "study";
      keyword[201] = "substr";
      keyword[202] = "symlink";
      keyword[203] = "syscall";
      keyword[204] = "sysopen";
      keyword[205] = "sysread";
      keyword[206] = "sysseek";
      keyword[207] = "system";
      keyword[208] = "syswrite";
      keyword[210] = "tell";
      keyword[209] = "telldir";
      keyword[212] = "tie";
      keyword[211] = "tied";
      keyword[214] = "time";
      keyword[213] = "times";
      keyword[215] = "truncate";
      keyword[217] = "uc";
      keyword[216] = "ucfirst";
      keyword[218] = "umask";
      keyword[219] = "undef";
      keyword[220] = "UNITCHECK";
      keyword[221] = "unlink";
      keyword[222] = "unpack";
      keyword[223] = "unshift";
      keyword[224] = "untie";
      keyword[225] = "use";
      keyword[226] = "utime";
      keyword[227] = "values";
      keyword[228] = "vec";
      keyword[230] = "wait";
      keyword[229] = "waitpid";
      keyword[231] = "wantarray";
      keyword[232] = "warn";
      keyword[233] = "write";
      //PERL syntax
      keyword[234] = "__DATA__";
      keyword[235] = "__END__";
      keyword[236] = "__FILE__";
      keyword[237] = "__LINE__";
      keyword[238] = "__PACKAGE__";
      keyword[239] = "and";
      keyword[240] = "cmp";
      keyword[241] = "continue";
      keyword[242] = "CORE";
      keyword[243] = "do";
      keyword[244] = "else";
      keyword[245] = "elsif";
      keyword[246] = "eq";
      keyword[247] = "exp";
      keyword[249] = "for";
      keyword[248] = "foreach";
      keyword[250] = "ge";
      keyword[251] = "gt";
      keyword[252] = "if";
      keyword[253] = "le";
      keyword[254] = "lock";
      keyword[255] = "lt";
      keyword[256] = "m";
      keyword[257] = "ne";
      keyword[258] = "no";
      keyword[259] = "or";
      keyword[260] = "package";
      keyword[265] = "q";
      keyword[261] = "qq";
      keyword[262] = "qr";
      keyword[263] = "qw";
      keyword[264] = "qx";
      keyword[267] = "s";
      keyword[266] = "sub";
      keyword[268] = "tr";
      keyword[269] = "unless";
      keyword[270] = "until";
      keyword[271] = "while";
      keyword[272] = "xor";
      keyword[273] = "y";
      //PERL variables
      keyword[274] = "$!";
      keyword[275] = "$\"";
      keyword[276] = "$#";
      keyword[277] = "$$";
      keyword[278] = "$%";
      keyword[279] = "$&";
      keyword[280] = "$'";
      keyword[281] = "$(";
      keyword[282] = "$)";
      keyword[283] = "$*";
      keyword[284] = "$+";
      keyword[285] = "$,";
      keyword[286] = "$-";
      keyword[287] = "$.";
      keyword[288] = "$/";
      keyword[289] = "$0";
      keyword[290] = "$:";
      keyword[291] = "$;";
      keyword[292] = "$<";
      keyword[293] = "$=";
      keyword[294] = "$>";
      keyword[295] = "$?";
      keyword[296] = "$@";
      keyword[297] = "$[";
      keyword[298] = "$\\";
      keyword[299] = "$]";
      keyword[300] = "$^";
      keyword[301] = "$^A";
      keyword[302] = "$^C";
      keyword[303] = "$^CHILD_ERROR_NATIVE";
      keyword[304] = "$^D";
      keyword[306] = "$^E";
      keyword[305] = "$^ENCODING";
      keyword[307] = "$^F";
      keyword[308] = "$^H";
      keyword[309] = "$^I";
      keyword[310] = "$^L";
      keyword[311] = "$^M";
      keyword[312] = "$^N";
      keyword[314] = "$^O";
      keyword[313] = "$^OPEN";
      keyword[315] = "$^P";
      keyword[318] = "$^R";
      keyword[316] = "$^RE_DEBUG_FLAGS";
      keyword[317] = "$^RE_TRIE_MAXBUF";
      keyword[319] = "$^S";
      keyword[321] = "$^T";
      keyword[320] = "$^TAINT";
      keyword[322] = "$^UNICODE";
      keyword[323] = "$^UTF8LOCALE";
      keyword[324] = "$^V";
      keyword[327] = "$^W";
      keyword[325] = "$^WARNING_BITS";
      keyword[326] = "$^WIDE_SYSTEM_CALLS";
      keyword[328] = "$^X";
      keyword[329] = "$_";
      keyword[330] = "$`";
      keyword[331] = "$a";
      keyword[332] = "$ACCUMULATOR";
      keyword[334] = "$ARG";
      keyword[333] = "$ARGV";
      keyword[335] = "$b";
      keyword[336] = "$BASETIME";
      keyword[337] = "$CHILD_ERROR";
      keyword[338] = "$COMPILING";
      keyword[339] = "$DEBUGGING";
      keyword[340] = "$EFFECTIVE_GROUP_ID";
      keyword[341] = "$EFFECTIVE_USER_ID";
      keyword[342] = "$EGID";
      keyword[343] = "$ERRNO";
      keyword[344] = "$EUID";
      keyword[345] = "$EVAL_ERROR";
      keyword[346] = "$EXCEPTIONS_BEING_CAUGHT";
      keyword[347] = "$EXECUTABLE_NAME";
      keyword[348] = "$EXTENDED_OS_ERROR";
      keyword[349] = "$FORMAT_FORMFEED";
      keyword[350] = "$FORMAT_LINE_BREAK_CHARACTERS";
      keyword[351] = "$FORMAT_LINES_LEFT";
      keyword[352] = "$FORMAT_LINES_PER_PAGE";
      keyword[353] = "$FORMAT_NAME";
      keyword[354] = "$FORMAT_PAGE_NUMBER";
      keyword[355] = "$FORMAT_TOP_NAME";
      keyword[356] = "$GID";
      keyword[357] = "$INPLACE_Mino";
      keyword[358] = "$INPUT_LINE_NUMBER";
      keyword[359] = "$INPUT_RECORD_SEPARATOR";
      keyword[360] = "$LAST_MATCH_END";
      keyword[361] = "$LAST_PAREN_MATCH";
      keyword[362] = "$LAST_REGEXP_CODE_RESULT";
      keyword[363] = "$LIST_SEPARATOR";
      keyword[364] = "$MATCH";
      keyword[365] = "$MULTILINE_MATCHING";
      keyword[366] = "$NR";
      keyword[367] = "$OFMT";
      keyword[368] = "$OFS";
      keyword[369] = "$ORS";
      keyword[370] = "$OS_ERROR";
      keyword[371] = "$OSNAME";
      keyword[372] = "$OUTPUT_AUTO_FLUSH";
      keyword[373] = "$OUTPUT_FIELD_SEPARATOR";
      keyword[374] = "$OUTPUT_RECORD_SEPARATOR";
      keyword[375] = "$PERL_VERSION";
      keyword[376] = "$PERLDB";
      keyword[377] = "$PID";
      keyword[378] = "$POSMATCH";
      keyword[379] = "$PREMATCH";
      keyword[380] = "$PROCESS_ID";
      keyword[381] = "$PROGRAM_NAME";
      keyword[382] = "$REAL_GROUP_ID";
      keyword[383] = "$REAL_USER_ID";
      keyword[384] = "$RS";
      keyword[385] = "$SUBSCRIPT_SEPARATOR";
      keyword[386] = "$SUBSEP";
      keyword[387] = "$SYSTEM_FD_MAX";
      keyword[388] = "$UID";
      keyword[389] = "$WARNING";
      keyword[390] = "$|";
      keyword[391] = "$~";
      keyword[392] = "%!";
      keyword[393] = "%^H";
      keyword[394] = "%ENV";
      keyword[395] = "%INC";
      keyword[396] = "%OVERLOAD";
      keyword[397] = "%SIG";
      keyword[398] = "@+";
      keyword[399] = "@-";
      keyword[400] = "@_";
      keyword[401] = "@ARGV";
      keyword[402] = "@INC";
      keyword[403] = "@LAST_MATCH_START";
      //PERL file handles
      keyword[405] = "ARGV";
      keyword[404] = "ARGVOUT";
      keyword[406] = "STDERR";
      keyword[407] = "STDIN";
      keyword[408] = "STDOUT";
      total_keywords = 409;
      break;
      /////////////////////////////////////////////////
      /////////////////////////////////////////////////
      /////////////////////////////////////////////////
    case(TEXI_MODE):
      //TEXI keywords
      keyword[0] = "@!";
      keyword[1] = "@\"";
      keyword[2] = "@'";
      keyword[3] = "@*";
      keyword[4] = "@,";
      keyword[5] = "@-";
      keyword[6] = "@.";
      keyword[7] = "@/";
      keyword[8] = "@:";
      keyword[9] = "@=";
      keyword[10] = "@?";
      keyword[11] = "@@";
      keyword[12] = "@atchar";
      keyword[13] = "@\\";
      keyword[14] = "@^";
      keyword[15] = "@`";
      keyword[16] = "@{";
      keyword[17] = "@lbracechar";
      keyword[18] = "@}";
      keyword[19] = "@rbracechar";
      keyword[20] = "@~";
      keyword[21] = "@AA";
      keyword[22] = "@aa";
      keyword[23] = "@abbr";
      keyword[24] = "@acronym";
      keyword[25] = "@AE";
      keyword[26] = "@ae";
      keyword[27] = "@afivepaper";
      keyword[28] = "@afourlatex";
      keyword[29] = "@afourpaper";
      keyword[30] = "@afourwide";
      keyword[31] = "@alias";
      keyword[32] = "@allowcodebreaks";
      keyword[33] = "@anchor";
      keyword[34] = "@appendixsection";
      keyword[35] = "@appendixsec";
      keyword[36] = "@appendixsubsec";
      keyword[37] = "@appendixsubsubsec";
      keyword[38] = "@appendix";
      keyword[39] = "@arrow";
      keyword[40] = "@asis";
      keyword[41] = "@author";
      keyword[42] = "@bullet";
      keyword[43] = "@bye";
      keyword[44] = "@b";
      keyword[45] = "@caption";
      keyword[46] = "@cartouche";
      keyword[47] = "@centerchap";
      keyword[48] = "@center";
      keyword[49] = "@chapheading";
      keyword[50] = "@chapter";
      keyword[51] = "@cindex";
      keyword[52] = "@cite";
      keyword[53] = "@clear";
      keyword[54] = "@clicksequence";
      keyword[55] = "@clickstyle";
      keyword[56] = "@click";
      keyword[57] = "@codequotebacktick";
      keyword[58] = "@codequoteundirected";
      keyword[59] = "@code";
      keyword[60] = "@command";
      keyword[61] = "@comma";
      keyword[62] = "@comment";
      keyword[63] = "@contents";
      keyword[64] = "@copying";
      keyword[65] = "@copyright";
      keyword[66] = "@c";
      keyword[67] = "@defcodeindex";
      keyword[68] = "@defcvx";
      keyword[69] = "@defcv";
      keyword[70] = "@deffnx";
      keyword[71] = "@deffn";
      keyword[72] = "@defindex";
      keyword[73] = "@definfoenclose";
      keyword[74] = "@defivarx";
      keyword[75] = "@defivar";
      keyword[76] = "@defmacx";
      keyword[77] = "@defmac";
      keyword[78] = "@defmethodx";
      keyword[79] = "@defmethod";
      keyword[80] = "@defoptx";
      keyword[81] = "@defopt";
      keyword[82] = "@defopx";
      keyword[83] = "@defop";
      keyword[84] = "@defspecx";
      keyword[85] = "@defspec";
      keyword[86] = "@deftpx";
      keyword[87] = "@deftp";
      keyword[88] = "@deftypecvx";
      keyword[89] = "@deftypecv";
      keyword[90] = "@deftypefnnewline";
      keyword[91] = "@deftypefnx";
      keyword[92] = "@deftypefn";
      keyword[93] = "@deftypefunx";
      keyword[94] = "@deftypefun";
      keyword[95] = "@deftypeivarx";
      keyword[96] = "@deftypeivar";
      keyword[97] = "@deftypemethodx";
      keyword[98] = "@deftypemethod";
      keyword[99] = "@deftypeopx";
      keyword[100] = "@deftypeop";
      keyword[101] = "@deftypevarx";
      keyword[102] = "@deftypevar";
      keyword[103] = "@deftypevrx";
      keyword[104] = "@deftypevr";
      keyword[105] = "@defunx";
      keyword[106] = "@defun";
      keyword[107] = "@defvarx";
      keyword[108] = "@defvar";
      keyword[109] = "@defvrx";
      keyword[110] = "@defvr";
      keyword[111] = "@detailmenu";
      keyword[112] = "@dfn";
      keyword[113] = "@DH";
      keyword[114] = "@dh";
      keyword[115] = "@dircategory";
      keyword[116] = "@direntry";
      keyword[117] = "@display";
      keyword[118] = "@dmn";
      keyword[119] = "@docbook";
      keyword[120] = "@documentdescription";
      keyword[121] = "@documentlanguage";
      keyword[122] = "@dotaccent";
      keyword[123] = "@dotless";
      keyword[124] = "@dots";
      keyword[125] = "@email";
      keyword[126] = "@emph";
      keyword[127] = "@enddots";
      keyword[128] = "@end";
      keyword[129] = "@enumerate";
      keyword[130] = "@env";
      keyword[131] = "@equiv";
      keyword[132] = "@errormsg";
      keyword[133] = "@error";
      keyword[134] = "@euro";
      keyword[135] = "@evenfooting";
      keyword[136] = "@evenheading";
      keyword[137] = "@exampleindent";
      keyword[138] = "@example";
      keyword[139] = "@exclamdown";
      keyword[140] = "@exdent";
      keyword[141] = "@expansion";
      keyword[142] = "@file";
      keyword[143] = "@finalout";
      keyword[144] = "@findex";
      keyword[145] = "@firstparagraphindent";
      keyword[146] = "@float";
      keyword[147] = "@flushleft";
      keyword[148] = "@flushright";
      keyword[149] = "@fonttextsize";
      keyword[150] = "@footnotestyle";
      keyword[151] = "@footnote";
      keyword[152] = "@format";
      keyword[153] = "@frenchspacing";
      keyword[154] = "@ftable";
      keyword[155] = "@geq";
      keyword[156] = "@group";
      keyword[157] = "@guillemetleft";
      keyword[158] = "@guillemetright";
      keyword[159] = "@guillemotleft";
      keyword[160] = "@guillemotright";
      keyword[161] = "@guilsinglleft";
      keyword[162] = "@guilsinglright";
      keyword[163] = "@H";
      keyword[164] = "@hashchar";
      keyword[165] = "@headings";
      keyword[166] = "@heading";
      keyword[167] = "@headitemfont";
      keyword[168] = "@headitem";
      keyword[169] = "@html";
      keyword[170] = "@hyphenation";
      keyword[171] = "@ifcommanddefined";
      keyword[172] = "@ifcommandnotdefined";
      keyword[173] = "@ifdocbook";
      keyword[174] = "@ifhtml";
      keyword[175] = "@ifinfo";
      keyword[176] = "@ifnotdocbook";
      keyword[177] = "@ifnothtml";
      keyword[178] = "@ifnotplaintext";
      keyword[179] = "@ifnottex";
      keyword[180] = "@ifnotxml";
      keyword[181] = "@ifnotinfo";
      keyword[182] = "@ifplaintext";
      keyword[183] = "@ifset";
      keyword[184] = "@iftex";
      keyword[185] = "@ifxml";
      keyword[186] = "@ignore";
      keyword[187] = "@image";
      keyword[188] = "@include";
      keyword[189] = "@indentedblock";
      keyword[190] = "@indent";
      keyword[191] = "@indicateurl";
      keyword[192] = "@inforef";
      keyword[193] = "@inlinefmtifelse";
      keyword[194] = "@inlinefmt";
      keyword[195] = "@inlineifclear";
      keyword[196] = "@inlineifset";
      keyword[197] = "@inlineraw";
      keyword[198] = "\\input";
      keyword[199] = "@insertcopying";
      keyword[200] = "@itemize";
      keyword[201] = "@itemx";
      keyword[202] = "@item";
      keyword[203] = "@i";
      keyword[204] = "@kbdinputstyle";
      keyword[205] = "@kbd";
      keyword[206] = "@key";
      keyword[207] = "@kindex";
      keyword[208] = "@LaTeX";
      keyword[209] = "@leq";
      keyword[210] = "@lisp";
      keyword[211] = "@listoffloats";
      keyword[212] = "@lowersections";
      keyword[213] = "@L";
      keyword[214] = "@l";
      keyword[215] = "@macro";
      keyword[216] = "@majorheading";
      keyword[217] = "@math";
      keyword[218] = "@menu";
      keyword[219] = "@minus";
      keyword[220] = "@multitable";
      keyword[221] = "@need";
      keyword[222] = "@node";
      keyword[223] = "@noindent";
      keyword[224] = "@novalidate";
      keyword[225] = "@oddfooting";
      keyword[226] = "@oddheading";
      keyword[227] = "@OE";
      keyword[228] = "@oe";
      keyword[229] = "@ogonek";
      keyword[230] = "@option";
      keyword[231] = "@ordf";
      keyword[232] = "@ordm";
      keyword[233] = "@O";
      keyword[234] = "@o";
      keyword[235] = "@pagesizes";
      keyword[236] = "@page";
      keyword[237] = "@paragraphindent";
      keyword[238] = "@part";
      keyword[239] = "@pindex";
      keyword[240] = "@point";
      keyword[241] = "@pounds";
      keyword[242] = "@printindex";
      keyword[243] = "@print";
      keyword[244] = "@pxref";
      keyword[245] = "@questiondown";
      keyword[246] = "@quotation";
      keyword[247] = "@quotedblleft";
      keyword[248] = "@quotedblright";
      keyword[249] = "@quoteleft";
      keyword[250] = "@quoteright";
      keyword[251] = "@quotedblbase";
      keyword[252] = "@quotesinglbase";
      keyword[253] = "@raggedright";
      keyword[254] = "@raisesections";
      keyword[255] = "@refill";
      keyword[256] = "@ref";
      keyword[257] = "@registeredsymbol";
      keyword[258] = "@result";
      keyword[259] = "@ringaccent";
      keyword[260] = "@r";
      keyword[261] = "@samp";
      keyword[262] = "@sansserif";
      keyword[263] = "@sc";
      keyword[264] = "@section";
      keyword[265] = "@setchapternewpage";
      keyword[266] = "@setcontentsaftertitlepage";
      keyword[267] = "@setfilename";
      keyword[268] = "@setshortcontentsaftertitlepage";
      keyword[269] = "@settitle";
      keyword[270] = "@set";
      keyword[271] = "@shortcaption";
      keyword[272] = "@shortcontents";
      keyword[273] = "@shorttitlepage";
      keyword[274] = "@slanted";
      keyword[275] = "@smallbook";
      keyword[276] = "@smalldisplay";
      keyword[277] = "@smallexample";
      keyword[278] = "@smallformat";
      keyword[279] = "@smallindentedblock";
      keyword[280] = "@smalllisp";
      keyword[281] = "@smallquotation";
      keyword[282] = "@sp";
      keyword[283] = "@ss";
      keyword[284] = "@strong";
      keyword[285] = "@subheading";
      keyword[286] = "@subsection";
      keyword[287] = "@subsubheading";
      keyword[288] = "@subsubsection";
      keyword[289] = "@subtitle";
      keyword[290] = "@summarycontents";
      keyword[291] = "@syncodeindex";
      keyword[292] = "@synindex";
      keyword[293] = "@table";
      keyword[294] = "@tab";
      keyword[295] = "@textdegree";
      keyword[296] = "@TeX";
      keyword[297] = "@tex";
      keyword[298] = "@thischapter";
      keyword[299] = "@thischaptername";
      keyword[300] = "@thischapternum";
      keyword[301] = "@thisfile";
      keyword[302] = "@thispage";
      keyword[303] = "@thistitle";
      keyword[304] = "@TH";
      keyword[305] = "@th";
      keyword[306] = "@tieaccent";
      keyword[307] = "@tie";
      keyword[308] = "@tindex";
      keyword[309] = "@titlefont";
      keyword[310] = "@titlepage";
      keyword[311] = "@title";
      keyword[312] = "@today";
      keyword[313] = "@top";
      keyword[314] = "@t";
      keyword[315] = "@ubaraccent";
      keyword[316] = "@udotaccent";
      keyword[317] = "@unmacro";
      keyword[318] = "@unnumberedsec";
      keyword[319] = "@unnumberedsubsec";
      keyword[320] = "@unnumberedsubsubsec";
      keyword[321] = "@unnumbered";
      keyword[322] = "@url";
      keyword[323] = "@urefbreakstyle";
      keyword[324] = "@uref";
      keyword[325] = "@u";
      keyword[326] = "@value";
      keyword[327] = "@var";
      keyword[328] = "@verbatiminclude";
      keyword[329] = "@verbatim";
      keyword[330] = "@verb";
      keyword[331] = "@vindex";
      keyword[332] = "@vskip";
      keyword[333] = "@vtable";
      keyword[334] = "@v";
      keyword[335] = "@w";
      keyword[336] = "@xml";
      keyword[337] = "@xrefautomaticsectiontitle";
      keyword[338] = "@xref";
      keyword[339] = "@";
      total_keywords = 340;
      break;
      /////////////////////////////////////////////////
      /////////////////////////////////////////////////
      /////////////////////////////////////////////////
    case(ASM_MODE):
      //x86 assembly instructions
      keyword[0] = "AAA";
      keyword[1] = "AAD";
      keyword[2] = "AAM";
      keyword[3] = "AAS";
      keyword[4] = "AAC";
      keyword[5] = "ADD";
      keyword[6] = "AND";
      keyword[7] = "CALL";
      keyword[8] = "CBW";
      keyword[9] = "CLC";
      keyword[10] = "CLD";
      keyword[11] = "CLI";
      keyword[12] = "CMC";
      keyword[13] = "CMPSB";
      keyword[14] = "CMPSW";
      keyword[15] = "CWD";
      keyword[16] = "DAA";
      keyword[17] = "DAS";
      keyword[18] = "DEC";
      keyword[19] = "DIV";
      keyword[20] = "ESC";
      keyword[21] = "HLT";
      keyword[22] = "IDIV";
      keyword[23] = "IMUL";
      keyword[24] = "INC";
      keyword[25] = "INTO";
      keyword[26] = "INT";
      keyword[27] = "INS";
      keyword[28] = "IN";
      keyword[29] = "IRET";
      keyword[30] = "JCC";
      keyword[31] = "JCXZ";
      keyword[32] = "JMP";
      keyword[33] = "LAHF";
      keyword[34] = "LDS";
      keyword[35] = "LEA";
      keyword[36] = "LES";
      keyword[37] = "LOCK";
      keyword[38] = "LODSB";
      keyword[39] = "LODSW";
      keyword[40] = "LOOPNE";
      keyword[41] = "LOOPNZ";
      keyword[42] = "LOOPE";
      keyword[43] = "LOOPZ";
      keyword[44] = "LOOPW";
      keyword[45] = "LOOPD";
      keyword[46] = "LOOP";
      keyword[47] = "MOVSB";
      keyword[48] = "MOVSW";
      keyword[49] = "MOVSD";
      keyword[50] = "MOVSX";
      keyword[51] = "MOVZX";
      keyword[52] = "MOVNTDQ";
      keyword[53] = "MOVNTI";
      keyword[54] = "MOVNTPD";
      keyword[55] = "MOVSXD";
      keyword[56] = "MOV";
      keyword[57] = "MUL";
      keyword[58] = "NEG";
      keyword[59] = "NOP";
      keyword[60] = "NOT";
      keyword[61] = "OR";
      keyword[62] = "OUTSD";
      keyword[63] = "OUT";
      keyword[64] = "POPFQ";
      keyword[65] = "PUSHFQ";
      keyword[66] = "POPAD";
      keyword[67] = "POPA";
      keyword[68] = "PUSHAD";
      keyword[69] = "PUSHFD";
      keyword[70] = "PUSHA";
      keyword[71] = "POPFD";
      keyword[72] = "POPF";
      keyword[73] = "POP";
      keyword[74] = "PUSHF";
      keyword[75] = "PUSH";
      keyword[76] = "RCL";
      keyword[77] = "RCR";
      keyword[78] = "REPE";
      keyword[79] = "PERNE";
      keyword[80] = "REPNZ";
      keyword[81] = "REPZ";
      keyword[82] = "REP";
      keyword[83] = "RETN";
      keyword[84] = "RETF";
      keyword[85] = "RET";
      keyword[86] = "ROL";
      keyword[87] = "ROR";
      keyword[88] = "SAHF";
      keyword[89] = "SAL";
      keyword[90] = "SAR";
      keyword[91] = "SBB";
      keyword[92] = "SCASD";
      keyword[93] = "SHLD";
      keyword[94] = "SHRD";
      keyword[95] = "STOSD";
      keyword[96] = "SCASB";
      keyword[97] = "SCASW";
      keyword[98] = "SHL";
      keyword[99] = "SHR";
      keyword[100] = "STC";
      keyword[101] = "STD";
      keyword[102] = "STI";
      keyword[103] = "SCASQ";
      keyword[104] = "STOSQ";
      keyword[105] = "STOSB";
      keyword[106] = "STOSW";
      keyword[107] = "SUB";
      keyword[108] = "TEST";
      keyword[109] = "WAIT";
      keyword[110] = "XCHG";
      keyword[111] = "XLAT";
      keyword[112] = "XOR";
      keyword[113] = "BOUND";
      keyword[114] = "ENTER";
      keyword[115] = "LEAVE";
      keyword[116] = "OUTS";
      keyword[117] = "ARPL";
      keyword[118] = "CLTS";
      keyword[119] = "LAR";
      keyword[120] = "LGDT";
      keyword[121] = "LIDT";
      keyword[122] = "LLDT";
      keyword[123] = "LMSW";
      keyword[124] = "LOADALL";
      keyword[125] = "LSL";
      keyword[126] = "LTR";
      keyword[127] = "SGDT";
      keyword[128] = "SIDT";
      keyword[129] = "SLDT";
      keyword[130] = "SMSW";
      keyword[131] = "STR";
      keyword[132] = "VERR";
      keyword[133] = "VERW";
      keyword[134] = "BSF";
      keyword[135] = "BSR";
      keyword[136] = "BTC";
      keyword[137] = "BTR";
      keyword[138] = "BTS";
      keyword[139] = "BT";
      keyword[140] = "CDQ";
      keyword[141] = "CMPSD";
      keyword[142] = "CWDE";
      keyword[143] = "INSD";
      keyword[144] = "JECXZ";
      keyword[145] = "LFS";
      keyword[146] = "LGS";
      keyword[147] = "LSS";
      keyword[148] = "SETAE";
      keyword[149] = "SETA";
      keyword[150] = "SETBE";
      keyword[151] = "SETB";
      keyword[152] = "SETC";
      keyword[153] = "SETE";
      keyword[154] = "SETGE";
      keyword[155] = "SETG";
      keyword[156] = "SETLE";
      keyword[157] = "SETL";
      keyword[158] = "SETNAE";
      keyword[159] = "SETNA";
      keyword[160] = "SETNBE";
      keyword[161] = "SETNB";
      keyword[162] = "SETNC";
      keyword[163] = "SETNE";
      keyword[164] = "SETNGE";
      keyword[165] = "SETNG";
      keyword[166] = "SETNLE";
      keyword[167] = "SETNL";
      keyword[168] = "SETNO";
      keyword[169] = "SETNP";
      keyword[170] = "SETNS";
      keyword[171] = "SETNZ";
      keyword[172] = "SETO";
      keyword[173] = "SETPE";
      keyword[174] = "SETPO";
      keyword[175] = "SETP";
      keyword[176] = "SETS";
      keyword[177] = "SETZ";
      keyword[178] = "BSWAP";
      keyword[179] = "CMPXCHG";
      keyword[180] = "INVD";
      keyword[181] = "INVLPG";
      keyword[182] = "WBINVD";
      keyword[183] = "XADD";
      keyword[184] = "CPUID";
      keyword[185] = "CMPXCHG8B";
      keyword[186] = "RDMSR";
      keyword[187] = "RDTSC";
      keyword[188] = "WRMSR";
      keyword[189] = "RSM";
      keyword[190] = "RDPMC";
      keyword[191] = "SYSCALL";
      keyword[192] = "SYSRET";
      keyword[193] = "CMOVAE";
      keyword[194] = "CMOVA";
      keyword[195] = "CMOVBE";
      keyword[196] = "CMOVB";
      keyword[197] = "CMOVCE";
      keyword[198] = "CMOVC";
      keyword[199] = "CMOVGE";
      keyword[200] = "CMOVG";
      keyword[201] = "CMOVLE";
      keyword[202] = "CMOVL";
      keyword[203] = "CMOVNAE";
      keyword[204] = "CMOVNA";
      keyword[205] = "CMOVNBE";
      keyword[206] = "CMOVNB";
      keyword[207] = "CMOVNC";
      keyword[208] = "CMOVNE";
      keyword[209] = "CMOVNGE";
      keyword[210] = "CMOVNG";
      keyword[211] = "CMOVNLE";
      keyword[212] = "CMOVNL";
      keyword[213] = "CMOVNO";
      keyword[214] = "CMOVNP";
      keyword[215] = "CMOVNS";
      keyword[216] = "CMOVNZ";
      keyword[217] = "CMOVO";
      keyword[218] = "CMOVPE";
      keyword[219] = "CMOVPO";
      keyword[220] = "CMOVP";
      keyword[221] = "CMOVS";
      keyword[222] = "CMOVZ";
      keyword[223] = "SYSENTER";
      keyword[224] = "SYSEXIT";
      keyword[225] = "UD2";
      keyword[226] = "MASKMOVQ";
      keyword[227] = "MOVNTPS";
      keyword[228] = "MOVNTQ";
      keyword[229] = "PREFETCH0";
      keyword[230] = "PREFETCH1";
      keyword[231] = "PREFETCH2";
      keyword[232] = "PREFETCHNTA";
      keyword[233] = "SFENCE";
      keyword[234] = "CLFLUSH";
      keyword[235] = "LFENCE";
      keyword[236] = "MASKMOVDQ";
      keyword[237] = "MFENCE";
      keyword[238] = "PAUSE";
      keyword[239] = "LDDQU";
      keyword[240] = "MONITOR";
      keyword[241] = "MWAIT";
      keyword[242] = "CDQE";
      keyword[243] = "CQO";
      keyword[244] = "CMPSQ";
      keyword[245] = "CMPXCHG16B";
      keyword[246] = "CMP";
      keyword[247] = "IRETQ";
      keyword[248] = "JRCXZ";
      keyword[249] = "LODSQ";
      keyword[250] = "RDTSCP";
      keyword[251] = "SWAPGS";
      keyword[252] = "STACK";
      keyword[253] = "DATA";
      keyword[254] = "CODE";
      keyword[255] = "TEXT";
      keyword[256] = "SECTION";
      keyword[257] = "START";
      keyword[258] = "SEGMENT";
      keyword[259] = "GLOBAL";
      keyword[260] = "BSS";
      keyword[261] = "JZ";
      keyword[262] = "JNZ";
      keyword[263] = "JE";
      keyword[264] = "JNE";
      keyword[265] = "MODEL";
      keyword[266] = "DB";
      keyword[267] = "DW";
      keyword[268] = "DD";
      total_keywords = 269;
      break;
      /////////////////////////////////////////////////
      /////////////////////////////////////////////////
      /////////////////////////////////////////////////
    case(PYTHON_MODE):
      //Python language keywords
      keyword[0] = "print";
      keyword[1] = "while";
      keyword[2] = "for";
      keyword[3] = "break";
      keyword[4] = "continue";
      keyword[5] = "if";
      keyword[6] = "elif";
      keyword[7] = "else";
      keyword[8] = "is";
      keyword[9] = "not";
      keyword[10] = "and";
      keyword[11] = "or";
      keyword[12] = "import";
      keyword[13] = "as";
      keyword[14] = "from";
      keyword[15] = "def";
      keyword[16] = "return";
      keyword[17] = "lambda";
      keyword[18] = "global";
      keyword[19] = "try";
      keyword[20] = "except";
      keyword[21] = "finally";
      keyword[22] = "raise";
      keyword[23] = "del";
      keyword[24] = "pass";
      keyword[25] = "assert";
      keyword[26] = "class";
      keyword[27] = "exec";
      keyword[28] = "yield";
      total_keywords = 29;
      break;
      /////////////////////////////////////////////////
      /////////////////////////////////////////////////
      /////////////////////////////////////////////////
    case(HTML_MODE):
      //HTML language keywords
      keyword[0] = "!--";
      keyword[1] = "--";
      keyword[2] = "!doctype";
      keyword[3] = "abbr";
      keyword[4] = "acronym";
      keyword[5] = "address";
      keyword[6] = "applet";
      keyword[7] = "area";
      keyword[8] = "article";
      keyword[9] = "aside";
      keyword[10] = "audio";
      keyword[11] = "a";
      keyword[12] = "basefont";
      keyword[13] = "base";
      keyword[14] = "bdi";
      keyword[15] = "bdo";
      keyword[16] = "big";
      keyword[17] = "blockquote";
      keyword[18] = "body";
      keyword[19] = "br";
      keyword[20] = "button";
      keyword[21] = "b";
      keyword[22] = "canvas";
      keyword[23] = "caption";
      keyword[24] = "center";
      keyword[25] = "cite";
      keyword[26] = "code";
      keyword[27] = "colgroup";
      keyword[28] = "col";
      keyword[29] = "datalist";
      keyword[30] = "dd";
      keyword[31] = "del";
      keyword[32] = "details";
      keyword[33] = "dfn";
      keyword[34] = "dialog";
      keyword[35] = "dir";
      keyword[36] = "div";
      keyword[37] = "di";
      keyword[38] = "dt";
      keyword[39] = "embed";
      keyword[40] = "em";
      keyword[41] = "fieldset";
      keyword[42] = "figcaption";
      keyword[43] = "figure";
      keyword[44] = "font";
      keyword[45] = "footer";
      keyword[46] = "form";
      keyword[47] = "frameset";
      keyword[48] = "frame";
      keyword[49] = "h1";
      keyword[50] = "h2";
      keyword[51] = "h3";
      keyword[52] = "h4";
      keyword[53] = "h5";
      keyword[54] = "h6";
      keyword[55] = "header";
      keyword[56] = "head";
      keyword[57] = "hr";
      keyword[58] = "html";
      keyword[59] = "iframe";
      keyword[60] = "img";
      keyword[61] = "input";
      keyword[62] = "ins";
      keyword[63] = "i";
      keyword[64] = "kbd";
      keyword[65] = "keygen";
      keyword[66] = "label";
      keyword[67] = "legend";
      keyword[68] = "link";
      keyword[69] = "li";
      keyword[70] = "main";
      keyword[71] = "map";
      keyword[72] = "mark";
      keyword[73] = "menuitem";
      keyword[74] = "menu";
      keyword[75] = "meta";
      keyword[76] = "meter";
      keyword[77] = "nav";
      keyword[78] = "noframes";
      keyword[79] = "noscript";
      keyword[80] = "object";
      keyword[81] = "ol";
      keyword[82] = "optgroup";
      keyword[83] = "option";
      keyword[84] = "output";
      keyword[85] = "param";
      keyword[86] = "pre";
      keyword[87] = "progress";
      keyword[88] = "p";
      keyword[89] = "q";
      keyword[90] = "rp";
      keyword[91] = "rt";
      keyword[92] = "ruby";
      keyword[93] = "samp";
      keyword[94] = "script";
      keyword[95] = "section";
      keyword[96] = "select";
      keyword[97] = "small";
      keyword[98] = "source";
      keyword[99] = "span";
      keyword[100] = "strike";
      keyword[101] = "strong";
      keyword[102] = "style";
      keyword[103] = "sub";
      keyword[104] = "summary";
      keyword[105] = "sup";
      keyword[106] = "s";
      keyword[107] = "table";
      keyword[108] = "tbody";
      keyword[109] = "td";
      keyword[110] = "textarea";
      keyword[111] = "tfoot";
      keyword[112] = "thead";
      keyword[113] = "th";
      keyword[114] = "time";
      keyword[115] = "title";
      keyword[116] = "track";
      keyword[117] = "tr";
      keyword[118] = "tt";
      keyword[119] = "ul";
      keyword[120] = "u";
      keyword[121] = "var";
      keyword[122] = "video";
      keyword[123] = "wbr";
      total_keywords = 124;
      break;
      /////////////////////////////////////////////////
      /////////////////////////////////////////////////
      /////////////////////////////////////////////////
    case(JAVASCRIPT_MODE):
      //JavaScript language keywords
      //As in version 5 (ECMAScript 5)
      keyword[0] = "break";
      keyword[1] = "const";
      keyword[2] = "continue";
      keyword[3] = "delete";
      keyword[4] = "double";
      keyword[5] = "while";
      keyword[6] = "export";
      keyword[7] = "for";
      keyword[8] = "int";
      keyword[9] = "function";
      keyword[10] = "if";
      keyword[11] = "else";
      keyword[12] = "import";
      keyword[13] = "instanceof";
      keyword[14] = "label";
      keyword[15] = "let";
      keyword[16] = "new";
      keyword[17] = "return";
      keyword[18] = "switch";
      keyword[19] = "this";
      keyword[20] = "throws";
      keyword[21] = "try";
      keyword[22] = "catch";
      keyword[23] = "typeof";
      keyword[24] = "var";
      keyword[25] = "void";
      keyword[26] = "with";
      keyword[27] = "yield";
      ///////////////////////////////////
      keyword[28] = "abstract";
      keyword[29] = "arguments";
      keyword[30] = "boolean";
      keyword[31] = "byte";
      keyword[32] = "case";
      keyword[33] = "catch";
      keyword[34] = "char";
      keyword[35] = "class";
      keyword[36] = "debugger";
      keyword[37] = "default";
      keyword[38] = "do";
      keyword[39] = "else";
      keyword[40] = "enum";
      keyword[41] = "eval";
      keyword[42] = "extends";
      keyword[43] = "false";
      keyword[44] = "finally";
      keyword[45] = "final";
      keyword[46] = "float";
      keyword[47] = "goto";
      keyword[48] = "implements";
      keyword[49] = "interface";
      keyword[50] = "in";
      keyword[51] = "long";
      keyword[52] = "native";
      keyword[53] = "null";
      keyword[54] = "package";
      keyword[55] = "private";
      keyword[56] = "protected";
      keyword[57] = "public";
      keyword[58] = "short";
      keyword[59] = "static";
      keyword[60] = "super";
      keyword[61] = "synchronized";
      keyword[62] = "throw";
      keyword[63] = "transient";
      keyword[64] = "true";
      keyword[65] = "volatile";
      ///////////////////////////////////
      keyword[66] = "array";
      keyword[67] = "date";
      keyword[68] = "hasownproperty";
      keyword[69] = "infinity";
      keyword[70] = "isfinite";
      keyword[71] = "isnan";
      keyword[72] = "isprototypeof";
      keyword[73] = "length";
      keyword[74] = "math";
      keyword[75] = "nan";
      keyword[76] = "name";
      keyword[77] = "number";
      keyword[78] = "object";
      keyword[79] = "prototype";
      keyword[80] = "string";
      keyword[81] = "tostring";
      keyword[82] = "undefined";
      keyword[83] = "valueof";
      total_keywords = 84;
      break;
      /////////////////////////////////////////////////
      /////////////////////////////////////////////////
      /////////////////////////////////////////////////
    case(BASIC_MODE):
      //BASIC language keywords
      //As in QBASIC v3.0
      keyword[0] = "ABS";
      keyword[1] = "ACS";
      keyword[2] = "ADVAL";
      keyword[3] = "AND";
      keyword[4] = "ASC";
      keyword[5] = "ASN";
      keyword[6] = "AUTO";
      keyword[7] = "BGET";
      keyword[8] = "BPUT";
      keyword[9] = "COLOR";
      keyword[10] = "CALLS";
      keyword[11] = "CHAIN";
      keyword[12] = "CHR$";
      keyword[13] = "CLEAR";
      keyword[14] = "CLOSE";
      keyword[15] = "CLG";
      keyword[16] = "CLS";
      keyword[17] = "COS";
      keyword[18] = "DATA";
      keyword[19] = "DEG";
      keyword[20] = "DEFDBL";
      keyword[21] = "DELETE";
      keyword[22] = "DIV";
      keyword[23] = "DIM";
      keyword[24] = "DRAW";
      keyword[25] = "ENDPROC";
      keyword[26] = "END";
      keyword[27] = "ENVELOPE";
      keyword[28] = "ELSEIF";
      keyword[29] = "EVAL";
      keyword[30] = "ERL";
      keyword[31] = "EOF";
      keyword[32] = "EOR";
      keyword[33] = "ERROR";
      keyword[34] = "EXP";
      keyword[35] = "EXIT";
      keyword[36] = "FOR";
      keyword[37] = "FALSE";
      keyword[38] = "FN";
      keyword[39] = "GOTO$";
      keyword[40] = "GET$";
      keyword[41] = "GET";
      keyword[42] = "GOSUB";
      keyword[43] = "GCOL";
      keyword[44] = "HIMEM";
      keyword[45] = "INPUT$";
      keyword[46] = "IF";
      keyword[47] = "INKEY$";
      keyword[48] = "INKEY";
      keyword[49] = "INT";
      keyword[50] = "INSTR";
      keyword[51] = "LIST";
      keyword[52] = "LOAD";
      keyword[53] = "LOMEM";
      keyword[54] = "LOCAL";
      keyword[55] = "LEFT$";
      keyword[56] = "LEN";
      keyword[57] = "LET";
      keyword[58] = "LOG";
      keyword[59] = "LN";
      keyword[60] = "MID$";
      keyword[61] = "MODE";
      keyword[62] = "MOD";
      keyword[63] = "MOVE";
      keyword[64] = "NEXT";
      keyword[65] = "NEW";
      keyword[66] = "NOT";
      keyword[67] = "OLD";
      keyword[68] = "ON";
      keyword[69] = "OFF";
      keyword[70] = "OR";
      keyword[71] = "OPENIN";
      keyword[72] = "OPENOUT";
      keyword[73] = "PRINT#";
      keyword[74] = "PAGE";
      keyword[75] = "PTR";
      keyword[76] = "PI";
      keyword[77] = "PLOT";
      keyword[78] = "PROC";
      keyword[79] = "POS";
      keyword[80] = "RETURN";
      keyword[81] = "REPEAT";
      keyword[82] = "REPORT";
      keyword[83] = "READ";
      keyword[84] = "REM";
      keyword[85] = "RUN";
      keyword[86] = "RAD";
      keyword[87] = "RESTORE";
      keyword[88] = "RIGHT$";
      keyword[89] = "RND";
      keyword[90] = "RENUMBER";
      keyword[91] = "SAVE";
      keyword[92] = "SGN";
      keyword[93] = "SIN";
      keyword[94] = "SQR";
      keyword[95] = "SOUND";
      keyword[96] = "SPC";
      keyword[97] = "STR$";
      keyword[98] = "STRING$";
      keyword[99] = "STOP";
      keyword[100] = "TAN";
      keyword[101] = "TAB";
      keyword[102] = "TIME$";
      keyword[103] = "TRACE";
      keyword[104] = "TRUE";
      keyword[105] = "UNTIL";
      keyword[106] = "USR0";
      keyword[107] = "VDU";
      keyword[108] = "VAL";
      keyword[109] = "VPOS";
      keyword[110] = "WIDTH";
      ////////////////////////////////////////////
      keyword[111] = "ACCESS";
      keyword[112] = "APPEND";
      keyword[113] = "AS";
      keyword[114] = "ATN";
      keyword[115] = "BASE";
      keyword[116] = "BEEP";
      keyword[117] = "BLOAD";
      keyword[118] = "BSAVE";
      keyword[119] = "CALL";
      keyword[120] = "CASE";
      keyword[121] = "CDBL";
      keyword[122] = "CHDIR";
      keyword[123] = "CINT";
      keyword[124] = "CIRCLE";
      keyword[125] = "COMMAND$";
      keyword[126] = "COMMON";
      keyword[127] = "COM";
      keyword[128] = "CONST";
      keyword[129] = "CONT";
      keyword[130] = "CSNG";
      keyword[131] = "CSRLIN";
      keyword[132] = "CVDMBF";
      keyword[133] = "CVD";
      keyword[134] = "CVSMBF";
      keyword[135] = "CVI";
      keyword[136] = "CVS";
      keyword[137] = "DATE$";
      keyword[138] = "DO";
      keyword[139] = "DEFINT";
      keyword[140] = "DEFSNG";
      keyword[141] = "DEFSTR";
      keyword[142] = "DEF";
      keyword[143] = "DRAW";
      keyword[144] = "EDIT";
      keyword[145] = "ELSE";
      keyword[146] = "ENVIRON$";
      keyword[147] = "ENVIRON";
      keyword[148] = "EQV";
      keyword[149] = "ERASE";
      keyword[150] = "ERDEV$";
      keyword[151] = "ERDEV";
      keyword[152] = "ERR";
      keyword[153] = "FIELD";
      keyword[154] = "FILES";
      keyword[155] = "FIX";
      keyword[156] = "FRE";
      keyword[157] = "GOTO";
      keyword[158] = "GO";
      keyword[159] = "HEX$";
      keyword[160] = "IMP";
      keyword[161] = "INPUT#";
      keyword[162] = "INPUT";
      keyword[163] = "INP";
      keyword[164] = "IOCTL$";
      keyword[165] = "IOCTL";
      keyword[166] = "KEY";
      keyword[167] = "KILL";
      keyword[168] = "LBOUND";
      keyword[169] = "LCOPY";
      keyword[170] = "LINE";
      keyword[171] = "LLIST";
      keyword[172] = "LOCATE";
      keyword[173] = "LOCK";
      keyword[174] = "LOC";
      keyword[175] = "LOF";
      keyword[176] = "LOOP";
      keyword[177] = "LPOS";
      keyword[178] = "LPRINT#";
      keyword[179] = "LPRINT";
      keyword[180] = "LSET";
      keyword[181] = "MERGE";
      keyword[182] = "MKD$";
      keyword[183] = "MKDIR";
      keyword[184] = "MKDMBF$";
      keyword[185] = "MKI$";
      keyword[186] = "MKS$";
      keyword[187] = "MKSMBF$";
      keyword[188] = "MOTOR";
      keyword[189] = "NAME";
      keyword[190] = "NOISE";
      keyword[191] = "NULL";
      keyword[192] = "OCT$";
      keyword[193] = "OPEN";
      keyword[194] = "COM";
      keyword[195] = "OPTION";
      keyword[196] = "OUTPUT";
      keyword[197] = "OUT";
      keyword[198] = "PAINT";
      keyword[199] = "PALETTE";
      keyword[200] = "USING";
      keyword[201] = "PEEK";
      keyword[202] = "PEN";
      keyword[203] = "PLAY";
      keyword[204] = "PMAP";
      keyword[205] = "POINT";
      keyword[206] = "POKE";
      keyword[207] = "PRESET";
      keyword[208] = "PRINT";
      keyword[209] = "PSET";
      keyword[210] = "PUT";
      keyword[211] = "RANDOMIZE";
      keyword[212] = "RANDOM";
      keyword[213] = "REDIM";
      keyword[214] = "RENUM";
      keyword[215] = "RESET";
      keyword[216] = "RESUME";
      keyword[217] = "RMDIR";
      keyword[218] = "RSET";
      keyword[219] = "SADD";
      keyword[220] = "SCREEN";
      keyword[221] = "SEG";
      keyword[222] = "SELECT";
      keyword[223] = "SHARED";
      keyword[224] = "SHELL";
      keyword[225] = "SPACE$";
      keyword[226] = "SPACE";
      keyword[227] = "STATIC";
      keyword[228] = "STEP";
      keyword[229] = "STICK";
      keyword[230] = "STRIG";
      keyword[231] = "SUB";
      keyword[232] = "SWAP";
      keyword[233] = "SYSTEM";
      keyword[234] = "THEN";
      keyword[235] = "TIMER";
      keyword[236] = "TIME";
      keyword[237] = "TO";
      keyword[238] = "TROFF";
      keyword[239] = "TRON";
      keyword[240] = "UBOUND";
      keyword[241] = "UNLOCK";
      keyword[242] = "USING";
      keyword[243] = "USR1";
      keyword[244] = "USR2";
      keyword[245] = "USR3";
      keyword[246] = "USR4";
      keyword[247] = "USR5";
      keyword[248] = "USR6";
      keyword[249] = "USR7";
      keyword[250] = "USR8";
      keyword[251] = "USR9";
      keyword[252] = "USR";
      keyword[253] = "VARPTR$";
      keyword[254] = "VARPTR";
      keyword[255] = "VIEW";
      keyword[256] = "WAIT";
      keyword[257] = "WEND";
      keyword[258] = "WHILE";
      keyword[259] = "WINDOW";
      keyword[260] = "WRITE#";
      keyword[261] = "WRITE";
      keyword[262] = "XOR";
      total_keywords = 263;
      break;
      /////////////////////////////////////////////////
      /////////////////////////////////////////////////
      /////////////////////////////////////////////////
    case(PASCAL_MODE):
      //GNU Pascal language keywords
      keyword[0] = "absolute";
      keyword[1] = "abstract";
      keyword[2] = "all";
      keyword[4] = "and";
      keyword[3] = "and_then";
      keyword[5] = "array";
      keyword[7] = "asm";
      keyword[6] = "asmname";
      keyword[8] = "as";
      keyword[9] = "attribute";
      keyword[10] = "begin";
      keyword[11] = "bindable";
      keyword[12] = "case";
      keyword[13] = "c_language";
      keyword[14] = "class";
      keyword[15] = "constructor";
      keyword[16] = "const";
      keyword[17] = "destructor";
      keyword[18] = "div";
      keyword[19] = "downto";
      keyword[20] = "double";
      keyword[21] = "else";
      keyword[22] = "end";
      keyword[23] = "exports";
      keyword[24] = "export";
      keyword[25] = "external";
      keyword[26] = "far";
      keyword[27] = "filepos";
      keyword[28] = "finalization";
      keyword[29] = "forward";
      keyword[30] = "formatstring";
      keyword[31] = "function";
      keyword[32] = "goto";
      keyword[33] = "if";
      keyword[34] = "implementation";
      keyword[35] = "import";
      keyword[36] = "inherited";
      keyword[37] = "initializaion";
      keyword[38] = "interface";
      keyword[39] = "interrupt";
      keyword[40] = "include";
      keyword[41] = "is";
      keyword[42] = "label";
      keyword[43] = "library";
      keyword[44] = "module";
      keyword[45] = "mod";
      keyword[46] = "name";
      keyword[47] = "near";
      keyword[48] = "nil";
      keyword[49] = "not";
      keyword[50] = "object";
      keyword[51] = "of";
      keyword[52] = "only";
      keyword[53] = "operator";
      keyword[54] = "or_else";
      keyword[55] = "ord";
      keyword[56] = "otherwise";
      keyword[57] = "packed";
      keyword[58] = "pow";
      keyword[59] = "private";
      keyword[60] = "procedure";
      keyword[61] = "program";
      keyword[62] = "property";
      keyword[63] = "protected";
      keyword[64] = "public";
      keyword[65] = "published";
      keyword[66] = "qualified";
      keyword[67] = "record";
      keyword[68] = "repeat";
      keyword[69] = "resident";
      keyword[70] = "restricted";
      keyword[71] = "segment";
      keyword[72] = "setfiletime";
      keyword[73] = "shl";
      keyword[74] = "shr";
      keyword[75] = "then";
      keyword[76] = "to";
      keyword[77] = "typeof";
      keyword[78] = "unit";
      keyword[79] = "until";
      keyword[80] = "uses";
      keyword[81] = "value";
      keyword[82] = "var";
      keyword[83] = "view";
      keyword[84] = "virtual";
      keyword[85] = "while";
      keyword[86] = "with";
      keyword[87] = "xor";
      ///////////////////////////////////////////
      keyword[88] = "abs";
      keyword[89] = "addr";
      keyword[90] = "alignof";
      keyword[91] = "ansichar";
      keyword[92] = "anyfile";
      keyword[93] = "append";
      keyword[94] = "arccos";
      keyword[95] = "arcsin";
      keyword[96] = "arctan";
      keyword[97] = "arg";
      keyword[98] = "assert";
      keyword[99] = "assigned";
      keyword[100] = "assign";
      keyword[101] = "bindingtype";
      keyword[102] = "binding";
      keyword[103] = "bind";
      keyword[104] = "bitsizeof";
      keyword[105] = "blockread";
      keyword[106] = "blockwrite";
      keyword[107] = "boolean";
      keyword[108] = "break";
      keyword[109] = "bytebool";
      keyword[110] = "bytecard";
      keyword[111] = "byteint";
      keyword[112] = "byte";
      keyword[113] = "cardinal";
      keyword[114] = "card";
      keyword[115] = "cboolean";
      keyword[116] = "ccardinal";
      keyword[117] = "char";
      keyword[118] = "chdir";
      keyword[119] = "chr";
      keyword[120] = "cinteger";
      keyword[121] = "close";
      keyword[122] = "cmplx";
      keyword[123] = "complex";
      keyword[124] = "compilerassert";
      keyword[125] = "comp";
      keyword[126] = "concat";
      keyword[127] = "conjugate";
      keyword[128] = "continue";
      keyword[129] = "copy";
      keyword[130] = "cos";
      keyword[131] = "cstring2string";
      keyword[132] = "cstringcopystring";
      keyword[133] = "cstring";
      keyword[134] = "currentroutinename";
      keyword[135] = "cword";
      keyword[136] = "cycle";
      keyword[137] = "date";
      keyword[138] = "dec";
      keyword[139] = "definesize";
      keyword[140] = "delete";
      keyword[141] = "discard";
      keyword[142] = "dispose";
      keyword[143] = "do";
      keyword[144] = "empty";
      keyword[145] = "eof";
      keyword[146] = "eoln";
      keyword[147] = "epsreal";
      keyword[148] = "eqpad";
      keyword[149] = "eq";
      keyword[150] = "erase";
      keyword[151] = "exclude";
      keyword[152] = "exit";
      keyword[153] = "exp";
      keyword[154] = "extended";
      keyword[155] = "extend";
      keyword[156] = "fail";
      keyword[157] = "false";
      keyword[158] = "filesize";
      keyword[159] = "file";
      keyword[160] = "fillchar";
      keyword[161] = "finalize";
      keyword[162] = "flush";
      keyword[163] = "forward";
      keyword[164] = "for";
      keyword[165] = "frac";
      keyword[166] = "frameaddress";
      keyword[167] = "freemem";
      keyword[168] = "gepad";
      keyword[169] = "getmem";
      keyword[170] = "gettimestamp";
      keyword[171] = "get";
      keyword[172] = "ge";
      keyword[173] = "gtpad";
      keyword[174] = "gt";
      keyword[175] = "im";
      keyword[176] = "inc";
      keyword[177] = "index";
      keyword[178] = "initialize";
      keyword[179] = "inoutres";
      keyword[180] = "input";
      keyword[181] = "insert";
      keyword[182] = "integer";
      keyword[183] = "ioresult";
      keyword[184] = "int";
      keyword[185] = "in";
      keyword[186] = "lastposition";
      keyword[187] = "leave";
      keyword[188] = "length";
      keyword[189] = "lepad";
      keyword[190] = "le";
      keyword[191] = "ln";
      keyword[192] = "locase";
      keyword[193] = "longbool";
      keyword[194] = "longcard";
      keyword[195] = "longestbool";
      keyword[196] = "longestcard";
      keyword[197] = "longestint";
      keyword[198] = "longestreal";
      keyword[199] = "longestword";
      keyword[200] = "longint";
      keyword[201] = "longreal";
      keyword[202] = "longword";
      keyword[203] = "low";
      keyword[204] = "ltpad";
      keyword[205] = "lt";
      keyword[206] = "mark";
      keyword[207] = "maxchar";
      keyword[208] = "maxint";
      keyword[209] = "maxreal";
      keyword[210] = "max";
      keyword[211] = "medbool";
      keyword[212] = "medcard";
      keyword[213] = "medint";
      keyword[214] = "medreal";
      keyword[215] = "medword";
      keyword[216] = "minreal";
      keyword[217] = "min";
      keyword[218] = "mkdir";
      keyword[219] = "moveleft";
      keyword[220] = "moveright";
      keyword[221] = "move";
      keyword[222] = "nepad";
      keyword[223] = "newcstring";
      keyword[224] = "new";
      keyword[225] = "ne";
      keyword[226] = "null";
      keyword[227] = "odd";
      keyword[228] = "or";
      keyword[229] = "output";
      keyword[230] = "pack";
      keyword[231] = "page";
      keyword[232] = "pansichar";
      keyword[233] = "paramcount";
      keyword[234] = "paramstr";
      keyword[235] = "pchar";
      keyword[236] = "pi";
      keyword[237] = "pobjecttype";
      keyword[238] = "pointer";
      keyword[239] = "polar";
      keyword[240] = "position";
      keyword[241] = "pos";
      keyword[242] = "pred";
      keyword[243] = "ptrcard";
      keyword[244] = "ptrdifftype";
      keyword[245] = "ptrint";
      keyword[246] = "ptrword";
      keyword[247] = "put";
      keyword[248] = "randomize";
      keyword[249] = "random";
      keyword[250] = "readstr";
      keyword[251] = "readln";
      keyword[252] = "read";
      keyword[253] = "real";
      keyword[254] = "release";
      keyword[255] = "rename";
      keyword[256] = "reset";
      keyword[257] = "result";
      keyword[258] = "returnaddress";
      keyword[259] = "return";
      keyword[260] = "rewrite";
      keyword[261] = "rmdir";
      keyword[262] = "re";
      keyword[263] = "round";
      keyword[264] = "runerror";
      keyword[265] = "seekwrite";
      keyword[266] = "seekupdate";
      keyword[267] = "seekread";
      keyword[268] = "seekeoln";
      keyword[269] = "seekeof";
      keyword[270] = "seek";
      keyword[271] = "self";
      keyword[272] = "setlength";
      keyword[273] = "settype";
      keyword[274] = "set";
      keyword[275] = "shortbool";
      keyword[276] = "shortcard";
      keyword[277] = "shortint";
      keyword[278] = "shortreal";
      keyword[279] = "shortword";
      keyword[280] = "single";
      keyword[281] = "sin";
      keyword[282] = "sizeof";
      keyword[283] = "sizetype";
      keyword[284] = "smallint";
      keyword[285] = "sqrt";
      keyword[286] = "sqr";
      keyword[287] = "standarderror";
      keyword[288] = "standardinput";
      keyword[289] = "standardoutput";
      keyword[290] = "stderr";
      keyword[291] = "string2cstring";
      keyword[292] = "string";
      keyword[293] = "str";
      keyword[294] = "substr";
      keyword[295] = "succ";
      keyword[296] = "";
      keyword[297] = "text";
      keyword[298] = "timestamp";
      keyword[299] = "time";
      keyword[300] = "trim";
      keyword[301] = "true";
      keyword[302] = "truncate";
      keyword[303] = "trunc";
      keyword[304] = "type";
      keyword[305] = "unbind";
      keyword[306] = "unpack";
      keyword[307] = "upcase";
      keyword[308] = "update";
      keyword[309] = "val";
      keyword[310] = "void";
      keyword[311] = "wordbool";
      keyword[312] = "word";
      keyword[313] = "writeln";
      keyword[314] = "writestr";
      keyword[315] = "write";
      total_keywords = 316;
      break;
      /////////////////////////////////////////////////
      /////////////////////////////////////////////////
      /////////////////////////////////////////////////
    case(F77_MODE):
      //FORTRAN 77 4.0 language keywords
      keyword[0] = "accept";
      keyword[1] = "assignment";
      keyword[2] = "assign";
      keyword[3] = "automatic";
      keyword[4] = "backspace";
      keyword[5] = "block";
      keyword[6] = "data";
      keyword[7] = "byte";
      keyword[8] = "call";
      keyword[9] = "character";
      keyword[10] = "close";
      keyword[11] = "common";
      keyword[12] = "complex";
      keyword[13] = "continue";
      keyword[14] = "decode";
      keyword[15] = "dimension";
      keyword[16] = "double";
      keyword[17] = "do";
      keyword[18] = "else";
      keyword[19] = "encode";
      keyword[20] = "endfile";
      keyword[21] = "end";
      keyword[22] = "entry";
      keyword[23] = "if";
      keyword[24] = "map";
      keyword[25] = "structure";
      keyword[26] = "union";
      keyword[27] = "equivalence";
      keyword[28] = "external";
      keyword[29] = "format";
      keyword[30] = "function";
      keyword[31] = "go";
      keyword[32] = "to";
      keyword[33] = "then";
      keyword[34] = "implicit";
      keyword[35] = "include";
      keyword[36] = "inquire";
      keyword[37] = "integer";
      keyword[38] = "intrinsic";
      keyword[39] = "logical";
      keyword[40] = "namelist";
      keyword[41] = "open";
      keyword[42] = "options";
      keyword[43] = "parameter";
      keyword[44] = "pause";
      keyword[45] = "pointer";
      keyword[46] = "pragma";
      keyword[47] = "program";
      keyword[48] = "print";
      keyword[49] = "read";
      keyword[50] = "real";
      keyword[51] = "record";
      keyword[52] = "return";
      keyword[53] = "rewind";
      keyword[54] = "save";
      keyword[55] = "static";
      keyword[56] = "stop";
      keyword[57] = "structure";
      keyword[58] = "subroutine";
      keyword[59] = "type";
      keyword[60] = "union";
      keyword[61] = "virtual";
      keyword[62] = "volatile";
      keyword[63] = "write";
      keyword[64] = "precision";
      keyword[65] = "file";
      keyword[66] = "abort";
      keyword[67] = "access";
      keyword[68] = "alarm";
      keyword[69] = "bit";
      keyword[70] = "and";
      keyword[71] = "or";
      keyword[72] = "setbit";
      keyword[73] = "xor";
      keyword[74] = "not";
      keyword[75] = "rshift";
      keyword[76] = "lshift";
      keyword[77] = "bic";
      keyword[78] = "bis";
      keyword[79] = "chdir";
      keyword[80] = "chmod";
      keyword[81] = "date";
      keyword[82] = "dtime";
      keyword[83] = "etime";
      keyword[84] = "exit";
      keyword[85] = "f77_floatingpoint";
      keyword[86] = "f77_ieee_environment";
      keyword[87] = "fdate";
      keyword[88] = "flush";
      keyword[89] = "fork";
      keyword[90] = "free";
      keyword[91] = "fseek";
      keyword[92] = "ftell";
      keyword[93] = "getarg";
      keyword[94] = "iargc";
      keyword[95] = "getcwd";
      keyword[96] = "fgetc";
      keyword[97] = "getc";
      keyword[98] = "getenv";
      keyword[99] = "getfd";
      keyword[100] = "getfile";
      keyword[101] = "getlog";
      keyword[102] = "getpid";
      keyword[103] = "getuid";
      keyword[104] = "getgid";
      keyword[105] = "hostnm";
      keyword[106] = "idate";
      keyword[107] = "itime";
      keyword[108] = "index";
      keyword[109] = "rindex";
      keyword[110] = "lnblnk";
      keyword[111] = "len";
      keyword[112] = "inmax";
      keyword[113] = "ioinit";
      keyword[114] = "kill";
      keyword[115] = "libm_double";
      keyword[116] = "libm_quadruple";
      keyword[117] = "libm_single";
      keyword[118] = "link";
      keyword[119] = "symlnk";
      keyword[120] = "loc";
      keyword[121] = "long";
      keyword[122] = "short";
      keyword[123] = "longjmp";
      keyword[124] = "isetjmp";
      keyword[125] = "malloc";
      keyword[126] = "mvbits";
      keyword[127] = "perror";
      keyword[128] = "gerror";
      keyword[129] = "ierrno";
      keyword[130] = "putc";
      keyword[131] = "fputc";
      keyword[132] = "qsort";
      keyword[133] = "drand";
      keyword[134] = "irand";
      keyword[135] = "rand";
      keyword[136] = "rename";
      keyword[137] = "secnds";
      keyword[138] = "sh";
      keyword[139] = "signal";
      keyword[140] = "sleep";
      keyword[141] = "fstat";
      keyword[142] = "lstat";
      keyword[143] = "stat";
      keyword[144] = "system";
      keyword[145] = "ctime";
      keyword[146] = "ltime";
      keyword[147] = "gmtime";
      keyword[148] = "time";
      keyword[149] = "topen";
      keyword[150] = "tclose";
      keyword[151] = "twrite";
      keyword[152] = "tread";
      keyword[153] = "trewin";
      keyword[154] = "tskipf";
      keyword[155] = "tstate";
      keyword[156] = "ttynam";
      keyword[157] = "isatty";
      keyword[158] = "unlink";
      keyword[159] = "wait";
      total_keywords = 160;
      break;
      /////////////////////////////////////////////////
      /////////////////////////////////////////////////
      /////////////////////////////////////////////////
    case(NO_MODE):
      break;
  }//end switch
  old_window_color = BG_COLOR[COLOR_WINDOW];
}