/* -*- c++ -*- */
/*
 * Copyright 2003 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <GrComplexNCOSource.h>

GrComplexNCOSource::GrComplexNCOSource (double sampling_rate, double freq, double ampl)
  : GrSource (sizeof (VrComplex), 1), d_ampl (ampl)
{
  setSamplingFrequency (sampling_rate);
  d_nco.set_freq (freq / sampling_rate * 2 * M_PI);
  d_nco.set_phase (0);
}

int
GrComplexNCOSource::work2 (VrSampleRange output, void *ao[])
{
  VrComplex *out = ((VrComplex **) ao)[0];
  
  sync (output.index);	// we've got state, must compute in order

  for (unsigned ii = 0; ii < output.size; ii++){
    out[ii] = VrComplex (d_nco.cos () * d_ampl, d_nco.sin () * d_ampl);
    d_nco.step ();
  }

  return output.size;
}
