/* -*- Mode: c++ -*-
 *
 *  Copyright 1997 Massachusetts Institute of Technology
 * 
 *  Permission to use, copy, modify, distribute, and sell this software and its
 *  documentation for any purpose is hereby granted without fee, provided that
 *  the above copyright notice appear in all copies and that both that
 *  copyright notice and this permission notice appear in supporting
 *  documentation, and that the name of M.I.T. not be used in advertising or
 *  publicity pertaining to distribution of the software without specific,
 *  written prior permission.  M.I.T. makes no representations about the
 *  suitability of this software for any purpose.  It is provided "as is"
 *  without express or implied warranty.
 * 
 */


#ifndef _VRTESTCOPYSLOW_H_
#define _VRTESTCOPYSLOW_H_

#include <VrSource.h>

template<class iType, class oType> 
class VrTestCopySlow : public VrSigProc<iType,oType> {
public:
  virtual void work(timestamp ts, unsigned int size, iType *i[], oType *o[]);
  virtual void initialize();
};

template<class iType, class oType> void
VrTestCopySlow<iType, oType>::initialize()
{
  setOutputSize (1); 
}

template<class iType, class oType> void
VrTestCopySlow<iType, oType>::work(timestamp ts, unsigned int size, iType *i[], oType *o[])
{ 

  while(size-- > 0) {
    //waste some time
    int n=ts;
    for(int ii=0; ii<1000;ii++)
      n += n % 13;

    *o[0]++= (oType) *i[0]++;
  }
  //  fprintf ("%ld complete[%d]\n", ts, pthread_self());
}

#endif





