/* -*- Mode: Java; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim:set ts=2 sw=2 sts=2 et: */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is mozilla.org code.
 *
 * The Initial Developer of the Original Code is
 * Kathleen Brade <brade@pearlcrescent.com>
 * Mark Smith <mcs@pearlcrescent.com>
 * Portions created by the Initial Developer are Copyright (C) 2008
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either of the GNU General Public License Version 2 or later (the "GPL"),
 * or the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

var gRegTestCoreDeferredComponent =
{
  /* nsISupports implementation. */
  QueryInterface: function (aIID)
  {
    if (!aIID.equals(Components.interfaces.nsISupports) &&
        !aIID.equals(Components.interfaces.nsIFactory))
      throw Components.results.NS_ERROR_NO_INTERFACE;

    return this;
  },

  /* nsIFactory implementation. */
  createInstance: function (aOuter, aIID)
  {
    if (null != aOuter)
      throw Components.results.NS_ERROR_NO_AGGREGATION;

    return this.QueryInterface(aIID);
  },

  lockFactory: function (aDoLock) {}
};

var gRegTestCoreDeferredComponentModule =
{
  kClassName: "RegTestCoreDeferredComponent",
  kClassID: Components.ID("{d04d1298-6dac-459b-a13b-bcab235730a0}"),
  kContractID: "@mozilla.org/RegTestServiceB;1",
  kICompReg: Components.interfaces.nsIComponentRegistrar,

  mIsFirstTime: true,

  /* nsISupports implementation. */
  QueryInterface: function (aIID)
  {
    if (aIID.equals(Components.interfaces.nsIModule) ||
        aIID.equals(Components.interfaces.nsISupports))
      return this;

    throw Components.results.NS_ERROR_NO_INTERFACE;
  },

  /* nsIModule implementation. */
  getClassObject: function (aCompMgr, aClassID, aIID)
  {
    if (!aClassID.equals(this.kClassID))
      throw Components.results.NS_ERROR_NO_INTERFACE;
    if (!aIID.equals(Components.interfaces.nsIFactory))
      throw Components.results.NS_ERROR_NOT_IMPLEMENTED;

    return gRegTestCoreDeferredComponent.QueryInterface(aIID);
  },

  registerSelf: function (aCompMgr, aFileSpec, aLocation, aType)
  {
    if (this.mIsFirstTime)
    {
      this.mIsFirstTime = false;
      throw Components.results.NS_ERROR_FACTORY_REGISTER_AGAIN;
    }

    aCompMgr = aCompMgr.QueryInterface(this.kICompReg);
    aCompMgr.registerFactoryLocation(this.kClassID, this.kClassName,
                                 this.kContractID, aFileSpec, aLocation, aType);
  },

  unregisterSelf: function (aCompMgr, aFileSpec, aLocation)
  {
    aCompMgr = aCompMgr.QueryInterface(this.kICompReg);
    aCompMgr.unregisterFactoryLocation(this.kClassID, aFileSpec);
  },

  canUnload: function (aCompMgr) { return true; }
};

function NSGetModule(aCompMgr, aFileSpec)
{
  return gRegTestCoreDeferredComponentModule;
}
