# coding=utf8

# Any copyright is dedicated to the Public Domain.
# http://creativecommons.org/publicdomain/zero/1.0/

from __future__ import absolute_import
import fluent.syntax.ast as FTL
from fluent.migrate.helpers import MESSAGE_REFERENCE, EXTERNAL_ARGUMENT
from fluent.migrate.transforms import REPLACE, PLURALS, REPLACE_IN_TEXT
from fluent.migrate import COPY, CONCAT


def migrate(ctx):
    """Bug 1435912 - Migrate Preferences::General XUL to Fluent, part {index}."""

    ctx.add_transforms(
        'browser/browser/preferences/preferences.ftl',
        'browser/locales/en-US/browser/preferences/preferences.ftl',
        [
            FTL.Message(
                id=FTL.Identifier('startup-header'),
                value=COPY(
                    'browser/chrome/browser/preferences/main.dtd',
                    'startup.label'
                )
            ),
            FTL.Message(
                id=FTL.Identifier('separate-profile-mode'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        REPLACE(
                            'browser/chrome/browser/preferences/main.dtd',
                            'separateProfileMode.label',
                            {
                                '&brandShortName;': MESSAGE_REFERENCE('-brand-short-name')
                            }
                        )
                    )
                ]
            ),
            FTL.Message(
                id=FTL.Identifier('use-icecat-sync'),
                value=REPLACE(
                    'browser/chrome/browser/preferences/main.dtd',
                    'useIceCatSync.label',
                    {
                        'Sync': MESSAGE_REFERENCE('-sync-brand-short-name')
                    },
                )
            ),
            FTL.Message(
                id=FTL.Identifier('get-started-not-logged-in'),
                value=REPLACE(
                    'browser/chrome/browser/preferences/main.dtd',
                    'getStarted.notloggedin.label',
                    {
                        '&syncBrand.shortName.label;': MESSAGE_REFERENCE('-sync-brand-short-name')
                    },
                )
            ),
            FTL.Message(
                id=FTL.Identifier('get-started-configured'),
                value=REPLACE(
                    'browser/chrome/browser/preferences/main.dtd',
                    'getStarted.configured.label',
                    {
                        '&syncBrand.shortName.label;': MESSAGE_REFERENCE('-sync-brand-short-name')
                    },
                )
            ),
            FTL.Message(
                id=FTL.Identifier('always-check-default'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        REPLACE(
                            'browser/chrome/browser/preferences/main.dtd',
                            'alwaysCheckDefault2.label',
                            {
                                '&brandShortName;': MESSAGE_REFERENCE('-brand-short-name')
                            },
                        )
                    ),
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/main.dtd',
                            'alwaysCheckDefault2.accesskey',
                        )
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('is-default'),
                value=REPLACE(
                    'browser/chrome/browser/preferences/main.dtd',
                    'isDefault.label',
                    {
                        '&brandShortName;': MESSAGE_REFERENCE('-brand-short-name')
                    },
                )
            ),
            FTL.Message(
                id=FTL.Identifier('is-not-default'),
                value=REPLACE(
                    'browser/chrome/browser/preferences/main.dtd',
                    'isNotDefault.label',
                    {
                        '&brandShortName;': MESSAGE_REFERENCE('-brand-short-name')
                    },
                )
            ),
            FTL.Message(
                id=FTL.Identifier('set-as-my-default-browser'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/main.dtd',
                            'setAsMyDefaultBrowser3.label',
                        )
                    ),
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/main.dtd',
                            'setAsMyDefaultBrowser3.accesskey',
                        )
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('startup-page'),
                value=REPLACE(
                    'browser/chrome/browser/preferences/main.dtd',
                    'startupPage2.label',
                    {
                        '&brandShortName;': MESSAGE_REFERENCE('-brand-short-name')
                    },
                ),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/main.dtd',
                            'startupPage2.accesskey',
                        )
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('startup-user-homepage'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/main.dtd',
                            'startupUserHomePage.label',
                        )
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('startup-blank-page'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/main.dtd',
                            'startupBlankPage.label',
                        )
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('startup-prev-session'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/main.dtd',
                            'startupPrevSession.label',
                        )
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('disable-extension'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/main.dtd',
                            'disableExtension.label',
                        )
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('home-page-header'),
                value=COPY(
                    'browser/chrome/browser/preferences/main.dtd',
                    'startupUserHomePage.label',
                )
            ),
            FTL.Message(
                id=FTL.Identifier('use-current-pages'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        FTL.Pattern(
                            elements=[
                                FTL.Placeable(
                                    expression=FTL.SelectExpression(
                                        expression=EXTERNAL_ARGUMENT('tabCount'),
                                        variants=[
                                            FTL.Variant(
                                                key=FTL.VariantName('1'),
                                                default=False,
                                                value=COPY(
                                                    'browser/chrome/browser/preferences/main.dtd',
                                                    'useCurrentPage.label',
                                                )
                                            ),
                                            FTL.Variant(
                                                key=FTL.VariantName('other'),
                                                default=True,
                                                value=COPY(
                                                    'browser/chrome/browser/preferences/main.dtd',
                                                    'useMultiple.label',
                                                )
                                            )
                                        ]
                                    )
                                )
                            ]
                        )
                    ),
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/main.dtd',
                            'useCurrentPage.accesskey',
                        )
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('choose-bookmark'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/main.dtd',
                            'chooseBookmark.label',
                        )
                    ),
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/main.dtd',
                            'chooseBookmark.accesskey',
                        )
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('restore-default'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/main.dtd',
                            'restoreDefault.label',
                        )
                    ),
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/main.dtd',
                            'restoreDefault.accesskey',
                        )
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('tabs-group-header'),
                value=COPY(
                    'browser/chrome/browser/preferences/tabs.dtd',
                    'tabsGroup.label',
                )
            ),
            FTL.Message(
                id=FTL.Identifier('ctrl-tab-recently-used-order'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/tabs.dtd',
                            'ctrlTabRecentlyUsedOrder.label',
                        )
                    ),
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/tabs.dtd',
                            'ctrlTabRecentlyUsedOrder.accesskey',
                        )
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('open-new-link-as-tabs'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/tabs.dtd',
                            'newWindowsAsTabs3.label',
                        )
                    ),
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/tabs.dtd',
                            'newWindowsAsTabs3.accesskey',
                        )
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('warn-on-close-multiple-tabs'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/tabs.dtd',
                            'warnOnCloseMultipleTabs.label',
                        )
                    ),
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/tabs.dtd',
                            'warnOnCloseMultipleTabs.accesskey',
                        )
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('warn-on-open-many-tabs'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        REPLACE(
                            'browser/chrome/browser/preferences/tabs.dtd',
                            'warnOnOpenManyTabs.label',
                            {
                                '&brandShortName;': MESSAGE_REFERENCE('-brand-short-name')
                            },
                        )
                    ),
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/tabs.dtd',
                            'warnOnOpenManyTabs.accesskey',
                        )
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('switch-links-to-new-tabs'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/tabs.dtd',
                            'switchLinksToNewTabs.label',
                        )
                    ),
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/tabs.dtd',
                            'switchLinksToNewTabs.accesskey',
                        )
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('show-tabs-in-taskbar'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/tabs.dtd',
                            'showTabsInTaskbar.label',
                        )
                    ),
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/tabs.dtd',
                            'showTabsInTaskbar.accesskey',
                        )
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('browser-containers-enabled'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/privacy.dtd',
                            'browserContainersEnabled.label',
                        )
                    ),
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/privacy.dtd',
                            'browserContainersEnabled.accesskey',
                        )
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('browser-containers-learn-more'),
                value=COPY(
                    'browser/chrome/browser/preferences/privacy.dtd',
                    'browserContainersLearnMore.label',
                )
            ),
            FTL.Message(
                id=FTL.Identifier('browser-containers-settings'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/privacy.dtd',
                            'browserContainersSettings.label'
                        )
                    ),
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/privacy.dtd',
                            'browserContainersSettings.accesskey'
                        )
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('containers-disable-alert-title'),
                value=COPY(
                    'browser/chrome/browser/preferences/preferences.properties',
                    'disableContainersAlertTitle',
                )
            ),
            FTL.Message(
                id=FTL.Identifier('containers-disable-alert-desc'),
                value=PLURALS(
                    'browser/chrome/browser/preferences/preferences.properties',
                    'disableContainersMsg',
                    EXTERNAL_ARGUMENT('tabCount'),
                    lambda text: REPLACE_IN_TEXT(
                        text,
                        {
                            '#S': EXTERNAL_ARGUMENT('tabCount')
                        }
                    )
                )
            ),
            FTL.Message(
                id=FTL.Identifier('containers-disable-alert-ok-button'),
                value=PLURALS(
                    'browser/chrome/browser/preferences/preferences.properties',
                    'disableContainersOkButton',
                    EXTERNAL_ARGUMENT('tabCount'),
                    lambda text: REPLACE_IN_TEXT(
                        text,
                        {
                            '#S': EXTERNAL_ARGUMENT('tabCount')
                        }
                    )
                )
            ),
            FTL.Message(
                id=FTL.Identifier('containers-disable-alert-cancel-button'),
                value=COPY(
                    'browser/chrome/browser/preferences/preferences.properties',
                    'disableContainersButton2',
                )
            ),
            FTL.Message(
                id=FTL.Identifier('language-and-appearance-header'),
                value=COPY(
                    'browser/chrome/browser/preferences/preferences.dtd',
                    'languageAndAppearance.label',
                )
            ),
            FTL.Message(
                id=FTL.Identifier('fonts-and-colors-header'),
                value=COPY(
                    'browser/chrome/browser/preferences/content.dtd',
                    'fontsAndColors.label',
                )
            ),
            FTL.Message(
                id=FTL.Identifier('default-font'),
                value=COPY(
                    'browser/chrome/browser/preferences/content.dtd',
                    'defaultFont2.label',
                ),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/content.dtd',
                            'defaultFont2.accesskey',
                        )
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('default-font-size'),
                value=COPY(
                    'browser/chrome/browser/preferences/content.dtd',
                    'defaultSize2.label',
                ),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/content.dtd',
                            'defaultSize2.accesskey',
                        )
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('advanced-fonts'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/content.dtd',
                            'advancedFonts.label',
                        )
                    ),
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/content.dtd',
                            'advancedFonts.accesskey',
                        )
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('colors-settings'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/content.dtd',
                            'colors.label',
                        )
                    ),
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/content.dtd',
                            'colors.accesskey',
                        )
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('language-header'),
                value=COPY(
                    'browser/chrome/browser/preferences/content.dtd',
                    'language2.label',
                )
            ),
            FTL.Message(
                id=FTL.Identifier('choose-language-description'),
                value=COPY(
                    'browser/chrome/browser/preferences/content.dtd',
                    'chooseLanguage.label',
                )
            ),
            FTL.Message(
                id=FTL.Identifier('choose-button'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/content.dtd',
                            'chooseButton.label',
                        )
                    ),
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/content.dtd',
                            'chooseButton.accesskey',
                        )
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('translate-web-pages'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/content.dtd',
                            'translateWebPages.label',
                        )
                    ),
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/content.dtd',
                            'translateWebPages.accesskey',
                        )
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('translate-exceptions'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/content.dtd',
                            'translateExceptions.label',
                        )
                    ),
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/content.dtd',
                            'translateExceptions.accesskey',
                        )
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('check-user-spelling'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/advanced.dtd',
                            'checkUserSpelling.label',
                        )
                    ),
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/advanced.dtd',
                            'checkUserSpelling.accesskey',
                        )
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('files-and-applications-title'),
                value=COPY(
                    'browser/chrome/browser/preferences/preferences.dtd',
                    'filesAndApplications.label',
                )
            ),
            FTL.Message(
                id=FTL.Identifier('download-header'),
                value=COPY(
                    'browser/chrome/browser/preferences/main.dtd',
                    'downloads.label',
                )
            ),
            FTL.Message(
                id=FTL.Identifier('download-save-to'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/main.dtd',
                            'saveTo.label',
                        )
                    ),
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/main.dtd',
                            'saveTo.accesskey',
                        )
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('download-choose-folder'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        FTL.Pattern(
                            elements=[
                                FTL.Placeable(
                                    expression=FTL.SelectExpression(
                                        expression=FTL.CallExpression(
                                            callee=FTL.Identifier('PLATFORM')
                                        ),
                                        variants=[
                                            FTL.Variant(
                                                key=FTL.VariantName('macos'),
                                                default=False,
                                                value=COPY(
                                                    'browser/chrome/browser/preferences/main.dtd',
                                                    'chooseFolderMac.label'
                                                )
                                            ),
                                            FTL.Variant(
                                                key=FTL.VariantName('other'),
                                                default=True,
                                                value=COPY(
                                                    'browser/chrome/browser/preferences/main.dtd',
                                                    'chooseFolderWin.label'
                                                )
                                            )
                                        ]
                                    )
                                )
                            ]
                        )
                    ),
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        FTL.Pattern(
                            elements=[
                                FTL.Placeable(
                                    expression=FTL.SelectExpression(
                                        expression=FTL.CallExpression(
                                            callee=FTL.Identifier('PLATFORM')
                                        ),
                                        variants=[
                                            FTL.Variant(
                                                key=FTL.VariantName('macos'),
                                                default=False,
                                                value=COPY(
                                                    'browser/chrome/browser/preferences/main.dtd',
                                                    'chooseFolderMac.accesskey'
                                                )
                                            ),
                                            FTL.Variant(
                                                key=FTL.VariantName('other'),
                                                default=True,
                                                value=COPY(
                                                    'browser/chrome/browser/preferences/main.dtd',
                                                    'chooseFolderWin.accesskey'
                                                )
                                            )
                                        ]
                                    )
                                )
                            ]
                        )
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('download-always-ask-where'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/main.dtd',
                            'alwaysAskWhere.label'
                        )
                    ),
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/main.dtd',
                            'alwaysAskWhere.accesskey'
                        )
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('applications-header'),
                value=COPY(
                    'browser/chrome/browser/preferences/applications.dtd',
                    'applications.label',
                )
            ),
            FTL.Message(
                id=FTL.Identifier('applications-description'),
                value=REPLACE(
                    'browser/chrome/browser/preferences/applications.dtd',
                    'applications.description',
                    {
                        '&brandShortName;': MESSAGE_REFERENCE('-brand-short-name')
                    },
                )
            ),
            FTL.Message(
                id=FTL.Identifier('applications-filter'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('placeholder'),
                        COPY(
                            'browser/chrome/browser/preferences/applications.dtd',
                            'filter2.emptytext',
                        )
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('applications-type-column'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/applications.dtd',
                            'typeColumn.label',
                        )
                    ),
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/applications.dtd',
                            'typeColumn.accesskey',
                        )
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('applications-action-column'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/applications.dtd',
                            'actionColumn2.label',
                        )
                    ),
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/applications.dtd',
                            'actionColumn2.accesskey',
                        )
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('drm-content-header'),
                value=COPY(
                    'browser/chrome/browser/preferences/content.dtd',
                    'drmContent2.label',
                )
            ),
            FTL.Message(
                id=FTL.Identifier('play-drm-content'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/content.dtd',
                            'playDRMContent2.label',
                        )
                    ),
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/content.dtd',
                            'playDRMContent2.accesskey',
                        )
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('play-drm-content-learn-more'),
                value=COPY(
                    'browser/chrome/browser/preferences/content.dtd',
                    'playDRMContent.learnMore.label',
                )
            ),
            FTL.Message(
                id=FTL.Identifier('update-application-title'),
                value=REPLACE(
                    'browser/chrome/browser/preferences/advanced.dtd',
                    'updateApplication.label',
                    {
                        '&brandShortName;': MESSAGE_REFERENCE('-brand-short-name')
                    },
                )
            ),
            FTL.Message(
                id=FTL.Identifier('update-application-description'),
                value=REPLACE(
                    'browser/chrome/browser/preferences/advanced.dtd',
                    'updateApplicationDescription.label',
                    {
                        '&brandShortName;': MESSAGE_REFERENCE('-brand-short-name')
                    },
                )
            ),
            FTL.Message(
                id=FTL.Identifier('update-application-info'),
                value=CONCAT(
                    COPY(
                        'browser/chrome/browser/preferences/advanced.dtd',
                        'updateApplication.version.pre'
                    ),
                    EXTERNAL_ARGUMENT('version'),
                    COPY(
                        'browser/chrome/browser/preferences/advanced.dtd',
                        'updateApplication.version.post'
                    ),
                    FTL.TextElement(' <a>'),
                    COPY(
                        'browser/chrome/browser/aboutDialog.dtd',
                        'releaseNotes.link',
                    ),
                    FTL.TextElement('</a>'),
                ),
            ),
            FTL.Message(
                id=FTL.Identifier('update-history'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/advanced.dtd',
                            'updateHistory2.label',
                        )
                    ),
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/advanced.dtd',
                            'updateHistory2.accesskey',
                        )
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('update-application-allow-description'),
                value=REPLACE(
                    'browser/chrome/browser/preferences/advanced.dtd',
                    'updateApplication.description',
                    {
                        '&brandShortName;': MESSAGE_REFERENCE('-brand-short-name')
                    },
                )
            ),
            FTL.Message(
                id=FTL.Identifier('update-application-auto'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/advanced.dtd',
                            'updateAuto3.label',
                        )
                    ),
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/advanced.dtd',
                            'updateAuto3.accesskey',
                        )
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('update-application-check-choose'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/advanced.dtd',
                            'updateCheckChoose2.label',
                        )
                    ),
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/advanced.dtd',
                            'updateCheckChoose2.accesskey',
                        )
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('update-application-manual'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/advanced.dtd',
                            'updateManual2.label',
                        )
                    ),
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/advanced.dtd',
                            'updateManual2.accesskey',
                        )
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('update-application-use-service'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/advanced.dtd',
                            'useService.label',
                        )
                    ),
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/advanced.dtd',
                            'useService.accesskey',
                        )
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('update-enable-search-update'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/advanced.dtd',
                            'enableSearchUpdate2.label',
                        )
                    ),
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/advanced.dtd',
                            'enableSearchUpdate2.accesskey',
                        )
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('performance-title'),
                value=COPY(
                    'browser/chrome/browser/preferences/advanced.dtd',
                    'performance.label',
                )
            ),
            FTL.Message(
                id=FTL.Identifier('performance-use-recommended-settings-checkbox'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/advanced.dtd',
                            'useRecommendedPerformanceSettings2.label',
                        )
                    ),
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/advanced.dtd',
                            'useRecommendedPerformanceSettings2.accesskey',
                        )
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('performance-use-recommended-settings-desc'),
                value=COPY(
                    'browser/chrome/browser/preferences/advanced.dtd',
                    'useRecommendedPerformanceSettings2.description',
                )
            ),
            FTL.Message(
                id=FTL.Identifier('performance-settings-learn-more'),
                value=COPY(
                    'browser/chrome/browser/preferences/advanced.dtd',
                    'performanceSettingsLearnMore.label',
                )
            ),
            FTL.Message(
                id=FTL.Identifier('performance-allow-hw-accel'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/advanced.dtd',
                            'allowHWAccel.label',
                        )
                    ),
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/advanced.dtd',
                            'allowHWAccel.accesskey',
                        )
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('performance-limit-content-process-option'),
                value=COPY(
                    'browser/chrome/browser/preferences/advanced.dtd',
                    'limitContentProcessOption.label',
                ),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/advanced.dtd',
                            'limitContentProcessOption.accesskey',
                        )
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('performance-limit-content-process-enabled-desc'),
                value=COPY(
                    'browser/chrome/browser/preferences/advanced.dtd',
                    'limitContentProcessOption.description',
                )
            ),
            FTL.Message(
                id=FTL.Identifier('performance-limit-content-process-disabled-desc'),
                value=CONCAT(
                    REPLACE(
                        'browser/chrome/browser/preferences/advanced.dtd',
                        'limitContentProcessOption.disabledDescription',
                        {
                            '&brandShortName;': MESSAGE_REFERENCE('-brand-short-name')
                        },
                    ),
                    FTL.TextElement(' <a>'),
                    COPY(
                        'browser/chrome/browser/preferences/advanced.dtd',
                        'limitContentProcessOption.disabledDescriptionLink',
                    ),
                    FTL.TextElement('</a>'),
                )
            ),
            FTL.Message(
                id=FTL.Identifier('performance-default-content-process-count'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        REPLACE(
                            'browser/chrome/browser/preferences/preferences.properties',
                            'defaultContentProcessCount',
                            {
                                '%S': EXTERNAL_ARGUMENT('num')
                            },
                        )
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('browsing-title'),
                value=COPY(
                    'browser/chrome/browser/preferences/advanced.dtd',
                    'browsing.label',
                )
            ),
            FTL.Message(
                id=FTL.Identifier('browsing-use-autoscroll'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/advanced.dtd',
                            'useAutoScroll.label',
                        )
                    ),
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/advanced.dtd',
                            'useAutoScroll.accesskey',
                        )
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('browsing-use-smooth-scrolling'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/advanced.dtd',
                            'useSmoothScrolling.label',
                        )
                    ),
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/advanced.dtd',
                            'useSmoothScrolling.accesskey',
                        )
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('browsing-use-onscreen-keyboard'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/advanced.dtd',
                            'useOnScreenKeyboard.label',
                        )
                    ),
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/advanced.dtd',
                            'useOnScreenKeyboard.accesskey',
                        )
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('browsing-use-cursor-navigation'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/advanced.dtd',
                            'useCursorNavigation.label',
                        )
                    ),
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/advanced.dtd',
                            'useCursorNavigation.accesskey',
                        )
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('browsing-search-on-start-typing'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/advanced.dtd',
                            'searchOnStartTyping.label',
                        )
                    ),
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/advanced.dtd',
                            'searchOnStartTyping.accesskey',
                        )
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('network-proxy-title'),
                value=COPY(
                    'browser/chrome/browser/preferences/advanced.dtd',
                    'networkProxy.label',
                )
            ),
            FTL.Message(
                id=FTL.Identifier('network-proxy-connection-learn-more'),
                value=COPY(
                    'browser/chrome/browser/preferences/advanced.dtd',
                    'connectionSettingsLearnMore.label',
                )
            ),
            FTL.Message(
                id=FTL.Identifier('network-proxy-connection-settings'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/advanced.dtd',
                            'connectionSettings.label',
                        )
                    ),
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/advanced.dtd',
                            'connectionSettings.accesskey',
                        )
                    ),
                ],
            ),
        ]
    )
