/* Copyright (C) 2022-2024 Free Software Foundation

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program. If not, see <http://www.gnu.org/licenses>.  */


package org.gprofng.mpmt;

import org.gprofng.analyzer.AnEnvironment;
import javax.swing.JPopupMenu;

public class NoMetricsSelectedPanel extends javax.swing.JPanel {
  private int dtype;

  public NoMetricsSelectedPanel(int dtype) {
    this.dtype = dtype;
    initComponents();
    setBackground(AnEnvironment.DEFAULT_PANEL_BACKGROUND);
    textLabel.setText(AnLocale.getString("No metrics selected for this view."));
    resolveButton.setText(AnLocale.getString("Select Metrics"));
    resolveButton.setMnemonic(AnLocale.getString('S', "select_metrics_button"));
    resolveButton.setToolTipText(AnLocale.getString(("Select metrics")));
  }

  /**
   * This method is called from within the constructor to initialize the form. WARNING: Do NOT
   * modify this code. The content of this method is always regenerated by the Form Editor.
   */
  @SuppressWarnings("unchecked")
  // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
  private void initComponents() {
    java.awt.GridBagConstraints gridBagConstraints;

    textLabel = new javax.swing.JLabel();
    pathTextField = new javax.swing.JTextField();
    resolveButton = new javax.swing.JButton();

    setLayout(new java.awt.GridBagLayout());

    textLabel.setText("jLabel1");
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.gridx = 0;
    gridBagConstraints.gridy = 0;
    add(textLabel, gridBagConstraints);

    pathTextField.setEditable(false);
    pathTextField.setBorder(null);
    pathTextField.setOpaque(false);
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.gridx = 0;
    gridBagConstraints.gridy = 1;
    gridBagConstraints.insets = new java.awt.Insets(8, 0, 0, 0);
    add(pathTextField, gridBagConstraints);

    resolveButton.setText("jButton1");
    resolveButton.addActionListener(
        new java.awt.event.ActionListener() {
          public void actionPerformed(java.awt.event.ActionEvent evt) {
            resolveButtonActionPerformed(evt);
          }
        });
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.gridx = 0;
    gridBagConstraints.gridy = 2;
    gridBagConstraints.insets = new java.awt.Insets(8, 0, 0, 0);
    add(resolveButton, gridBagConstraints);
  } // </editor-fold>//GEN-END:initComponents

  private void resolveButtonActionPerformed(
      java.awt.event.ActionEvent evt) { // GEN-FIRST:event_resolveButtonActionPerformed
    JPopupMenu popup = new JPopupMenu();
    AnWindow.getInstance()
        .getSettings()
        .getMetricsSetting()
        .addMetricsPopupSelector(popup, dtype, true);
    popup.show(resolveButton, resolveButton.getWidth(), 0 /*resolveButton.getHeight()*/);
  } // GEN-LAST:event_resolveButtonActionPerformed

  // Variables declaration - do not modify//GEN-BEGIN:variables
  private javax.swing.JTextField pathTextField;
  private javax.swing.JButton resolveButton;
  private javax.swing.JLabel textLabel;
  // End of variables declaration//GEN-END:variables
}
