;; -*- mode: scheme; coding: utf-8 -*-

;;;;
;;;; Copyright (C) 2016 - 2018
;;;; Free Software Foundation, Inc.

;;;; This file is part of GNU Guile-CV.

;;;; GNU Guile-CV is free software; you can redistribute it and/or
;;;; modify it under the terms of the GNU General Public License as
;;;; published by the Free Software Foundation; either version 3 of the
;;;; License, or (at your option) any later version.

;;;; GNU Guile-CV is distributed in the hope that it will be useful, but
;;;; WITHOUT ANY WARRANTY; without even the implied warranty of
;;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;;;; General Public License for more details.

;;;; You should have received a copy of the GNU General Public License
;;;; along with GNU Guile-CV.  If not, see
;;;; <https://www.gnu.org/licenses/gpl.html>.
;;;;

;;; Commentary:

;;; Code:


(define-module (tests texture)
  #:use-module (oop goops)
  #:use-module (rnrs bytevectors)
  #:use-module (ice-9 match)
  #:use-module (ice-9 receive)
  #:use-module (unit-test)
  #:use-module (cv))


(define %img
  (list 4 4 1
        (list #f32(0 0 1 1
                   0 0 1 1
                   0 2 2 2
                   2 2 3 3))))

(define %glcm
  (list 4 4 4
        (list #f32(2  2  1  0
                   0  2  0  0
                   0  0  3  1
                   0  0  0  1)
              #f32(2  1  0  0
                   0  1  0  0
                   0  2  2  0
                   0  0  1  0)
              #f32(3  0  0  0
                   0  2  0  0
                   2  2  1  0
                   0  0  2  0)
              #f32(1  0  0  0
                   1  1  0  0
                   3  1  0  0
                   0  0  2  0))))

(define %glcp
   (list 4 4 4
        (list #f32(0.16667    0.08333    0.04167    0.00000
                   0.08333    0.16667    0.00000    0.00000
                   0.04167    0.00000    0.25000    0.04167
                   0.00000    0.00000    0.04167    0.08333)
              #f32(0.22222    0.05556    0.00000    0.00000
                   0.05556    0.11111    0.11111    0.00000
                   0.00000    0.11111    0.22222    0.05556
                   0.00000    0.00000    0.05556    0.00000)
              #f32(0.25000    0.00000    0.08333    0.00000
                   0.00000    0.16667    0.08333    0.00000
                   0.08333    0.08333    0.08333    0.08333
                   0.00000    0.00000    0.08333    0.00000)
              #f32(0.11111    0.05556    0.16667    0.00000
                   0.05556    0.11111    0.05556    0.00000
                   0.16667    0.05556    0.00000    0.11111
                   0.00000    0.00000    0.11111    0.00000))))

(define %texture
  '(0.13754
    0.95139
    0.52583
    0.97835
    0.69931
    4.45139
    2.96200
    1.59541
    2.11124
    1.43885
    0.89552))

(define %sinter-t1
  '(0.12167
    1.34866
    0.96552
    19.56449
    0.78232
    21.24842
    76.90931
    2.65457
    3.12041
    2.01052
    1.01531))

(define %sinter-t2
  '(0.12167
    1.34866
    0.96552
   19.56449
    0.78232
   21.24842
   76.90931
    3.82974
    4.50181
    2.01052
    1.46479))

(define %sinter-t3
  '(0.12167
    1.34866
    0.96552
   19.56449
    0.78232
   21.24842
   76.90931
    3.82974
    4.50181
    1.01052
    1.46479))


(define-class <guile-cv-tests-texture> (<test-case>))

(define-method (test-im-glcm (self <guile-cv-tests-texture>))
  (assert-true (im-=? (im-glcm %img 4 #:p-max 3) %glcm)))

(define-method (test-im-glcp (self <guile-cv-tests-texture>))
  (assert-true (im-=? (im-glcp %img 4 #:p-max 3) %glcp)))

(define-method (test-im-texture (self <guile-cv-tests-texture>))
  (let* ((i-dir (getenv "TEST_IMAGES_PATH"))
	 (s-file (string-append i-dir "/sinter.png"))
         (sinter (im-load s-file))
         (sinter-t1 (im-texture sinter 16))
         (sinter-t2 (im-texture sinter 16 #:use-log2 #t))
         (sinter-t3 (im-texture sinter 16 #:use-log2 #t #:no-px-y0 #t)))
    (assert-true (and-l (map (lambda (ab)
                               (match ab ((a b) (float=? a b))))
                          (zip sinter-t1 %sinter-t1))))
    ))


(exit-with-summary (run-all-defined-test-cases))


#!

;; not using the following, maybe later though, let's keep it in case.

(define %a11-glcm
  (list 16 16 4
        (list #f32(
                   52  36  0  0  0  0  0  0  0  0  0  0  0  0  0  0
                   30  5403  3164  671  415  138  42  2  0  0  0  0  0  0  0  0
                   3  3342  73588  8158  2523  1516  722  181  7  0  0  0  0  0  0  0
                   2  557  8197  8327  2526  1778  1426  952  343  21  1  2  0  0  0  0
                   1  368  2618  2503  1994  1620  1450  1250  928  328  14  1  0  0  0  0
                   0  146  1598  1716  1651  1498  1277  1238  1222  861  277  14  0  0  0  0
                   0  18  691  1438  1408  1325  1319  1221  1247  1198  742  204  3  0  0  0
                   0  2  157  924  1253  1226  1296  1415  1302  1417  1131  501  60  0  0  0
                   0  0  4  283  931  1179  1202  1446  1572  1686  1645  910  198  7  0  0
                   0  0  2  16  340  914  1109  1331  1743  2483  2799  1711  323  22  0  0
                   0  0  0  1  18  291  814  1172  1644  2762  6016  4888  784  30  0  0
                   0  0  0  0  0  8  158  452  930  1730  5057  24492  5810  53  0  0
                   0  0  0  0  0  0  2  28  130  286  724  6063  60760  2143  1  0
                   0  0  0  0  0  0  0  0  2  8  19  31  2206  10663  3  0
                   0  0  0  0  0  0  0  0  0  0  0  0  0  4  0  0
                   0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0)
              #f32(
                   44  40  3  1  0  0  0  0  0  0  0  0  0  0  0  0
                   41  4445  3236  987  597  339  121  53  11  1  0  0  0  0  0  0
                   1  3815  68427  8962  3362  2324  1606  838  347  109  11  3  0  0  0  0
                   2  729  9568  6084  1865  1476  1374  1368  1018  461  129  11  0  0  0  0
                   0  407  3395  1973  1423  1247  1082  1033  1073  981  390  44  0  0  0  0
                   0  192  2331  1512  1197  1155  1045  971  960  1182  792  140  6  0  0  0
                   0  133  1459  1380  1041  979  1032  989  960  1088  1275  437  21  1  0  0
                   0  54  839  1243  955  889  916  1076  1058  1157  1546  872  58  0  0  0
                   0  31  375  1019  957  856  873  1022  1204  1305  1815  1429  160  2  0  0
                   0  12  168  549  889  886  864  949  1217  1713  2561  2572  390  5  0  0
                   0  0  35  232  562  891  976  1012  1302  1923  4115  6308  1015  13  0  0
                   0  0  0  40  160  373  728  1044  1358  1985  4224  20356  8244  71  0  0
                   0  0  0  2  21  51  152  286  526  818  1491  6473  57503  2738  1  0
                   0  0  0  0  0  5  14  14  17  22  40  101  2662  10054  3  0
                   0  0  0  0  0  0  0  0  0  0  0  0  1  3  0  0
                   0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0)
              #f32(
                   50  29  5  3  1  0  0  0  0  0  0  0  0  0  0  0
                   38  5561  3049  636  395  144  14  1  0  0  0  0  0  0  0  0
                   0  3289  73517  7965  2690  1664  712  87  2  0  1  0  0  0  0  0
                   0  492  8471  8268  2437  1787  1539  948  167  3  1  0  0  0  0  0
                   0  282  2580  2681  1851  1621  1473  1466  925  179  4  0  0  0  0  0
                   0  156  1389  1925  1647  1306  1276  1309  1378  958  142  5  0  0  0  0
                   0  48  724  1388  1448  1256  1205  1246  1320  1374  762  40  0  0  0  0
                   0  1  227  860  1267  1233  1152  1254  1402  1598  1405  281  2  0  0  0
                   0  0  12  347  901  1177  1221  1272  1441  1860  2029  769  37  0  0  0
                   0  0  3  31  365  865  1097  1234  1575  2304  3401  1814  103  0  0  0
                   0  0  2  3  57  366  762  1050  1532  2263  5534  6423  425  1  0  0
                   0  0  0  0  0  65  314  639  958  1640  3988  24138  6990  6  0  0
                   0  0  0  0  0  0  31  159  343  542  1102  5239  60440  2282  0  0
                   0  0  0  0  0  0  0  5  19  54  48  65  2132  10606  3  0
                   0  0  0  0  0  0  0  0  0  0  1  0  0  2  1  0
                   0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0)
              #f32(
                   46  33  1  3  2  1  2  0  0  0  0  0  0  0  0  0
                   42  4571  3443  726  489  313  135  75  42  2  0  0  0  0  0  0
                   0  3630  68774  8870  3377  2348  1617  744  302  116  6  0  0  0  0  0
                   0  678  9313  6177  1914  1474  1408  1505  974  453  89  5  0  0  0  0
                   0  399  3323  2033  1371  1196  994  1040  1223  1041  385  27  0  0  0  0
                   0  232  2254  1553  1149  1108  966  890  930  1229  1028  138  1  0  0  0
                   0  148  1523  1475  997  937  957  904  923  1030  1429  465  10  0  0  0
                   0  109  753  1443  916  895  908  1022  1020  1078  1455  994  74  0  0  0
                   0  45  336  1112  1070  843  894  996  1104  1289  1593  1577  196  0  0  0
                   0  6  124  545  1070  920  857  997  1157  1691  2353  2629  410  3  0  0
                   0  0  13  131  543  928  1104  970  1321  1930  4183  6115  1146  5  0  0
                   0  0  0  11  136  429  760  1073  1461  2024  4271  20153  8347  45  0  0
                   0  0  0  0  11  84  164  405  552  830  1534  6425  57221  2843  0  0
                   0  0  0  0  0  0  14  30  34  45  58  91  2648  9998  4  0
                   0  0  0  0  0  0  0  0  1  0  0  0  0  3  0  0
                   0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0))))

!#
