/*
 * Copyright (C) 1997, 1998, 1999, 2002, 2003, 2004, 2006 Free Software
 * Foundation, Inc.
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this software; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <config.h>
#include <libguile.h>
#include <guile-gtk.h>
#include "compat.h"
#include "gtk-threads.h"
#include <string.h>

#define numberof(x)  (sizeof (x) / sizeof ((x)[0]))



GdkColor*
gtk_style_white (GtkStyle *style)
{
  return &style->white;
}

GdkColor*
gtk_style_black (GtkStyle *style)
{
  return &style->black;
}

GdkColor *
gtk_style_fg (GtkStyle *style, GtkStateType state)
{
  if (state < 0 || state >= numberof (style->fg))
    return NULL;
  else
    return &style->fg[state];
}

GdkColor *
gtk_style_bg (GtkStyle *style, GtkStateType state)
{
  if (state < 0 || state >= numberof (style->bg))
    return NULL;
  else
    return &style->bg[state];
}

GdkColor *
gtk_style_light (GtkStyle *style, GtkStateType state)
{
  if (state < 0 || state >= numberof (style->light))
    return NULL;
  else
    return &style->light[state];
}

GdkColor *
gtk_style_dark (GtkStyle *style, GtkStateType state)
{
  if (state < 0 || state >= numberof (style->dark))
    return NULL;
  else
    return &style->dark[state];
}

GdkColor *
gtk_style_mid (GtkStyle *style, GtkStateType state)
{
  if (state < 0 || state >= numberof (style->mid))
    return NULL;
  else
    return &style->mid[state];
}

GdkColor *
gtk_style_text (GtkStyle *style, GtkStateType state)
{
  if (state < 0 || state >= numberof (style->text))
    return NULL;
  else
    return &style->text[state];
}

GdkColor *
gtk_style_base (GtkStyle *style, GtkStateType state)
{
  if (state < 0 || state >= numberof (style->base))
    return NULL;
  else
    return &style->base[state];
}

GdkGC *
gtk_style_fg_gc (GtkStyle *style, GtkStateType state)
{
  if (style == NULL || state < 0 || state >= 5)
    return NULL;

  return style->fg_gc[state];
}

GdkGC *
gtk_style_bg_gc (GtkStyle *style, GtkStateType state)
{
  if (style == NULL || state < 0 || state >= 5)
    return NULL;

  return style->bg_gc[state];
}

GdkGC *
gtk_style_light_gc (GtkStyle *style, GtkStateType state)
{
  if (style == NULL || state < 0 || state >= 5)
    return NULL;

  return style->light_gc[state];
}

GdkGC *
gtk_style_dark_gc (GtkStyle *style, GtkStateType state)
{
  if (style == NULL || state < 0 || state >= 5)
    return NULL;

  return style->dark_gc[state];
}

GdkGC *
gtk_style_mid_gc (GtkStyle *style, GtkStateType state)
{
  if (style == NULL || state < 0 || state >= 5)
    return NULL;

  return style->mid_gc[state];
}

GdkGC *
gtk_style_text_gc (GtkStyle *style, GtkStateType state)
{
  if (style == NULL || state < 0 || state >= 5)
    return NULL;

  return style->text_gc[state];
}

GdkGC *
gtk_style_base_gc (GtkStyle *style, GtkStateType state)
{
  if (style == NULL || state < 0 || state >= 5)
    return NULL;

  return style->base_gc[state];
}

SCM_KEYWORD (kw_type,  "type");
SCM_KEYWORD (kw_flags, "flags");

static SCM
args_query_ret (GtkArg *args, guint32 *arg_flags, guint nargs)
{
  SCM res = SCM_EOL, *restail = &res;
  int i;

  if (args == NULL)
    {
      if (arg_flags != NULL)
	g_free (arg_flags);
      return SCM_BOOL_F;
    }

  for (i = 0; i < nargs; i++)
    {
      *restail =
	scm_cons (scm_list_5 (scm_from_locale_string (args[i].name),
			      kw_type,
			      sgtk_type2scm (args[i].type),
			      kw_flags,
			      sgtk_flags2scm (arg_flags[i],
					      &sgtk_gtk_arg_flags_info)),
		  SCM_EOL);
      restail = SCM_CDRLOC(*restail);
    }

  g_free (args);
  g_free (arg_flags);

  return res;
}

SCM
gtk_object_query_args_interp (GtkType type)
{
  guint nargs = 0;
  guint32 *arg_flags = NULL;
  GtkArg *args;
  args = gtk_object_query_args (type, &arg_flags, &nargs);
  return args_query_ret (args, arg_flags, nargs);
}

SCM
gtk_container_query_child_args_interp (GtkType type)
{
  guint nargs = 0;
  guint32 *arg_flags = NULL;
  GtkArg *args;
  args = gtk_container_query_child_args (type, &arg_flags, &nargs);
  return args_query_ret (args, arg_flags, nargs);
}

int
gtk_editable_insert_text_scm (GtkEditable *editable,
			      gchar       *text,
			      int          position)
{
  gtk_editable_insert_text (editable, text, strlen (text), &position);
  return position;
}

void* gtk_fake_copy (void* ptr)
{
  return ptr;
}

void *gtk_no_copy (void *ptr)
{
  return NULL;
}

void gtk_no_free (void *ptr)
{
}

SCM
gtk_selection_data_data (GtkSelectionData* data)
{
  if (data->length >= 0)
    return scm_from_locale_stringn (data->data, data->length);
  else
    return SCM_BOOL_F;
}


static GList *
sgtk_glist_malloc (size_t len)
{
  GList *lst = scm_malloc (len * sizeof (GList));
  size_t i;
  for (i = 0; i < len; i++)
    {
      lst[i].next = &lst[i+1];
      lst[i].prev = &lst[i-1];
    }
  lst[0].prev = NULL;
  lst[len-1].next = NULL;
  return lst;
}


/* Explicit code for this isn't nice, but we want to make sure the strings
   are protected after conversion to cstrs.  This and gdk_drag_begin are the
   only places a GList is an input, so no burning need for a generic
   mechanism.  However one thing we can do here with explicit code is
   disallow an empty list or vector; gtkcombo.c has an assert against
   that.  */
void
gtk_combo_set_popdown_strings_interp (GtkCombo *combo, SCM strings)
#define FUNC_NAME "gtk-combo-set-popdown-strings"
{
  GList *lst;
  SCM keep;

  if (scm_is_pair (strings))
    {
      size_t len = scm_to_size_t (scm_length (strings)), i;
      lst = sgtk_glist_malloc (len);
      keep = sgtk_make_cblk (lst, len * sizeof (GList));
      for (i = 0; i < len; i++, strings = scm_cdr (strings))
	{
	  SCM cstr = sgtk_to_cstr (scm_car (strings));
          keep = scm_cons (cstr, keep);
          lst[i].data = sgtk_cstr2ptr (cstr, SCM_ARG2, FUNC_NAME);
	}
    }
  else if (scm_is_vector (strings))
    {
      size_t len = scm_c_vector_length (strings), i;
      if (len == 0)
        goto wrong_type;
      lst = sgtk_glist_malloc (len);
      keep = sgtk_make_cblk (lst, len * sizeof (GList));
      for (i = 0; i < len; i++)
	{
	  SCM cstr = sgtk_to_cstr (scm_c_vector_ref (strings, i));
          keep = scm_cons (cstr, keep);
          lst[i].data = sgtk_cstr2ptr (cstr, SCM_ARG2, FUNC_NAME);
	}
    }
  else
    {
    wrong_type:
      SCM_WRONG_TYPE_ARG (SCM_ARG2, strings);
    }

  gtk_combo_set_popdown_strings (combo, lst);
  scm_remember_upto_here_1 (keep);
}
#undef FUNC_NAME


/* Same as in gtk-glue.c, could share with that file if it exported this. */
static SCM
_sgtk_helper_toscm_copy_GtkWidget (void *mem)
{
  return sgtk_wrap_gtkobj ((GtkObject*)(*(GtkWidget**)mem));
}

/* The list returned by gtk_container_children must be freed by the caller.
   Could do this sort of thing with a .defs file option, but easy enough to
   have explicit code while there's only a few such.  */
SCM
gtk_container_children_interp (GtkContainer *container)
{
  GList* children;
  SCM ret;
  children = gtk_container_children (container);
  ret = sgtk_list2scm (children, _sgtk_helper_toscm_copy_GtkWidget);
  g_list_free (children);
  return ret;
}

/* Return a list of strings. */
SCM
gtk_rc_get_default_files_interp (void)
{
  return scm_makfromstrs (-1, gtk_rc_get_default_files ());
}

SCM
gtk_widget_size_request_interp (GtkWidget *widget)
{
  GtkRequisition req;
  gtk_widget_size_request (widget, &req);
  return scm_cons (scm_from_int (req.width), scm_from_int (req.height));
}




/* These SCM_PROCs are here to have them initialized in
   sgtk_init_gtk_support.  Having them in sgtk_init_substrate is wrong
   because then they are not guaranteed to end up in the (gtk gtk)
   module. */

SCM_PROC (s_gtk_callback_trampoline, "gtk-callback-trampoline", 0, 1, 0, sgtk_callback_trampoline);
SCM_PROC (s_gtk_standalone_p, "gtk-standalone?", 0, 0, 0, sgtk_standalone_p);

SCM sgtk_gtk_object_new (SCM, SCM);
SCM sgtk_gtk_object_set (SCM, SCM);
SCM sgtk_gtk_object_get (SCM, SCM);

SCM_PROC (s_gtk_object_new, "gtk-object-new", 1, 0, 1, sgtk_gtk_object_new);
SCM_PROC (s_gtk_object_set, "gtk-object-set", 1, 0, 1, sgtk_gtk_object_set);
SCM_PROC (s_gtk_object_get, "gtk-object-get", 2, 0, 0, sgtk_gtk_object_get);
SCM_PROC (s_gtk_widget_new, "gtk-widget-new", 1, 0, 1, sgtk_gtk_object_new);
SCM_PROC (s_gtk_widget_set, "gtk-widget-set", 1, 0, 1, sgtk_gtk_object_set);
SCM_PROC (s_gtk_widget_get, "gtk-widget-get", 2, 0, 0, sgtk_gtk_object_get);

SCM_PROC (s_gtk_threads_update, "gtk-threads-update", 0, 0, 0, sgtk_threads_update);

void
sgtk_init_gtk_support ()
{
#ifndef SCM_MAGIC_SNARFER
#ifndef MKDEP
#include "gtk-support.x"
#endif /* MKDEP */
#endif /* SCM_MAGIC_SNARFER */

  /* Use the library variables so as to indicate what we're running with,
     not GTK_MAJOR_VERSION etc which would be what we compiled against.  */
  scm_c_define ("gtk-major-version", scm_from_uint (gtk_major_version));
  scm_c_define ("gtk-minor-version", scm_from_uint (gtk_minor_version));
  scm_c_define ("gtk-micro-version", scm_from_uint (gtk_micro_version));
  scm_c_define ("gtk-binary-age",    scm_from_uint (gtk_binary_age));
  scm_c_define ("gtk-interface-age", scm_from_uint (gtk_interface_age));

  scm_c_define ("gtk-priority-default",  scm_from_int (GTK_PRIORITY_DEFAULT));
  scm_c_define ("gtk-priority-high",     scm_from_int (GTK_PRIORITY_HIGH));
  scm_c_define ("gtk-priority-internal", scm_from_int (GTK_PRIORITY_INTERNAL));
  scm_c_define ("gtk-priority-low",      scm_from_int (GTK_PRIORITY_LOW));
  scm_c_define ("gtk-priority-redraw",   scm_from_int (GTK_PRIORITY_REDRAW));
  scm_c_define ("gtk-priority-resize",   scm_from_int (GTK_PRIORITY_RESIZE));
}
