/* classes: h_files */

#ifndef STRUCTH
#define STRUCTH
/*	Copyright (C) 1995 Free Software Foundation, Inc.
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this software; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * As a special exception, the Free Software Foundation gives permission
 * for additional uses of the text contained in its release of GUILE.
 *
 * The exception is that, if you link the GUILE library with other files
 * to produce an executable, this does not by itself cause the
 * resulting executable to be covered by the GNU General Public License.
 * Your use of that executable is in no way restricted on account of
 * linking the GUILE library code into it.
 *
 * This exception does not however invalidate any other reasons why
 * the executable file might be covered by the GNU General Public License.
 *
 * This exception applies only to the code released by the
 * Free Software Foundation under the name GUILE.  If you copy
 * code from other Free Software Foundation releases into a copy of
 * GUILE, as the General Public License permits, the exception does
 * not apply to the code that you add in this way.  To avoid misleading
 * anyone as to the status of such modified files, you must delete
 * this exception notice from them.
 *
 * If you write modifications of your own for GUILE, it is your choice
 * whether to permit this exception to apply to your modifications.
 * If you do not wish that, delete this exception notice.  
 */


#include "libguile/__scm.h"



/* Number of words with negative index */
#define scm_struct_n_extra_words 3

/* These are how the initial words of a vtable are allocated. */
#define scm_struct_i_ptr -3	/* start of block (see alloc_struct) */
#define scm_struct_i_n_words -2	/* How many words allocated to this struct? */
#define scm_struct_i_tag -1	/* A unique tag for this type.. */
#define scm_struct_i_layout 0	/* A symbol describing the physical arrangement of this type. */
#define scm_struct_i_vcell 1	/* An opaque word, managed by the garbage collector.  */
#define scm_struct_i_vtable 2	/* A pointer to the handle for this vtable. */
#define scm_struct_i_vtable_offset 3 /* Where do user fields start? */


#define SCM_STRUCTP(X)  		(SCM_TYP3(X) == scm_tc3_cons_gloc)
#define SCM_STRUCT_DATA(X) 		((SCM*)(SCM_CDR(X)))
#define SCM_STRUCT_VTABLE_DATA(X) 	((SCM *)(SCM_CAR(X) - 1))
#define SCM_STRUCT_LAYOUT(X) 		(SCM_STRUCT_VTABLE_DATA(X)[scm_struct_i_layout])
#define SCM_STRUCT_VTABLE(X) 		(SCM_STRUCT_VTABLE_DATA(X)[scm_struct_i_vtable])
/* Efficiency is important in the following macro, since it's used in GC */
#define SCM_LAYOUT_TAILP(X)		(((X) & 32) == 0) /* R, W or O */




extern SCM scm_make_struct_layout SCM_P ((SCM fields));
extern SCM scm_struct_p SCM_P ((SCM x));
extern SCM scm_struct_vtable_p SCM_P ((SCM x));
extern SCM scm_make_struct SCM_P ((SCM vtable, SCM tail_array_size, SCM init));
extern SCM scm_make_vtable_vtable SCM_P ((SCM extra_fields, SCM tail_array_size, SCM init));
extern SCM scm_struct_ref SCM_P ((SCM handle, SCM pos));
extern SCM scm_struct_set_x SCM_P ((SCM handle, SCM pos, SCM val));
extern SCM scm_struct_vtable SCM_P ((SCM handle));
extern SCM scm_struct_vtable_tag SCM_P ((SCM handle));
extern void scm_init_struct SCM_P ((void));

#endif  /* STRUCTH */
