/*
 * Decompiled with CFR 0.152.
 */
package gnu.jel.reflect;

import gnu.jel.ClassFile;
import gnu.jel.TypesStack;
import gnu.jel.debug.Debug;
import gnu.jel.reflect.Member;

public class LocalField
implements Member {
    protected int modifiers;
    private String name;
    private Class type;
    private int typeID;
    private Object constValue;

    public LocalField(int modifiers, Class type, String name, Object constValue) {
        this.type = type;
        this.typeID = TypesStack.typeID(type);
        this.name = name;
        Debug.assert(constValue == null || (modifiers & 0x18) == 24);
        this.modifiers = modifiers & 0xFFFF | 0x10000;
        this.constValue = constValue;
    }

    public Class getDeclaringClass() {
        return null;
    }

    public String getName() {
        return this.name;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public Class getType() {
        return this.type;
    }

    public int getTypeID() {
        return this.typeID;
    }

    public Class[] getParameterTypes() {
        return new Class[0];
    }

    public Object eval(Object obj, Object[] params) throws Exception {
        throw new Exception();
    }

    public boolean equals(Object o) {
        if (!(o instanceof LocalField)) {
            return false;
        }
        LocalField obj = (LocalField)o;
        Class dc = this.getDeclaringClass();
        Class odc = obj.getDeclaringClass();
        return this.name.equals(obj.name) && (dc == odc || dc != null && dc.equals(odc));
    }

    public void code(ClassFile cf) {
        if ((this.modifiers & 8) > 0) {
            cf.code(178L);
        } else {
            cf.code(180L);
        }
        cf.codeI(cf.getIndex(this, 12));
    }
}

