
;; INNOR INSTALLER MODE:

(defun iss-mode ()
  (interactive)
  (kill-all-local-variables)
  (setq major-mode 'iss-mode)
  (setq mode-name "Inno Setup Script")

  (make-local-variable 'font-lock-keywords-case-fold-search)
  ;;(setq-default font-lock-keywords-case-fold-search nil)
  (setq font-lock-keywords-case-fold-search t)
  ;;(d-bat--font-lock-mode-hook)
  ;;(font-lock-fontify-buffer)
  ;;(turn-on-fast-lock)
  (turn-on-font-lock)
  (run-hooks 'd-iss--font-lock-mode-hook)
  )

(defun d-iss--font-lock-mode-hook ()
  (if (eq major-mode 'iss-mode)
      (progn
        ;;(d-foo)
        (d-font-lock-add-end
         '(
           ("%[a-zA-Z]+%" 0 font-lock-variable-name-face t)
           ("\\([- _.a-zA-Z0-9]+\\)=" 1 font-lock-variable-name-face t)
           ;;("[ABCDEF]:[^ ;\n]+" 0 font-lock-function-name-face t)
           ;;("\\." 0 font-lock-function-name-face nil)
           ("^;.*$" 0 font-lock-comment-face t)
           ("=" 0 font-lock-reference-face t)
           ;;("/[a-zA-Z]" 0 font-lock-function-name-face t)
           ("\\[\\sw+\\]" 0 font-lock-function-name-face t)
           ("\\<\\(set\\|rem\\)\\>" 0 font-lock-keyword-face t)
           ("\\<rem \\([^\n]*\\)$" 1 font-lock-comment-face t)
           ("---+" 0 font-lock-type-face t)
           ("---+ \\([a-zA-Z !:_-]+\\) ---+" 0 font-lock-type-face t)
           ))
        ;;(turn-on-fast-lock)
        ;;(font-lock-fontify-buffer)
        ;;(setq font-lock-mode t)
        )))
(add-hook 'font-lock-mode-hook 'd-iss--font-lock-mode-hook)

(setq auto-mode-alist
      (append '(("\\.iss$" . iss-mode)
                )
                auto-mode-alist))

;;(setq auto-mode-alist nil)

(provide 'd-iss)
;;; d-iss.el ends here
