/*
 * Decompiled with CFR 0.152.
 */
package gnu.math;

import gnu.math.Dimensions;
import gnu.math.NamedUnit;
import gnu.math.Unit;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;

public class BaseUnit
extends NamedUnit
implements Externalizable {
    String dimension;
    static int base_count = 0;
    int index;
    private static final String unitName = "(name)";

    public String getDimension() {
        return this.dimension;
    }

    public BaseUnit() {
        this.name = unitName;
        this.index = Integer.MAX_VALUE;
        this.dims = Dimensions.Empty;
    }

    protected void init() {
        this.base = this;
        this.scale = 1.0;
        this.dims = new Dimensions(this);
        super.init();
        this.index = base_count++;
    }

    public BaseUnit(String string) {
        this.name = string;
        this.init();
    }

    public BaseUnit(String string, String string2) {
        this.name = string;
        this.dimension = string2;
        this.init();
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public Unit unit() {
        return this;
    }

    public static BaseUnit lookup(String string, String string2) {
        if ((string = string.intern()) == unitName && string2 == null) {
            return Unit.Empty;
        }
        int n = string.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % Unit.table.length;
        NamedUnit namedUnit = Unit.table[n2];
        while (namedUnit != null) {
            if (namedUnit.name == string && namedUnit instanceof BaseUnit) {
                BaseUnit baseUnit = (BaseUnit)namedUnit;
                if (baseUnit.dimension == string2) {
                    return baseUnit;
                }
            }
            namedUnit = namedUnit.chain;
        }
        return null;
    }

    public static BaseUnit make(String string, String string2) {
        BaseUnit baseUnit = BaseUnit.lookup(string, string2);
        return baseUnit == null ? new BaseUnit(string, string2) : baseUnit;
    }

    public static int compare(BaseUnit baseUnit, BaseUnit baseUnit2) {
        int n = baseUnit.name.compareTo(baseUnit2.name);
        if (n != 0) {
            return n;
        }
        String string = baseUnit.dimension;
        String string2 = baseUnit2.dimension;
        if (string == string2) {
            return 0;
        }
        if (string == null) {
            return -1;
        }
        if (string2 == null) {
            return 1;
        }
        return string.compareTo(string2);
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeUTF(this.name);
        objectOutput.writeObject(this.dimension);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.name = objectInput.readUTF();
        this.dimension = (String)objectInput.readObject();
    }

    public Object readResolve() throws ObjectStreamException {
        BaseUnit baseUnit = BaseUnit.lookup(this.name, this.dimension);
        if (baseUnit != null) {
            return baseUnit;
        }
        this.init();
        return this;
    }
}

