/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.ArrayClassLoader;
import gnu.bytecode.ArrayType;
import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Field;
import gnu.bytecode.Label;
import gnu.bytecode.Method;
import gnu.bytecode.PrimType;
import gnu.bytecode.SwitchState;
import gnu.bytecode.Type;
import gnu.bytecode.Variable;
import gnu.expr.ApplyExp;
import gnu.expr.BeginExp;
import gnu.expr.ChainLambdas;
import gnu.expr.CheckedTarget;
import gnu.expr.ClassExp;
import gnu.expr.ConditionalTarget;
import gnu.expr.ConsumerTarget;
import gnu.expr.Declaration;
import gnu.expr.ErrorExp;
import gnu.expr.Expression;
import gnu.expr.FindCapturedVars;
import gnu.expr.FindTailCalls;
import gnu.expr.IfExp;
import gnu.expr.IgnoreTarget;
import gnu.expr.Initializer;
import gnu.expr.InlineCalls;
import gnu.expr.LambdaExp;
import gnu.expr.Language;
import gnu.expr.LetExp;
import gnu.expr.LitTable;
import gnu.expr.Literal;
import gnu.expr.ModuleExp;
import gnu.expr.ModuleInfo;
import gnu.expr.ModuleManager;
import gnu.expr.NameLookup;
import gnu.expr.PairClassType;
import gnu.expr.PushApply;
import gnu.expr.QuoteExp;
import gnu.expr.ReferenceExp;
import gnu.expr.ScopeExp;
import gnu.expr.SeriesTarget;
import gnu.expr.StackTarget;
import gnu.expr.Target;
import gnu.expr.TypeValue;
import gnu.mapping.Environment;
import gnu.mapping.OutPort;
import gnu.mapping.Procedure;
import gnu.mapping.Symbol;
import gnu.mapping.ThreadLocation;
import gnu.mapping.Values;
import gnu.mapping.WrappedException;
import gnu.text.Lexer;
import gnu.text.Options;
import gnu.text.Path;
import gnu.text.SourceLocator;
import gnu.text.SourceMessages;
import gnu.text.SyntaxException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Stack;
import java.util.Vector;
import java.util.jar.JarOutputStream;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import kawa.Shell;

public class Compilation
implements SourceLocator {
    public boolean mustCompile;
    int maxSelectorValue;
    public ClassType curClass;
    public ClassType mainClass;
    public ClassType moduleClass;
    public LambdaExp curLambda;
    public ModuleExp mainLambda;
    public Variable thisDecl;
    Variable moduleInstanceVar;
    private int state;
    public static final int PROLOG_PARSING = 1;
    public static final int PROLOG_PARSED = 2;
    public static final int BODY_PARSED = 4;
    public static final int RESOLVED = 6;
    public static final int WALKED = 8;
    public static final int COMPILE_SETUP = 10;
    public static final int COMPILED = 12;
    public static final int CLASS_WRITTEN = 14;
    public static final int ERROR_SEEN = 100;
    public ModuleInfo minfo;
    public Lexer lexer;
    boolean pedantic;
    Field moduleInstanceMainField;
    public Stack pendingImports;
    public static boolean fewerClasses;
    public static boolean debugPrintExpr;
    public static boolean debugPrintFinalExpr;
    public static Options options;
    public Options currentOptions = new Options(options);
    public static int defaultCallConvention;
    public static final int CALL_WITH_UNSPECIFIED = 0;
    public static final int CALL_WITH_RETURN = 1;
    public static final int CALL_WITH_CONSUMER = 2;
    public static final int CALL_WITH_TAILCALLS = 3;
    public static final int CALL_WITH_CONTINUATIONS = 4;
    public static int moduleStatic;
    ClassType[] classes;
    int numClasses;
    ArrayClassLoader loader;
    public boolean immediate;
    public Method method;
    Method clinitMethod;
    int method_counter;
    SwitchState fswitch;
    Field fswitchIndex;
    public static ClassType typeObject;
    public static ClassType scmBooleanType;
    public static ClassType typeString;
    public static ClassType javaStringType;
    public static ClassType scmKeywordType;
    public static ClassType scmSequenceType;
    public static ClassType javaIntegerType;
    public static ClassType scmListType;
    public static ClassType typePair;
    public static ClassType scmPairType;
    public static final ArrayType objArrayType;
    public static ClassType scmNamedType;
    public static ClassType typeRunnable;
    public static ClassType typeType;
    public static ClassType typeObjectType;
    public static ClassType typeClass;
    public static ClassType typeClassType;
    public static ClassType typeProcedure;
    public static ClassType typeLanguage;
    public static ClassType typeEnvironment;
    public static ClassType typeLocation;
    public static ClassType typeSymbol;
    public static final Method getSymbolValueMethod;
    public static final Method getSymbolProcedureMethod;
    public static final Method getLocationMethod;
    public static final Method getProcedureBindingMethod;
    public static final Field trueConstant;
    public static final Field falseConstant;
    static final Method setNameMethod;
    static Method makeListMethod;
    public static final Type[] int1Args;
    public static final Type[] string1Arg;
    public static final Type[] sym1Arg;
    public static final Method getLocation1EnvironmentMethod;
    public static final Method getLocation2EnvironmentMethod;
    public static Method getCurrentEnvironmentMethod;
    public static Type[] apply0args;
    public static Type[] apply1args;
    public static Type[] apply2args;
    public static Type[] applyNargs;
    static Method checkArgCountMethod;
    public static Method apply0method;
    public static Method apply1method;
    public static Method apply2method;
    public static Method apply3method;
    public static Method apply4method;
    public static Method applyNmethod;
    public static Method[] applymethods;
    public static ClassType typeProcedure0;
    public static ClassType typeProcedure1;
    public static ClassType typeProcedure2;
    public static ClassType typeProcedure3;
    public static ClassType typeProcedure4;
    public static ClassType typeProcedureN;
    public static ClassType typeModuleBody;
    public static ClassType typeModuleWithContext;
    public static ClassType typeApplet;
    public static ClassType typeServlet;
    public static ClassType typeCallContext;
    public static final ClassType typeConsumer;
    public static Method getCallContextInstanceMethod;
    public static ClassType typeValues;
    public static Field noArgsField;
    public static Field pcCallContextField;
    public static ClassType typeMethodProc;
    public static ClassType typeModuleMethod;
    public static Field argsCallContextField;
    public static Field procCallContextField;
    private static Type[] applyCpsArgs;
    public static Method applyCpsMethod;
    public static ClassType[] typeProcedureArray;
    Initializer clinitChain;
    public static boolean generateMainDefault;
    public boolean generateMain = generateMainDefault;
    LitTable litTable;
    public static boolean generateAppletDefault;
    public boolean generateApplet = generateAppletDefault;
    public static boolean generateServletDefault;
    public boolean generateServlet = generateServletDefault;
    public static boolean inlineOk;
    public static String classPrefixDefault;
    public String classPrefix = classPrefixDefault;
    public static boolean emitSourceDebugExtAttr;
    int localFieldIndex;
    Variable callContextVar;
    Variable callContextVarForInit;
    protected Language language;
    public Stack exprStack;
    Method forNameHelper;
    private int keyUninitialized;
    private static Compilation chainUninitialized;
    private Compilation nextUninitialized;
    public NameLookup lexical;
    protected ScopeExp current_scope;
    protected SourceMessages messages;
    private static final ThreadLocation current;

    public int getState() {
        return this.state;
    }

    public void setState(int state) {
        this.state = state;
    }

    public boolean isPedantic() {
        return this.pedantic;
    }

    public void pushPendingImport(ModuleInfo info, ScopeExp defs) {
        if (this.pendingImports == null) {
            this.pendingImports = new Stack();
        }
        this.pendingImports.push(info);
        this.pendingImports.push(defs);
        ReferenceExp posExp = new ReferenceExp((Object)null);
        posExp.setLine(this);
        this.pendingImports.push(posExp);
    }

    public final boolean getBooleanOption(String key, boolean defaultValue) {
        return this.currentOptions.getBoolean(key, defaultValue);
    }

    public final boolean getBooleanOption(String key) {
        return this.currentOptions.getBoolean(key);
    }

    public boolean usingCPStyle() {
        return defaultCallConvention == 4;
    }

    public boolean usingTailCalls() {
        return defaultCallConvention >= 3;
    }

    public final CodeAttr getCode() {
        return this.method.getCode();
    }

    public final ClassType getModuleType() {
        return defaultCallConvention >= 2 ? typeModuleWithContext : typeModuleBody;
    }

    public void compileConstant(Object value) {
        CodeAttr code = this.getCode();
        if (value == null) {
            code.emitPushNull();
        } else if (value instanceof String && !this.immediate) {
            code.emitPushString((String)value);
        } else {
            code.emitGetStatic(this.compileConstantToField(value));
        }
    }

    public Field compileConstantToField(Object value) {
        Literal literal = this.litTable.findLiteral(value);
        if (literal.field == null) {
            literal.assign(this.litTable);
        }
        return literal.field;
    }

    public boolean inlineOk(Expression proc) {
        if (proc instanceof LambdaExp && !(((LambdaExp)proc).currentLambda() instanceof ModuleExp)) {
            return true;
        }
        return inlineOk;
    }

    public boolean inlineOk(Procedure proc) {
        return inlineOk;
    }

    public void compileConstant(Object value, Target target) {
        if (target instanceof IgnoreTarget) {
            return;
        }
        if (value instanceof Values) {
            Object[] values = ((Values)value).getValues();
            int len = values.length;
            if (target instanceof ConsumerTarget) {
                for (int i = 0; i < len; ++i) {
                    this.compileConstant(values[i], target);
                }
                return;
            }
            if (target instanceof SeriesTarget) {
                SeriesTarget starget = (SeriesTarget)target;
                Label saveDone = starget.done;
                if (len > 0) {
                    starget.done = null;
                    for (int i = 0; i < len; ++i) {
                        if (i + 1 == len) {
                            starget.done = saveDone;
                        }
                        this.compileConstant(values[i], target);
                    }
                } else if (saveDone != null && this.getCode().reachableHere()) {
                    this.getCode().emitGoto(saveDone);
                }
                return;
            }
        }
        if (target instanceof ConditionalTarget) {
            ConditionalTarget ctarg = (ConditionalTarget)target;
            this.getCode().emitGoto(this.getLanguage().isTrue(value) ? ctarg.ifTrue : ctarg.ifFalse);
            return;
        }
        if (target instanceof StackTarget) {
            Type type = ((StackTarget)target).getType();
            if (type instanceof PrimType) {
                try {
                    int sig1;
                    String signature = type.getSignature();
                    CodeAttr code = this.getCode();
                    int n = sig1 = signature == null || signature.length() != 1 ? 32 : (int)signature.charAt(0);
                    if (value instanceof Number) {
                        Number num = (Number)value;
                        switch (sig1) {
                            case 73: {
                                code.emitPushInt(num.intValue());
                                return;
                            }
                            case 83: {
                                code.emitPushInt(num.shortValue());
                                return;
                            }
                            case 66: {
                                code.emitPushInt(num.byteValue());
                                return;
                            }
                            case 74: {
                                code.emitPushLong(num.longValue());
                                return;
                            }
                            case 70: {
                                code.emitPushFloat(num.floatValue());
                                return;
                            }
                            case 68: {
                                code.emitPushDouble(num.doubleValue());
                                return;
                            }
                        }
                    }
                    if (sig1 == 67) {
                        code.emitPushInt(((PrimType)type).charValue(value));
                        return;
                    }
                    if (sig1 == 90) {
                        boolean val = PrimType.booleanValue(value);
                        code.emitPushInt(val ? 1 : 0);
                        return;
                    }
                }
                catch (ClassCastException ex) {
                    // empty catch block
                }
            }
            try {
                value = type.coerceFromObject(value);
            }
            catch (Exception ex) {
                StringBuffer sbuf = new StringBuffer();
                if (value == Values.empty) {
                    sbuf.append("cannot convert void to ");
                } else {
                    sbuf.append("cannot convert literal (of type ");
                    sbuf.append(value.getClass().getName());
                    sbuf.append(") to ");
                }
                sbuf.append(type.getName());
                this.error('w', sbuf.toString());
            }
        }
        this.compileConstant(value);
        target.compileFromStack(this, value == null ? target.getType() : Type.make(value.getClass()));
    }

    private void dumpInitializers(Initializer inits) {
        Initializer init = Initializer.reverse(inits);
        while (init != null) {
            init.emit(this);
            init = init.next;
        }
    }

    public ClassType findNamedClass(String name) {
        for (int i = 0; i < this.numClasses; ++i) {
            if (!name.equals(this.classes[i].getName())) continue;
            return this.classes[i];
        }
        return null;
    }

    private static void putURLWords(String name, StringBuffer sbuf) {
        int dot = name.indexOf(46);
        if (dot > 0) {
            Compilation.putURLWords(name.substring(dot + 1), sbuf);
            sbuf.append('.');
            name = name.substring(0, dot);
        }
        sbuf.append(name);
    }

    public static String mangleURI(String name) {
        boolean hasSlash = name.indexOf(47) >= 0;
        int len = name.length();
        if (len > 6 && name.startsWith("class:")) {
            return name.substring(6);
        }
        if (len > 5 && name.charAt(4) == ':' && name.substring(0, 4).equalsIgnoreCase("http")) {
            name = name.substring(5);
            len -= 5;
            hasSlash = true;
        } else if (len > 4 && name.charAt(3) == ':' && name.substring(0, 3).equalsIgnoreCase("uri")) {
            name = name.substring(4);
            len -= 4;
        }
        int start = 0;
        StringBuffer sbuf = new StringBuffer();
        while (true) {
            boolean first;
            int slash;
            int end = (slash = name.indexOf(47, start)) < 0 ? len : slash;
            boolean bl = first = sbuf.length() == 0;
            if (first && hasSlash) {
                String host = name.substring(start, end);
                if (end - start > 4 && host.startsWith("www.")) {
                    host = host.substring(4);
                }
                Compilation.putURLWords(host, sbuf);
            } else if (start != end) {
                int extLen;
                int dot;
                if (!first) {
                    sbuf.append('.');
                }
                if (end == len && (dot = name.lastIndexOf(46, len)) > start + 1 && !first && ((extLen = len - dot) <= 4 || extLen == 5 && name.endsWith("html"))) {
                    end = len -= extLen;
                    name = name.substring(0, len);
                }
                sbuf.append(name.substring(start, end));
            }
            if (slash < 0) break;
            start = slash + 1;
        }
        return sbuf.toString();
    }

    public static String mangleName(String name) {
        return Compilation.mangleName(name, -1);
    }

    public static String mangleNameIfNeeded(String name) {
        if (Compilation.isValidJavaName(name)) {
            return name;
        }
        return Compilation.mangleName(name, 0);
    }

    public static boolean isValidJavaName(String name) {
        int len = name.length();
        if (len == 0 || !Character.isJavaIdentifierStart(name.charAt(0))) {
            return false;
        }
        int i = len;
        while (--i > 0) {
            if (Character.isJavaIdentifierPart(name.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String mangleName(String name, boolean reversible) {
        return Compilation.mangleName(name, reversible ? 1 : -1);
    }

    public static String mangleName(String name, int kind) {
        boolean reversible = kind >= 0;
        int len = name.length();
        if (len == 6 && name.equals("*init*")) {
            return "<init>";
        }
        StringBuffer mangled = new StringBuffer(len);
        boolean upcaseNext = false;
        for (int i = 0; i < len; ++i) {
            char ch = name.charAt(i);
            if (upcaseNext) {
                ch = Character.toTitleCase(ch);
                upcaseNext = false;
            }
            if (Character.isDigit(ch)) {
                if (i == 0) {
                    mangled.append("$N");
                }
                mangled.append(ch);
                continue;
            }
            if (Character.isLetter(ch) || ch == '_') {
                mangled.append(ch);
                continue;
            }
            if (ch == '$') {
                mangled.append(kind > 1 ? "$$" : "$");
                continue;
            }
            switch (ch) {
                case '+': {
                    mangled.append("$Pl");
                    break;
                }
                case '-': {
                    char next;
                    if (reversible) {
                        mangled.append("$Mn");
                        break;
                    }
                    char c = next = i + 1 < len ? name.charAt(i + 1) : (char)'\u0000';
                    if (next == '>') {
                        mangled.append("$To$");
                        ++i;
                        break;
                    }
                    if (Character.isLowerCase(next)) break;
                    mangled.append("$Mn");
                    break;
                }
                case '*': {
                    mangled.append("$St");
                    break;
                }
                case '/': {
                    mangled.append("$Sl");
                    break;
                }
                case '=': {
                    mangled.append("$Eq");
                    break;
                }
                case '<': {
                    mangled.append("$Ls");
                    break;
                }
                case '>': {
                    mangled.append("$Gr");
                    break;
                }
                case '@': {
                    mangled.append("$At");
                    break;
                }
                case '~': {
                    mangled.append("$Tl");
                    break;
                }
                case '%': {
                    mangled.append("$Pc");
                    break;
                }
                case '.': {
                    mangled.append("$Dt");
                    break;
                }
                case ',': {
                    mangled.append("$Cm");
                    break;
                }
                case '(': {
                    mangled.append("$LP");
                    break;
                }
                case ')': {
                    mangled.append("$RP");
                    break;
                }
                case '[': {
                    mangled.append("$LB");
                    break;
                }
                case ']': {
                    mangled.append("$RB");
                    break;
                }
                case '{': {
                    mangled.append("$LC");
                    break;
                }
                case '}': {
                    mangled.append("$RC");
                    break;
                }
                case '\'': {
                    mangled.append("$Sq");
                    break;
                }
                case '\"': {
                    mangled.append("$Dq");
                    break;
                }
                case '&': {
                    mangled.append("$Am");
                    break;
                }
                case '#': {
                    mangled.append("$Nm");
                    break;
                }
                case '?': {
                    char first;
                    char c = first = mangled.length() > 0 ? mangled.charAt(0) : (char)'\u0000';
                    if (!reversible && i + 1 == len && Character.isLowerCase(first)) {
                        mangled.setCharAt(0, Character.toTitleCase(first));
                        mangled.insert(0, "is");
                        break;
                    }
                    mangled.append("$Qu");
                    break;
                }
                case '!': {
                    mangled.append("$Ex");
                    break;
                }
                case ':': {
                    mangled.append("$Cl");
                    break;
                }
                case ';': {
                    mangled.append("$SC");
                    break;
                }
                case '^': {
                    mangled.append("$Up");
                    break;
                }
                case '|': {
                    mangled.append("$VB");
                    break;
                }
                default: {
                    mangled.append('$');
                    mangled.append(Character.forDigit(ch >> 12 & 0xF, 16));
                    mangled.append(Character.forDigit(ch >> 8 & 0xF, 16));
                    mangled.append(Character.forDigit(ch >> 4 & 0xF, 16));
                    mangled.append(Character.forDigit(ch & 0xF, 16));
                }
            }
            if (reversible) continue;
            upcaseNext = true;
        }
        String mname = mangled.toString();
        return mname.equals(name) ? name : mname;
    }

    public static char demangle2(char char1, char char2) {
        switch (char1 << 16 | char2) {
            case 4259949: {
                return '&';
            }
            case 4259956: {
                return '@';
            }
            case 4391020: {
                return ':';
            }
            case 4391021: {
                return ',';
            }
            case 4456561: {
                return '\"';
            }
            case 0x440074: {
                return '.';
            }
            case 4522097: {
                return '=';
            }
            case 4522104: {
                return '!';
            }
            case 4653170: {
                return '>';
            }
            case 4980802: {
                return '[';
            }
            case 4980803: {
                return '{';
            }
            case 4980816: {
                return '(';
            }
            case 4980851: {
                return '<';
            }
            case 5046371: {
                return '%';
            }
            case 5046382: {
                return '-';
            }
            case 5111917: {
                return '#';
            }
            case 5242979: {
                return '%';
            }
            case 5242988: {
                return '+';
            }
            case 5308533: {
                return '?';
            }
            case 5374018: {
                return ']';
            }
            case 5374019: {
                return '}';
            }
            case 0x520050: {
                return ')';
            }
            case 5439555: {
                return ';';
            }
            case 5439596: {
                return '/';
            }
            case 5439601: {
                return '\\';
            }
            case 5439604: {
                return '*';
            }
            case 5505132: {
                return '~';
            }
            case 0x550070: {
                return '^';
            }
            case 5636162: {
                return '|';
            }
        }
        return '\uffff';
    }

    public static String demangleName(String name) {
        return Compilation.demangleName(name, false);
    }

    public static String demangleName(String name, boolean reversible) {
        StringBuffer sbuf = new StringBuffer();
        int len = name.length();
        boolean mangled = false;
        boolean predicate = false;
        boolean downCaseNext = false;
        for (int i = 0; i < len; ++i) {
            char d;
            char ch = name.charAt(i);
            if (downCaseNext && !reversible) {
                ch = Character.toLowerCase(ch);
                downCaseNext = false;
            }
            if (!reversible && ch == 'i' && i == 0 && len > 2 && name.charAt(i + 1) == 's' && !Character.isLowerCase(d = name.charAt(i + 2))) {
                mangled = true;
                predicate = true;
                ++i;
                if (!Character.isUpperCase(d) && !Character.isTitleCase(d)) continue;
                sbuf.append(Character.toLowerCase(d));
                ++i;
                continue;
            }
            if (ch == '$' && i + 2 < len) {
                char c2;
                char c1 = name.charAt(i + 1);
                d = Compilation.demangle2(c1, c2 = name.charAt(i + 2));
                if (d != '\uffff') {
                    sbuf.append(d);
                    i += 2;
                    mangled = true;
                    downCaseNext = true;
                    continue;
                }
                if (c1 == 'T' && c2 == 'o' && i + 3 < len && name.charAt(i + 3) == '$') {
                    sbuf.append("->");
                    i += 3;
                    mangled = true;
                    downCaseNext = true;
                    continue;
                }
            } else if (!reversible && i > 1 && (Character.isUpperCase(ch) || Character.isTitleCase(ch)) && Character.isLowerCase(name.charAt(i - 1))) {
                sbuf.append('-');
                mangled = true;
                ch = Character.toLowerCase(ch);
            }
            sbuf.append(ch);
        }
        if (predicate) {
            sbuf.append('?');
        }
        return mangled ? sbuf.toString() : name;
    }

    public String generateClassName(String hint) {
        hint = Compilation.mangleName(hint, true);
        if (this.mainClass != null) {
            hint = this.mainClass.getName() + '$' + hint;
        } else if (this.classPrefix != null) {
            hint = this.classPrefix + hint;
        }
        if (this.findNamedClass(hint) == null) {
            return hint;
        }
        int i = 0;
        String new_hint;
        while (this.findNamedClass(new_hint = hint + i) != null) {
            ++i;
        }
        return new_hint;
    }

    public Compilation(boolean immediate, SourceMessages messages) {
        this(messages);
        this.immediate = immediate;
    }

    public Compilation(SourceMessages messages) {
        this.messages = messages;
        this.lexical = new NameLookup(this.getLanguage());
    }

    public Compilation(Language language, SourceMessages messages) {
        this(language, messages, new NameLookup(language));
    }

    public Compilation(Language language, SourceMessages messages, NameLookup lexical) {
        this.language = language;
        this.messages = messages;
        this.lexical = lexical;
    }

    public void walkModule(ModuleExp mexp) {
        if (debugPrintExpr) {
            OutPort dout = OutPort.errDefault();
            dout.println("[Module:" + mexp.getName());
            mexp.print(dout);
            dout.println(']');
            dout.flush();
        }
        InlineCalls.inlineCalls(mexp, this);
        PushApply.pushApply(mexp);
        ChainLambdas.chainLambdas(mexp, this);
        FindTailCalls.findTailCalls(mexp, this);
    }

    public void outputClass(String directory) throws IOException {
        char dirSep = File.separatorChar;
        for (int iClass = 0; iClass < this.numClasses; ++iClass) {
            ClassType clas = this.classes[iClass];
            String out_name = directory + clas.getName().replace('.', dirSep) + ".class";
            String parent = new File(out_name).getParent();
            if (parent != null) {
                new File(parent).mkdirs();
            }
            clas.writeToFile(out_name);
            clas.cleanupAfterCompilation();
        }
        this.minfo.comp = null;
        this.mainLambda.body = null;
        this.mainLambda = null;
        this.litTable = null;
    }

    public void compileToArchive(ModuleExp mexp, String fname) throws IOException {
        ZipOutputStream zout;
        boolean makeJar = false;
        if (fname.endsWith(".zip")) {
            makeJar = false;
        } else if (fname.endsWith(".jar")) {
            makeJar = true;
        } else {
            fname = fname + ".zip";
            makeJar = false;
        }
        this.process(12);
        File zar_file = new File(fname);
        if (zar_file.exists()) {
            zar_file.delete();
        }
        if (makeJar) {
            zout = new JarOutputStream(new FileOutputStream(zar_file));
        } else {
            zout = new ZipOutputStream(new FileOutputStream(zar_file));
            zout.setMethod(0);
        }
        byte[][] classBytes = new byte[this.numClasses][];
        CRC32 zcrc = new CRC32();
        for (int iClass = 0; iClass < this.numClasses; ++iClass) {
            ClassType clas = this.classes[iClass];
            classBytes[iClass] = clas.writeToArray();
            ZipEntry zent = new ZipEntry(clas.getName().replace('.', '/') + ".class");
            zent.setSize(classBytes[iClass].length);
            zcrc.reset();
            zcrc.update(classBytes[iClass], 0, classBytes[iClass].length);
            zent.setCrc(zcrc.getValue());
            zout.putNextEntry(zent);
            zout.write(classBytes[iClass]);
        }
        zout.close();
    }

    private void registerClass(ClassType new_class) {
        if (this.classes == null) {
            this.classes = new ClassType[20];
        } else if (this.numClasses >= this.classes.length) {
            ClassType[] new_classes = new ClassType[2 * this.classes.length];
            System.arraycopy(this.classes, 0, new_classes, 0, this.numClasses);
            this.classes = new_classes;
        }
        new_class.access_flags = new_class.access_flags | (new_class.isInterface() ? 1 : 33);
        if (new_class == this.mainClass && this.numClasses > 0) {
            new_class = this.classes[0];
            this.classes[0] = this.mainClass;
        }
        this.classes[this.numClasses++] = new_class;
    }

    public void addClass(ClassType new_class) {
        if (this.mainLambda.filename != null) {
            if (emitSourceDebugExtAttr) {
                new_class.setStratum(this.getLanguage().getName());
            }
            new_class.setSourceFile(this.mainLambda.filename);
        }
        this.registerClass(new_class);
    }

    public void addMainClass(ModuleExp module) {
        ClassType sup;
        this.mustCompile = true;
        ClassType type = this.mainClass = module.classFor(this);
        ClassType[] interfaces = module.getInterfaces();
        if (interfaces != null) {
            type.setInterfaces(interfaces);
        }
        if ((sup = module.getSuperType()) == null) {
            sup = this.generateApplet ? typeApplet : (this.generateServlet ? typeServlet : this.getModuleType());
        }
        if (!this.generateServlet) {
            type.addInterface(typeRunnable);
        }
        type.setSuper(sup);
        module.type = type;
        this.addClass(type);
        Compilation.getConstructor(this.mainClass, module);
    }

    public final Method getConstructor(LambdaExp lexp) {
        return Compilation.getConstructor(lexp.getHeapFrameType(), lexp);
    }

    public static final Method getConstructor(ClassType clas, LambdaExp lexp) {
        Method meth = clas.getDeclaredMethod("<init>", 0);
        if (meth != null) {
            return meth;
        }
        Type[] args = lexp instanceof ClassExp && lexp.staticLinkField != null ? new Type[]{lexp.staticLinkField.getType()} : apply0args;
        return clas.addMethod("<init>", 1, args, Type.void_type);
    }

    public final void generateConstructor(LambdaExp lexp) {
        this.generateConstructor(lexp.getHeapFrameType(), lexp);
    }

    public final void generateConstructor(ClassType clas, LambdaExp lexp) {
        Method constructor_method;
        Method save_method = this.method;
        Variable callContextSave = this.callContextVar;
        this.callContextVar = null;
        ClassType save_class = this.curClass;
        this.curClass = clas;
        clas.constructor = constructor_method = Compilation.getConstructor(clas, lexp);
        this.method = constructor_method;
        CodeAttr code = constructor_method.startCode();
        if (lexp instanceof ClassExp && lexp.staticLinkField != null) {
            code.emitPushThis();
            code.emitLoad(code.getCurrentScope().getVariable(1));
            code.emitPutField(lexp.staticLinkField);
        }
        Method superConstructor = clas.getSuperclass().addMethod("<init>", 1, apply0args, Type.void_type);
        code.emitPushThis();
        code.emitInvokeSpecial(superConstructor);
        if (this.curClass == this.mainClass && this.minfo != null && this.minfo.sourcePath != null) {
            code.emitPushThis();
            code.emitInvokeStatic(ClassType.make("gnu.expr.ModuleInfo").getDeclaredMethod("register", 1));
        }
        if (lexp.initChain != null) {
            Initializer init;
            LambdaExp save = this.curLambda;
            this.curLambda = new LambdaExp();
            this.curLambda.closureEnv = code.getArg(0);
            this.curLambda.outer = save;
            while ((init = lexp.initChain) != null) {
                lexp.initChain = null;
                this.dumpInitializers(init);
            }
            this.curLambda = save;
        }
        if (lexp instanceof ClassExp) {
            ClassExp cexp = (ClassExp)lexp;
            this.callInitMethods(cexp.getCompiledClassType(this), new Vector(10));
        }
        code.emitReturn();
        this.method = save_method;
        this.curClass = save_class;
        this.callContextVar = callContextSave;
    }

    void callInitMethods(ClassType clas, Vector seen) {
        if (clas == null) {
            return;
        }
        String name = clas.getName();
        if ("java.lang.Object".equals(name)) {
            return;
        }
        int i = seen.size();
        while (--i >= 0) {
            if (((ClassType)seen.elementAt(i)).getName() != name) continue;
            return;
        }
        seen.addElement(clas);
        ClassType[] interfaces = clas.getInterfaces();
        if (interfaces != null) {
            int n = interfaces.length;
            for (int i2 = 0; i2 < n; ++i2) {
                this.callInitMethods(interfaces[i2], seen);
            }
        }
        int clEnvArgs = 1;
        if (clas instanceof PairClassType) {
            clas = ((PairClassType)clas).instanceType;
        } else if (clas.isInterface()) {
            try {
                clas = (ClassType)Type.make(Class.forName(clas.getName() + "$class"));
            }
            catch (Throwable ex) {
                return;
            }
        } else {
            clEnvArgs = 0;
        }
        Method meth = clas.getDeclaredMethod("$finit$", clEnvArgs);
        if (meth != null) {
            CodeAttr code = this.getCode();
            code.emitPushThis();
            code.emitInvoke(meth);
        }
    }

    public void generateMatchMethods(LambdaExp lexp) {
        int numApplyMethods;
        int n = numApplyMethods = lexp.applyMethods == null ? 0 : lexp.applyMethods.size();
        if (numApplyMethods == 0) {
            return;
        }
        Method save_method = this.method;
        ClassType save_class = this.curClass;
        ClassType procType = typeModuleMethod;
        this.curClass = lexp.getHeapFrameType();
        if (!this.curClass.getSuperclass().isSubtype(typeModuleBody)) {
            this.curClass = this.moduleClass;
        }
        CodeAttr code = null;
        for (int i = 0; i <= 5; ++i) {
            boolean needThisMatch = false;
            SwitchState aswitch = null;
            String mname = null;
            Type[] matchArgs = null;
            int j = numApplyMethods;
            while (--j >= 0) {
                int methodIndex;
                boolean varArgs;
                LambdaExp source = (LambdaExp)lexp.applyMethods.elementAt(j);
                Method[] primMethods = source.primMethods;
                int numMethods = primMethods.length;
                boolean bl = varArgs = source.max_args < 0 || source.max_args >= source.min_args + numMethods;
                if (i < 5) {
                    methodIndex = i - source.min_args;
                    if (methodIndex < 0 || methodIndex >= numMethods || methodIndex == numMethods - 1 && varArgs) continue;
                    numMethods = 1;
                    varArgs = false;
                } else {
                    methodIndex = 5 - source.min_args;
                    if (methodIndex > 0 && numMethods <= methodIndex && !varArgs) continue;
                    methodIndex = numMethods - 1;
                }
                if (!needThisMatch) {
                    if (i < 5) {
                        mname = "match" + i;
                        matchArgs = new Type[i + 2];
                        for (int k = i; k >= 0; --k) {
                            matchArgs[k + 1] = typeObject;
                        }
                        matchArgs[i + 1] = typeCallContext;
                    } else {
                        mname = "matchN";
                        matchArgs = new Type[3];
                        matchArgs[1] = objArrayType;
                        matchArgs[2] = typeCallContext;
                    }
                    matchArgs[0] = procType;
                    this.method = this.curClass.addMethod(mname, matchArgs, Type.int_type, 1);
                    code = this.method.startCode();
                    code.emitLoad(code.getArg(1));
                    code.emitGetField(procType.getField("selector"));
                    aswitch = new SwitchState(code);
                    needThisMatch = true;
                }
                aswitch.addCase(source.getSelectorValue(this), code);
                int line = source.getLineNumber();
                if (line > 0) {
                    code.putLineNumber(source.getFileName(), line);
                }
                Variable ctxVar = code.getArg(i == 5 ? 3 : i + 2);
                if (i < 5) {
                    Declaration var = source.firstDecl();
                    for (int k = 1; k <= i; ++k) {
                        code.emitLoad(ctxVar);
                        code.emitLoad(code.getArg(k + 1));
                        Type ptype = var.getType();
                        if (ptype != Type.pointer_type) {
                            if (ptype instanceof TypeValue) {
                                Label trueLabel = new Label(code);
                                Label falseLabel = new Label(code);
                                ConditionalTarget ctarget = new ConditionalTarget(trueLabel, falseLabel, this.getLanguage());
                                code.emitDup();
                                ((TypeValue)((Object)ptype)).emitIsInstance(null, this, ctarget);
                                falseLabel.define(code);
                                code.emitPushInt(0xFFF40000 | k);
                                code.emitReturn();
                                trueLabel.define(code);
                            } else if (ptype instanceof ClassType && ptype != Type.pointer_type && ptype != Type.tostring_type) {
                                code.emitDup();
                                ptype.emitIsInstance(code);
                                code.emitIfIntEqZero();
                                code.emitPushInt(0xFFF40000 | k);
                                code.emitReturn();
                                code.emitFi();
                            }
                        }
                        code.emitPutField(typeCallContext.getField("value" + k));
                        var = var.nextDecl();
                    }
                } else {
                    code.emitLoad(ctxVar);
                    code.emitLoad(code.getArg(2));
                    code.emitPutField(typeCallContext.getField("values"));
                }
                code.emitLoad(ctxVar);
                if (defaultCallConvention < 2) {
                    code.emitLoad(code.getArg(1));
                } else {
                    code.emitLoad(code.getArg(0));
                }
                code.emitPutField(procCallContextField);
                code.emitLoad(ctxVar);
                if (defaultCallConvention >= 2) {
                    code.emitPushInt(source.getSelectorValue(this) + methodIndex);
                } else {
                    code.emitPushInt(i);
                }
                code.emitPutField(pcCallContextField);
                code.emitPushInt(0);
                code.emitReturn();
            }
            if (!needThisMatch) continue;
            aswitch.addDefault(code);
            int nargs = i > 4 ? 2 : i + 1;
            ++nargs;
            for (int k = 0; k <= nargs; ++k) {
                code.emitLoad(code.getArg(k));
            }
            Method defMethod = typeModuleBody.getDeclaredMethod(mname, matchArgs.length);
            code.emitInvokeSpecial(defMethod);
            code.emitReturn();
            aswitch.finish(code);
        }
        this.method = save_method;
        this.curClass = save_class;
    }

    public void generateApplyMethodsWithContext(LambdaExp lexp) {
        int numApplyMethods;
        int n = numApplyMethods = lexp.applyMethods == null ? 0 : lexp.applyMethods.size();
        if (numApplyMethods == 0) {
            return;
        }
        ClassType save_class = this.curClass;
        this.curClass = lexp.getHeapFrameType();
        if (!this.curClass.getSuperclass().isSubtype(typeModuleWithContext)) {
            this.curClass = this.moduleClass;
        }
        ClassType procType = typeModuleMethod;
        Method save_method = this.method;
        CodeAttr code = null;
        Type[] applyArgs = new Type[]{typeCallContext};
        this.method = this.curClass.addMethod("apply", applyArgs, Type.void_type, 1);
        code = this.method.startCode();
        Variable ctxVar = code.getArg(1);
        code.emitLoad(ctxVar);
        code.emitGetField(pcCallContextField);
        SwitchState aswitch = new SwitchState(code);
        for (int j = 0; j < numApplyMethods; ++j) {
            LambdaExp source = (LambdaExp)lexp.applyMethods.elementAt(j);
            Method[] primMethods = source.primMethods;
            int numMethods = primMethods.length;
            for (int i = 0; i < numMethods; ++i) {
                int explicitFrameArg;
                boolean varArgs = i == numMethods - 1 && (source.max_args < 0 || source.max_args >= source.min_args + numMethods);
                int methodIndex = i;
                aswitch.addCase(source.getSelectorValue(this) + i, code);
                int line = source.getLineNumber();
                if (line > 0) {
                    code.putLineNumber(source.getFileName(), line);
                }
                Method primMethod = primMethods[methodIndex];
                Type[] primArgTypes = primMethod.getParameterTypes();
                int singleArgs = source.min_args + methodIndex;
                Variable counter = null;
                int pendingIfEnds = 0;
                if (i > 4 && numMethods > 1) {
                    counter = code.addLocal(Type.int_type);
                    code.emitLoad(ctxVar);
                    code.emitGetField(typeCallContext.getDeclaredField("count"));
                    if (source.min_args != 0) {
                        code.emitPushInt(source.min_args);
                        code.emitSub(Type.int_type);
                    }
                    code.emitStore(counter);
                }
                int needsThis = primMethod.getStaticFlag() ? 0 : 1;
                int n2 = explicitFrameArg = singleArgs + (varArgs ? 2 : 1) < primArgTypes.length ? 1 : 0;
                if (needsThis + explicitFrameArg > 0) {
                    code.emitPushThis();
                    if (this.curClass == this.moduleClass && this.mainClass != this.moduleClass) {
                        code.emitGetField(this.moduleInstanceMainField);
                    }
                }
                Declaration var = source.firstDecl();
                for (int k = 0; k < singleArgs; ++k) {
                    if (counter != null && k >= source.min_args) {
                        code.emitLoad(counter);
                        code.emitIfIntLEqZero();
                        code.emitLoad(ctxVar);
                        code.emitInvoke(primMethods[k - source.min_args]);
                        code.emitElse();
                        ++pendingIfEnds;
                        code.emitInc(counter, (short)-1);
                    }
                    code.emitLoad(ctxVar);
                    if (k <= 4 && !varArgs && source.max_args <= 4) {
                        code.emitGetField(typeCallContext.getDeclaredField("value" + (k + 1)));
                    } else {
                        code.emitGetField(typeCallContext.getDeclaredField("values"));
                        code.emitPushInt(k);
                        code.emitArrayLoad(Type.pointer_type);
                    }
                    Type ptype = var.getType();
                    if (ptype != Type.pointer_type) {
                        CheckedTarget.emitCheckedCoerce(this, source, k + 1, ptype);
                    }
                    var = var.nextDecl();
                }
                if (varArgs) {
                    Type lastArgType = primArgTypes[explicitFrameArg + singleArgs];
                    if (lastArgType instanceof ArrayType) {
                        boolean mustConvert;
                        Type elType = ((ArrayType)lastArgType).getComponentType();
                        boolean bl = mustConvert = !"java.lang.Object".equals(elType.getName());
                        if (mustConvert) {
                            new Error("not implemented mustConvert restarg");
                        }
                        code.emitLoad(ctxVar);
                        code.emitPushInt(singleArgs);
                        code.emitInvokeVirtual(typeCallContext.getDeclaredMethod("getRestArgsArray", 1));
                    } else if ("gnu.lists.LList".equals(lastArgType.getName())) {
                        code.emitLoad(ctxVar);
                        code.emitPushInt(singleArgs);
                        code.emitInvokeVirtual(typeCallContext.getDeclaredMethod("getRestArgsList", 1));
                    } else if (lastArgType == typeCallContext) {
                        code.emitLoad(ctxVar);
                    } else {
                        throw new RuntimeException("unsupported #!rest type:" + lastArgType);
                    }
                }
                code.emitLoad(ctxVar);
                code.emitInvoke(primMethod);
                while (--pendingIfEnds >= 0) {
                    code.emitFi();
                }
                if (defaultCallConvention < 2) {
                    Target.pushObject.compileFromStack(this, source.getReturnType());
                }
                code.emitReturn();
            }
        }
        aswitch.addDefault(code);
        Method errMethod = typeModuleMethod.getDeclaredMethod("applyError", 0);
        code.emitInvokeStatic(errMethod);
        code.emitReturn();
        aswitch.finish(code);
        this.method = save_method;
        this.curClass = save_class;
    }

    public void generateApplyMethodsWithoutContext(LambdaExp lexp) {
        int i;
        int numApplyMethods;
        int n = numApplyMethods = lexp.applyMethods == null ? 0 : lexp.applyMethods.size();
        if (numApplyMethods == 0) {
            return;
        }
        ClassType save_class = this.curClass;
        this.curClass = lexp.getHeapFrameType();
        ClassType procType = typeModuleMethod;
        if (!this.curClass.getSuperclass().isSubtype(typeModuleBody)) {
            this.curClass = this.moduleClass;
        }
        Method save_method = this.method;
        CodeAttr code = null;
        int n2 = i = defaultCallConvention >= 2 ? 5 : 0;
        while (i < 6) {
            boolean needThisApply = false;
            SwitchState aswitch = null;
            String mname = null;
            Type[] applyArgs = null;
            int j = numApplyMethods;
            while (--j >= 0) {
                int explicitFrameArg;
                int methodIndex;
                LambdaExp source = (LambdaExp)lexp.applyMethods.elementAt(j);
                Method[] primMethods = source.primMethods;
                int numMethods = primMethods.length;
                boolean varArgs = source.max_args < 0 || source.max_args >= source.min_args + numMethods;
                boolean skipThisProc = false;
                if (i < 5) {
                    methodIndex = i - source.min_args;
                    if (methodIndex < 0 || methodIndex >= numMethods || methodIndex == numMethods - 1 && varArgs) {
                        skipThisProc = true;
                    }
                    numMethods = 1;
                    varArgs = false;
                } else {
                    methodIndex = 5 - source.min_args;
                    if (methodIndex > 0 && numMethods <= methodIndex && !varArgs) {
                        skipThisProc = true;
                    }
                    methodIndex = numMethods - 1;
                }
                if (skipThisProc) continue;
                if (!needThisApply) {
                    if (i < 5) {
                        mname = "apply" + i;
                        applyArgs = new Type[i + 1];
                        for (int k = i; k > 0; --k) {
                            applyArgs[k] = typeObject;
                        }
                    } else {
                        mname = "applyN";
                        applyArgs = new Type[2];
                        applyArgs[1] = objArrayType;
                    }
                    applyArgs[0] = procType;
                    this.method = this.curClass.addMethod(mname, applyArgs, defaultCallConvention >= 2 ? Type.void_type : Type.pointer_type, 1);
                    code = this.method.startCode();
                    code.emitLoad(code.getArg(1));
                    code.emitGetField(procType.getField("selector"));
                    aswitch = new SwitchState(code);
                    needThisApply = true;
                }
                aswitch.addCase(source.getSelectorValue(this), code);
                int line = source.getLineNumber();
                if (line > 0) {
                    code.putLineNumber(source.getFileName(), line);
                }
                Method primMethod = primMethods[methodIndex];
                Type[] primArgTypes = primMethod.getParameterTypes();
                int singleArgs = source.min_args + methodIndex;
                Variable counter = null;
                int pendingIfEnds = 0;
                if (i > 4 && numMethods > 1) {
                    counter = code.addLocal(Type.int_type);
                    code.emitLoad(code.getArg(2));
                    code.emitArrayLength();
                    if (source.min_args != 0) {
                        code.emitPushInt(source.min_args);
                        code.emitSub(Type.int_type);
                    }
                    code.emitStore(counter);
                }
                int needsThis = primMethod.getStaticFlag() ? 0 : 1;
                int n3 = explicitFrameArg = singleArgs + (varArgs ? 1 : 0) < primArgTypes.length ? 1 : 0;
                if (needsThis + explicitFrameArg > 0) {
                    code.emitPushThis();
                    if (this.curClass == this.moduleClass && this.mainClass != this.moduleClass) {
                        code.emitGetField(this.moduleInstanceMainField);
                    }
                }
                Declaration var = source.firstDecl();
                for (int k = 0; k < singleArgs; ++k) {
                    if (counter != null && k >= source.min_args) {
                        code.emitLoad(counter);
                        code.emitIfIntLEqZero();
                        code.emitInvoke(primMethods[k - source.min_args]);
                        code.emitElse();
                        ++pendingIfEnds;
                        code.emitInc(counter, (short)-1);
                    }
                    Variable pvar = null;
                    if (i <= 4) {
                        pvar = code.getArg(k + 2);
                        code.emitLoad(pvar);
                    } else {
                        code.emitLoad(code.getArg(2));
                        code.emitPushInt(k);
                        code.emitArrayLoad(Type.pointer_type);
                    }
                    Type ptype = var.getType();
                    if (ptype != Type.pointer_type) {
                        CheckedTarget.emitCheckedCoerce(this, source, k + 1, ptype, pvar);
                    }
                    var = var.nextDecl();
                }
                if (varArgs) {
                    Type lastArgType = primArgTypes[explicitFrameArg + singleArgs];
                    if (lastArgType instanceof ArrayType) {
                        boolean mustConvert;
                        Type elType = ((ArrayType)lastArgType).getComponentType();
                        boolean bl = mustConvert = !"java.lang.Object".equals(elType.getName());
                        if (singleArgs == 0 && !mustConvert) {
                            code.emitLoad(code.getArg(2));
                        } else {
                            code.pushScope();
                            if (counter == null) {
                                counter = code.addLocal(Type.int_type);
                                code.emitLoad(code.getArg(2));
                                code.emitArrayLength();
                                if (singleArgs != 0) {
                                    code.emitPushInt(singleArgs);
                                    code.emitSub(Type.int_type);
                                }
                                code.emitStore(counter);
                            }
                            code.emitLoad(counter);
                            code.emitNewArray(elType);
                            Label testLabel = new Label(code);
                            code.emitGoto(testLabel);
                            Label loopTopLabel = new Label(code);
                            loopTopLabel.define(code);
                            code.emitDup(1);
                            code.emitLoad(counter);
                            code.emitLoad(code.getArg(2));
                            code.emitLoad(counter);
                            if (singleArgs != 0) {
                                code.emitPushInt(singleArgs);
                                code.emitAdd(Type.int_type);
                            }
                            code.emitArrayLoad(Type.pointer_type);
                            if (mustConvert) {
                                CheckedTarget.emitCheckedCoerce(this, source, source.getName(), 0, elType, null);
                            }
                            code.emitArrayStore(elType);
                            testLabel.define(code);
                            code.emitInc(counter, (short)-1);
                            code.emitLoad(counter);
                            code.emitGotoIfIntGeZero(loopTopLabel);
                            code.popScope();
                        }
                    } else if ("gnu.lists.LList".equals(lastArgType.getName())) {
                        code.emitLoad(code.getArg(2));
                        code.emitPushInt(singleArgs);
                        code.emitInvokeStatic(makeListMethod);
                    } else if (lastArgType == typeCallContext) {
                        code.emitLoad(code.getArg(2));
                    } else {
                        throw new RuntimeException("unsupported #!rest type:" + lastArgType);
                    }
                }
                code.emitInvoke(primMethod);
                while (--pendingIfEnds >= 0) {
                    code.emitFi();
                }
                if (defaultCallConvention < 2) {
                    Target.pushObject.compileFromStack(this, source.getReturnType());
                }
                code.emitReturn();
            }
            if (needThisApply) {
                aswitch.addDefault(code);
                if (defaultCallConvention >= 2) {
                    Method errMethod = typeModuleMethod.getDeclaredMethod("applyError", 0);
                    code.emitInvokeStatic(errMethod);
                } else {
                    int nargs = i > 4 ? 2 : i + 1;
                    ++nargs;
                    for (int k = 0; k < nargs; ++k) {
                        code.emitLoad(code.getArg(k));
                    }
                    code.emitInvokeSpecial(typeModuleBody.getDeclaredMethod(mname, applyArgs));
                }
                code.emitReturn();
                aswitch.finish(code);
            }
            ++i;
        }
        this.method = save_method;
        this.curClass = save_class;
    }

    private Method startClassInit() {
        ClassType languageType;
        Method registerMethod;
        this.method = this.curClass.addMethod("<clinit>", apply0args, Type.void_type, 9);
        CodeAttr code = this.method.startCode();
        if ((this.generateMain || this.generateApplet || this.generateServlet) && (registerMethod = (languageType = (ClassType)Type.make(this.getLanguage().getClass())).getDeclaredMethod("registerEnvironment", 0)) != null) {
            code.emitInvokeStatic(registerMethod);
        }
        return this.method;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(int wantedState) {
        Compilation saveCompilation = Compilation.getCurrent();
        try {
            Compilation.setCurrent(this);
            ModuleExp mexp = this.getModule();
            if (wantedState >= 4 && this.getState() < 3) {
                this.setState(3);
                this.language.parse(this, 0);
                this.lexer.close();
                this.lexer = null;
                this.setState(this.messages.seenErrors() ? 100 : 4);
                if (this.pendingImports != null) {
                    return;
                }
            }
            if (wantedState >= 6 && this.getState() < 6) {
                this.addMainClass(mexp);
                this.language.resolve(this);
                this.setState(this.messages.seenErrors() ? 100 : 6);
            }
            if (wantedState >= 8 && this.getState() < 8) {
                this.walkModule(mexp);
                this.setState(this.messages.seenErrors() ? 100 : 8);
            }
            if (wantedState >= 10 && this.getState() < 10) {
                this.litTable = new LitTable(this);
                mexp.setCanRead(true);
                FindCapturedVars.findCapturedVars(mexp, this);
                mexp.allocFields(this);
                mexp.allocChildMethods(this);
                this.setState(this.messages.seenErrors() ? 100 : 10);
            }
            if (wantedState >= 12 && this.getState() < 12) {
                this.generateBytecode();
                this.setState(this.messages.seenErrors() ? 100 : 12);
            }
            if (wantedState >= 14 && this.getState() < 14) {
                ModuleManager manager = ModuleManager.getInstance();
                this.outputClass(manager.getCompilationDirectory());
                this.setState(14);
            }
        }
        catch (SyntaxException ex) {
            this.setState(100);
            if (ex.getMessages() != this.getMessages()) {
                throw new RuntimeException("confussing syntax error: " + ex);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
            this.error('f', "caught " + ex);
            this.setState(100);
        }
        finally {
            Compilation.setCurrent(saveCompilation);
        }
    }

    void generateBytecode() {
        String uri;
        int line;
        Method apply_method;
        Type[] arg_types;
        int arg_count;
        ModuleExp module = this.getModule();
        if (debugPrintFinalExpr) {
            OutPort dout = OutPort.errDefault();
            dout.println("[Compiling final " + module.getName() + " to " + this.mainClass.getName() + ":");
            module.print(dout);
            dout.println(']');
            dout.flush();
        }
        ClassType neededSuper = this.getModuleType();
        if (this.mainClass.getSuperclass().isSubtype(neededSuper)) {
            this.moduleClass = this.mainClass;
        } else {
            this.moduleClass = new ClassType(this.generateClassName("frame"));
            this.moduleClass.setSuper(neededSuper);
            this.addClass(this.moduleClass);
            this.generateConstructor(this.moduleClass, module);
        }
        this.curClass = module.type;
        LambdaExp saveLambda = this.curLambda;
        this.curLambda = module;
        if (module.isHandlingTailCalls()) {
            arg_count = 1;
            arg_types = new Type[]{typeCallContext};
        } else if (module.min_args != module.max_args || module.min_args > 4 || fewerClasses && this.curClass == this.mainClass) {
            arg_count = 1;
            arg_types = new Type[]{new ArrayType(typeObject)};
        } else {
            arg_count = module.min_args;
            arg_types = new Type[arg_count];
            int i = arg_count;
            while (--i >= 0) {
                arg_types[i] = typeObject;
            }
        }
        Variable heapFrame = module.heapFrame;
        boolean staticModule = module.isStatic();
        this.method = apply_method = this.curClass.addMethod("run", arg_types, Type.void_type, 17);
        this.method.initCode();
        CodeAttr code = this.getCode();
        this.thisDecl = this.method.getStaticFlag() ? null : module.declareThis(module.type);
        module.closureEnv = module.thisVariable;
        module.heapFrame = module.isStatic() ? null : module.thisVariable;
        module.allocChildClasses(this);
        if (module.isHandlingTailCalls() || this.usingCPStyle()) {
            this.callContextVar = new Variable("$ctx", typeCallContext);
            module.getVarScope().addVariableAfter(this.thisDecl, this.callContextVar);
            this.callContextVar.setParameter(true);
        }
        if ((line = module.getLineNumber()) > 0) {
            code.putLineNumber(module.getFileName(), line);
        }
        module.allocParameters(this);
        module.enterFunction(this);
        if (this.usingCPStyle()) {
            this.loadCallContext();
            code.emitGetField(pcCallContextField);
            this.fswitch = new SwitchState(code);
            Label l = new Label(code);
            l.define(code);
            this.fswitch.addCase(0, l, code);
        }
        module.compileBody(this);
        module.compileChildMethods(this);
        Label startLiterals = null;
        Label afterLiterals = null;
        Method initMethod = null;
        if (this.curClass == this.mainClass) {
            Initializer init;
            Method save_method = this.method;
            Variable callContextSave = this.callContextVar;
            this.callContextVar = null;
            this.clinitMethod = initMethod = this.startClassInit();
            code = this.getCode();
            startLiterals = new Label(code);
            afterLiterals = new Label(code);
            code.fixupChain(afterLiterals, startLiterals);
            if (staticModule) {
                this.generateConstructor(module);
                code.emitNew(this.moduleClass);
                code.emitDup(this.moduleClass);
                code.emitInvokeSpecial(this.moduleClass.constructor);
                this.moduleInstanceMainField = this.moduleClass.addField("$instance", this.mainClass, 25);
                code.emitPutStatic(this.moduleInstanceMainField);
            }
            while ((init = this.clinitChain) != null) {
                this.clinitChain = null;
                this.dumpInitializers(init);
            }
            if (!this.immediate && module.staticInitRun()) {
                code.emitGetStatic(this.moduleInstanceMainField);
                code.emitInvokeInterface(typeRunnable.getDeclaredMethod("run", 0));
            }
            code.emitReturn();
            if (!(this.moduleClass == this.mainClass || staticModule || this.generateMain || this.immediate)) {
                this.method = this.curClass.addMethod("run", 1, Type.typeArray0, Type.void_type);
                code = this.method.startCode();
                Variable ctxVar = code.addLocal(typeCallContext);
                Variable saveVar = code.addLocal(typeConsumer);
                Variable exceptionVar = code.addLocal(Type.throwable_type);
                code.emitInvokeStatic(getCallContextInstanceMethod);
                code.emitStore(ctxVar);
                Field consumerFld = typeCallContext.getDeclaredField("consumer");
                code.emitLoad(ctxVar);
                code.emitGetField(consumerFld);
                code.emitStore(saveVar);
                code.emitLoad(ctxVar);
                code.emitGetStatic(ClassType.make("gnu.lists.VoidConsumer").getDeclaredField("instance"));
                code.emitPutField(consumerFld);
                code.emitTryStart(false, Type.void_type);
                code.emitPushThis();
                code.emitLoad(ctxVar);
                code.emitInvokeVirtual(save_method);
                code.emitPushNull();
                code.emitStore(exceptionVar);
                code.emitTryEnd();
                code.emitCatchStart(exceptionVar);
                code.emitCatchEnd();
                code.emitTryCatchEnd();
                code.emitLoad(ctxVar);
                code.emitLoad(exceptionVar);
                code.emitLoad(saveVar);
                code.emitInvokeStatic(typeModuleBody.getDeclaredMethod("runCleanup", 3));
                code.emitReturn();
            }
            this.method = save_method;
            this.callContextVar = callContextSave;
        }
        module.compileEnd(this);
        this.curLambda = saveLambda;
        if (fewerClasses) {
            this.method.popScope();
        }
        module.heapFrame = heapFrame;
        if (this.usingCPStyle() || fewerClasses && this.curClass == this.mainClass) {
            code = this.getCode();
            this.fswitch.finish(code);
        }
        if (startLiterals != null || this.callContextVar != null) {
            this.method = initMethod;
            code = this.getCode();
            Label endLiterals = new Label(code);
            code.fixupChain(startLiterals, endLiterals);
            if (this.callContextVarForInit != null) {
                code.emitInvokeStatic(getCallContextInstanceMethod);
                code.emitStore(this.callContextVarForInit);
            }
            try {
                if (this.immediate) {
                    code.emitPushInt(Compilation.registerForImmediateLiterals(this));
                    code.emitInvokeStatic(ClassType.make("gnu.expr.Compilation").getDeclaredMethod("setupLiterals", 1));
                } else {
                    this.litTable.emit();
                }
            }
            catch (Throwable ex) {
                this.error('e', "Literals: Internal error:" + ex);
            }
            code.fixupChain(endLiterals, afterLiterals);
        }
        if (this.generateMain && this.curClass == this.mainClass) {
            Type[] args = new Type[]{new ArrayType(javaStringType)};
            this.method = this.curClass.addMethod("main", 9, args, Type.void_type);
            code = this.method.startCode();
            if (Shell.defaultFormatName != null) {
                code.emitPushString(Shell.defaultFormatName);
                code.emitInvokeStatic(ClassType.make("kawa.Shell").getDeclaredMethod("setDefaultFormat", 1));
            }
            code.emitLoad(code.getArg(0));
            code.emitInvokeStatic(typeModuleBody.getDeclaredMethod("processArgs", 1));
            if (this.moduleInstanceMainField != null) {
                code.emitGetStatic(this.moduleInstanceMainField);
            } else {
                code.emitNew(this.curClass);
                code.emitDup(this.curClass);
                code.emitInvokeSpecial(this.curClass.constructor);
            }
            code.emitInvokeVirtual(typeModuleBody.getDeclaredMethod("runAsMain", 0));
            code.emitReturn();
        }
        if (this.minfo != null && (uri = this.minfo.getNamespaceUri()) != null) {
            ModuleManager manager = ModuleManager.getInstance();
            String mainPrefix = this.mainClass.getName();
            int dot = mainPrefix.lastIndexOf(46);
            if (dot < 0) {
                mainPrefix = "";
            } else {
                String mainPackage = mainPrefix.substring(0, dot);
                try {
                    manager.loadPackageInfo(mainPackage);
                }
                catch (ClassNotFoundException ex) {
                }
                catch (Throwable ex) {
                    this.error('e', "error loading map for " + mainPackage + " - " + ex);
                }
                mainPrefix = mainPrefix.substring(0, dot + 1);
            }
            ClassType mapClass = new ClassType(mainPrefix + "$ModulesMap$");
            ClassType typeModuleSet = ClassType.make("gnu.expr.ModuleSet");
            mapClass.setSuper(typeModuleSet);
            this.registerClass(mapClass);
            this.method = mapClass.addMethod("<init>", 1, apply0args, Type.void_type);
            Method superConstructor = typeModuleSet.addMethod("<init>", 1, apply0args, Type.void_type);
            code = this.method.startCode();
            code.emitPushThis();
            code.emitInvokeSpecial(superConstructor);
            code.emitReturn();
            ClassType typeModuleManager = ClassType.make("gnu.expr.ModuleManager");
            Type[] margs = new Type[]{typeModuleManager};
            this.method = mapClass.addMethod("register", margs, Type.void_type, 1);
            code = this.method.startCode();
            Method reg = typeModuleManager.getDeclaredMethod("register", 3);
            for (ModuleInfo mi = manager.firstModule(); mi != null; mi = mi.nextModule()) {
                String miClassName = mi.className;
                if (miClassName == null || !miClassName.startsWith(mainPrefix)) continue;
                String moduleSource = mi.sourcePath;
                String moduleUri = mi.getNamespaceUri();
                code.emitLoad(code.getArg(1));
                this.compileConstant(miClassName);
                if (!Path.valueOf(moduleSource).isAbsolute()) {
                    try {
                        char sep = File.separatorChar;
                        String path = manager.getCompilationDirectory();
                        path = path + mainPrefix.replace('.', sep);
                        path = Path.toURL(path).toString();
                        int plen = path.length();
                        if (plen > 0 && path.charAt(plen - 1) != sep) {
                            path = path + sep;
                        }
                        moduleSource = Path.relativize(mi.getSourceAbsPathname(), path);
                    }
                    catch (Throwable ex) {
                        throw new WrappedException("exception while fixing up '" + moduleSource + '\'', ex);
                    }
                }
                this.compileConstant(moduleSource);
                this.compileConstant(moduleUri);
                code.emitInvokeVirtual(reg);
            }
            code.emitReturn();
        }
    }

    public Field allocLocalField(Type type, String name) {
        if (name == null) {
            name = "tmp_" + ++this.localFieldIndex;
        }
        Field field = this.curClass.addField(name, type, 0);
        return field;
    }

    public final void loadCallContext() {
        CodeAttr code = this.getCode();
        if (this.callContextVar != null && !this.callContextVar.dead()) {
            code.emitLoad(this.callContextVar);
        } else if (this.method == this.clinitMethod) {
            this.callContextVar = new Variable("$ctx", typeCallContext);
            this.callContextVar.reserveLocal(code.getMaxLocals(), code);
            code.emitLoad(this.callContextVar);
            this.callContextVarForInit = this.callContextVar;
        } else {
            code.emitInvokeStatic(getCallContextInstanceMethod);
            code.emitDup();
            this.callContextVar = new Variable("$ctx", typeCallContext);
            code.getCurrentScope().addVariable(code, this.callContextVar);
            code.emitStore(this.callContextVar);
        }
    }

    public void freeLocalField(Field field) {
    }

    public Expression parse(Object input) {
        throw new Error("unimeplemented parse");
    }

    public Language getLanguage() {
        return this.language;
    }

    public LambdaExp currentLambda() {
        return this.current_scope.currentLambda();
    }

    public final ModuleExp getModule() {
        return this.mainLambda;
    }

    public void setModule(ModuleExp mexp) {
        this.mainLambda = mexp;
    }

    public boolean isStatic() {
        return this.mainLambda.isStatic();
    }

    public ModuleExp currentModule() {
        return this.current_scope.currentModule();
    }

    public void mustCompileHere() {
        this.mustCompile = true;
    }

    public ScopeExp currentScope() {
        return this.current_scope;
    }

    public void setCurrentScope(ScopeExp scope) {
        int current_nesting;
        int scope_nesting = ScopeExp.nesting(scope);
        for (current_nesting = ScopeExp.nesting(this.current_scope); current_nesting > scope_nesting; --current_nesting) {
            this.pop(this.current_scope);
        }
        ScopeExp sc = scope;
        while (scope_nesting > current_nesting) {
            sc = sc.outer;
            --scope_nesting;
        }
        while (sc != this.current_scope) {
            this.pop(this.current_scope);
            sc = sc.outer;
        }
        this.pushChain(scope, sc);
    }

    void pushChain(ScopeExp scope, ScopeExp limit) {
        if (scope != limit) {
            this.pushChain(scope.outer, limit);
            this.pushScope(scope);
            this.lexical.push(scope);
        }
    }

    public ModuleExp pushNewModule(Lexer lexer) {
        this.lexer = lexer;
        return this.pushNewModule(lexer.getName());
    }

    public ModuleExp pushNewModule(String filename) {
        ModuleExp module = new ModuleExp();
        if (filename != null) {
            module.setFile(filename);
        }
        if (generateAppletDefault) {
            module.setFlag(32768);
        }
        if (this.immediate) {
            module.setFlag(262144);
            new ModuleInfo().setCompilation(this);
        }
        this.mainLambda = module;
        this.push(module);
        return module;
    }

    public void push(ScopeExp scope) {
        this.pushScope(scope);
        this.lexical.push(scope);
    }

    public final void pushScope(ScopeExp scope) {
        if (!this.mustCompile && (scope.mustCompile() || scope instanceof LambdaExp && !(scope instanceof ModuleExp))) {
            this.mustCompileHere();
        }
        scope.outer = this.current_scope;
        this.current_scope = scope;
    }

    public void pop(ScopeExp scope) {
        this.lexical.pop(scope);
        this.current_scope = scope.outer;
    }

    public final void pop() {
        this.pop(this.current_scope);
    }

    public void push(Declaration decl) {
        this.lexical.push(decl);
    }

    public Declaration lookup(Object name, int namespace) {
        return this.lexical.lookup(name, namespace);
    }

    public void usedClass(Type type) {
        while (type instanceof ArrayType) {
            type = ((ArrayType)type).getComponentType();
        }
        if (!this.immediate || !(type instanceof ClassType)) {
            return;
        }
        ClassType clas = (ClassType)type;
        if (this.loader != null && clas.isExisting()) {
            this.loader.addClass(clas.getReflectClass());
        }
    }

    public SourceMessages getMessages() {
        return this.messages;
    }

    public void setMessages(SourceMessages messages) {
        this.messages = messages;
    }

    public void error(char severity, String message, SourceLocator location2) {
        String file = location2.getFileName();
        int line = location2.getLineNumber();
        int column = location2.getColumnNumber();
        if (file == null || line <= 0) {
            file = this.getFileName();
            line = this.getLineNumber();
            column = this.getColumnNumber();
        }
        if (severity == 'w' && this.getBooleanOption("warn-as-error", false)) {
            severity = (char)101;
        }
        this.messages.error(severity, file, line, column, message);
    }

    public void error(char severity, String message) {
        if (severity == 'w' && this.getBooleanOption("warn-as-error", false)) {
            severity = (char)101;
        }
        this.messages.error(severity, this, message);
    }

    public void error(char severity, Declaration decl, String msg1, String msg2) {
        this.error(severity, msg1 + decl.getName() + msg2, null, decl);
    }

    public void error(char severity, String message, String code, Declaration decl) {
        if (severity == 'w' && this.getBooleanOption("warn-as-error", false)) {
            severity = (char)101;
        }
        String filename = this.getFileName();
        int line = this.getLineNumber();
        int column = this.getColumnNumber();
        int decl_line = decl.getLineNumber();
        if (decl_line > 0) {
            filename = decl.getFileName();
            line = decl_line;
            column = decl.getColumnNumber();
        }
        this.messages.error(severity, filename, line, column, message, code);
    }

    public Expression syntaxError(String message) {
        this.error('e', message);
        return new ErrorExp(message);
    }

    public final int getLineNumber() {
        return this.messages.getLineNumber();
    }

    public final int getColumnNumber() {
        return this.messages.getColumnNumber();
    }

    public final String getFileName() {
        return this.messages.getFileName();
    }

    public String getPublicId() {
        return this.messages.getPublicId();
    }

    public String getSystemId() {
        return this.messages.getSystemId();
    }

    public boolean isStableSourceLocation() {
        return false;
    }

    public void setFile(String filename) {
        this.messages.setFile(filename);
    }

    public void setLine(int line) {
        this.messages.setLine(line);
    }

    public void setColumn(int column) {
        this.messages.setColumn(column);
    }

    public final void setLine(Expression position) {
        this.messages.setLocation(position);
    }

    public void setLine(Object location2) {
        if (location2 instanceof SourceLocator) {
            this.messages.setLocation((SourceLocator)location2);
        }
    }

    public final void setLocation(SourceLocator position) {
        this.messages.setLocation(position);
    }

    public void setLine(String filename, int line, int column) {
        this.messages.setLine(filename, line, column);
    }

    public void letStart() {
        this.pushScope(new LetExp(null));
    }

    public Declaration letVariable(Object name, Type type, Expression init) {
        LetExp let2 = (LetExp)this.current_scope;
        Declaration decl = let2.addDeclaration(name, type);
        decl.noteValue(init);
        return decl;
    }

    public void letEnter() {
        LetExp let2 = (LetExp)this.current_scope;
        int ndecls = let2.countDecls();
        Expression[] inits = new Expression[ndecls];
        int i = 0;
        for (Declaration decl = let2.firstDecl(); decl != null; decl = decl.nextDecl()) {
            inits[i++] = decl.getValue();
        }
        let2.inits = inits;
        this.lexical.push(let2);
    }

    public LetExp letDone(Expression body) {
        LetExp let2 = (LetExp)this.current_scope;
        let2.body = body;
        this.pop(let2);
        return let2;
    }

    private void checkLoop() {
        if (((LambdaExp)this.current_scope).getName() != "%do%loop") {
            throw new Error("internal error - bad loop state");
        }
    }

    public void loopStart() {
        LambdaExp loopLambda = new LambdaExp();
        Expression[] inits = new Expression[]{loopLambda};
        LetExp let2 = new LetExp(inits);
        String fname = "%do%loop";
        Declaration fdecl = let2.addDeclaration(fname);
        fdecl.noteValue(loopLambda);
        loopLambda.setName(fname);
        let2.outer = this.current_scope;
        loopLambda.outer = let2;
        this.current_scope = loopLambda;
    }

    public Declaration loopVariable(Object name, Type type, Expression init) {
        this.checkLoop();
        LambdaExp loopLambda = (LambdaExp)this.current_scope;
        Declaration decl = loopLambda.addDeclaration(name, type);
        if (this.exprStack == null) {
            this.exprStack = new Stack();
        }
        this.exprStack.push(init);
        ++loopLambda.min_args;
        return decl;
    }

    public void loopEnter() {
        int ninits;
        this.checkLoop();
        LambdaExp loopLambda = (LambdaExp)this.current_scope;
        loopLambda.max_args = ninits = loopLambda.min_args;
        Expression[] inits = new Expression[ninits];
        int i = ninits;
        while (--i >= 0) {
            inits[i] = (Expression)this.exprStack.pop();
        }
        LetExp let2 = (LetExp)loopLambda.outer;
        Declaration fdecl = let2.firstDecl();
        let2.setBody(new ApplyExp(new ReferenceExp(fdecl), inits));
        this.lexical.push(loopLambda);
    }

    public void loopCond(Expression cond) {
        this.checkLoop();
        this.exprStack.push(cond);
    }

    public void loopBody(Expression body) {
        LambdaExp loopLambda = (LambdaExp)this.current_scope;
        loopLambda.body = body;
    }

    public Expression loopRepeat(Expression[] exps) {
        LambdaExp loopLambda = (LambdaExp)this.current_scope;
        ScopeExp let2 = loopLambda.outer;
        Declaration fdecl = let2.firstDecl();
        Expression cond = (Expression)this.exprStack.pop();
        ApplyExp recurse = new ApplyExp(new ReferenceExp(fdecl), exps);
        loopLambda.body = new IfExp(cond, new BeginExp(loopLambda.body, recurse), QuoteExp.voidExp);
        this.lexical.pop(loopLambda);
        this.current_scope = let2.outer;
        return let2;
    }

    public Expression loopRepeat() {
        return this.loopRepeat(Expression.noExpressions);
    }

    public Expression loopRepeat(Expression exp) {
        Expression[] args = new Expression[]{exp};
        return this.loopRepeat(args);
    }

    public void loadClassRef(ClassType clas) {
        if (clas == this.mainClass && this.mainLambda.isStatic() && this.moduleInstanceMainField != null) {
            CodeAttr code = this.getCode();
            code.emitGetStatic(this.moduleInstanceMainField);
            code.emitInvokeVirtual(Type.pointer_type.getDeclaredMethod("getClass", 0));
        } else {
            this.loadClassRef(clas.getName());
        }
    }

    public void loadClassRef(String className) {
        CodeAttr code = this.getCode();
        if (this.curClass.getClassfileMajorVersion() >= 49) {
            code.emitPushClass(className);
        } else {
            code.emitPushString(className);
            code.emitInvokeStatic(this.getForNameHelper());
        }
    }

    public Method getForNameHelper() {
        if (this.forNameHelper == null) {
            Method save_method = this.method;
            this.forNameHelper = this.method = this.curClass.addMethod("class$", 9, string1Arg, typeClass);
            CodeAttr code = this.method.startCode();
            code.emitLoad(code.getArg(0));
            code.emitPushInt(0);
            code.emitPushString(this.mainClass.getName());
            code.emitInvokeStatic(typeClass.getDeclaredMethod("forName", 1));
            code.emitInvokeVirtual(typeClass.getDeclaredMethod("getClassLoader", 0));
            code.emitInvokeStatic(typeClass.getDeclaredMethod("forName", 3));
            code.emitReturn();
            this.method = save_method;
        }
        return this.forNameHelper;
    }

    public Object resolve(Object name, boolean function2) {
        Environment env = Environment.getCurrent();
        Symbol symbol = name instanceof String ? env.defaultNamespace().lookup((String)name) : (Symbol)name;
        if (symbol == null) {
            return null;
        }
        if (function2 && this.getLanguage().hasSeparateFunctionNamespace()) {
            return env.getFunction(symbol, null);
        }
        return env.get(symbol, null);
    }

    public static void setupLiterals(int key) {
        Compilation comp = Compilation.findForImmediateLiterals(key);
        try {
            Class clas = comp.loader.loadClass(comp.mainClass.getName(), true);
            Literal init = comp.litTable.literalsChain;
            while (init != null) {
                clas.getDeclaredField(init.field.getName()).set(null, init.value);
                init = init.next;
            }
        }
        catch (Throwable ex) {
            throw new WrappedException("internal error", ex);
        }
    }

    public static synchronized int registerForImmediateLiterals(Compilation comp) {
        int i = 0;
        Compilation c = chainUninitialized;
        while (c != null) {
            if (i <= c.keyUninitialized) {
                i = c.keyUninitialized + 1;
            }
            c = c.nextUninitialized;
        }
        comp.keyUninitialized = i;
        comp.nextUninitialized = chainUninitialized;
        chainUninitialized = comp;
        return i;
    }

    public static synchronized Compilation findForImmediateLiterals(int key) {
        Compilation prev = null;
        Compilation comp = chainUninitialized;
        while (true) {
            Compilation next = comp.nextUninitialized;
            if (comp.keyUninitialized == key) {
                if (prev == null) {
                    chainUninitialized = next;
                } else {
                    prev.nextUninitialized = next;
                }
                return comp;
            }
            prev = comp;
            comp = next;
        }
    }

    public static Compilation getCurrent() {
        return (Compilation)current.get();
    }

    public static void setCurrent(Compilation comp) {
        current.set(comp);
    }

    public String toString() {
        return "<compilation " + this.mainLambda + ">";
    }

    static {
        debugPrintExpr = false;
        options = new Options();
        options.add("warn-undefined-variable", 1, "warn if no compiler-visible binding for a variable");
        options.add("warn-invoke-unknown-method", 1, "warn if invoke calls an unknown method");
        options.add("warn-as-error", 1, "Make all warnings into errors");
        moduleStatic = 0;
        typeObject = Type.pointer_type;
        scmBooleanType = ClassType.make("java.lang.Boolean");
        javaStringType = typeString = ClassType.make("java.lang.String");
        scmKeywordType = ClassType.make("gnu.expr.Keyword");
        scmSequenceType = ClassType.make("gnu.lists.Sequence");
        javaIntegerType = ClassType.make("java.lang.Integer");
        scmListType = ClassType.make("gnu.lists.LList");
        scmPairType = typePair = ClassType.make("gnu.lists.Pair");
        objArrayType = ArrayType.make(typeObject);
        scmNamedType = ClassType.make("gnu.mapping.Named");
        typeRunnable = ClassType.make("java.lang.Runnable");
        typeType = ClassType.make("gnu.bytecode.Type");
        typeObjectType = ClassType.make("gnu.bytecode.ObjectType", typeType);
        typeClass = Type.java_lang_Class_type;
        typeClassType = ClassType.make("gnu.bytecode.ClassType", typeObjectType);
        typeProcedure = ClassType.make("gnu.mapping.Procedure");
        typeLanguage = ClassType.make("gnu.expr.Language");
        typeEnvironment = ClassType.make("gnu.mapping.Environment");
        typeLocation = ClassType.make("gnu.mapping.Location");
        typeSymbol = ClassType.make("gnu.mapping.Symbol");
        getSymbolValueMethod = typeLanguage.getDeclaredMethod("getSymbolValue", 1);
        getSymbolProcedureMethod = typeLanguage.getDeclaredMethod("getSymbolProcedure", 1);
        getLocationMethod = typeLocation.addMethod("get", Type.typeArray0, Type.pointer_type, 1);
        getProcedureBindingMethod = typeSymbol.addMethod("getProcedure", Type.typeArray0, typeProcedure, 1);
        trueConstant = scmBooleanType.getDeclaredField("TRUE");
        falseConstant = scmBooleanType.getDeclaredField("FALSE");
        setNameMethod = typeProcedure.getDeclaredMethod("setName", 1);
        int1Args = new Type[]{Type.int_type};
        string1Arg = new Type[]{javaStringType};
        sym1Arg = string1Arg;
        getLocation1EnvironmentMethod = typeEnvironment.getDeclaredMethod("getLocation", 1);
        Type[] args = new Type[]{typeSymbol, Type.pointer_type};
        getLocation2EnvironmentMethod = typeEnvironment.addMethod("getLocation", args, typeLocation, 17);
        Type[] makeListArgs = new Type[]{objArrayType, Type.int_type};
        makeListMethod = scmListType.addMethod("makeList", makeListArgs, scmListType, 9);
        getCurrentEnvironmentMethod = typeEnvironment.addMethod("getCurrent", Type.typeArray0, typeEnvironment, 9);
        apply0args = Type.typeArray0;
        apply1args = new Type[]{typeObject};
        apply2args = new Type[]{typeObject, typeObject};
        applyNargs = new Type[]{objArrayType};
        apply0method = typeProcedure.addMethod("apply0", apply0args, typeObject, 17);
        apply1method = typeProcedure.addMethod("apply1", apply1args, typeObject, 1);
        apply2method = typeProcedure.addMethod("apply2", apply2args, typeObject, 1);
        Type[] apply3args = new Type[]{typeObject, typeObject, typeObject};
        apply3method = typeProcedure.addMethod("apply3", apply3args, typeObject, 1);
        Type[] apply4args = new Type[]{typeObject, typeObject, typeObject, typeObject};
        apply4method = typeProcedure.addMethod("apply4", apply4args, typeObject, 1);
        applyNmethod = typeProcedure.addMethod("applyN", applyNargs, typeObject, 1);
        Type[] args2 = new Type[]{typeProcedure, Type.int_type};
        checkArgCountMethod = typeProcedure.addMethod("checkArgCount", args2, Type.void_type, 9);
        applymethods = new Method[]{apply0method, apply1method, apply2method, apply3method, apply4method, applyNmethod};
        typeProcedure0 = ClassType.make("gnu.mapping.Procedure0", typeProcedure);
        typeProcedure1 = ClassType.make("gnu.mapping.Procedure1", typeProcedure);
        typeProcedure2 = ClassType.make("gnu.mapping.Procedure2", typeProcedure);
        typeProcedure3 = ClassType.make("gnu.mapping.Procedure3", typeProcedure);
        typeProcedure4 = ClassType.make("gnu.mapping.Procedure4", typeProcedure);
        typeProcedureN = ClassType.make("gnu.mapping.ProcedureN", typeProcedure);
        typeModuleBody = ClassType.make("gnu.expr.ModuleBody", typeProcedure0);
        typeModuleWithContext = ClassType.make("gnu.expr.ModuleWithContext", typeModuleBody);
        typeApplet = ClassType.make("java.applet.Applet");
        typeServlet = ClassType.make("gnu.kawa.servlet.KawaServlet");
        typeCallContext = ClassType.make("gnu.mapping.CallContext");
        typeConsumer = ClassType.make("gnu.lists.Consumer");
        getCallContextInstanceMethod = typeCallContext.getDeclaredMethod("getInstance", 0);
        typeValues = ClassType.make("gnu.mapping.Values");
        noArgsField = typeValues.getDeclaredField("noArgs");
        pcCallContextField = typeCallContext.getDeclaredField("pc");
        typeMethodProc = ClassType.make("gnu.mapping.MethodProc", typeProcedureN);
        typeModuleMethod = ClassType.make("gnu.expr.ModuleMethod", typeMethodProc);
        argsCallContextField = typeCallContext.getDeclaredField("values");
        procCallContextField = typeCallContext.getDeclaredField("proc");
        applyCpsArgs = new Type[]{typeCallContext};
        applyCpsMethod = typeProcedure.addMethod("apply", applyCpsArgs, Type.void_type, 1);
        typeProcedureArray = new ClassType[]{typeProcedure0, typeProcedure1, typeProcedure2, typeProcedure3, typeProcedure4};
        generateMainDefault = false;
        generateAppletDefault = false;
        generateServletDefault = false;
        inlineOk = true;
        classPrefixDefault = "";
        emitSourceDebugExtAttr = true;
        current = new ThreadLocation("current-compilation");
    }
}

