/*
 * Decompiled with CFR 0.152.
 */
package kawa.standard;

import gnu.expr.Declaration;
import gnu.expr.Expression;
import gnu.expr.LetExp;
import gnu.expr.QuoteExp;
import gnu.lists.LList;
import gnu.lists.Pair;
import gnu.mapping.Printable;
import gnu.mapping.Symbol;
import java.util.Stack;
import kawa.lang.Macro;
import kawa.lang.Syntax;
import kawa.lang.SyntaxForm;
import kawa.lang.TemplateScope;
import kawa.lang.Translator;

public class let_syntax
extends Syntax
implements Printable {
    public static final let_syntax let_syntax = new let_syntax(false, "let-syntax");
    public static final let_syntax letrec_syntax = new let_syntax(true, "letrec-syntax");
    boolean recursive;

    public let_syntax(boolean bl, String string) {
        super(string);
        this.recursive = bl;
    }

    public Expression rewrite(Object object2, Translator translator) {
        if (!(object2 instanceof Pair)) {
            return translator.syntaxError("missing let-syntax arguments");
        }
        Pair pair = (Pair)object2;
        Object object3 = pair.car;
        Object object4 = pair.cdr;
        int n = Translator.listLength(object3);
        if (n < 0) {
            return translator.syntaxError("bindings not a proper list");
        }
        Stack<Declaration> stack = null;
        int n2 = 0;
        Expression[] expressionArray = new Expression[n];
        Declaration[] declarationArray = new Declaration[n];
        Macro[] macroArray = new Macro[n];
        Pair[] pairArray = new Pair[n];
        SyntaxForm[] syntaxFormArray = new SyntaxForm[n];
        LetExp letExp = new LetExp(expressionArray);
        SyntaxForm syntaxForm = null;
        for (int i = 0; i < n; ++i) {
            TemplateScope templateScope;
            while (object3 instanceof SyntaxForm) {
                syntaxForm = (SyntaxForm)object3;
                object3 = syntaxForm.form;
            }
            SyntaxForm syntaxForm2 = syntaxForm;
            Pair pair2 = (Pair)object3;
            Object object5 = pair2.car;
            if (object5 instanceof SyntaxForm) {
                syntaxForm2 = (SyntaxForm)object5;
                object5 = syntaxForm2.form;
            }
            if (!(object5 instanceof Pair)) {
                return translator.syntaxError(this.getName() + " binding is not a pair");
            }
            Pair pair3 = (Pair)object5;
            Object object6 = pair3.car;
            SyntaxForm syntaxForm3 = syntaxForm2;
            while (object6 instanceof SyntaxForm) {
                syntaxForm3 = (SyntaxForm)object6;
                object6 = syntaxForm3.form;
            }
            if (!(object6 instanceof String) && !(object6 instanceof Symbol)) {
                return translator.syntaxError("variable in " + this.getName() + " binding is not a symbol");
            }
            Object object7 = pair3.cdr;
            while (object7 instanceof SyntaxForm) {
                syntaxForm2 = (SyntaxForm)object7;
                object7 = syntaxForm2.form;
            }
            if (!(object7 instanceof Pair)) {
                return translator.syntaxError(this.getName() + " has no value for '" + object6 + "'");
            }
            pair3 = (Pair)object7;
            if (pair3.cdr != LList.Empty) {
                return translator.syntaxError("let binding for '" + object6 + "' is improper list");
            }
            Declaration declaration = new Declaration(object6);
            macroArray[i] = Macro.make(declaration);
            pairArray[i] = pair3;
            syntaxFormArray[i] = syntaxForm2;
            letExp.addDeclaration(declaration);
            TemplateScope templateScope2 = templateScope = syntaxForm3 == null ? null : syntaxForm3.scope;
            if (templateScope != null) {
                Declaration declaration2 = translator.makeRenamedAlias(declaration, templateScope);
                if (stack == null) {
                    stack = new Stack<Declaration>();
                }
                stack.push(declaration2);
                ++n2;
            }
            declarationArray[i] = declaration;
            expressionArray[i] = QuoteExp.nullExp;
            object3 = pair2.cdr;
        }
        if (this.recursive) {
            this.push(letExp, translator, stack);
        }
        Macro macro = translator.currentMacroDefinition;
        for (int i = 0; i < n; ++i) {
            translator.currentMacroDefinition = macroArray[i];
            expressionArray[i] = translator.rewrite_car(pairArray[i], syntaxFormArray[i]);
            macroArray[i].expander = expressionArray[i];
            declarationArray[i].noteValue(new QuoteExp(macroArray[i]));
        }
        translator.currentMacroDefinition = macro;
        if (!this.recursive) {
            this.push(letExp, translator, stack);
        }
        Expression expression = translator.rewrite_body(object4);
        translator.pop(letExp);
        translator.popRenamedAlias(n2);
        return expression;
    }

    private void push(LetExp letExp, Translator translator, Stack stack) {
        translator.push(letExp);
        if (stack != null) {
            int n = stack.size();
            while (--n >= 0) {
                translator.pushRenamedAlias((Declaration)stack.pop());
            }
        }
    }
}

