/*
 * Decompiled with CFR 0.152.
 */
package gnu.text;

import gnu.text.LineBufferedReader;
import gnu.text.SourceLocator;
import java.io.PrintStream;
import java.io.PrintWriter;

public class SourceError
implements SourceLocator {
    public SourceError next;
    public char severity;
    public String filename;
    public String code;
    public int line;
    public int column;
    public String message;
    public Throwable fakeException;

    public SourceError(char c, String string, int n, int n2, String string2) {
        this.severity = c;
        this.filename = string;
        this.line = n;
        this.column = n2;
        this.message = string2;
    }

    public SourceError(char c, SourceLocator sourceLocator, String string) {
        this(c, sourceLocator.getFileName(), sourceLocator.getLineNumber(), sourceLocator.getColumnNumber(), string);
    }

    public SourceError(LineBufferedReader lineBufferedReader, char c, String string) {
        this(c, lineBufferedReader.getName(), lineBufferedReader.getLineNumber() + 1, lineBufferedReader.getColumnNumber(), string);
        if (this.column >= 0) {
            ++this.column;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.filename == null ? "<unknown>" : this.filename);
        if (this.line > 0 || this.column > 0) {
            stringBuffer.append(':');
            stringBuffer.append(this.line);
            if (this.column > 0) {
                stringBuffer.append(':');
                stringBuffer.append(this.column);
            }
        }
        stringBuffer.append(": ");
        if (this.severity == 'w') {
            stringBuffer.append("warning - ");
        }
        stringBuffer.append(this.message);
        if (this.code != null) {
            stringBuffer.append(" [");
            stringBuffer.append(this.code);
            stringBuffer.append("]");
        }
        if (this.fakeException != null) {
            StackTraceElement[] stackTraceElementArray = this.fakeException.getStackTrace();
            for (int i = 0; i < stackTraceElementArray.length; ++i) {
                stringBuffer.append("\n");
                stringBuffer.append("    ");
                stringBuffer.append(stackTraceElementArray[i].toString());
            }
        }
        return stringBuffer.toString();
    }

    public void print(PrintWriter printWriter) {
        printWriter.print(this);
    }

    public void println(PrintWriter printWriter) {
        int n;
        String string = this.toString();
        while ((n = string.indexOf(10)) >= 0) {
            printWriter.println(string.substring(0, n));
            string = string.substring(n + 1);
        }
        printWriter.println(string);
    }

    public void println(PrintStream printStream) {
        int n;
        String string = this.toString();
        while ((n = string.indexOf(10)) >= 0) {
            printStream.println(string.substring(0, n));
            string = string.substring(n + 1);
        }
        printStream.println(string);
    }

    public int getLineNumber() {
        return this.line == 0 ? -1 : this.line;
    }

    public int getColumnNumber() {
        return this.column == 0 ? -1 : this.column;
    }

    public String getPublicId() {
        return null;
    }

    public String getSystemId() {
        return this.filename;
    }

    public String getFileName() {
        return this.filename;
    }

    public boolean isStableSourceLocation() {
        return true;
    }
}

