/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.io;

import gnu.kawa.io.InPort;
import gnu.kawa.io.NullReader;
import gnu.kawa.io.Path;
import gnu.lists.CharSeq;
import gnu.lists.FString;
import java.io.IOException;

public class CharArrayInPort
extends InPort {
    static final Path stringPath = Path.valueOf("<string>");

    public static CharArrayInPort make(CharSequence seq) {
        if (seq instanceof FString) {
            return new CharArrayInPort((FString)seq);
        }
        int len = seq.length();
        char[] buf = new char[len];
        if (seq instanceof String) {
            ((String)seq).getChars(0, len, buf, 0);
        } else if (!(seq instanceof CharSeq)) {
            int i = len;
            while (--i >= 0) {
                buf[i] = seq.charAt(i);
            }
        } else {
            ((CharSeq)seq).getChars(0, len, buf, 0);
        }
        return new CharArrayInPort(buf, len);
    }

    public CharArrayInPort(char[] buffer, int len) {
        super(NullReader.nullReader, stringPath);
        try {
            this.setBuffer(buffer);
        }
        catch (IOException ex) {
            throw new Error(ex.toString());
        }
        this.limit = len;
    }

    public CharArrayInPort(char[] buffer) {
        this(buffer, buffer.length);
    }

    public CharArrayInPort(String string2) {
        this(string2.toCharArray());
    }

    public CharArrayInPort(FString string2) {
        this(string2.data, string2.size());
    }

    @Override
    public int read() throws IOException {
        if (this.pos >= this.limit) {
            return -1;
        }
        return super.read();
    }
}

